/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.daemon.controller.IDmnControllerEventHandler;
import com.neeve.event.lifecycle.ILifecycleEvent;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.test.UnitTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class SrvAppLifecycleDispatchTest
extends UnitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLifecycleDispatch() throws Exception {
        SrvConfigDescriptor descriptor = SrvConfigDescriptor.create("lifecycleDispatchTestServer");
        descriptor.setDiscoveryDescriptor(null);
        descriptor.save();
        SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create("lifecycleDispatchTestApp");
        appDescriptor.setMainClass(LifecycleDispatchTestApp.class.getName());
        appDescriptor.setAutoStart(true);
        appDescriptor.save(descriptor.getName());
        descriptor.addApp(appDescriptor);
        descriptor.save();
        ServerRunner runner = new ServerRunner(descriptor);
        runner.start();
        try {
            runner.waitForServerToStart();
            LifecycleDispatchTestApp app = (LifecycleDispatchTestApp)runner.controller.getAppManager().getAppLoader("lifecycleDispatchTestApp").getAppMain();
            app.engine.waitForMessagingToStart();
            app.engineActiveLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)app.lifecycleCount);
        }
        finally {
            runner.shutdown();
        }
    }

    static {
        System.setProperty("nv.aep.autocreatedirectbus", "true");
    }

    public static final class LifecycleDispatchTestApp {
        AepEngine engine;
        volatile int lifecycleCount;
        CountDownLatch engineActiveLatch = new CountDownLatch(1);

        @AppInjectionPoint
        public final void engineInjectionPoint(AepEngine engine) {
            this.engine = engine;
        }

        @EventHandler
        public final void onLifecycle(ILifecycleEvent event) {
            Assert.assertNotNull((Object)event.getBackingMessage());
            ++this.lifecycleCount;
            if (event instanceof AepEngineActiveEvent) {
                this.engineActiveLatch.countDown();
            }
        }
    }

    private static final class ServerRunner
    extends Thread
    implements IDmnControllerEventHandler {
        final SrvController controller;
        private boolean startComplete;
        private Throwable startResult;

        ServerRunner(SrvConfigDescriptor descriptor) {
            this.controller = SrvController.getInstance(descriptor);
            this.controller.setEventHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitForServerToStart() throws Exception {
            ServerRunner serverRunner = this;
            synchronized (serverRunner) {
                while (!this.startComplete) {
                    this.wait(30000L);
                }
                Assert.assertTrue((boolean)this.startComplete);
                Assert.assertNull((Object)this.startResult);
            }
        }

        final void shutdown() {
            this.controller.stop();
        }

        @Override
        public void run() {
            this.controller.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int type, Object data) {
            if (type == 4) {
                ServerRunner serverRunner = this;
                synchronized (serverRunner) {
                    this.startComplete = true;
                    this.startResult = (Throwable)data;
                    this.notifyAll();
                }
            }
        }
    }
}

