/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepApplicationExceptionEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.aep.test.unit.generated.xbuf.Message;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.IEventAcknowledger;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.alert.SrvMonAppExceptionMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppedMessage;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFilter;
import com.neeve.sma.event.MessageEvent;
import com.neeve.util.UtlEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AepMessageFilteringTest
extends AbstractAepServerTest {
    private static volatile AepEngine.AppExceptionHandlingPolicy exceptionHandlingPolicy = AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue;
    private static volatile MessageViewFilter filter;

    @BeforeClass
    public static void setup() {
        UtlEnv.getEnvPropsNoWarn().put("store.clustering.enabled", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAepMessageFiltering() throws Throwable {
        TestFilter filter = new TestFilter();
        AepMessageFilteringTest.filter = filter;
        String val = XRuntime.getProps().getProperty("nv.server.stats.enable");
        XRuntime.getProps().setProperty("nv.server.stats.interval", "1");
        XRuntime.getProps().setProperty("nv.server.stats.enable", "true");
        XRuntime.getProps().setProperty("nv.server.stats.apps.trace", "debug");
        XRuntime.getProps().setProperty("nv.aep.heartbeatDispatchTestApp.stats.interval", "1");
        XRuntime.getProps().setProperty("nv.aep.heartbeatDispatchTestApp.stats.trace", "debug");
        try {
            AepEngineFilterTestApp app = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName(), "primary", AepEngineFilterTestApp.class);
            filter.reset();
            int sendCount = 100;
            int expectedPassCount = 0;
            for (int i = 1; i <= sendCount; ++i) {
                Message message = (Message)AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage();
                message.setIntField(i);
                if (!filter.filter((MessageView)message)) {
                    ++expectedPassCount;
                }
                filter.invocations.decrementAndGet();
                app.engine.injectMessage((IRogMessage)message);
            }
            app.waitForMessages(5, expectedPassCount);
            app.waitForTransactionStability(5, expectedPassCount);
            long tte = System.currentTimeMillis() + 2000L;
            while (app.engine.getStats().getNumMsgsSourced() < (long)sendCount && System.currentTimeMillis() < tte) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((String)"Wrong number of messages received", (long)expectedPassCount, (long)app.receivedMessageCount);
            Assert.assertEquals((String)"Filter called wrong number of times", (long)sendCount, (long)filter.invocations.get());
            if (app.heartbeatNumSourced != (long)sendCount) {
                Thread.sleep(2000L);
            }
            Assert.assertEquals((String)"Wrong number of sources messages reported in server heartbeat", (long)sendCount, (long)app.heartbeatNumSourced);
            Assert.assertEquals((String)"Wrong number of filtered messages reported in server heartbeat", (long)(sendCount - expectedPassCount), (long)app.heartbeatNumFiltered);
            filter.filterAll = true;
            app = AepMessageFilteringTest.restartApp(app);
            Assert.assertEquals((String)"Wrong number of messages recovered", (long)expectedPassCount, (long)app.receivedMessageCount);
            Assert.assertEquals((String)"Filter called wrong number of times", (long)sendCount, (long)filter.invocations.get());
        }
        finally {
            if (val != null) {
                XRuntime.getProps().setProperty("nv.server.stats.enable", val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAepMessageFilteringAcks() throws Throwable {
        TestFilter filter = new TestFilter();
        AepMessageFilteringTest.filter = filter;
        AepEngineFilterTestApp app = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName(), "primary", AepEngineFilterTestApp.class);
        app.engine.setMessageFilter((MessageViewFilter)filter);
        filter.reset();
        int sendCount = 100;
        int expectedPassCount = 0;
        final CountDownLatch ackLatch = new CountDownLatch(sendCount);
        IEventAcknowledger acknowledger = new IEventAcknowledger(){

            public void dispose() {
            }

            public void ack() {
                ackLatch.countDown();
            }
        };
        for (int i = 1; i <= sendCount; ++i) {
            Message message = (Message)AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage();
            message.setIntField(i);
            if (!filter.filter((MessageView)message)) {
                ++expectedPassCount;
            }
            filter.invocations.decrementAndGet();
            MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)acknowledger);
            try {
                message.setTag(0, (Object)messageEvent);
                app.engine.getEventMultiplexer().multiplexEvent((Event)messageEvent, 0);
                continue;
            }
            finally {
                messageEvent.dispose();
            }
        }
        app.waitForMessages(5, expectedPassCount);
        app.waitForTransactionStability(5, expectedPassCount);
        long tte = System.currentTimeMillis() + 2000L;
        while (app.engine.getStats().getNumMsgsSourced() < (long)sendCount && System.currentTimeMillis() < tte) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Wrong number of messages received", (long)expectedPassCount, (long)app.receivedMessageCount);
        Assert.assertEquals((String)"Filter called wrong number of times", (long)sendCount, (long)filter.invocations.get());
        Assert.assertTrue((String)"Timed out waiting for event acknowledgements", (boolean)ackLatch.await(5L, TimeUnit.SECONDS));
        filter.filterAll = true;
        app = AepMessageFilteringTest.restartApp(app);
        Assert.assertEquals((String)"Wrong number of messages recovered", (long)expectedPassCount, (long)app.receivedMessageCount);
        Assert.assertEquals((String)"Filter called wrong number of times", (long)sendCount, (long)filter.invocations.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAepMessageFilteringLogExceptionAndContinueExceptionHandling() throws Throwable {
        exceptionHandlingPolicy = AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue;
        int sendCount = 10;
        final CountDownLatch exceptionLatch = new CountDownLatch(1);
        filter = new MessageViewFilter(){
            int invocations = 0;

            public boolean filter(MessageView view) {
                if (++this.invocations == 5) {
                    exceptionLatch.countDown();
                    throw new RuntimeException("Intentional Exception");
                }
                return false;
            }
        };
        AepEngineFilterTestApp app = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName(), "primary", AepEngineFilterTestApp.class);
        ArrayList<Message> sent = new ArrayList<Message>();
        AtomicInteger ackCounter = new AtomicInteger();
        for (int i = 1; i <= 10; ++i) {
            Message message = (Message)AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage();
            message.setIntField(i);
            MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)new TestAcknowledger("Message" + i, ackCounter, null));
            try {
                message.setTag(0, (Object)messageEvent);
                app.engine.getEventMultiplexer().multiplexEvent((Event)messageEvent, 0);
                sent.add(message);
                continue;
            }
            finally {
                messageEvent.dispose();
            }
        }
        app.waitForMessages(10, 9);
        Assert.assertEquals((String)"Wrong last message received", (long)10L, (long)app.lastMessageIntField);
        Assert.assertEquals((String)"Wrong number of messages received", (long)9L, (long)app.getRcvdMessageCount());
        Assert.assertTrue((String)"Application failed to trigger filter exception", (boolean)exceptionLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Wrong number of message acks from engine", (long)10L, (long)ackCounter.get());
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && app.appExceptionEvent == null) {
            Thread.sleep(100L);
        }
        System.out.println(app.appExceptionEvent);
        Assert.assertNotNull((String)"AepApplicationExceptionEvent was not dispatched to application", (Object)app.appExceptionEvent);
        Assert.assertNotNull((String)"SrvMonAppExceptionMessage was not set as backing message to AepApplicationExceptionEvent", (Object)app.appExceptionEvent.getBackingMessage());
        Assert.assertEquals((String)"Wrong message reported in error event", sent.get(4), (Object)app.appExceptionEvent.getTriggeringMessage());
        SrvMonAppExceptionMessage alert = (SrvMonAppExceptionMessage)app.appExceptionEvent.getBackingMessage();
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(alert.toJsonString());
        }
        Assert.assertTrue((String)"Wrong exception in monitoring alert: ", (alert.getException().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong view id in backing monitoring alert: ", (long)((Message)sent.get(0)).getType(), (long)alert.getTriggeringMessageMessageViewId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAepMessageFilteringRollbackAndStopExceptionHandling() throws Throwable {
        exceptionHandlingPolicy = AepEngine.AppExceptionHandlingPolicy.RollbackAndStop;
        int sendCount = 10;
        final CountDownLatch exceptionLatch = new CountDownLatch(1);
        final CountDownLatch allMessageInjected = new CountDownLatch(1);
        filter = new MessageViewFilter(){
            int invocations = 0;

            public boolean filter(MessageView view) {
                try {
                    allMessageInjected.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                if (++this.invocations == 5) {
                    exceptionLatch.countDown();
                    throw new RuntimeException("Intentional Exception");
                }
                return false;
            }
        };
        AepEngineFilterTestApp app = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName(), "primary", AepEngineFilterTestApp.class);
        ArrayList<Message> sent = new ArrayList<Message>();
        AtomicInteger ackCounter = new AtomicInteger();
        for (int i = 1; i <= 10; ++i) {
            Message message = (Message)AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage();
            message.setIntField(i);
            MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)new TestAcknowledger("Message" + i, ackCounter, null));
            message.setTag(0, (Object)messageEvent);
            try {
                app.engine.getEventMultiplexer().multiplexEvent((Event)messageEvent, 0);
            }
            catch (Exception e) {
                System.out.println("Send #" + i + " failed (not uexpectedly) with: " + e.getMessage());
                messageEvent.dispose();
                break;
            }
            try {
                sent.add(message);
                continue;
            }
            finally {
                messageEvent.dispose();
            }
        }
        allMessageInjected.countDown();
        app.waitForMessages(10, 4);
        Assert.assertTrue((String)"Application failed to trigger filter exception", (boolean)exceptionLatch.await(10L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Too many messages received", (long)4L, (long)app.getRcvdMessageCount());
        Assert.assertEquals((String)"Wrong message received last", (long)app.lastMessageIntField, (long)4L);
        Assert.assertEquals((String)"Wrong number of message acks from engine", (long)4L, (long)ackCounter.get());
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && app.appExceptionEvent == null) {
            Thread.sleep(100L);
        }
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(app.appExceptionEvent);
        }
        Assert.assertNotNull((String)"AepApplicationExceptionEvent was not dispatched to application", (Object)app.appExceptionEvent);
        Assert.assertNotNull((String)"SrvMonAppExceptionMessage was not set as backing message to AepApplicationExceptionEvent", (Object)app.appExceptionEvent.getBackingMessage());
        Assert.assertEquals((String)"Wrong message reported in error event", sent.get(4), (Object)app.appExceptionEvent.getTriggeringMessage());
        SrvMonAppExceptionMessage alert = (SrvMonAppExceptionMessage)app.appExceptionEvent.getBackingMessage();
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(alert.toJsonString());
        }
        Assert.assertTrue((String)"Wrong exception in monitoring alert: ", (alert.getException().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong view id in backing monitoring alert: ", (long)((Message)sent.get(0)).getType(), (long)alert.getTriggeringMessageMessageViewId());
        while (System.currentTimeMillis() < timeout && app.engineStoppedEvent == null) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull((String)"AepEngineStoppedEvent was not dispatched to application", (Object)app.engineStoppedEvent);
        Assert.assertNotNull((String)"AepEngineStoppedEvent should have reported an exception", (Object)app.engineStoppedEvent.getCause());
        Assert.assertTrue((String)"Wrong exception in monitoring alert: ", (app.engineStoppedEvent.getCause().getMessage().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(app.engineStoppedEvent);
        }
        Assert.assertNotNull((String)"SrvMonAepEngineStoppedEvent was not set as backing message to AepEngineStoppedEvent", (Object)app.engineStoppedEvent.getBackingMessage());
        SrvMonAppEngineStoppedMessage stopAlert = (SrvMonAppEngineStoppedMessage)app.engineStoppedEvent.getBackingMessage();
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(stopAlert.toJsonString());
        }
        Assert.assertTrue((String)"Wrong exception in monitoring stop alert: ", (alert.getException().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong view id in backing monitoring stop alert: ", (long)((Message)sent.get(0)).getType(), (long)alert.getTriggeringMessageMessageViewId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAepMessageFilteringQuarantineAndStopExceptionHandling() throws Throwable {
        AepMessageFilteringTest.setVerbose((boolean)false);
        exceptionHandlingPolicy = AepEngine.AppExceptionHandlingPolicy.QuarantineAndStop;
        int sendCount = 10;
        final CountDownLatch exceptionLatch = new CountDownLatch(1);
        final CountDownLatch allMessageInjected = new CountDownLatch(1);
        filter = new MessageViewFilter(){
            int invocations = 0;

            public boolean filter(MessageView view) {
                try {
                    allMessageInjected.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                if (++this.invocations == 5) {
                    exceptionLatch.countDown();
                    throw new RuntimeException("Intentional Exception");
                }
                return false;
            }
        };
        AepEngineFilterTestApp app = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName(), "primary", AepEngineFilterTestApp.class);
        HashMap<String, String> quarantineProps = new HashMap<String, String>();
        quarantineProps.put("bus1.channel5.join", "true");
        AepEngineFilterTestQuarantineListenerApp quarantineApp = AepMessageFilteringTest.createApp(this.testcaseName.getMethodName() + "quarantinelistener", "primary", AepEngineFilterTestQuarantineListenerApp.class, quarantineProps);
        quarantineApp.holdMessages = true;
        ArrayList<Message> sent = new ArrayList<Message>();
        AtomicInteger ackCounter = new AtomicInteger();
        for (int i = 1; i <= 10; ++i) {
            Message message = (Message)AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage();
            message.setIntField(i);
            MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)new TestAcknowledger("Message" + i, ackCounter, null));
            message.setTag(0, (Object)messageEvent);
            try {
                app.engine.getEventMultiplexer().multiplexEvent((Event)messageEvent, 0);
            }
            catch (Exception e) {
                System.out.println("Send #" + i + " failed (not uexpectedly) with: " + e.getMessage());
                messageEvent.dispose();
                break;
            }
            try {
                sent.add(message);
                continue;
            }
            finally {
                messageEvent.dispose();
            }
        }
        allMessageInjected.countDown();
        app.waitForMessages(10, 4);
        Assert.assertTrue((String)"Application failed to trigger filter exception", (boolean)exceptionLatch.await(10L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Too many messages received", (long)4L, (long)app.getRcvdMessageCount());
        Assert.assertEquals((String)"Wrong message received last", (long)app.lastMessageIntField, (long)4L);
        Assert.assertEquals((String)"Wrong number of message acks from engine", (long)5L, (long)ackCounter.get());
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && app.appExceptionEvent == null) {
            Thread.sleep(100L);
        }
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(app.appExceptionEvent);
        }
        Assert.assertNotNull((String)"AepApplicationExceptionEvent was not dispatched to application", (Object)app.appExceptionEvent);
        Assert.assertNotNull((String)"SrvMonAppExceptionMessage was not set as backing message to AepApplicationExceptionEvent", (Object)app.appExceptionEvent.getBackingMessage());
        Assert.assertEquals((String)"Wrong message reported in error event", sent.get(4), (Object)app.appExceptionEvent.getTriggeringMessage());
        SrvMonAppExceptionMessage alert = (SrvMonAppExceptionMessage)app.appExceptionEvent.getBackingMessage();
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(alert.toJsonString());
        }
        Assert.assertTrue((String)"Wrong exception in monitoring alert: ", (alert.getException().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong view id in backing monitoring alert: ", (long)((Message)sent.get(0)).getType(), (long)alert.getTriggeringMessageMessageViewId());
        while (System.currentTimeMillis() < timeout && app.engineStoppedEvent == null) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull((String)"AepEngineStoppedEvent was not dispatched to application", (Object)app.engineStoppedEvent);
        Assert.assertNotNull((String)"AepEngineStoppedEvent should have reported an exception", (Object)app.engineStoppedEvent.getCause());
        Assert.assertTrue((String)"Wrong exception in monitoring alert: ", (app.engineStoppedEvent.getCause().getMessage().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(app.engineStoppedEvent);
        }
        Assert.assertNotNull((String)"SrvMonAepEngineStoppedEvent was not set as backing message to AepEngineStoppedEvent", (Object)app.engineStoppedEvent.getBackingMessage());
        SrvMonAppEngineStoppedMessage stopAlert = (SrvMonAppEngineStoppedMessage)app.engineStoppedEvent.getBackingMessage();
        if (AepMessageFilteringTest.verbose()) {
            System.out.println(stopAlert.toJsonString());
        }
        Assert.assertTrue((String)"Wrong exception in monitoring stop alert: ", (alert.getException().indexOf("Intentional Exception") >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong view id in backing monitoring stop alert: ", (long)((Message)sent.get(0)).getType(), (long)alert.getTriggeringMessageMessageViewId());
        quarantineApp.waitForMessages(5, 1);
        Assert.assertEquals((String)"Got the wrong quarantine message", (long)5L, (long)((Message)quarantineApp.getRcvdMessages().get(0)).getIntField());
        if (AepMessageFilteringTest.verbose()) {
            boolean includeMetadata = true;
            System.out.println("Sent Messages:");
            int i = 1;
            for (IRogMessage iRogMessage : sent) {
                app.dumpMessage("Message " + i++, iRogMessage, includeMetadata);
            }
            System.out.println("App messages received:");
            app.dumpReceivedMessages(includeMetadata);
            System.out.println("Quarantined messages received:");
            quarantineApp.dumpReceivedMessages(includeMetadata);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static class AepEngineFilterTestQuarantineListenerApp
    extends AbstractAepServerTestApp {
        @EventHandler(source="channel5@aeptest1")
        public void onMessage(Message message) {
            this.recordReceipt((IRogMessage)message);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static class AepEngineFilterTestApp
    extends AbstractAepServerTestApp {
        private volatile long heartbeatNumFiltered = 0L;
        private volatile long heartbeatNumSourced = 0L;
        private volatile AepApplicationExceptionEvent appExceptionEvent;
        private volatile AepEngineStoppedEvent engineStoppedEvent;
        private volatile int lastMessageIntField = -1;

        public AepEngineFilterTestApp() {
            this.holdMessages = true;
        }

        @Override
        @AppInjectionPoint
        public void setAepEngineDescriptor(AepEngineDescriptor descriptor) {
            descriptor.setQuarantineChannel("channel5@aeptest1");
            super.setAepEngineDescriptor(descriptor);
        }

        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            super.setAepEngine(engine);
            engine.registerFactory((Object)new Factory());
            engine.setMessageFilter(filter);
            engine.setAppExceptionHandlingPolicy(exceptionHandlingPolicy);
        }

        @EventHandler
        public void onMessage(Message message) {
            this.lastMessageIntField = message.getIntField();
            this.recordReceipt((IRogMessage)message);
        }

        @EventHandler
        public void onMessage(SrvMonHeartbeatMessage heartbeat) {
            for (SrvMonAppStats appStats : heartbeat.getAppsStats()) {
                if (!appStats.getAppName().equals(this.engine.getName())) continue;
                this.heartbeatNumFiltered = appStats.getEngineStats().getNumMsgsFiltered();
                this.heartbeatNumSourced = appStats.getEngineStats().getNumMsgsSourced();
            }
        }

        @EventHandler
        public void onAppException(AepApplicationExceptionEvent event) {
            this.appExceptionEvent = event;
        }

        @EventHandler
        public void onEngineStopped(AepEngineStoppedEvent event) {
            this.engineStoppedEvent = event;
        }
    }

    private static final class TestAcknowledger
    implements IEventAcknowledger {
        final String id;
        final AtomicInteger ackCounter;
        final AtomicInteger disposeCounter;

        TestAcknowledger(String id, AtomicInteger ackCounter, AtomicInteger disposeCounter) {
            this.id = id;
            this.ackCounter = ackCounter;
            this.disposeCounter = disposeCounter;
        }

        public void ack() {
            if (this.ackCounter != null) {
                if (AepMessageFilteringTest.verbose()) {
                    System.out.println("Ack for: " + this.id);
                }
                this.ackCounter.incrementAndGet();
            }
        }

        public void dispose() {
            if (this.disposeCounter != null) {
                this.disposeCounter.incrementAndGet();
            }
        }
    }

    private static final class TestFilter
    implements MessageViewFilter {
        volatile boolean filterAll = false;
        AtomicInteger invocations = new AtomicInteger();

        private TestFilter() {
        }

        public boolean filter(MessageView view) {
            this.invocations.incrementAndGet();
            if (this.filterAll) {
                return true;
            }
            if (view instanceof Message) {
                return ((Message)view).getIntField() % 2 == 0;
            }
            return false;
        }

        public void reset() {
            this.filterAll = false;
            this.invocations.set(0);
        }
    }
}

