/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminException;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.SmaException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class AdminSessionFactoryTest {
    @Test
    public void testAdminSessionFactoryComponentized() throws EAdminException, SmaException {
        Properties properties = new Properties();
        properties.put("nv.server.admin.transports", "sma");
        properties.put("nv.server.admin.sma.bus.name", "test-component-bus");
        properties.put("nv.server.admin.sma.bus.provider", "loopback");
        properties.put("nv.server.admin.sma.bus.address", "test-component-bus-address");
        properties.put("nv.server.admin.sma.bus.port", "100");
        properties.put("nv.server.admin.sma.bus.properties.topic_starts_with_channel", "false");
        MessageBusDescriptor descriptor = AdminSessionFactory.loadAdminBusDescriptor(properties);
        Assert.assertEquals((String)"Wrong bus name", (Object)"test-component-bus", (Object)descriptor.getName());
        Assert.assertEquals((String)"Wrong bus provider", (Object)"loopback", (Object)descriptor.getProviderConfigAsAddressDescriptor().type);
        Assert.assertEquals((String)"Wrong bus address", (Object)"test-component-bus-address:100", (Object)descriptor.getProviderConfigAsAddressDescriptor().address);
        Assert.assertEquals((String)"Wrong bus provider property", (Object)"false", (Object)descriptor.getProviderConfig().getProperty("topic_starts_with_channel"));
    }

    @Test
    public void testAdminSessionFactoryAsDescriptor() throws EAdminException, SmaException {
        Properties properties = new Properties();
        properties.put("nv.server.admin.transports", "sma");
        properties.put("nv.server.admin.sma.bus.name", "test-descriptor-bus");
        properties.put("nv.server.admin.sma.bus.descriptor", "loopback://test-descriptor-bus:200&topic_starts_with_channel=false");
        MessageBusDescriptor descriptor = AdminSessionFactory.loadAdminBusDescriptor(properties);
        Assert.assertEquals((String)"Wrong bus name", (Object)"test-descriptor-bus", (Object)descriptor.getName());
        Assert.assertEquals((String)"Wrong bus provider", (Object)"loopback", (Object)descriptor.getProviderConfigAsAddressDescriptor().type);
        Assert.assertEquals((String)"Wrong bus address", (Object)"test-descriptor-bus:200", (Object)descriptor.getProviderConfigAsAddressDescriptor().address);
        Assert.assertEquals((String)"Wrong bus provider property", (Object)"false", (Object)descriptor.getProviderConfig().getProperty("topic_starts_with_channel"));
    }
}

