/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.mon.util;

import com.neeve.aep.event.AepApplicationExceptionEvent;
import com.neeve.aep.event.AepBusBindingCreateFailedEvent;
import com.neeve.aep.event.AepBusBindingCreatedEvent;
import com.neeve.aep.event.AepBusBindingDestroyedEvent;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepDuplicateAcknowledgementAlertEvent;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.aep.event.AepEngineCreatedEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.event.AepInboundLogExceptionEvent;
import com.neeve.aep.event.AepMessageTraceLoggingExceptionEvent;
import com.neeve.aep.event.AepMessagingFailedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartFailedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.event.AepOutOfOrderSendCommitCompletionAlertEvent;
import com.neeve.aep.event.AepOutboundLogExceptionEvent;
import com.neeve.aep.event.AepSendExceptionEvent;
import com.neeve.aep.event.AepStatsAlertEvent;
import com.neeve.aep.event.AepStuckAlertEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.ci.XRuntime;
import com.neeve.event.alert.AlertEvent;
import com.neeve.event.alert.IAlertEvent;
import com.neeve.event.lifecycle.ILifecycleEvent;
import com.neeve.lang.XCollection;
import com.neeve.lang.XIterator;
import com.neeve.ods.impl.StoreBindingFailedEvent;
import com.neeve.ods.impl.StoreBindingRoleChangedEvent;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import com.neeve.ods.impl.StoreTransactionLogRepairedEvent;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogValidatable;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingInfo;
import com.neeve.server.mon.SrvMonAppBusBindingState;
import com.neeve.server.mon.SrvMonAppBusChannelInfo;
import com.neeve.server.mon.SrvMonAppClientInfo;
import com.neeve.server.mon.SrvMonAppFlowInfo;
import com.neeve.server.mon.SrvMonAppInfo;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonGaugeType;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.alert.ITriggeringMessageMetadata;
import com.neeve.server.mon.alert.SrvMonAppDuplicateAcknowledgementAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppInboundLogExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppOutOfOrderSendCommitCompletionAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppOutboundLogExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppSendExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppStatsAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppStoreTransactionLogRepairedMessage;
import com.neeve.server.mon.alert.SrvMonAppStuckAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppUnhandledMessageMessage;
import com.neeve.server.mon.alert.SrvMonMessageBusBindingReconnectedMessage;
import com.neeve.server.mon.alert.SrvMonMessageBusBindingReconnectingMessage;
import com.neeve.server.mon.alert.SrvMonMessageMetadata;
import com.neeve.server.mon.alert.SrvMonMessageTraceLoggingExceptionMessage;
import com.neeve.server.mon.alert.SrvMonUnhandledMessageMessage;
import com.neeve.server.mon.cnc.ISrvMonCommandDescription;
import com.neeve.server.mon.cnc.SrvMonArgumentType;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonOptionDescription;
import com.neeve.server.mon.cnc.SrvMonOptionType;
import com.neeve.server.mon.cnc.SrvMonReturnType;
import com.neeve.server.mon.cnc.SrvMonTraceLevel;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.common.ISrvMonAlertEvent;
import com.neeve.server.mon.common.ISrvMonLifecycleEvent;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreateFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpeningMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineActiveMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppingMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingPrestartMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingStartFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreBindingFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreBindingRoleChangedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberInitCompleteMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberUpMessage;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageBusBindingReconnectedEvent;
import com.neeve.sma.event.MessageBusBindingReconnectingEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.stats.IStats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.WordUtils;

public final class SrvMonUtil {
    private static final SimpleDateFormat tracerDateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss:SSS");
    private static final Tracer tracer = Tracer.get((String)"nv.server");

    public static final PktPacket serializeToPacket(IRogMessage message, boolean disposeMessage) {
        PktPacket packet = message.serializeToPacket();
        if (disposeMessage) {
            message.dispose();
        }
        return packet;
    }

    public static final SrvMonAppBusBindingInfo createMonAppBusBindingInfo(String busBindingName) {
        SrvMonAppBusBindingInfo busBindingInfo = SrvMonAppBusBindingInfo.create();
        busBindingInfo.setName(busBindingName);
        busBindingInfo.setState(SrvMonAppBusBindingState.Created);
        return busBindingInfo;
    }

    public static final boolean addMonAppBusBindingInfo(SrvMonAppInfo appInfo, SrvMonAppBusBindingInfo busBindingInfo) {
        appInfo.lendBusBindingsInfo(busBindingInfo);
        return true;
    }

    public static final SrvMonAppBusBindingInfo getMonAppBusBindingInfo(SrvMonAppInfo appInfo, String busBindingName) {
        SrvMonAppBusBindingInfo[] busBindingsInfo = appInfo.getBusBindingsInfo();
        if (busBindingsInfo != null) {
            for (int i = 0; i < busBindingsInfo.length; ++i) {
                if (busBindingsInfo[i] == null || !busBindingsInfo[i].getName().equals(busBindingName)) continue;
                return busBindingsInfo[i];
            }
        }
        return null;
    }

    public static final boolean updateMonAppBusBindingState(SrvMonAppInfo appInfo, String busBindingName, SrvMonAppBusBindingState newState) {
        SrvMonAppBusBindingInfo busBindingInfo = SrvMonUtil.getMonAppBusBindingInfo(appInfo, busBindingName);
        if (busBindingInfo != null) {
            busBindingInfo.setState(newState);
            return true;
        }
        return false;
    }

    public static final boolean removeMonAppBusBindingInfo(SrvMonAppInfo appInfo, String busBindingName) {
        SrvMonAppBusBindingInfo[] busBindingsInfo = appInfo.getBusBindingsInfo();
        if (busBindingsInfo != null) {
            for (int i = 0; i < busBindingsInfo.length; ++i) {
                if (busBindingsInfo[i] == null || !busBindingsInfo[i].getName().equals(busBindingName)) continue;
                busBindingsInfo[i] = null;
                appInfo.lendBusBindingsInfo(busBindingsInfo);
                return true;
            }
        }
        return false;
    }

    public static final SrvMonAppBusChannelInfo createMonAppBusChannelInfo(String busChannelName, boolean joined) {
        SrvMonAppBusChannelInfo busChannelInfo = SrvMonAppBusChannelInfo.create();
        busChannelInfo.setName(busChannelName);
        busChannelInfo.setJoined(joined);
        return busChannelInfo;
    }

    public static final boolean addMonAppBusChannelInfo(SrvMonAppBusBindingInfo busBindingInfo, SrvMonAppBusChannelInfo busChannelInfo) {
        busBindingInfo.lendChannelsInfo(busChannelInfo);
        return true;
    }

    public static final boolean addMonAppBusChannelInfo(SrvMonAppInfo appInfo, String busBindingName, SrvMonAppBusChannelInfo busChannelInfo) {
        SrvMonAppBusBindingInfo busBindingInfo = SrvMonUtil.getMonAppBusBindingInfo(appInfo, busBindingName);
        if (busBindingInfo != null) {
            return SrvMonUtil.addMonAppBusChannelInfo(busBindingInfo, busChannelInfo);
        }
        return false;
    }

    public static final boolean removeMonAppBusChannelInfo(SrvMonAppInfo appInfo, String busBindingName, String busChannelName) {
        SrvMonAppBusChannelInfo[] busChannelsInfo;
        SrvMonAppBusBindingInfo busBindingInfo = SrvMonUtil.getMonAppBusBindingInfo(appInfo, busBindingName);
        if (busBindingInfo != null && (busChannelsInfo = busBindingInfo.getChannelsInfo()) != null) {
            for (int i = 0; i < busChannelsInfo.length; ++i) {
                if (busChannelsInfo[i] == null || !busChannelsInfo[i].getName().equals(busChannelName)) continue;
                busChannelsInfo[i] = null;
                busBindingInfo.lendChannelsInfo(busChannelsInfo);
                return true;
            }
        }
        return false;
    }

    public static final SrvMonAppClientInfo createMonAppClientInfo(String clientName) {
        SrvMonAppClientInfo clientInfo = SrvMonAppClientInfo.create();
        clientInfo.setName(clientName);
        return clientInfo;
    }

    public static final boolean addMonAppClientInfo(SrvMonAppInfo appInfo, SrvMonAppClientInfo clientInfo) {
        appInfo.lendClientsInfo(clientInfo);
        return true;
    }

    public static final boolean removeMonAppClientInfo(SrvMonAppInfo appInfo, String clientName) {
        SrvMonAppClientInfo[] clientsInfo = appInfo.getClientsInfo();
        if (clientsInfo != null) {
            for (int i = 0; i < clientsInfo.length; ++i) {
                if (clientsInfo[i] == null || !clientsInfo[i].getName().equals(clientName)) continue;
                clientsInfo[i] = null;
                appInfo.lendClientsInfo(clientsInfo);
                return true;
            }
        }
        return false;
    }

    public static final SrvMonAppFlowInfo createMonAppFlowInfo(int flowid) {
        SrvMonAppFlowInfo appFlowInfo = SrvMonAppFlowInfo.create();
        appFlowInfo.setId(flowid);
        return appFlowInfo;
    }

    public static final boolean addMonAppFlowInfo(SrvMonAppInfo appInfo, SrvMonAppFlowInfo appFlowInfo) {
        appInfo.lendFlowsInfo(appFlowInfo);
        return true;
    }

    public static final SrvMonHeartbeatMessage prepareMonHeartbeatMessage(long statsCollectionStartWallTime, long statsCollectionStartTime, long statsCollectionEndTime, String xvmName, SrvMonSysStats sysStats, XCollection<SrvMonPoolStats> poolStats, XCollection<SrvMonAdminClientStats> adminClientStats, XCollection<SrvMonAppInfo> appsInfo, XCollection<SrvMonAppStats> appsStats) {
        SrvMonHeartbeatMessage message = SrvMonHeartbeatMessage.create();
        message.setCollectionStartWallTime(statsCollectionStartWallTime);
        message.setCollectionStartTime(statsCollectionStartTime);
        message.setCollectionEndTime(statsCollectionEndTime);
        message.setServerName(xvmName);
        message.setServerPid(XRuntime.getPid());
        message.setSysStats(sysStats);
        message.setPoolStatsFrom((XIterator<SrvMonPoolStats>)poolStats.reusableIterator());
        message.setAdminClientStatsFrom((XIterator<SrvMonAdminClientStats>)adminClientStats.reusableIterator());
        message.setAppsInfoFrom((XIterator<SrvMonAppInfo>)appsInfo.reusableIterator());
        message.setAppsStatsFrom((XIterator<SrvMonAppStats>)appsStats.reusableIterator());
        return message;
    }

    public static void addGaugeValue(SrvMonUserGaugeStat srvMonUserGaugeStat, IStats.Gauge gauge) {
        switch (gauge.getType()) {
            case Boolean: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.BOOLEAN);
                srvMonUserGaugeStat.setBooleanValue(gauge.getBooleanValue());
                break;
            }
            case Byte: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.BYTE);
                srvMonUserGaugeStat.setByteValue(gauge.getByteValue());
                break;
            }
            case Char: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.CHAR);
                srvMonUserGaugeStat.setCharValue(gauge.getCharValue());
                break;
            }
            case Double: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.DOUBLE);
                srvMonUserGaugeStat.setDoubleValue(gauge.getDoubleValue());
                break;
            }
            case Float: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.FLOAT);
                srvMonUserGaugeStat.setFloatValue(gauge.getFloatValue());
                break;
            }
            case Int: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.INT);
                srvMonUserGaugeStat.setIntValue(gauge.getIntValue());
                break;
            }
            case Long: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.LONG);
                srvMonUserGaugeStat.setLongValue(gauge.getLongValue());
                break;
            }
            case Short: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.SHORT);
                srvMonUserGaugeStat.setShortValue(gauge.getShortValue());
                break;
            }
            case String: {
                srvMonUserGaugeStat.setGuageType(SrvMonGaugeType.STRING);
                srvMonUserGaugeStat.setStringValueFrom(gauge.getStringValue());
            }
        }
    }

    public static Object getGaugeValue(SrvMonUserGaugeStat srvMonUserGaugeStat) {
        switch (srvMonUserGaugeStat.getGuageType()) {
            case BOOLEAN: {
                return srvMonUserGaugeStat.getBooleanValue();
            }
            case BYTE: {
                return srvMonUserGaugeStat.getByteValue();
            }
            case CHAR: {
                return Character.valueOf(srvMonUserGaugeStat.getCharValue());
            }
            case DOUBLE: {
                return srvMonUserGaugeStat.getDoubleValue();
            }
            case FLOAT: {
                return Float.valueOf(srvMonUserGaugeStat.getFloatValue());
            }
            case INT: {
                return srvMonUserGaugeStat.getIntValue();
            }
            case LONG: {
                return srvMonUserGaugeStat.getLongValue();
            }
            case SHORT: {
                return srvMonUserGaugeStat.getShortValue();
            }
            case STRING: {
                return srvMonUserGaugeStat.getStringValue();
            }
        }
        return null;
    }

    private static final void setLifecycleEventDetails(String source, ILifecycleEvent event, ISrvMonLifecycleEvent message) {
        message.setEventTimestampAsTimestamp(event.getEventTime());
        if (source != null) {
            message.setEventSource(source);
        } else if (event.getSource() != null) {
            message.setEventSource(event.getSource().getName());
        }
    }

    private static final void setAlertEventDetails(String source, IAlertEvent event, ISrvMonAlertEvent message) {
        message.setEventTimestampAsTimestamp(event.getEventTime());
        if (source != null) {
            message.setEventSource(source);
        } else if (event.getSource() != null) {
            message.setEventSource(event.getSource().getName());
        }
    }

    public static final SrvMonAppBusBindingCreatedMessage setBackingMessage(String appName, AepBusBindingCreatedEvent event) {
        SrvMonAppBusBindingCreatedMessage message = SrvMonAppBusBindingCreatedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        message.setBusBindingInfo(SrvMonUtil.createMonAppBusBindingInfo(event.getBusBindingName()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingCreateFailedMessage setBackingMessage(String appName, AepBusBindingCreateFailedEvent event) {
        SrvMonAppBusBindingCreateFailedMessage message = SrvMonAppBusBindingCreateFailedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppEngineCreatedMessage setBackingMessage(String appName, AepEngineCreatedEvent event) {
        SrvMonAppEngineCreatedMessage message = SrvMonAppEngineCreatedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreMemberUpMessage setBackingMessage(String appName, StoreMemberUpEvent event) {
        SrvMonAppStoreMemberUpMessage message = SrvMonAppStoreMemberUpMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setMemberName(event.getMember() != null ? event.getMember().getName() : "<unknown>");
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreMemberInitCompleteMessage setBackingMessage(String appName, StoreMemberInitCompleteEvent event) {
        SrvMonAppStoreMemberInitCompleteMessage message = SrvMonAppStoreMemberInitCompleteMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setMemberName(event.getMember() != null ? event.getMember().getName() : "<unknown>");
        message.setLastTransactionId(event.getLastTransactionId());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppEngineStartedMessage setBackingMessage(String appName, AepEngineStartedEvent event) {
        SrvMonAppEngineStartedMessage message = SrvMonAppEngineStartedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingOpeningMessage setBackingMessage(String appName, AepBusBindingOpeningEvent event) {
        SrvMonAppBusBindingOpeningMessage message = SrvMonAppBusBindingOpeningMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingOpenedMessage setBackingMessage(String appName, AepBusBindingOpenedEvent event) {
        SrvMonAppBusBindingOpenedMessage message = SrvMonAppBusBindingOpenedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingOpenFailedMessage setBackingMessage(String appName, AepBusBindingOpenFailedEvent event) {
        SrvMonAppBusBindingOpenFailedMessage message = SrvMonAppBusBindingOpenFailedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        message.setTemporary(event.isTemporary());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppChannelUpMessage setBackingMessage(String appName, AepChannelUpEvent event) {
        SrvMonAppChannelUpMessage message = SrvMonAppChannelUpMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getMessageBusBinding().getDescriptor().getName());
        message.setChannelName(event.getMessageChannel().getName());
        message.setIsJoined(event.getMessageChannel().isJoined());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingUpMessage setBackingMessage(String appName, AepBusBindingUpEvent event) {
        SrvMonAppBusBindingUpMessage message = SrvMonAppBusBindingUpMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getMessageBusBinding().getDescriptor().getName());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppMessagingPrestartMessage setBackingMessage(String appName, AepMessagingPrestartEvent event) {
        SrvMonAppMessagingPrestartMessage message = SrvMonAppMessagingPrestartMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppMessagingStartedMessage setBackingMessage(String appName, AepMessagingStartedEvent event) {
        SrvMonAppMessagingStartedMessage message = SrvMonAppMessagingStartedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setStatus(event.getStatus() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getStatus()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppMessagingStartFailedMessage setBackingMessage(String appName, AepMessagingStartFailedEvent event) {
        SrvMonAppMessagingStartFailedMessage message = SrvMonAppMessagingStartFailedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppEngineActiveMessage setBackingMessage(String appName, AepEngineActiveEvent event) {
        SrvMonAppEngineActiveMessage message = SrvMonAppEngineActiveMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreBindingRoleChangedMessage setBackingMessage(String appName, StoreBindingRoleChangedEvent event) {
        SrvMonAppStoreBindingRoleChangedMessage message = SrvMonAppStoreBindingRoleChangedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setRole(event.getRole().toString());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreMemberDownMessage setBackingMessage(String appName, StoreMemberDownEvent event) {
        SrvMonAppStoreMemberDownMessage message = SrvMonAppStoreMemberDownMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setMemberName(event.getMember() != null ? event.getMember().getName() : "<unknown>");
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreBindingFailedMessage setBackingMessage(String appName, StoreBindingFailedEvent event) {
        SrvMonAppStoreBindingFailedMessage message = SrvMonAppStoreBindingFailedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppChannelDownMessage setBackingMessage(String appName, AepChannelDownEvent event) {
        SrvMonAppChannelDownMessage message = SrvMonAppChannelDownMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getMessageBusBinding().getDescriptor().getName());
        message.setChannelName(event.getMessageChannel().getName());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingDownMessage setBackingMessage(String appName, AepBusBindingDownEvent event) {
        SrvMonAppBusBindingDownMessage message = SrvMonAppBusBindingDownMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getMessageBusBinding().getDescriptor().getName());
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppMessagingFailedMessage setBackingMessage(String appName, AepMessagingFailedEvent event) {
        SrvMonAppMessagingFailedMessage message = SrvMonAppMessagingFailedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppBusBindingDestroyedMessage setBackingMessage(String appName, AepBusBindingDestroyedEvent event) {
        SrvMonAppBusBindingDestroyedMessage message = SrvMonAppBusBindingDestroyedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setBusBindingName(event.getBusBindingName());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppEngineStoppedMessage setBackingMessage(String appName, AepEngineStoppedEvent event) {
        SrvMonAppEngineStoppedMessage message = SrvMonAppEngineStoppedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static SrvMonAppEngineStoppingMessage setBackingMessage(String appName, AepEngineStoppingEvent event) {
        SrvMonAppEngineStoppingMessage message = SrvMonAppEngineStoppingMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setLifecycleEventDetails(appName, (ILifecycleEvent)event, message);
        message.setCause(event.getCause() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getCause()));
        message.setPreserveChannelJoins(event.getPreserveChannelJoins());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStoreTransactionLogRepairedMessage setBackingMessage(String appName, StoreTransactionLogRepairedEvent event) {
        SrvMonAppStoreTransactionLogRepairedMessage message = SrvMonAppStoreTransactionLogRepairedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppDuplicateAcknowledgementAlertMessage setBackingMessage(String appName, AepDuplicateAcknowledgementAlertEvent event) {
        SrvMonAppDuplicateAcknowledgementAlertMessage message = SrvMonAppDuplicateAcknowledgementAlertMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonAppInboundLogExceptionMessage setBackingMessage(String appName, AepInboundLogExceptionEvent event) {
        SrvMonAppInboundLogExceptionMessage message = SrvMonAppInboundLogExceptionMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setException(event.getException() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getException()));
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonAppOutboundLogExceptionMessage setBackingMessage(String appName, AepOutboundLogExceptionEvent event) {
        SrvMonAppOutboundLogExceptionMessage message = SrvMonAppOutboundLogExceptionMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setException(event.getException() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getException()));
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonAppOutOfOrderSendCommitCompletionAlertMessage setBackingMessage(String appName, AepOutOfOrderSendCommitCompletionAlertEvent event) {
        SrvMonAppOutOfOrderSendCommitCompletionAlertMessage message = SrvMonAppOutOfOrderSendCommitCompletionAlertMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setCompletedCommitTxnId(event.getCompletedCommitTxnId());
        message.setFirstReleasedCommitTxnId(event.getFirstReleasedCommitTxnId());
        message.setLastReleasedCommitTxnId(event.getLastReleasedCommitTxnId());
        message.setFirstIncompleteCommitTxnId(event.getFirstIncompleteCommitTxnId());
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonAppSendExceptionMessage setBackingMessage(String appName, AepSendExceptionEvent event) {
        SrvMonAppSendExceptionMessage message = SrvMonAppSendExceptionMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setException(event.getException() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getException()));
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        message.setFailedSendMessageMetadata(SrvMonUtil.createMessageMetadata(event.getMessageView()));
        return message;
    }

    public static final SrvMonAppStatsAlertMessage setBackingMessage(String appName, AepStatsAlertEvent event) {
        SrvMonAppStatsAlertMessage message = SrvMonAppStatsAlertMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setMetricName(event.getMetricName());
        message.setMetricValue(event.getMetricValue() != null ? event.getMetricValue().toString() : null);
        message.setMetricAlertThreshold(event.getMetricAlertThreshold() != null ? event.getMetricAlertThreshold().toString() : null);
        message.setAlertType(event.getAlertType() != null ? event.getAlertType().toString() : null);
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppStuckAlertMessage setBackingMessage(String appName, AepStuckAlertEvent event) {
        SrvMonAppStuckAlertMessage message = SrvMonAppStuckAlertMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setReason(event.getReason() != null ? event.getReason().toString() : null);
        message.setLastEventProcessedTimestamp(event.getLastEventProcessedTimestamp());
        message.setLastCommitCompletionTimestamp(event.getLastCommitCompletionTimestamp());
        message.setIncompleteCommitCount(event.getIncompleteCommitCount());
        message.setDescription(event.message());
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonUnhandledMessageMessage setBackingMessage(String appName, UnhandledMessageEvent event) {
        SrvMonUnhandledMessageMessage message = SrvMonUnhandledMessageMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        if (event.getReason() != null) {
            message.setException(UtlThrowable.prepareStackTrace((Throwable)event.getReason()));
        }
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        if (event.getMessageMetadata() != null) {
            SrvMonUtil.fillInTriggeringMessageMetadata(event.getMessageMetadata(), (ITriggeringMessageMetadata)message);
            if (event.getMessageMetadata().getMessageChannelNameAsRaw() == null && event.getMessageChannel() != null) {
                message.setTriggeringMessageMessageChannelNameFrom(event.getMessageChannel().getNameAsRaw());
            }
        } else if (event.getMessageChannel() != null) {
            message.setTriggeringMessageMessageChannelNameFrom(event.getMessageChannel().getNameAsRaw());
            message.setTriggeringMessageMessageChannelIdFrom(event.getMessageChannel().getId());
        }
        message.setTriggeringMessageMessageKey(event.getMessageKey());
        if (event.getMessageBusBinding() != null) {
            message.setTriggeringMessageMessageBusName(event.getMessageBusBinding().getName());
            message.setTriggeringMessageMessageBusType(event.getMessageBusBinding().getType());
        }
        message.setTriggeringMessageSMATransportMessageId(event.getMessageSMATransportMessageId());
        message.setTriggeringMessageSMAMessagePayloadBlob(event.getSerializedPayloadBlob());
        message.setTriggeringMessageSMAMessageMetadataBlob(event.getSerializedMetadataBlob());
        return message;
    }

    public static final SrvMonMessageTraceLoggingExceptionMessage setBackingMessage(String appName, AepMessageTraceLoggingExceptionEvent event) {
        SrvMonMessageTraceLoggingExceptionMessage message = SrvMonMessageTraceLoggingExceptionMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setOperation(event.getOperation());
        if (event.getException() != null) {
            message.setException(UtlThrowable.prepareStackTrace((Throwable)event.getException()));
        }
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonAppUnhandledMessageMessage setBackingMessage(String appName, AepUnhandledMessageEvent event) {
        SrvMonAppUnhandledMessageMessage message = SrvMonAppUnhandledMessageMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    public static final SrvMonMessageBusBindingReconnectingMessage setBackingMessage(String appName, MessageBusBindingReconnectingEvent event) {
        SrvMonMessageBusBindingReconnectingMessage message = SrvMonMessageBusBindingReconnectingMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        MessageBusBinding binding = event.getMessageBusBinding();
        if (binding != null) {
            message.setBusName(binding.getName());
        }
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonMessageBusBindingReconnectedMessage setBackingMessage(String appName, MessageBusBindingReconnectedEvent event) {
        SrvMonMessageBusBindingReconnectedMessage message = SrvMonMessageBusBindingReconnectedMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        MessageBusBinding binding = event.getMessageBusBinding();
        if (binding != null) {
            message.setBusName(binding.getName());
        }
        event.setBackingMessage((MessageView)message);
        return message;
    }

    public static final SrvMonAppExceptionMessage setBackingMessage(String appName, AepApplicationExceptionEvent event) {
        SrvMonAppExceptionMessage message = SrvMonAppExceptionMessage.create();
        message.setTimestamp(event.getEventTime());
        SrvMonUtil.setAlertEventDetails(appName, (IAlertEvent)event, message);
        message.setException(event.getException() == null ? null : UtlThrowable.prepareStackTrace((Throwable)event.getException()));
        event.setBackingMessage((MessageView)message);
        SrvMonUtil.fillInTriggeringMessageMetadata((AlertEvent)event, (ITriggeringMessageMetadata)message);
        return message;
    }

    private static final SrvMonMessageMetadata createMessageMetadata(MessageView view) {
        if (view != null) {
            SrvMonMessageMetadata metadata = SrvMonMessageMetadata.create();
            try {
                metadata.setMessageMessageBusName(view.getMessageBus());
                metadata.setMessageMessageChannelName(view.getMessageChannel());
                metadata.setMessageMessageKey(view.getMessageKey());
                metadata.setMessageMessageEncodingType((byte)view.getMessageEncodingType());
                metadata.setMessageMessageFactoryId(view.getVfid());
                metadata.setMessageMessageViewId(view.getType());
                metadata.setMessageMessageFlowId(view.getMessageFlow());
                metadata.setMessageMessageSenderId(view.getMessageSender());
                metadata.setMessageMessageSno(view.getMessageSequenceNumber());
            }
            catch (Exception e) {
                tracer.log("Error populating message metadata: " + e.getMessage(), Tracer.Level.WARNING);
                metadata.dispose();
                metadata = null;
            }
            return metadata;
        }
        return null;
    }

    private static final void fillInTriggeringMessageMetadata(AlertEvent alertEvent, ITriggeringMessageMetadata backingMessage) {
        MessageView view = alertEvent.getTriggeringMessage();
        if (view != null) {
            try {
                backingMessage.setTriggeringMessageMessageBusName(view.getMessageBus());
                backingMessage.setTriggeringMessageMessageChannelName(view.getMessageChannel());
                backingMessage.setTriggeringMessageMessageKey(view.getMessageKey());
                backingMessage.setTriggeringMessageMessageEncodingType((byte)view.getMessageEncodingType());
                backingMessage.setTriggeringMessageMessageFactoryId(view.getVfid());
                backingMessage.setTriggeringMessageMessageViewId(view.getType());
                backingMessage.setTriggeringMessageMessageFlowId(view.getMessageFlow());
                backingMessage.setTriggeringMessageMessageSenderId(view.getMessageSender());
                backingMessage.setTriggeringMessageMessageSno(view.getMessageSequenceNumber());
            }
            catch (Exception e) {
                tracer.log("Error populating triggering message metadata: " + e.getMessage(), Tracer.Level.WARNING);
            }
        }
    }

    private static final void fillInTriggeringMessageMetadata(MessageMetadata metadata, ITriggeringMessageMetadata backingMessage) {
        if (metadata != null) {
            try {
                backingMessage.setTriggeringMessageMessageChannelName(metadata.getMessageChannelName());
                backingMessage.setTriggeringMessageMessageEncodingType(metadata.getMessageEncodingType());
                backingMessage.setTriggeringMessageMessageFactoryId(metadata.getMessageViewFactory());
                backingMessage.setTriggeringMessageMessageViewId(metadata.getMessageViewType());
                backingMessage.setTriggeringMessageMessageFlowId(metadata.getMessageFlow());
                backingMessage.setTriggeringMessageMessageSenderId(metadata.getMessageSender());
                backingMessage.setTriggeringMessageMessageSno(metadata.getMessageSno());
            }
            catch (Exception e) {
                tracer.log("Error populating triggering message metadata: " + e.getMessage(), Tracer.Level.WARNING);
            }
        }
    }

    public static final SrvMonArgumentType convertToArgumentType(Class<?> targetType) {
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return SrvMonArgumentType.INT;
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return SrvMonArgumentType.BOOLEAN;
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return SrvMonArgumentType.DOUBLE;
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return SrvMonArgumentType.FLOAT;
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return SrvMonArgumentType.LONG;
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return SrvMonArgumentType.BYTE;
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return SrvMonArgumentType.SHORT;
        }
        if (targetType == Date.class) {
            return SrvMonArgumentType.DATE;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return SrvMonArgumentType.CHAR;
        }
        if (targetType.isEnum()) {
            return SrvMonArgumentType.STRING;
        }
        return SrvMonArgumentType.STRING;
    }

    public static final SrvMonReturnType convertToReturnType(Class<?> targetType) {
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return SrvMonReturnType.BOOLEAN;
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return SrvMonReturnType.BYTE;
        }
        if (targetType == Character.TYPE || targetType == Character.class) {
            return SrvMonReturnType.CHAR;
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return SrvMonReturnType.SHORT;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return SrvMonReturnType.INT;
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return SrvMonReturnType.LONG;
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return SrvMonReturnType.FLOAT;
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return SrvMonReturnType.DOUBLE;
        }
        if (targetType == Date.class) {
            return SrvMonReturnType.DATE;
        }
        if (targetType == Void.TYPE || targetType == Void.class) {
            return SrvMonReturnType.VOID;
        }
        return SrvMonReturnType.STRING;
    }

    public static final SrvMonOptionType convertToOptionType(Class<?> targetType) {
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return SrvMonOptionType.INT;
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return SrvMonOptionType.BOOLEAN;
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return SrvMonOptionType.DOUBLE;
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return SrvMonOptionType.FLOAT;
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return SrvMonOptionType.LONG;
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return SrvMonOptionType.BYTE;
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return SrvMonOptionType.SHORT;
        }
        if (targetType == Date.class) {
            return SrvMonOptionType.DATE;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return SrvMonOptionType.CHAR;
        }
        if (targetType.isEnum()) {
            return SrvMonOptionType.STRING;
        }
        return SrvMonOptionType.STRING;
    }

    /*
     * WARNING - void declaration
     */
    public static final void printCommmandUsage(ISrvMonCommandDescription command, Appendable builder) {
        try {
            boolean first;
            builder.append("").append(command.getName()).append(command.hasDisplayName() ? " (\"" + command.getDisplayName() + "\")" : "").append("\n");
            builder.append("  ").append(command.getDescription());
            builder.append("\n  Usage:\n\n");
            builder.append("  ").append(command.getName()).append(" ");
            for (SrvMonOptionDescription srvMonOptionDescription : command.getOptionsEmptyIfNull()) {
                if (!srvMonOptionDescription.getRequired()) {
                    builder.append("[");
                }
                builder.append("-").append(srvMonOptionDescription.getShortForm());
                if (!srvMonOptionDescription.getRequired()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            for (IRogValidatable iRogValidatable : command.getArgumentsEmptyIfNull()) {
                if (!iRogValidatable.getRequired()) {
                    builder.append("[");
                }
                builder.append("<").append(iRogValidatable.getName()).append(">");
                if (!iRogValidatable.getRequired()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            builder.append("\n");
            String optionIndent = "       ";
            String optionNewlineIndent = "           ";
            for (SrvMonOptionDescription srvMonOptionDescription : command.getOptionsEmptyIfNull()) {
                StringBuilder optionUsage = new StringBuilder();
                if (!srvMonOptionDescription.getRequired()) {
                    optionUsage.append("[");
                }
                optionUsage.append("<-" + srvMonOptionDescription.getShortForm() + "|--" + srvMonOptionDescription.getLongForm() + "> ");
                if (srvMonOptionDescription.getValidValuesEmptyIfNull().length > 0) {
                    optionUsage.append("<");
                    first = true;
                    for (String option : srvMonOptionDescription.getValidValuesEmptyIfNull()) {
                        if (!first) {
                            optionUsage.append("|");
                        }
                        first = false;
                        optionUsage.append(option);
                    }
                    optionUsage.append("> ");
                }
                if (srvMonOptionDescription.getDescription() != null) {
                    optionUsage.append(srvMonOptionDescription.getDescription());
                }
                if (srvMonOptionDescription.getDefaultValue() != null) {
                    optionUsage.append(" default='" + srvMonOptionDescription.getDefaultValue() + "'");
                }
                if (!srvMonOptionDescription.getRequired()) {
                    optionUsage.append("]");
                }
                builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage.toString(), (int)68, (String)("\n" + optionNewlineIndent), (boolean)false)).append("\n");
            }
            for (IRogValidatable iRogValidatable : command.getArgumentsEmptyIfNull()) {
                StringBuilder argsUsage = new StringBuilder();
                if (!iRogValidatable.getRequired()) {
                    argsUsage.append("[");
                }
                argsUsage.append(iRogValidatable.getName() + ": ");
                if (iRogValidatable.getValidValuesEmptyIfNull().length > 0) {
                    argsUsage.append("<");
                    first = true;
                    for (String option : iRogValidatable.getValidValuesEmptyIfNull()) {
                        if (!first) {
                            argsUsage.append("|");
                        }
                        first = false;
                        argsUsage.append(option);
                    }
                    argsUsage.append("> ");
                }
                if (iRogValidatable.getDescription() != null) {
                    argsUsage.append(iRogValidatable.getDescription());
                } else {
                    argsUsage.append("a '" + UtlText.toFirstLetterUppercase((String)iRogValidatable.getType().name().toLowerCase()) + "'");
                }
                if (iRogValidatable.getDefaultValue() != null) {
                    argsUsage.append(" default='" + iRogValidatable.getDefaultValue() + "'");
                }
                if (!iRogValidatable.getRequired()) {
                    argsUsage.append("]");
                }
                builder.append(optionIndent).append(WordUtils.wrap((String)argsUsage.toString(), (int)68, (String)("\n" + optionNewlineIndent), (boolean)false)).append("\n");
            }
            String[] aliases = command.getAliases();
            if (aliases != null && aliases.length > 0) {
                void var5_14;
                builder.append("\n  Aliases: ");
                boolean bl = false;
                while (var5_14 < aliases.length) {
                    if (var5_14 > 0) {
                        builder.append(", ");
                    }
                    builder.append(aliases[var5_14]);
                    ++var5_14;
                }
                builder.append("\n");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Appendable formatTraceRecordTo(SrvMonTraceRecord traceRecord, Appendable sb) {
        try {
            if (traceRecord.getLegacy()) {
                sb.append(traceRecord.getTrace());
            } else {
                sb.append("<");
                sb.append(Long.toString(traceRecord.getThreadId()));
                sb.append(",");
                sb.append(traceRecord.getProcessId());
                sb.append(",");
                sb.append(traceRecord.getHostName());
                sb.append("> ");
                SimpleDateFormat simpleDateFormat = tracerDateFormat;
                synchronized (simpleDateFormat) {
                    sb.append(tracerDateFormat.format(new Date(traceRecord.getTimestamp())));
                }
                sb.append(" (");
                sb.append(SrvMonUtil.getLevel(traceRecord.getLevel()));
                sb.append(")...");
                sb.append(traceRecord.getTrace());
                sb.append("\n");
            }
            return sb;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error formatting trace record");
        }
    }

    private static final String getLevel(SrvMonTraceLevel level) {
        if (level == SrvMonTraceLevel.FINEST) {
            return "dbg";
        }
        if (level == SrvMonTraceLevel.FINER) {
            return "fin";
        }
        if (level == SrvMonTraceLevel.FINE) {
            return "fin";
        }
        if (level == SrvMonTraceLevel.CONFIG) {
            return "cfg";
        }
        if (level == SrvMonTraceLevel.INFO) {
            return "inf";
        }
        if (level == SrvMonTraceLevel.WARNING) {
            return "wrn";
        }
        if (level == SrvMonTraceLevel.SEVERE) {
            return "sev";
        }
        return "unk";
    }

    public static Object getResponseValue(SrvMonInvokeCommandResponse response) {
        if (!response.hasReturnType()) {
            return response.getStringReturnValue();
        }
        switch (response.getReturnType()) {
            case BOOLEAN: {
                return response.getBooleanReturnValue();
            }
            case BYTE: {
                return response.getByteReturnValue();
            }
            case CHAR: {
                return Character.valueOf(response.getCharReturnValue());
            }
            case DATE: {
                return response.getDateReturnValue();
            }
            case DOUBLE: {
                return response.getDoubleReturnValue();
            }
            case FLOAT: {
                return Float.valueOf(response.getFloatReturnValue());
            }
            case INT: {
                return response.getIntReturnValue();
            }
            case LONG: {
                return response.getLongReturnValue();
            }
            case SHORT: {
                return response.getShortReturnValue();
            }
            case STRING: {
                return response.getStringReturnValue();
            }
            case VOID: {
                return null;
            }
        }
        return null;
    }
}

