/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import com.neeve.server.controller.SrvController;
import com.neeve.util.UtlEnv;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;

final class SrvControllerSunOsMbeanAccessor
implements SrvController.StatsRunner.Sys.SunOperatingSystemMXBean {
    private static final boolean disableCpuLoadStats = UtlEnv.getValue((String)"nv.server.stats.disableenhancedcpuloadstats", (boolean)false);
    private final OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private final Method processCpuLoadMethod;
    private final Method systemCpuLoadMethod;

    public SrvControllerSunOsMbeanAccessor() {
        Method processCpuLoadMethod = null;
        if (!disableCpuLoadStats) {
            try {
                processCpuLoadMethod = OperatingSystemMXBean.class.getMethod("getProcessCpuLoad", new Class[0]);
                if (processCpuLoadMethod.getReturnType() != Double.TYPE) {
                    processCpuLoadMethod = null;
                }
                ((Double)processCpuLoadMethod.invoke((Object)this.osBean, new Object[0])).doubleValue();
            }
            catch (Throwable thrown) {
                processCpuLoadMethod = null;
            }
        }
        this.processCpuLoadMethod = processCpuLoadMethod;
        Method systemCpuLoadMethod = null;
        if (!disableCpuLoadStats) {
            try {
                systemCpuLoadMethod = OperatingSystemMXBean.class.getMethod("getSystemCpuLoad", new Class[0]);
                if (systemCpuLoadMethod.getReturnType() != Double.TYPE) {
                    systemCpuLoadMethod = null;
                }
                ((Double)systemCpuLoadMethod.invoke((Object)this.osBean, new Object[0])).doubleValue();
            }
            catch (Throwable thrown) {
                systemCpuLoadMethod = null;
            }
        }
        this.systemCpuLoadMethod = systemCpuLoadMethod;
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.osBean.getCommittedVirtualMemorySize();
    }

    @Override
    public long getTotalSwapSpaceSize() {
        return this.osBean.getTotalSwapSpaceSize();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        return this.osBean.getFreeSwapSpaceSize();
    }

    @Override
    public long getProcessCpuTime() {
        return this.osBean.getProcessCpuTime();
    }

    @Override
    public double getProcessCpuLoad() {
        if (this.processCpuLoadMethod != null) {
            try {
                return (Double)this.processCpuLoadMethod.invoke((Object)this.osBean, new Object[0]);
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Error getting process cpu load");
            }
        }
        return -1.0;
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.systemCpuLoadMethod != null) {
            try {
                return (Double)this.systemCpuLoadMethod.invoke((Object)this.osBean, new Object[0]);
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Error getting system cpu load");
            }
        }
        return -1.0;
    }

    @Override
    public long getFreePhysicalMemorySize() {
        return this.osBean.getFreePhysicalMemorySize();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.osBean.getTotalPhysicalMemorySize();
    }

    @Override
    public boolean enhancedProcessorLoadStatsAvailable() {
        return this.systemCpuLoadMethod != null || this.processCpuLoadMethod != null;
    }
}

