/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.client;

import com.neeve.ci.XRuntime;
import com.neeve.client.ClientConnection;
import com.neeve.client.ClientConnectionPool;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.pkt.PktPacket;
import com.neeve.server.client.SrvClient;
import com.neeve.util.UtlList;

public abstract class SrvClientConnection
extends ClientConnection {
    private String app;

    protected SrvClientConnection(String name, SrvClient<?> client, IClientConnectionPoolEventHandler eventHandler) {
        super(name, client, eventHandler);
    }

    @Override
    protected void onLinkOpen(ILnkPeerEndpoint pep) throws Exception {
    }

    @Override
    protected void onOpen() {
    }

    @Override
    protected boolean handlePacket(PktPacket packet) {
        return false;
    }

    @Override
    protected void handlePacketList(UtlList list) {
    }

    @Override
    protected boolean handleMessage(ILnkMessage message) {
        if (!this.canSetMessageFactory()) {
            throw new InternalError("received a message when message dispatch is explictly not supported!");
        }
        return false;
    }

    @Override
    protected void handleMessageList(UtlList list) {
        if (!this.canSetMessageFactory()) {
            throw new InternalError("received a message list when message dispatch is explictly not supported!");
        }
    }

    @Override
    protected boolean handleFailure(Exception e) {
        return false;
    }

    @Override
    protected void onClose() {
    }

    @Override
    protected final String getServerLinkDescriptor(String linkName) {
        StringBuilder sb = new StringBuilder();
        sb.append("server://");
        sb.append(this.app == null ? "null" : this.app);
        sb.append("&clientname=" + (this.client.getName() == null ? XRuntime.getAppName() : this.client.getName()));
        sb.append("&clientgroup=" + (this.group == null ? XRuntime.getAppGroup() : this.group));
        sb.append("&threadaff=" + this.threadAffinity);
        sb.append("&maxusers=1");
        sb.append("&appver=" + this.getAppVersion());
        sb.append("&base=" + linkName);
        return sb.toString();
    }

    public abstract short getAppVersion();

    public final SrvClientConnection setApp(String app) {
        if (this.state != ClientConnectionPool.State.INIT) {
            throw this.prepareIllegalStateException(ClientConnectionPool.State.INIT, this.state);
        }
        this.app = app;
        return this;
    }

    public final String getApp() {
        return this.app;
    }
}

