/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl.direct;

import com.neeve.adm.AdmFactory;
import com.neeve.client.EClientException;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.client.IClientEventHandler;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkRequest;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderSMA;
import com.neeve.pkt.types.PktBodyServerAdminReply;
import com.neeve.pkt.types.PktBodyServerAdminRequest;
import com.neeve.pkt.types.PktBodyServerTraceRecord;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.impl.direct.AdminClientConnection;
import com.neeve.server.admin.impl.direct.EAdminClientServerError;
import com.neeve.server.client.SrvClient;
import com.neeve.server.mon.SrvMonFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.alert.SrvMonAlertFactory;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.SrvMonCncFactory;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.lifecycle.SrvMonLifecycleFactory;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlList;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

final class AdminClient
extends SrvClient<AdminClientConnection> {
    static final short MIN_APP_VERSION = 1;
    private final SrvMonFactory monFactory;
    private final SrvMonCncFactory monCncFactory;
    private final SrvMonLifecycleFactory monLifecycleFactory;
    private final SrvMonAlertFactory monAlertFactory;
    private final String tracePrefix;
    private AtomicBoolean traceWatchStarted = new AtomicBoolean(false);
    private AtomicBoolean appWatchStarted = new AtomicBoolean(false);
    private AtomicBoolean appWatchJoined = new AtomicBoolean(false);
    private int adminCompatLevel = 1;

    AdminClient(String name, IClientEventHandler eventHandler) {
        super("admin", name, eventHandler);
        this.monFactory = new SrvMonFactory();
        this.monCncFactory = new SrvMonCncFactory();
        this.monLifecycleFactory = new SrvMonLifecycleFactory();
        this.monAlertFactory = new SrvMonAlertFactory();
        this.tracePrefix = "[AdminClient '" + name + "'] ";
    }

    public static AdminClient create(String name, IClientEventHandler eventHandler) {
        return new AdminClient(name, eventHandler);
    }

    @Override
    protected final AdminClientConnection doCreateConnection(String name, IClientConnectionPoolEventHandler eventHandler) {
        return new AdminClientConnection(name, this, eventHandler);
    }

    @Override
    protected final void onPacket(PktPacket packet) {
        MessageView message = this.packetToMessage(packet);
        if (message != null) {
            this.dispatchEvent(452, message);
            if (message instanceof SrvMonHeartbeatMessage) {
                this.appWatchJoined.set(true);
            }
            message.dispose();
            return;
        }
        PktBody body = packet.getBody();
        int packetType = body.getType();
        switch (packetType) {
            case 560: {
                if (!this.traceWatchStarted.get()) break;
                String record = ((PktBodyServerTraceRecord)body).getRecord();
                this.dispatchEvent(451, record);
                break;
            }
            default: {
                this.tracer.log(this.tracePrefix + "Received unknown admin message type '" + packetType + "/'" + body.getClass().getSimpleName() + "': " + packet, Tracer.Level.WARNING);
            }
        }
    }

    final MessageView packetToMessage(PktPacket packet) {
        PktSubheaderSMA smaHeader = packet.getHeader().getSMASubheader();
        PktBody body = packet.getBody();
        int packetType = body.getType();
        if (smaHeader != null) {
            int encoding = smaHeader.getMessageEncodingType();
            short vfid = smaHeader.getMessageViewFactoryId();
            short vtype = smaHeader.getMessageViewType();
            if (vfid == 1 || vfid == 7) {
                vfid = AdmFactory.decodeObjectFactoryIdFromPacketId((int)packetType);
                vtype = AdmFactory.decodeObjectTypeFormPacketId((int)packetType);
                switch (vfid) {
                    case 32: 
                    case 34: 
                    case 35: 
                    case 36: {
                        encoding = 3;
                        break;
                    }
                    default: {
                        if (!this.tracer.debug) break;
                        this.tracer.log(this.tracePrefix + "Received Raw Admin packet of a non monitoring factory packet type: " + packetType, Tracer.Level.DEBUG);
                    }
                }
            }
            Object factory = null;
            switch (vfid) {
                case 1: 
                case 7: {
                    factory = null;
                    break;
                }
                case 36: {
                    factory = this.monCncFactory;
                    break;
                }
                case 32: {
                    factory = this.monFactory;
                    break;
                }
                case 35: {
                    factory = this.monAlertFactory;
                    break;
                }
                case 34: {
                    factory = this.monLifecycleFactory;
                    break;
                }
                default: {
                    factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory(vfid);
                }
            }
            if (factory != null) {
                MessageView view = factory.wrap(vtype, encoding, packet);
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Received Admin Message: " + view, Tracer.Level.DEBUG);
                }
                return view;
            }
        } else {
            return this.legacyPacketToMessage(packet);
        }
        return null;
    }

    private MessageView legacyPacketToMessage(PktPacket packet) {
        PktBody body = packet.getBody();
        int type = body.getType();
        switch (type) {
            case 1052641: {
                return this.monFactory.wrap((short)1, 3, packet);
            }
            case 1052642: {
                return this.monFactory.wrap((short)2, 3, packet);
            }
            case 1052643: {
                return this.monFactory.wrap((short)3, 3, packet);
            }
            case 1052644: {
                return this.monFactory.wrap((short)4, 3, packet);
            }
            case 1052645: {
                return this.monFactory.wrap((short)5, 3, packet);
            }
            case 1052646: {
                return this.monFactory.wrap((short)6, 3, packet);
            }
            case 1052647: {
                return this.monFactory.wrap((short)7, 3, packet);
            }
            case 1052648: {
                return this.monFactory.wrap((short)8, 3, packet);
            }
            case 1052649: {
                return this.monFactory.wrap((short)9, 3, packet);
            }
            case 1052650: {
                return this.monFactory.wrap((short)10, 3, packet);
            }
            case 1052651: {
                return this.monFactory.wrap((short)11, 3, packet);
            }
            case 1052739: {
                return this.monFactory.wrap((short)99, 3, packet);
            }
            case 1183719: {
                return this.monCncFactory.wrap((short)11, 3, packet);
            }
            case 1183710: {
                return this.monCncFactory.wrap((short)2, 3, packet);
            }
            case 1183712: {
                return this.monCncFactory.wrap((short)4, 3, packet);
            }
            case 1183713: {
                return this.monCncFactory.wrap((short)5, 3, packet);
            }
            case 1183717: {
                return this.monCncFactory.wrap((short)9, 3, packet);
            }
        }
        this.tracer.log(this.tracePrefix + "Received unrecognized legacy admin message type '" + type + "'", Tracer.Level.WARNING);
        return null;
    }

    @Override
    public final void open() throws EClientException {
        super.open();
    }

    @Override
    protected final void onMessage(ILnkMessage message) {
        throw new InternalError("received a message when message dispatch is explictly not supported!");
    }

    @Override
    protected final void onFlushCompletion(ILnkPeerEndpoint.AsynchronousFlushContext flushContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object invokeCommand(int timeout, String target, String command, Object ... params) throws EClientOpTimeoutException, EAdminClientServerError, EClientOpFailedException {
        if (target == null) {
            throw new IllegalArgumentException("the command target app cannot be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("the command name cannot be null");
        }
        if (this.adminCompatLevel < 4) {
            PktPacket packet;
            try {
                if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
                    this.tracer.log(this.tracePrefix + "Invoking legacy admin client command '" + command + "' [target=" + target + ", timeout= " + timeout + ", args= " + (params != null ? Arrays.asList(params) : "[]") + "]", Tracer.Level.VERBOSE);
                }
                packet = PktFactory.getInstance().createPacket(558);
                StringBuilder sb = new StringBuilder();
                sb.append(target).append(" ").append(command);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        sb.append(" ").append(UtlText.quoteAndEscape((String)((String)UtlDataTypes.convert(String.class, (Object)params[i]))));
                    }
                }
                ((PktBodyServerAdminRequest)packet.getBody()).setCommand(sb.toString());
            }
            catch (Exception e) {
                throw new EClientOpFailedException("failed to create packet of type=SERVER_ADMIN [" + e.toString() + "]");
            }
            if (timeout > 0) {
                LnkRequest request = this.sendSync(packet, timeout);
                LnkRequest.Result result = request.getResult();
                UtlList replies = result.getReplies();
                if (replies.count() != 1) {
                    throw new InternalError("Received reply to admin request with an invalid number of reply elements <exp=1 actual=" + replies.count() + ">");
                }
                PktPacket reply = (PktPacket)replies.first();
                PktBodyServerAdminReply replyBody = (PktBodyServerAdminReply)reply.getBody();
                String cmdresult = replyBody.getResult();
                if (cmdresult.startsWith("OK ")) {
                    return cmdresult.substring(cmdresult.indexOf(32), cmdresult.length()).trim();
                }
                if (cmdresult.startsWith("NOK ")) {
                    throw new EAdminClientServerError(cmdresult.substring(cmdresult.indexOf(32), cmdresult.length()).trim());
                }
                throw new EClientOpFailedException("received a command result from the server with an invalid format: " + cmdresult);
            }
            this.sendStreaming(packet, null, 16);
            return null;
        }
        if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
            this.tracer.log(this.tracePrefix + "Invoking admin client command '" + command + "' [target=" + target + ", timeout= " + timeout + ", args= " + (params != null ? Arrays.asList(params) : "[]") + "]", Tracer.Level.VERBOSE);
        }
        SrvMonInvokeCommandRequest invokeRequest = SrvMonInvokeCommandRequest.create();
        invokeRequest.setTarget(target);
        invokeRequest.setCommandName(command);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                invokeRequest.addParameters((String)UtlDataTypes.convert(String.class, (Object)params[i]));
            }
        }
        if (timeout > 0) {
            PktPacket reply = this.sendRequest(invokeRequest, timeout);
            if (reply.getBody().getType() == 1183719) {
                SrvMonInvokeCommandResponse response = SrvMonCncFactory.createSrvMonInvokeCommandResponseFromXbufContainerPacket(reply);
                try {
                    if (response.hasErrorMessage()) {
                        throw new EAdminClientServerError(response.getErrorMessage());
                    }
                    Object object = SrvMonUtil.getResponseValue(response);
                    return object;
                }
                finally {
                    try {
                        response.dispose();
                    }
                    catch (Throwable thrown) {
                        this.tracer.log(this.tracePrefix + "Error disposing command response container: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                }
            }
            throw new EClientOpFailedException("received a command result from the server with an invalid format: " + reply.getBody().getClass());
        }
        this.sendOneway(invokeRequest);
        return null;
    }

    public final void startTraceWatch() throws EClientOpFailedException {
        if (this.traceWatchStarted.compareAndSet(false, true)) {
            boolean success = false;
            try {
                if (this.adminCompatLevel >= 2) {
                    this.sendOneway(SrvMonStartTraceWatchRequest.create());
                    success = true;
                } else {
                    this.invokeCommand(-1, "server", "start_trace_watch", new Object[0]);
                    success = true;
                }
            }
            finally {
                if (!success) {
                    this.traceWatchStarted.set(false);
                }
            }
        }
    }

    public final void stopTraceWatch() throws EClientOpFailedException {
        if (this.traceWatchStarted.compareAndSet(true, false)) {
            boolean success = false;
            try {
                if (this.adminCompatLevel >= 2) {
                    this.sendOneway(SrvMonStopTraceWatchRequest.create());
                    success = true;
                } else {
                    this.invokeCommand(-1, "server", "stop_trace_watch", new Object[0]);
                    success = true;
                }
            }
            finally {
                if (!success) {
                    this.traceWatchStarted.set(true);
                }
            }
        }
    }

    public final void startAppWatch() throws EClientOpFailedException {
        if (this.appWatchStarted.compareAndSet(false, true)) {
            this.appWatchJoined.set(false);
            boolean success = false;
            try {
                if (this.adminCompatLevel >= 5) {
                    this.sendOneway(SrvMonStartAppWatchCommand.create());
                    success = true;
                } else {
                    this.invokeCommand(-1, "server", "start_app_watch", new Object[0]);
                    success = true;
                }
            }
            finally {
                if (!success) {
                    this.appWatchStarted.set(false);
                }
            }
        }
    }

    public void waitForAppWatchJoin(int timeoutMillis) throws EAdminClientServerError, EClientOpFailedException {
        if (this.appWatchStarted.get()) {
            if (!this.appWatchJoined.get()) {
                this.invokeCommand(timeoutMillis, "server", "app_ping", "admin");
                this.appWatchJoined.set(this.appWatchStarted.get());
            }
        } else {
            throw new IllegalStateException("App watch has not been started");
        }
    }

    public final void stopAppWatch() throws EClientOpFailedException {
        if (this.appWatchStarted.compareAndSet(true, false)) {
            boolean success = false;
            try {
                if (this.adminCompatLevel >= 5) {
                    this.sendOneway(SrvMonStartAppWatchCommand.create());
                    success = true;
                } else {
                    this.invokeCommand(-1, "server", "stop_app_watch", new Object[0]);
                    success = true;
                }
            }
            finally {
                if (!success) {
                    this.appWatchStarted.set(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <RequestType extends IRogMessage & ISrvMonXvmRequest> PktPacket sendRequest(RequestType requestMessage, long timeout) throws EClientOpTimeoutException, EClientOpFailedException {
        ((ISrvMonXvmRequest)requestMessage).setAdminClientCompatLevel("5");
        PktPacket requestPacket = requestMessage.serializeToPacket();
        try {
            LnkRequest linkRequest = this.sendSync(requestPacket, (int)timeout);
            LnkRequest.Result linkResult = linkRequest.getResult();
            UtlList replies = linkResult.getReplies();
            if (replies.count() != 1) {
                throw new InternalError("Received reply to admin request with an invalid number of reply elements <exp=1 actual=" + replies.count() + ">");
            }
            PktPacket reply = (PktPacket)replies.first();
            if (reply.getBody().getType() == 559) {
                PktBodyServerAdminReply replyBody = (PktBodyServerAdminReply)reply.getBody();
                String cmdresult = replyBody.getResult();
                if (cmdresult.startsWith("NOK ")) {
                    throw new EAdminClientServerError(cmdresult.substring(cmdresult.indexOf(32), cmdresult.length()).trim());
                }
                throw new EClientOpFailedException("received a command result from the server with an invalid format: " + cmdresult);
            }
            PktPacket pktPacket = reply;
            return pktPacket;
        }
        finally {
            requestPacket.dispose();
            requestMessage.dispose();
        }
    }

    private final <CommandType extends IRogMessage & ISrvMonXvmRequest> void sendOneway(CommandType commandMessage) throws EClientOpFailedException {
        ((ISrvMonXvmRequest)commandMessage).setAdminClientCompatLevel("5");
        PktPacket commandPacket = commandMessage.serializeToPacket();
        try {
            this.sendStreaming(commandPacket, null, 16);
        }
        finally {
            commandPacket.dispose();
            commandMessage.dispose();
        }
    }

    protected final int getAdminCompatLevel() throws EClientOpFailedException {
        block7: {
            try {
                String result = (String)this.invokeCommand(5000, "server", "get_admin_compat_level", new Object[0]);
                try {
                    int dot = result.indexOf(46);
                    int adminCompatLevel = dot == -1 ? Integer.parseInt(result) : Integer.parseInt(result.substring(0, dot));
                    if (adminCompatLevel >= 2) {
                        this.adminCompatLevel = adminCompatLevel;
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "adminCompatLevel reported by remote server is " + adminCompatLevel, Tracer.Level.DEBUG);
                        }
                        return this.adminCompatLevel;
                    }
                    this.tracer.log(this.tracePrefix + "Received invalid admin compat level: " + adminCompatLevel, Tracer.Level.WARNING);
                }
                catch (NumberFormatException e) {
                    this.tracer.log(this.tracePrefix + "Received invalid response to get_admin_compat_level: " + result, Tracer.Level.WARNING);
                }
            }
            catch (EAdminClientServerError e) {
                if (!this.tracer.debug) break block7;
                this.tracer.log(this.tracePrefix + "get_admin_compat_level is not supported by the server: " + e.getMessage(), Tracer.Level.DEBUG);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Falling back to adminCompatLevel 1", Tracer.Level.DEBUG);
        }
        return this.adminCompatLevel;
    }
}

