/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.cli.CliException;
import com.neeve.cli.CommandExecutor;
import com.neeve.cli.annotations.Command;
import com.neeve.cli.annotations.Option;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.VMConfigurer;
import com.neeve.daemon.DmnMain;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.root.RootConfig;
import com.neeve.server.Configurer;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminOpFailedException;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.trace.Tracer;
import com.neeve.trace.TracerRegistry;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTailoring;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.StringTokenizer;

public final class Main
extends DmnMain {
    private Main(SrvConfigDescriptor configDescriptor, Configurer configurer) {
        super(SrvController.getInstance(configDescriptor));
        SrvController controller = (SrvController)this.controller;
        controller.setBootstrapConfigurer(configurer);
    }

    private static final UtlTailoring.PropertySource instantiateConfigLocalizer(String className) throws Exception {
        Class<?> localizerClass = null;
        try {
            localizerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Config localizer class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new Exception("Config localizer class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Constructor<?> constructor = null;
        try {
            Class[] parameterTypes = new Class[]{};
            constructor = localizerClass.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw new Exception("access to the default constructor in config localizer class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new Exception("the default constructor could not be found in the config localizer class [" + className + "]");
        }
        UtlTailoring.PropertySource localizer = null;
        try {
            Object[] parameters = new Object[]{};
            localizer = (UtlTailoring.PropertySource)constructor.newInstance(parameters);
        }
        catch (IllegalAccessException e) {
            throw new Exception("access to constructor in config localizer class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            throw new Exception(e.getCause());
        }
        return localizer;
    }

    private static final void configure(final String xvmName, final String profiles, String config, String configLocalizerClassStr) throws Exception {
        File configFile = new File(XRuntime.getRootDirectory().toString() + File.separator + "conf" + File.separator + config + ".xml");
        if (!configFile.exists()) {
            throw new Exception("The config string '" + config + "' is invalid [config file ' " + configFile.getAbsolutePath() + "' was not found.]");
        }
        final UtlTailoring.PropertySource configLocalizer = configLocalizerClassStr != null ? Main.instantiateConfigLocalizer(configLocalizerClassStr) : UtlTailoring.ENV_SUBSTITUTION_RESOLVER;
        VMConfigurer.configure(configFile, new UtlTailoring.PropertySource(){

            public String getValue(String key, String defaultValue) {
                String value = configLocalizer.getValue(key, defaultValue);
                if (value == null) {
                    if (key.equals("nv.ddl.targetxvm")) {
                        return xvmName;
                    }
                    if (key.equals("nv.ddl.profiles")) {
                        return profiles;
                    }
                }
                return value;
            }
        });
    }

    public static final Configurer loadBootstrapConfigurer() throws ServiceConfigurationError {
        ServiceLoader<Configurer> loader = ServiceLoader.load(Configurer.class);
        Iterator<Configurer> iterator = loader.iterator();
        ArrayList<Configurer> configurers = new ArrayList<Configurer>();
        while (iterator.hasNext()) {
            configurers.add(iterator.next());
        }
        if (configurers.size() <= 1) {
            if (configurers.size() == 1) {
                Configurer configurer = (Configurer)configurers.iterator().next();
                return configurer;
            }
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Multiple configuration service providers not supported. Detected the following providers:\n");
        for (Configurer configurer : configurers) {
            sb.append("...").append(configurer.getClass().getName()).append("\n");
        }
        throw new ServiceConfigurationError(sb.toString());
    }

    private static final String getDefaultPlatformOverlayConfig() {
        String NVROOT = UtlEnv.getEnvPropsNoWarn().getProperty("NVROOT", ".");
        if (new File(NVROOT + File.separator + "conf" + File.separator + "config.xml").exists()) {
            return "config";
        }
        if (new File(NVROOT + File.separator + "conf" + File.separator + "descriptor.xml").exists()) {
            return "descriptor";
        }
        if (new File(NVROOT + File.separator + "conf" + File.separator + "platform.xml").exists()) {
            return "platform";
        }
        if (new File(NVROOT + File.separator + "conf" + File.separator + "xplatform.xml").exists()) {
            return "xplatform";
        }
        return null;
    }

    public static final SrvConfigDescriptor seedServerConfig(Configurer configurer, String[] args) throws Exception, CliException {
        Args parsed = Main.parseAndSeedConfiguration(configurer, args);
        return parsed.descriptor;
    }

    private static final Args parseAndSeedConfiguration(Configurer configurer, String[] args) throws Exception, CliException {
        if (configurer != null) {
            try {
                args = configurer.configure(args);
                args = args == null ? new String[]{} : args;
            }
            catch (Exception e) {
                System.err.println("Exception thrown by the configuration service provider. Exiting...");
                throw e;
            }
        }
        Args options = Args.parse(args);
        if (!options.showHelp) {
            SrvConfigDescriptor configDescriptor;
            Properties props;
            if (options.xvmName == null && options.xvmDescriptor == null) {
                options.xvmName = "default";
            }
            if (!options.skipOverlayConfig && options.configOverlayFileName != null) {
                Main.configure(options.xvmName, options.configProfiles, options.configOverlayFileName, options.configLocalizerClassName);
            }
            UtlAddressDescriptor serverDescriptor = null;
            boolean usingDescriptor = false;
            if (options.xvmName == null) {
                serverDescriptor = UtlAddressDescriptor.parse((String)options.xvmDescriptor, null);
                options.xvmName = serverDescriptor.address;
                usingDescriptor = true;
            }
            XRuntime.setAppName((String)options.xvmName);
            IConfigRepository repo = ConfigRepositoryFactory.getInstance().getDefaultRepository();
            IConfigSimpleEntity env = repo.getSimpleEntity("/env/default");
            if (env != null) {
                props = env.getProperties();
                XRuntime.updateProps((Properties)props);
                if (XRuntime.getValue((String)"nv.xvm.setsystempropsfromenv", (boolean)false)) {
                    System.getProperties().putAll((Map<?, ?>)props);
                }
            }
            if ((env = repo.getSimpleEntity("/env/servers/" + options.xvmName)) != null) {
                props = env.getProperties();
                XRuntime.updateProps((Properties)props);
                if (XRuntime.getValue((String)"nv.xvm.setsystempropsfromenv", (boolean)false)) {
                    System.getProperties().putAll((Map<?, ?>)props);
                }
            }
            RootConfig.flushConfig();
            TracerRegistry.getInstance().clear();
            SrvConfigDescriptor srvConfigDescriptor = configDescriptor = usingDescriptor ? SrvConfigDescriptor.create(serverDescriptor) : SrvConfigDescriptor.load(repo, options.xvmName);
            if (options.appDescriptors != null) {
                StringTokenizer tokenizer = new StringTokenizer(options.appDescriptors, ",");
                if (tokenizer.hasMoreTokens()) {
                    while (tokenizer.hasMoreTokens()) {
                        SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create(UtlAddressDescriptor.parse((String)tokenizer.nextToken().trim(), null));
                        appDescriptor.save(repo, options.xvmName);
                        configDescriptor.addApp(appDescriptor);
                    }
                }
            } else if (options.appClassName != null) {
                SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create("noname");
                appDescriptor.setMainClass(options.appClassName);
                appDescriptor.save(repo, options.xvmName);
                configDescriptor.addApp(appDescriptor);
            }
            configDescriptor.save(repo);
            XRuntime.setAppGroup((String)configDescriptor.getGroup());
            boolean checked = configDescriptor.isChecked();
            RootConfig.setChecked(null, (boolean)checked);
            boolean threaded = configDescriptor.isMultiThreaded();
            RootConfig.setThreaded(null, (boolean)threaded);
            options.descriptor = configDescriptor;
            return options;
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        Configurer configurer;
        try {
            configurer = Main.loadBootstrapConfigurer();
            if (configurer != null) {
                System.out.println("   [External configuration service provider '" + configurer.getClass().getName() + "'].");
            } else {
                System.out.println("   [No external configuration service provider]");
            }
        }
        catch (Throwable e) {
            System.err.println("Failure encountered while loading the configuration service provider. Exiting...");
            e.printStackTrace();
            System.exit(-1);
            return;
        }
        Args parsed = null;
        try {
            parsed = Main.parseAndSeedConfiguration(configurer, args);
        }
        catch (CliException e) {
            System.err.println("**** Error parsing xvm options [" + e.getMessage() + "] ****");
            System.exit(-1);
        }
        catch (Throwable t) {
            System.out.println("**** Error configuring xmv [" + t.toString() + "] ****");
            t.printStackTrace();
            System.exit(-1);
        }
        if (parsed.descriptor != null) {
            SrvConfigDescriptor configDescriptor = parsed.descriptor;
            if (parsed.action.equals("start")) {
                try {
                    System.out.println("");
                    System.out.println("   The Talon XVM");
                    System.out.println("   Copyright (c) 2018 Neeve Research, LLC.");
                    System.out.println("   All Rights Reserved.");
                    System.out.println("");
                    Main.printCommonDaemonBanner(Main.getProductInfo());
                    System.out.println("");
                    System.out.println("   Server <name=" + configDescriptor.getName() + " group=" + configDescriptor.getGroup() + ">");
                    System.out.print("   Checked=" + configDescriptor.getChecked() + ". ");
                    System.out.print("MultiThreaded=" + configDescriptor.isMultiThreaded() + " [IO=" + configDescriptor.getIOThreadCount() + " Demand=" + configDescriptor.getMaxOnDemandThreadCount() + "].");
                    System.out.println("\n");
                    new Main(configDescriptor, configurer).entryPoint(parsed.managedByWrapper, parsed.args);
                }
                catch (Throwable t) {
                    System.out.println("**** Server '" + configDescriptor.getName() + "': Unhandled fault [" + t.toString() + "] ****");
                    t.printStackTrace();
                    System.exit(-1);
                }
            } else {
                String discoveryDescriptor = configDescriptor.getDiscoveryDescriptor();
                IDiscoveryCache discoveryCache = null;
                if (discoveryDescriptor == null) {
                    System.out.println("Attempting to discover xvm (discovery descriptor: " + UtlAddressDescriptor.parse((String)DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR, null).toPasswordSanitizedFullString() + ")");
                    discoveryCache = DiscoveryCacheFactory.getInstance().getDefaultCache();
                } else {
                    try {
                        System.out.println("Attempting to discover xvm (server discovery descriptor: " + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + ")");
                        discoveryCache = DiscoveryCacheFactory.getInstance().createCache(discoveryDescriptor);
                    }
                    catch (EDiscoveryException e) {
                        System.out.println("**** Unable to open server discovery cache '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "' [" + e.getMessage() + "] ****");
                        System.exit(-1);
                    }
                }
                IDiscoveryEntity entity = discoveryCache.get("Server", configDescriptor.getName());
                if (entity == null) {
                    System.err.println("**** XVM '" + configDescriptor.getName() + "' not discovered, cannot perform " + parsed.action + " ****");
                    System.exit(-1);
                }
                String clientName = "talon-main-" + System.getProperty("user.name") + "-" + XRuntime.getLocalHostAddressForDisplay((String)"unknown");
                AdminSession session = null;
                Properties connectionProps = new Properties();
                if (configDescriptor.getAdmin().getSma().isEnabled()) {
                    connectionProps.setProperty("nv.server.admin.transports", "sma");
                    String adminBusName = configDescriptor.getAdmin().getSma().getBusName();
                    if (adminBusName != null) {
                        connectionProps.setProperty("nv.server.admin.sma.bus.name", adminBusName);
                    }
                }
                try {
                    session = AdminSessionFactory.getDefaultInstance().createAdminClientSession(clientName, configDescriptor.getName(), null, discoveryCache, Tracer.get((String)"nv.server"), XRuntime.getProps());
                    session.open();
                }
                catch (Exception e) {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                    System.err.println("**** Error opening admin connection to xvm '" + configDescriptor.getName() + "' [" + e.getMessage() + "] ****");
                    e.printStackTrace();
                }
                if (session != null) {
                    try {
                        System.out.print("Invoking '" + parsed.action + "' on the '" + configDescriptor.getName() + " XVM'...");
                        session.invokeCommand("server", parsed.action, new Object[0]);
                        System.out.println("SUCCESS");
                    }
                    catch (EAdminOpFailedException e) {
                        if (parsed.action.equals("kill")) {
                            System.out.println("SUCCESS (" + e.getLocalizedMessage() + ")");
                        } else {
                            System.err.println("**** Error executing XVM command on '" + configDescriptor.getName() + "' [" + e.getMessage() + "] ****");
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("**** Error executing XVM command on '" + configDescriptor.getName() + "' [" + e.getMessage() + "] ****");
                        e.printStackTrace();
                    }
                    finally {
                        session.close();
                    }
                }
                discoveryCache.close();
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    public static final ProductInfo getProductInfo() {
        return ManifestProductInfo.loadProductInfo((String)"nvx-talon");
    }

    @Command(name="com.neeve.talon.server.Main", description="Talon XVM Main Entry Point")
    public static final class Args {
        public String[] args;
        public SrvConfigDescriptor descriptor = null;
        public final CommandExecutor parser;
        @Option(shortForm=104, longForm="help", required=false, defaultValue="false", displayName="Show Help", description="Displays this help message")
        public boolean showHelp;
        @Option(shortForm=110, longForm="name", required=false, displayName="Xvm Name", description="Specifies the the name of the XVM. For an XVM other than the 'default' XVM, the XVM must be either preconfigured in the configuration repository or configured in DDL XML config file.\n\nIf this option is not specified then teh 'default' XVM is used.")
        public String xvmName;
        @Option(shortForm=105, longForm="inputConfig", required=false, displayName="Config DDL XML File", description="Same as -c, --config.")
        public String inputConfigOverlayFileName;
        @Option(shortForm=99, longForm="config", required=false, displayName="Config DDL XML File", description="Specifies the name of the DDL configuration input XML used to configure the XVM. \n\nThe file name should be specified without the .xml suffix. It will be used to seed the platform's internal configuration repository. \n\nIf not specified, then the first of config.xml, descriptor.xml, platform.xml, or xplatform.xml found in $NVROOT/conf will be used if found. If none are found and this argument is not specified then the configuration repository is not seeded. When launched without specifying a configuration file, configuration can be done by a Configurer class loaded via ServiceLoader.load(Configurer.class), or existing configuration can be used.")
        public String configOverlayFileName;
        @Option(shortForm=115, longForm="skipOverlayConfig", hidden=false, defaultValue="false", required=false, displayName="Skip Config File", description="Specifies the name of the class that will be used to localize the DDL configuration file via variable substitution. When not specified the substitution will source replacements from com.neeve.util.UtlEnv bootstrap environement (which consults System properties, -Dnv.app.propfile and the environment in increasing order of precedence). \n\nThis option is useful when there is an existing config.xml file located in $NVROOT/conf that should be ignored.")
        public boolean skipOverlayConfig;
        @Option(shortForm=112, longForm="profiles", hidden=false, required=false, displayName="Config Profiles", description="Configures the XVM using the specified comma separated list of configuration profiles when processing the configuration DDL XML file.")
        public String configProfiles;
        @Option(shortForm=97, longForm="action", hidden=false, required=false, defaultValue="start", validOptions={"start", "stop", "kill", "threaddump"}, displayName="Action", description="The action to perform on the XVM where:\n\nstart: starts the XVM.\nstop: connects to the XVM and issues a shutdown.\nkill: connects to the XVM and issues a hard kill command.\nthreaddump: connects to the XVM and triggers a thread dump.")
        public String action;
        @Option(shortForm=109, longForm="managed", hidden=true, required=false, defaultValue="false", displayName="Wrapper Managed", description="Specifies that the XVM should use the Java service wrapper for launch. This flag expects the XVM to be launched from a Talon distribution that includes the service wrapper configuration and binaries).")
        public boolean managedByWrapper;
        @Option(shortForm=68, longForm="descriptor", hidden=true, required=false, displayName="XVM Descriptor", description="Starts an XVM described by a server descriptor string. With this option, a server personality is created on the fly using server configuration specified via the descriptor string and then started up. \n\n<This option is ignored if the --name option is specified>")
        public String xvmDescriptor;
        @Option(shortForm=65, longForm="apps", hidden=true, required=false, displayName="App Descriptors", description="Starts the XVM with apps described by the app descriptor strings. The apps described by the descriptor strings are with appended to the apps already configured for the server being started up (named server if --name is specified or default server otherwise).")
        public String appDescriptors;
        @Option(shortForm=67, longForm="appclass", hidden=true, required=false, displayName="App Main Class", description="Starts the server with a single app instance loaded using the specified class name. The app is appended to the apps already configured for the server being started up (named server if --name is specified or default server otherwise). \n\n<This option is ignored if the --apps option is specified>")
        public String appClassName;
        @Option(shortForm=108, longForm="configlocalizerclass", hidden=true, required=false, displayName="Config Localizer Class", description="Specifies the name of the class that will be used to localize the DDL configuration file via variable substitution. When not specified the substitution will source replacements from com.neeve.util.UtlEnv bootstrap environement (which consults System properties, -Dnv.app.propfile and the environment in increasing order of precedence).")
        public String configLocalizerClassName;

        public Args(String[] args) throws CliException {
            this.args = args;
            this.parser = CommandExecutor.createExecutor((Object)this, (Method)UtlReflection.getMethod(Args.class, (String)"configure", (Class[])new Class[0]));
            try {
                this.parser.execute(args);
            }
            catch (InvocationTargetException e) {
                throw new CliException(e.getMessage(), (Throwable)e);
            }
        }

        public void configure() {
            if (this.showHelp) {
                this.parser.help(System.out);
            }
            if (this.configOverlayFileName == null) {
                this.configOverlayFileName = this.inputConfigOverlayFileName;
            }
            if (this.configOverlayFileName == null) {
                this.configOverlayFileName = Main.getDefaultPlatformOverlayConfig();
            }
        }

        private static Args parse(String[] args) throws CliException {
            return new Args(args);
        }
    }
}

