/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.test.UnitTest;
import com.neeve.util.UtlTableFormatter;
import java.math.BigDecimal;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UtlTableFormatterTest
extends UnitTest {
    @Test
    public void testFormatFloat() {
        UtlTableFormatter tableFormatter = new UtlTableFormatter(false);
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            float f = rnd.nextFloat();
            Object formatted = tableFormatter.formatColumn("", Float.class, Float.valueOf(f), UtlTableFormatter.Format.TABULAR);
            String result = formatted.toString();
            Assert.assertTrue((String)("double was not formatted to 20 chars: " + result), (result.length() <= 20 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFormatDouble() {
        UtlTableFormatter tableFormatter = new UtlTableFormatter(false);
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            double d = rnd.nextDouble();
            Object formatted = tableFormatter.formatColumn("", Double.class, d, UtlTableFormatter.Format.TABULAR);
            String result = formatted.toString();
            Assert.assertTrue((String)("double was not formatted to 20 chars: " + result), (result.length() <= 20 ? 1 : 0) != 0);
        }
    }

    @Test
    @Ignore
    public void testFormatBigDecimal() {
        UtlTableFormatter tableFormatter = new UtlTableFormatter(false);
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            BigDecimal bd = BigDecimal.valueOf(rnd.nextLong(), rnd.nextInt());
            Object formatted = tableFormatter.formatColumn("", BigDecimal.class, bd, UtlTableFormatter.Format.TABULAR);
            String result = formatted.toString();
            Assert.assertTrue((String)("double was not formatted to 20 chars: " + result), (result.length() <= 20 ? 1 : 0) != 0);
        }
    }
}

