/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.test.UnitTest;
import com.neeve.util.UtlStr;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class UtlStrTest
extends UnitTest {
    @BeforeClass
    public static void init() {
        System.setProperty("ENVVAR", "envval");
    }

    @Test
    public void testSubstEnvEmptyStr() {
        Assert.assertEquals((Object)UtlStr.substEnv(""), (Object)"");
    }

    @Test
    public void testSubstEnvPlainOlStr() {
        Assert.assertEquals((Object)UtlStr.substEnv("plainolstr"), (Object)"plainolstr");
    }

    @Test
    public void testSubstEnvStrWithEscapeAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("\\strwithescapeatstart"), (Object)"strwithescapeatstart");
    }

    @Test
    public void testSubstEnvStrWithEscapeAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithescape\\atmiddle"), (Object)"strwithescapeatmiddle");
    }

    @Test
    public void testSubstEnvStrWithEscapeAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithescapeatend\\"), (Object)"strwithescapeatend");
    }

    @Test
    public void testSubstEnvTokenDelimEscapedAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("\\%strwithetokendelimescapedatstart"), (Object)"%strwithetokendelimescapedatstart");
    }

    @Test
    public void testSubstEnvStrWithTokenDelimEscapedAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithetokendeli\\%mescapedatmiddle"), (Object)"strwithetokendeli%mescapedatmiddle");
    }

    @Test
    public void testSubstEnvWithTokenDelimEscapedAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithetokendelimescapedatend\\%"), (Object)"strwithetokendelimescapedatend%");
    }

    @Test
    public void testSubstEnvWithEscapeEscapedAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("\\\\strwithescapeescapedatstart"), (Object)"\\strwithescapeescapedatstart");
    }

    @Test
    public void testSubstEnvWithEscapeEscapedAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithescapeescaped\\\\inmiddle"), (Object)"strwithescapeescaped\\inmiddle");
    }

    @Test
    public void testSubstEnvWithEscapeEscapedAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithescapeescapedatend\\"), (Object)"strwithescapeescapedatend");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvEmptySubstTokenAtStart() {
        UtlStr.substEnv("%%strwithemptysubsttokenatstart");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvEmptySubstTokenAtMiddle() {
        UtlStr.substEnv("strwith%%emptysubsttokenatmiddle");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvEmptySubstTokenAtEnd() {
        UtlStr.substEnv("strwithemptysubsttokenatend%%");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvSpacesSubstTokenAtStart() {
        UtlStr.substEnv("%     %sstrwithpacessubsttokenatstart");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvSpacesSubstTokenAtEnd() {
        UtlStr.substEnv("strwithspacessubsttokenatend%     %");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoColonColonAtStart() {
        UtlStr.substEnv("%ENVVAR%strwithnocoloncolonsubsttokenatstart");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoColonColonAtMiddle() {
        UtlStr.substEnv("strwith%ENVVAR%nocoloncolonsubsttokenatmiddle");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoColonColonAtEnd() {
        UtlStr.substEnv("strwithnocoloncolonsubsttokenatend%ENVVAR%");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoDefaultValueAtStart() {
        UtlStr.substEnv("%ENVVAR::%strwithnodefaultvaluesubsttokenatstart");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoDefaultValueAtMiddle() {
        UtlStr.substEnv("strwith%ENVVAR::%nodefaultvaluesubsttokenatmiddle");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubstEnvWithNoDefaultValueAtEnd() {
        UtlStr.substEnv("strwithnodefaultvaluesubsttokenatend%ENVVAR::%");
    }

    @Test
    public void testSubstEnvWithNoEnvVarAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("%::defval%strwithnoenvvarubsttokenatstart"), (Object)"defvalstrwithnoenvvarubsttokenatstart");
    }

    @Test
    public void testSubstEnvWithNoEnvVarAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwith%::defval%noenvvarubsttokenatmiddle"), (Object)"strwithdefvalnoenvvarubsttokenatmiddle");
    }

    @Test
    public void testSubstEnvWithNoEnvVarAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithnoenvvarubsttokenatend%::defval%"), (Object)"strwithnoenvvarubsttokenatenddefval");
    }

    @Test
    public void testSubstEnvWithAbsentEnvVarAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("%INVENVVAR::defval%strwithabsentenvvarubsttokenatstart"), (Object)"defvalstrwithabsentenvvarubsttokenatstart");
    }

    @Test
    public void testSubstEnvWithAbsentEnvVarAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwith%INVENVVAR::defval%absentenvvarubsttokenatmiddle"), (Object)"strwithdefvalabsentenvvarubsttokenatmiddle");
    }

    @Test
    public void testSubstEnvWithAbsentEnvVarAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithabsentenvvarubsttokenatend%INVENVVAR::defval%"), (Object)"strwithabsentenvvarubsttokenatenddefval");
    }

    @Test
    public void testSubstEnvWithSysPropEnvVarAtStart() {
        Assert.assertEquals((Object)UtlStr.substEnv("%ENVVAR::defval%strwithspenvvarubsttokenatstart"), (Object)"envvalstrwithspenvvarubsttokenatstart");
    }

    @Test
    public void testSubstEnvWithSysPropEnvVarAtMiddle() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwith%ENVVAR::defval%spenvvarubsttokenatmiddle"), (Object)"strwithenvvalspenvvarubsttokenatmiddle");
    }

    @Test
    public void testSubstEnvWithSysPropEnvVarAtEnd() {
        Assert.assertEquals((Object)UtlStr.substEnv("strwithspenvvarubsttokenatend%ENVVAR::defval%"), (Object)"strwithspenvvarubsttokenatendenvval");
    }
}

