/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlReflection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UtlReflectionTest {
    @Test
    public void testIsAnnotationPresent() throws Exception {
        Assert.assertFalse((boolean)UtlReflection.isAnnotationPresent(UtlReflection.getMethod(TestClass.class, "intfUnannotatedMethod", new Class[0]), Ignore.class));
        Assert.assertFalse((boolean)UtlReflection.isAnnotationPresent(UtlReflection.getMethod(TestSuperClass.class, "intfUnannotatedMethod", new Class[0]), Ignore.class));
        Assert.assertFalse((boolean)UtlReflection.isAnnotationPresent(UtlReflection.getMethod(TestInterface.class, "intfUnannotatedMethod", new Class[0]), Ignore.class));
    }

    private void checkAnnotation(Class<?> type, String methodName, String expectedValue) {
        Ignore annotation = UtlReflection.getAnnotation(UtlReflection.getMethod(type, methodName, new Class[0]), Ignore.class);
        if (expectedValue != null) {
            Assert.assertNotNull((String)("Annotation not found in " + type.getSimpleName()), (Object)annotation);
            Assert.assertEquals((String)"Wrong annotation found", (Object)expectedValue, (Object)annotation.value());
        } else {
            Assert.assertNull((String)("Annotation should not have been found: " + annotation.value()), (Object)annotation);
        }
    }

    @Test
    public void testImplementedIntfAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "intfAnnotatedMethod", "subclass");
    }

    @Test
    public void testSuperClassOnlyAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "superClassOnlyAnnotatedMethod", "superclass");
    }

    @Test
    public void testFinalPublicSuperClassOnlyAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "finalSuperClassOnlyAnnotatedMethod", "superclass");
    }

    @Test
    public void testPrivateSuperClassOnlyAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "finalPrivateSuperClassOnlyAnnotatedMethod", "superclass");
    }

    @Test
    public void testFinalProtectedSuperClassOnlyAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "finalProtectedSuperClassOnlyAnnotatedMethod", "superclass");
    }

    @Test
    public void testFinalPackageSuperClassOnlyAnnotatedMethod() throws Exception {
        this.checkAnnotation(TestClass.class, "finalPackageSuperClassOnlyAnnotatedMethod", "superclass");
    }

    @Test
    public void testInterfaceAnnotationIgnored() throws Exception {
        Ignore annotation = UtlReflection.getAnnotation(UtlReflection.getMethod(TestClass.class, "intfOnlyAnnotatedMethod", new Class[0]), Ignore.class);
        Assert.assertNull((String)"Annotation should not be found on interface declaration", (Object)annotation);
    }

    public static class TestClass
    extends TestSuperClass {
        @Override
        @Ignore(value="subclass")
        public void intfAnnotatedMethod() {
        }

        @Override
        public void intfUnannotatedMethod() {
        }

        @Override
        public void superClassOnlyAnnotatedMethod() {
        }
    }

    public static abstract class TestSuperClass
    implements TestInterface {
        @Override
        @Ignore(value="superclass")
        public void intfAnnotatedMethod() {
        }

        @Override
        public void intfUnannotatedMethod() {
        }

        @Override
        public void intfOnlyAnnotatedMethod() {
        }

        @Ignore(value="superclass")
        public final void finalSuperClassOnlyAnnotatedMethod() {
        }

        @Ignore(value="superclass")
        public abstract void superClassOnlyAnnotatedMethod();

        @Ignore(value="superclass")
        private final void finalPrivateSuperClassOnlyAnnotatedMethod() {
        }

        @Ignore(value="superclass")
        protected final void finalProtectedSuperClassOnlyAnnotatedMethod() {
        }

        @Ignore(value="superclass")
        final void finalPackageSuperClassOnlyAnnotatedMethod() {
        }
    }

    public static interface TestInterface {
        @Ignore(value="interface")
        public void intfAnnotatedMethod();

        @Ignore(value="interface")
        public void intfOnlyAnnotatedMethod();

        public void intfUnannotatedMethod();
    }
}

