/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlReadWriteLock;
import com.neeve.util.UtlReentrantReadWriteLock;
import com.neeve.util.UtlUnit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.Ignore;
import org.junit.Test;

public class UtlReadWriteLockTest {
    static int shared = 0;

    @Test
    @Ignore
    public void testLockPerformance() throws InterruptedException {
        final AtomicBoolean spinLock = new AtomicBoolean();
        final Object mutex = new Object();
        final ReentrantLock javaLock = new ReentrantLock();
        final ReentrantLock fairJavaLock = new ReentrantLock(true);
        final ReentrantReadWriteLock javaRWLock = new ReentrantReadWriteLock();
        final ReentrantReadWriteLock fairJavaRWLock = new ReentrantReadWriteLock(true);
        final UtlReadWriteLock utilLock = UtlReadWriteLock.create((String)"utillock");
        final UtlReentrantReadWriteLock utilReentrantLock = UtlReentrantReadWriteLock.create("utillock");
        int THREAD_COUNT = 12;
        int CYCLES = 3;
        int ITERATIONS = 1000000;
        StringBuilder csv = new StringBuilder();
        for (int t = 1; t <= 12; ++t) {
            System.out.println("LOCK PERFORMANCE [Thread Count=" + t + "]");
            for (int c = 1; c <= 3; ++c) {
                System.out.println("  TEST CYCLE: " + c);
                final int iterations = 1000000 / t;
                UtlReadWriteLockTest.runConcurrentTest("Mutex", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            Object object = mutex;
                            synchronized (object) {
                                ++shared;
                                continue;
                            }
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("SpinLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            while (!spinLock.compareAndSet(false, true)) {
                            }
                            ++shared;
                            spinLock.set(false);
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            javaLock.lock();
                            ++shared;
                            javaLock.unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaLock(Fair)", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            fairJavaLock.lock();
                            ++shared;
                            fairJavaLock.unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaReadLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            javaRWLock.readLock().lock();
                            ++shared;
                            javaRWLock.readLock().unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaReadLock(Fair)", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            fairJavaRWLock.readLock().lock();
                            ++shared;
                            fairJavaRWLock.readLock().unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("UtlReadLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            utilLock.getReadLockUninterrupted();
                            ++shared;
                            utilLock.releaseLock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("UtlReentrantReadLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            utilReentrantLock.getReadLockUninterrupted();
                            ++shared;
                            utilReentrantLock.releaseReadLock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaWriteLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            javaRWLock.writeLock().lock();
                            ++shared;
                            javaRWLock.writeLock().unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("JavaWriteLock(Fair)", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            fairJavaRWLock.writeLock().lock();
                            ++shared;
                            fairJavaRWLock.writeLock().unlock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("UtlReadWriteLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            utilLock.getWriteLockUninterrupted();
                            ++shared;
                            utilLock.releaseLock();
                        }
                    }
                }, t, c, iterations, csv);
                UtlReadWriteLockTest.runConcurrentTest("UtlReentrantWriteLock", new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < iterations; ++i) {
                            utilReentrantLock.getWriteLockUninterrupted();
                            ++shared;
                            utilReentrantLock.releaseWriteLock();
                        }
                    }
                }, t, c, iterations, csv);
            }
        }
        System.out.println("Results:\n\n" + csv);
    }

    private static final void runConcurrentTest(String testName, Runnable runnable, int threadCount, int cycle, int iterations, StringBuilder csv) throws InterruptedException {
        TestThread[] threads = new TestThread[threadCount];
        shared = 0;
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch joinLatch = new CountDownLatch(threadCount);
        for (int t = 0; t < threads.length; ++t) {
            threads[t] = new TestThread(testName + "-Thread-" + t, startLatch, joinLatch, runnable);
            threads[t].start();
        }
        long testStart = System.nanoTime();
        startLatch.countDown();
        joinLatch.await();
        long testEnd = System.nanoTime();
        String runTime = UtlUnit.formatDuration((double)(testEnd - testStart) / (double)iterations, TimeUnit.NANOSECONDS, 3);
        System.out.println("    " + testName + ": " + runTime);
        for (int t = 0; t < threads.length; ++t) {
            threads[t].join();
            System.out.println("      Thread " + (t + 1) + ": " + UtlUnit.formatDuration((double)(threads[t].finish - threads[t].start) / (double)iterations, TimeUnit.NANOSECONDS, 3) + "    [start=" + threads[t].start + ", finish=" + threads[t].finish + "]");
        }
        System.out.println("      SharedCounter actual/expected:" + shared + "/" + threads.length * iterations);
        if (csv.length() == 0) {
            csv.append("#Threads,Iteration,Test,runTime\n");
        }
        csv.append(threadCount).append(",").append(cycle).append(",").append(testName).append(",").append((double)(testEnd - testStart) / (double)iterations).append("\n");
    }

    public static final void main(String[] args) {
        UtlReadWriteLockTest test = new UtlReadWriteLockTest();
        try {
            test.testLockPerformance();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class TestThread
    extends Thread {
        final CountDownLatch startLatch;
        final CountDownLatch joinLatch;
        final Runnable runnable;
        volatile long start;
        volatile long finish;

        TestThread(String name, CountDownLatch startLatch, CountDownLatch joinLatch, Runnable runnable) {
            super(name);
            this.startLatch = startLatch;
            this.joinLatch = joinLatch;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.start = System.nanoTime();
                this.runnable.run();
                this.finish = System.nanoTime();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            finally {
                this.joinLatch.countDown();
            }
        }
    }
}

