/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlEnv;
import com.neeve.util.UtlPool;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class UtlPoolTest {
    @Test
    public void testPooLifo() {
        UtlPool.Params params = UtlPool.Params.create();
        params.setDetachedWash(false);
        params.setThreaded(false);
        params.setInitialCapacity(16);
        params.setPreallocate(true);
        UtlPool<TestObject> pool = UtlPool.create("TestObject", "testPoolMRU", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, params);
        TestObject object1 = pool.get(null);
        pool.put(object1);
        TestObject object2 = pool.get(null);
        Assert.assertSame((String)"Object returned from pool after put is not the most recent object addded", (Object)object1, (Object)object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPool() {
        UtlPool.Params params = UtlPool.Params.create();
        params.setDetachedWash(false);
        params.setThreaded(true);
        params.setInitialCapacity(16);
        params.setPreallocate(true);
        try (UtlPool<TestObject> pool = UtlPool.create("TestObject", "testThreadPool", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, params);){
            UtlPoolTest.assertPoolParamsEqual("Creation parameters", params, pool.params());
            Assert.assertEquals((String)"Shouldn't be pool misses", (long)0L, (long)pool.stats().misses());
            TestObject object = pool.get(null);
            object.dispose();
            object = pool.get(null);
            object.dispose();
            Assert.assertEquals((String)"Shouldn't be pool misses for a preallocated pool", (long)0L, (long)pool.stats().misses());
            Assert.assertEquals((String)"Wrong number of hits", (long)2L, (long)pool.stats().hits());
            Assert.assertEquals((String)"Wrong number of puts", (long)(2 + params.getInitialCapacity()), (long)pool.stats().puts());
            Assert.assertEquals((String)"Wrong number of gets", (long)2L, (long)pool.stats().gets());
            Assert.assertEquals((String)"Wrong number of evicts", (long)0L, (long)pool.stats().evicts());
            Assert.assertEquals((String)"Wrong number of growths", (long)0L, (long)pool.stats().growths());
        }
    }

    @Test
    public void testUtlPoolParamsReadOnly() {
        try (UtlPool<TestObject> pool = UtlPool.create("TestObject", "testUtlPoolParamsReadOnly", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, UtlPool.Params.create());){
            Assert.assertTrue((String)"Pool creation params should be read only", (boolean)pool.params().isReadOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUtlPoolEnvParameters() {
        UtlPool.Params expectedParams = UtlPool.Params.create();
        expectedParams.setInitialCapacity(256);
        expectedParams.setMaxCapacity(512);
        expectedParams.setDetachedWash(false);
        expectedParams.setPreallocate(true);
        expectedParams.setThreaded(false);
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.initialCapacity", "" + expectedParams.getInitialCapacity());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.maxCapacity", "" + expectedParams.getMaxCapacity());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.detachedWash", "" + expectedParams.isDetachedWash());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.preallocate", "" + expectedParams.isPreallocate());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.threaded", "" + expectedParams.isThreaded());
        try (UtlPool<TestObject> pool = UtlPool.create("TestObject", "testPoolEnvParams", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, UtlPool.Params.create());){
            UtlPool.Params createdParams = pool.params();
            UtlPoolTest.assertPoolParamsEqual("Params from environment", expectedParams, createdParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUtlPoolEnvParametersDoNotOverride() {
        UtlPool.Params expectedParams = UtlPool.Params.create();
        expectedParams.setInitialCapacity(256);
        expectedParams.setMaxCapacity(512);
        expectedParams.setDetachedWash(false);
        expectedParams.setPreallocate(true);
        expectedParams.setThreaded(false);
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.initialCapacity", "10");
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.maxCapacity", "1");
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.detachedWash", "true");
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.preallocate", "false");
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.threaded", "true");
        try (UtlPool<TestObject> pool = UtlPool.create("TestObject", "testPoolEnvParams", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, expectedParams);){
            UtlPool.Params createdParams = pool.params();
            UtlPoolTest.assertPoolParamsEqual("Params from environment", expectedParams, createdParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUtlPoolEnvParametersDoOverride() {
        UtlPool.Params expectedParams = UtlPool.Params.create();
        expectedParams.setInitialCapacity(256);
        expectedParams.setMaxCapacity(512);
        expectedParams.setDetachedWash(false);
        expectedParams.setPreallocate(true);
        expectedParams.setThreaded(false);
        UtlPool.Params overrideParams = UtlPool.Params.create();
        overrideParams.setInitialCapacity(1);
        overrideParams.setMaxCapacity(10);
        overrideParams.setDetachedWash(true);
        overrideParams.setPreallocate(false);
        overrideParams.setThreaded(true);
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.initialCapacity", "" + overrideParams.getInitialCapacity());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.maxCapacity", "" + overrideParams.getMaxCapacity());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.detachedWash", "" + overrideParams.isDetachedWash());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.preallocate", "" + overrideParams.isPreallocate());
        UtlEnv.getEnvProps().setProperty("nv.pool.TestObject.testPoolEnvParams.threaded", "" + overrideParams.isThreaded());
        UtlEnv.getEnvProps().setProperty("nv.pool.overrideparamsfromenv", "true");
        UtlPool<TestObject> pool = UtlPool.create("TestObject", "testPoolEnvParams", new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, expectedParams);
        try {
            UtlPool.Params createdParams = pool.params();
            UtlPoolTest.assertPoolParamsEqual("Params from environment", overrideParams, createdParams);
        }
        finally {
            UtlEnv.getEnvProps().setProperty("nv.pool.overrideparamsfromenv", "true");
            pool.close();
        }
    }

    @Test
    public void testPoolMaxCapacityZero() {
        this.doTestPoolMaxCapacity("testPoolMaxCapacityZero", 0);
    }

    @Test
    public void testPoolMaxCapacity() {
        this.doTestPoolMaxCapacity("testPoolMaxCapacity", 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestPoolMaxCapacity(String poolName, int maxCapacity) {
        int objectToTake = 512;
        try (UtlPool<TestObject> pool = UtlPool.create("TestObject", poolName, new UtlPool.Factory<TestObject>(){

            @Override
            public TestObject createItem(Object object) {
                return new TestObject();
            }

            public TestObject[] createItemArray(int size) {
                return new TestObject[size];
            }
        }, UtlPool.Params.create().setMaxCapacity(maxCapacity));){
            int i;
            Assert.assertTrue((String)("Initial capacity should be less than or equal to max capacity but was" + pool.params().getInitialCapacity()), (pool.params().getInitialCapacity() <= maxCapacity ? 1 : 0) != 0);
            ArrayList<TestObject> taken = new ArrayList<TestObject>();
            int objectsTaken = 0;
            for (int i2 = 0; i2 < objectToTake; ++i2) {
                taken.add(pool.get(null));
                ++objectsTaken;
            }
            int expectedEvicts = 0;
            Assert.assertEquals((String)("Wrong number of misses after taking " + objectsTaken + " items without preallocation"), (long)objectsTaken, (long)pool.stats().misses());
            Assert.assertEquals((String)("Wrong number of hits after taking " + objectsTaken + " items without preallocation"), (long)0L, (long)pool.stats().hits());
            Assert.assertEquals((String)("Wrong number of puts after taking " + objectsTaken + " items without preallocation"), (long)0L, (long)pool.stats().puts());
            Assert.assertEquals((String)("Wrong number of gets after taking " + objectsTaken + " items without preallocation"), (long)objectsTaken, (long)pool.stats().gets());
            Assert.assertEquals((String)("Wrong number of evicts after taking " + objectsTaken + " items without preallocation"), (long)expectedEvicts, (long)pool.stats().evicts());
            Assert.assertEquals((String)("Wrong size after taking " + objectsTaken + " items without preallocation"), (long)0L, (long)pool.size());
            Assert.assertEquals((String)("Wrong capacity after taking " + objectsTaken + " items without preallocation"), (long)pool.params().getInitialCapacity(), (long)pool.capacity());
            int objectsReturned = 0;
            for (i = 0; i < objectsTaken / 2; ++i) {
                ((TestObject)taken.remove(taken.size() - 1)).dispose();
                ++objectsReturned;
            }
            expectedEvicts = objectsReturned > pool.params().getMaxCapacity() ? objectsReturned - pool.params().getMaxCapacity() : 0;
            Assert.assertEquals((String)("Wrong number of misses after returning " + objectsReturned + " items without preallocation"), (long)objectsTaken, (long)pool.stats().misses());
            Assert.assertEquals((String)("Wrong number of hits after returning " + objectsReturned + " items without preallocation"), (long)0L, (long)pool.stats().hits());
            Assert.assertEquals((String)("Wrong number of puts after returning " + objectsReturned + " items without preallocation"), (long)(objectsTaken / 2), (long)pool.stats().puts());
            Assert.assertEquals((String)("Wrong number of gets after returning " + objectsReturned + " items without preallocation"), (long)objectsTaken, (long)pool.stats().gets());
            Assert.assertEquals((String)("Wrong number of evicts after returning " + objectsReturned + " items without preallocation"), (long)expectedEvicts, (long)pool.stats().evicts());
            Assert.assertEquals((String)("Wrong size after returning " + objectsReturned + " items without preallocation"), (long)Math.min(maxCapacity, objectsReturned), (long)pool.size());
            Assert.assertEquals((String)("Wrong capacity after returning " + objectsReturned + " items without preallocation"), (long)Math.min(maxCapacity, objectsReturned), (long)pool.capacity());
            while (!taken.isEmpty()) {
                ((TestObject)taken.remove(taken.size() - 1)).dispose();
                ++objectsReturned;
            }
            expectedEvicts = objectsReturned > pool.params().getMaxCapacity() ? objectsReturned - pool.params().getMaxCapacity() : 0;
            Assert.assertEquals((String)("Wrong number of misses after returning " + objectsReturned + " items without preallocation"), (long)objectsTaken, (long)pool.stats().misses());
            Assert.assertEquals((String)("Wrong number of hits after returning " + objectsReturned + " items without preallocation"), (long)0L, (long)pool.stats().hits());
            Assert.assertEquals((String)("Wrong number of puts after returning " + objectsReturned + " items without preallocation"), (long)objectsReturned, (long)pool.stats().puts());
            Assert.assertEquals((String)("Wrong number of gets after returning " + objectsReturned + " items without preallocation"), (long)objectsTaken, (long)pool.stats().gets());
            Assert.assertEquals((String)("Wrong number of evicts after returning " + objectsReturned + " items without preallocation"), (long)expectedEvicts, (long)pool.stats().evicts());
            Assert.assertEquals((String)("Wrong size after returning " + objectsReturned + " items without preallocation"), (long)Math.min(maxCapacity, objectsReturned), (long)pool.size());
            Assert.assertEquals((String)("Wrong capacity after returning " + objectsReturned + " items without preallocation"), (long)Math.min(maxCapacity, objectsReturned), (long)pool.capacity());
            for (i = 0; i < objectToTake; ++i) {
                taken.add(pool.get(null));
                ++objectsTaken;
            }
            Assert.assertEquals((String)("Wrong number of misses after taking " + objectsTaken + " items without preallocation"), (long)(objectsTaken - objectsReturned + expectedEvicts), (long)pool.stats().misses());
            Assert.assertEquals((String)("Wrong number of hits after taking " + objectsTaken + " items without preallocation"), (long)(objectsReturned - expectedEvicts), (long)pool.stats().hits());
            Assert.assertEquals((String)("Wrong number of puts after taking " + objectsTaken + " items without preallocation"), (long)objectsReturned, (long)pool.stats().puts());
            Assert.assertEquals((String)("Wrong number of gets after taking " + objectsTaken + " items without preallocation"), (long)objectsTaken, (long)pool.stats().gets());
            Assert.assertEquals((String)("Wrong number of evicts after taking " + objectsTaken + " items without preallocation"), (long)expectedEvicts, (long)pool.stats().evicts());
            Assert.assertEquals((String)("Wrong size after taking " + objectsTaken + " items without preallocation"), (long)0L, (long)pool.size());
            Assert.assertEquals((String)("Wrong capacity after taking " + objectsTaken + " items without preallocation"), (long)Math.min(maxCapacity, objectsReturned), (long)pool.capacity());
            while (!taken.isEmpty()) {
                ((TestObject)taken.remove(taken.size() - 1)).dispose();
            }
        }
    }

    private static void assertPoolParamsEqual(String actualParamsDescription, UtlPool.Params expectedParams, UtlPool.Params actualParams) {
        Assert.assertEquals((String)(actualParamsDescription + " initialCapacity is incorrect"), (long)expectedParams.getInitialCapacity(), (long)actualParams.getInitialCapacity());
        Assert.assertEquals((String)(actualParamsDescription + " maxCapacity is incorrect"), (long)expectedParams.getMaxCapacity(), (long)actualParams.getMaxCapacity());
        Assert.assertEquals((String)(actualParamsDescription + " detachedWash is incorrect"), (Object)expectedParams.isDetachedWash(), (Object)actualParams.isDetachedWash());
        Assert.assertEquals((String)(actualParamsDescription + " preallocate is incorrect"), (Object)expectedParams.isPreallocate(), (Object)actualParams.isPreallocate());
        Assert.assertEquals((String)(actualParamsDescription + " threaded is incorrect"), (Object)expectedParams.isThreaded(), (Object)actualParams.isThreaded());
    }

    public static class TestObject
    implements UtlPool.Item<TestObject> {
        UtlPool<TestObject> pool;

        @Override
        public TestObject init() {
            return this;
        }

        @Override
        public TestObject setPool(UtlPool<TestObject> pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public UtlPool<TestObject> getPool() {
            return this.pool;
        }

        public void dispose() {
            this.pool.put(this);
        }
    }
}

