/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlObjectGraph;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class UtlBufferTest {
    @Test
    public void testCharArraySerialization() throws UnsupportedEncodingException {
        char[] orig = (char[])UtlObjectGraph.createRandomArray(Character.TYPE, 10, new Random());
        char[] copy = new char[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 2);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testCharArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 2);
        copy = new char[orig.length];
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.testCharArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 2);
        copy = new char[orig.length];
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testCharArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 2);
        copy = new char[orig.length];
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.testCharArraySerialiazation(orig, copy, buffer);
    }

    private void testCharArraySerialiazation(char[] orig, char[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (long)orig[i], (long)copy[i]);
        }
    }

    @Test
    public void testByteArraySerialization() throws UnsupportedEncodingException {
        byte[] orig = (byte[])UtlObjectGraph.createRandomArray(Byte.TYPE, 10, new Random());
        byte[] copy = new byte[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 1);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testByteArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 1);
        copy = new byte[orig.length];
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.testByteArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 1);
        copy = new byte[orig.length];
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testByteArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 1);
        copy = new byte[orig.length];
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.testByteArraySerialiazation(orig, copy, buffer);
    }

    private void testByteArraySerialiazation(byte[] orig, byte[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (long)orig[i], (long)copy[i]);
        }
    }

    @Test
    public void testShortArraySerialization() throws UnsupportedEncodingException {
        short[] orig = (short[])UtlObjectGraph.createRandomArray(Short.TYPE, 10, new Random());
        short[] copy = new short[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 2);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testShortArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new short[orig.length];
        this.testShortArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 2);
        buffer.order(ByteOrder.BIG_ENDIAN);
        copy = new short[orig.length];
        this.testShortArraySerialiazation(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new short[orig.length];
        this.testShortArraySerialiazation(orig, copy, buffer);
    }

    private void testShortArraySerialiazation(short[] orig, short[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (long)orig[i], (long)copy[i]);
        }
    }

    @Test
    public void testIntArraySerialization() throws UnsupportedEncodingException {
        int[] orig = (int[])UtlObjectGraph.createRandomArray(Integer.TYPE, 10, new Random());
        int[] copy = new int[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testIntArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new int[orig.length];
        this.testIntArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        copy = new int[orig.length];
        this.testIntArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new int[orig.length];
        this.testIntArraySerialization(orig, copy, buffer);
    }

    private void testIntArraySerialization(int[] orig, int[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (long)orig[i], (long)copy[i]);
        }
    }

    @Test
    public void testLongArraySerialization() throws UnsupportedEncodingException {
        long[] orig = (long[])UtlObjectGraph.createRandomArray(Long.TYPE, 10, new Random());
        long[] copy = new long[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testLongArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new long[orig.length];
        this.testLongArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        copy = new long[orig.length];
        this.testLongArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new long[orig.length];
        this.testLongArraySerialization(orig, copy, buffer);
    }

    private void testLongArraySerialization(long[] orig, long[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (long)orig[i], (long)copy[i]);
        }
    }

    @Test
    public void testFloatArraySerialization() throws UnsupportedEncodingException {
        float[] orig = (float[])UtlObjectGraph.createRandomArray(Float.TYPE, 10, new Random());
        float[] copy = new float[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testFloatArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new float[orig.length];
        this.testFloatArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        copy = new float[orig.length];
        this.testFloatArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new float[orig.length];
        this.testFloatArraySerialization(orig, copy, buffer);
    }

    private void testFloatArraySerialization(float[] orig, float[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (float)orig[i], (float)copy[i], (float)0.0f);
        }
    }

    @Test
    public void testDoubleArraySerialization() throws UnsupportedEncodingException {
        double[] orig = (double[])UtlObjectGraph.createRandomArray(Double.TYPE, 10, new Random());
        double[] copy = new double[orig.length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(orig.length * 8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.testDoubleArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocateDirect(orig.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new double[orig.length];
        this.testDoubleArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        copy = new double[orig.length];
        this.testDoubleArraySerialization(orig, copy, buffer);
        buffer = ByteBuffer.allocate(orig.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        copy = new double[orig.length];
        this.testDoubleArraySerialization(orig, copy, buffer);
    }

    private void testDoubleArraySerialization(double[] orig, double[] copy, ByteBuffer buffer) {
        UtlBuffer.copy(orig, 0, buffer, 0, orig.length);
        UtlBuffer.copy(buffer, 0, copy, 0, orig.length);
        for (int i = 0; i < orig.length; ++i) {
            Assert.assertEquals((String)("Copied array differs at index " + i), (double)orig[i], (double)copy[i], (double)0.0);
        }
    }

    @Test
    public void testBufferWipe() {
        byte[] bytes = (byte[])UtlObjectGraph.createRandomArray(Byte.TYPE, 1024, new Random());
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        this.testBufferWiped(buffer);
        buffer.put(bytes);
        UtlBuffer.wipe(buffer, buffer.capacity());
        this.testBufferWiped(buffer);
        buffer = ByteBuffer.allocateDirect(bytes.length);
        this.testBufferWiped(buffer);
        buffer.put(bytes);
        UtlBuffer.wipe(buffer, buffer.capacity());
        this.testBufferWiped(buffer);
    }

    public void testBufferWiped(ByteBuffer buffer) {
        buffer.clear();
        while (buffer.hasRemaining()) {
            Assert.assertEquals((String)("Buffer not clear at " + buffer.position()), (long)0L, (long)buffer.get());
        }
        buffer.clear();
    }

    @Test
    public void testWriteLongBytes() {
        long l = System.currentTimeMillis();
        byte[] to = new byte[65];
        UtlBuffer.writeLong(l, to, 1, true);
        Assert.assertEquals((String)"wrong value for serialized/deserialized long (big endian)", (long)l, (long)UtlBuffer.readLong(to, 1, true));
        UtlBuffer.writeLong(l, to, 1, false);
        Assert.assertEquals((String)"wrong value for serialized/deserialized long (little endian)", (long)l, (long)UtlBuffer.readLong(to, 1, false));
    }

    @Test
    public void testBufferCleaner() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(32);
        UtlBuffer.releaseBuffer(buffer);
    }
}

