/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.NativeKernel;
import com.neeve.util.UtlEnv;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class UtlTime {
    @Deprecated
    public static final String PROP_TIME_USENATIVE = "nv.time.usenative";
    @Deprecated
    public static final boolean PROP_TIME_USENATIVE_DEFAULT = false;
    @Deprecated
    public static final String PROP_TIME_FORMAT = "nv.time.format";
    @Deprecated
    public static final String PROP_TIME_FORMAT_DEFAULT = "yyyyMMdd-HH:mm:ss.SSS";
    @Deprecated
    public static final String PROP_TIME_TIMEZONEFORMAT = "nv.time.timezoneformat";
    @Deprecated
    public static final String PROP_TIME_TIMEZONEFORMAT_DEFAULT = "GMT";
    @Deprecated
    public static final String PROP_TIME_USEEPOCHOFFSET = "nv.time.useepochoffset";
    @Deprecated
    static final boolean PROP_TIME_USEEPOCHOFFSET_DEFAULT = true;
    private static String dateFormat = "yyyyMMdd-HH:mm:ss.SSS";
    private static TimeZone dateFormatTimezone = TimeZone.getTimeZone("GMT");
    private static ThreadLocal<TimestampFormatHolder> formatters = new ThreadLocal();
    private static final boolean nativeKernelLoaded;
    private static final boolean USE_NATIVE;
    private static final boolean USE_EPOCH_OFFSET;
    private static final long microsOffset;

    private static final native long nativeNow();

    @Deprecated
    public static final boolean isEpochOffset() {
        return USE_EPOCH_OFFSET;
    }

    public static final boolean isNativeTimeEnabled() {
        return USE_NATIVE;
    }

    public static final boolean isEpochOffsetTimeEnabled() {
        return USE_EPOCH_OFFSET;
    }

    public static final long now() {
        if (USE_EPOCH_OFFSET) {
            return UtlTime.nowSinceEpoch();
        }
        return USE_NATIVE ? UtlTime.nativeNow() : System.nanoTime() / 1000L;
    }

    public static final long nowSinceEpoch() {
        if (USE_NATIVE) {
            return UtlTime.nativeNow();
        }
        return microsOffset + System.nanoTime() / 1000L;
    }

    public static final void setTimestampFormat(String dateFormat) {
        new SimpleDateFormat(dateFormat);
        UtlTime.dateFormat = dateFormat;
    }

    public static final String getTimestampFormat() {
        return dateFormat;
    }

    public static final void setTimestampFormatTimeZone(TimeZone timezone) {
        dateFormatTimezone = timezone;
    }

    public static final TimeZone setTimestampFormatTimeZone(String timezone) {
        TimeZone toSet;
        dateFormatTimezone = toSet = TimeZone.getTimeZone(timezone);
        return toSet;
    }

    public static final TimeZone getTimestampFormatTimeZone() {
        return dateFormatTimezone;
    }

    public static final DateFormat getTimestampFormatter() {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(dateFormatTimezone);
        return df;
    }

    public static final String format(Date date) {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.format(date);
    }

    public static final Date parse(String timestamp) throws ParseException {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.formatter.parse(timestamp);
    }

    public static final DateFormat getCachedTimestampFormatter() {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.formatter;
    }

    public static final void cleanupFormatter() {
        formatters.remove();
    }

    public static final void main(String[] args) {
        UtlTime.setTimestampFormatTimeZone(Calendar.getInstance().getTimeZone());
        long now = UtlTime.nowSinceEpoch();
        long micros = now % 1000L;
        System.out.println("Time: " + UtlTime.getTimestampFormatter().format(new Date(now / 1000L)) + String.format("%03d", micros));
    }

    static {
        UtlTime.setTimestampFormat(UtlEnv.getValue(PROP_TIME_FORMAT, PROP_TIME_FORMAT_DEFAULT));
        UtlTime.setTimestampFormatTimeZone(UtlEnv.getValue(PROP_TIME_TIMEZONEFORMAT, PROP_TIME_TIMEZONEFORMAT_DEFAULT));
        boolean val = false;
        try {
            NativeKernel.initialize();
            val = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nativeKernelLoaded = val;
        USE_NATIVE = nativeKernelLoaded && UtlEnv.getValue(PROP_TIME_USENATIVE, false);
        boolean shouldUseEpochOffset = UtlEnv.getValue(PROP_TIME_USEEPOCHOFFSET, true);
        USE_EPOCH_OFFSET = !USE_NATIVE && shouldUseEpochOffset;
        long microsSinceEpoch = System.currentTimeMillis() * 1000L;
        long nowInMicros = System.nanoTime() / 1000L;
        microsOffset = microsSinceEpoch - nowInMicros;
        if (UtlEnv.getValue("nv.native.configtrace", false)) {
            System.out.println("NATIVE TIME IS " + (USE_NATIVE ? "ENABLED" : "DISABLED"));
            if (USE_EPOCH_OFFSET) {
                System.out.println("EPOCH OFFSET TIME IS " + (USE_EPOCH_OFFSET ? "ENABLED" : "DISABLED"));
            } else if (shouldUseEpochOffset) {
                System.out.println("EPOCH OFFSET TIME IS SET AS ENABLED BUT WAS DISABLED BECAUSE NATIVE TIME WAS ENABLED");
            }
        }
    }

    private static final class TimestampFormatHolder {
        String dateFormat;
        TimeZone tz;
        DateFormat formatter;

        TimestampFormatHolder() {
            this.updateFormatter();
        }

        public final String format(Date date) {
            if (this.dateFormat != dateFormat || this.tz != dateFormatTimezone) {
                this.updateFormatter();
            }
            return this.formatter.format(date);
        }

        private final void updateFormatter() {
            this.dateFormat = dateFormat;
            this.tz = dateFormatTimezone;
            this.formatter = new SimpleDateFormat(this.dateFormat);
            this.formatter.setTimeZone(this.tz);
        }
    }
}

