/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import cern.colt.list.ObjectArrayList;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class UtlPoolRegistry {
    private final HashMap<String, UtlPool<?>> pools = new HashMap();
    private final Map<EventHandler, EventHandler> eventHandlers = new ConcurrentHashMap<EventHandler, EventHandler>();
    private static final UtlPoolRegistry instance = new UtlPoolRegistry();
    private static final boolean enabled = UtlProps.getValue((Properties)System.getProperties(), (String)"nv.poolregistry.enabled", (boolean)true);

    private UtlPoolRegistry() {
    }

    public static UtlPoolRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void put(UtlPool<?> pool) {
        if (enabled) {
            boolean added = false;
            this.remove(pool);
            HashMap<String, UtlPool<?>> hashMap = this.pools;
            synchronized (hashMap) {
                this.pools.put(pool.key(), pool);
                added = true;
            }
            if (added) {
                Iterator<EventHandler> iterator = this.eventHandlers.keySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onPoolAdded(pool);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UtlPool<?> get(String name) {
        HashMap<String, UtlPool<?>> hashMap = this.pools;
        synchronized (hashMap) {
            return this.pools.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectArrayList getValues(EventHandler eventHandler) {
        HashMap<String, UtlPool<?>> hashMap = this.pools;
        synchronized (hashMap) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<UtlPool<?>> iterator = this.pools.values().iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            if (eventHandler != null) {
                this.eventHandlers.put(eventHandler, eventHandler);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHandler(EventHandler eventHandler) {
        HashMap<String, UtlPool<?>> hashMap = this.pools;
        synchronized (hashMap) {
            if (eventHandler != null) {
                this.eventHandlers.remove(eventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(UtlPool<?> pool) {
        if (enabled) {
            boolean removed = false;
            HashMap<String, UtlPool<?>> hashMap = this.pools;
            synchronized (hashMap) {
                if (this.pools.containsKey(pool.key())) {
                    this.pools.remove(pool.key());
                    removed = true;
                }
            }
            if (removed) {
                Iterator<EventHandler> iterator = this.eventHandlers.keySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onPoolRemoved(pool);
                }
            }
        }
    }

    public static interface EventHandler {
        public void onPoolAdded(UtlPool<?> var1);

        public void onPoolRemoved(UtlPool<?> var1);
    }
}

