/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.env.Env;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlProc;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class UtlEnv {
    private static final boolean WARN_ON_EARLY_ACCESS;
    private static final boolean DUMP_ON_EARLY_ACCESS;
    private static final boolean WARN_ON_REINIT;
    private static final boolean DUMP_ON_REINIT;
    private static String lastInitializer;
    private static final Properties initialPrebootstrapEnv;
    private static final Properties prebootstrapEnv;
    private static volatile Properties initializedEnv;

    private static final Map<String, Object> toMap(Properties props) {
        UtlLinkedHashMap map = new UtlLinkedHashMap();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    public static final void reset() {
        initializedEnv = null;
        prebootstrapEnv.clear();
        prebootstrapEnv.putAll((Map<?, ?>)initialPrebootstrapEnv);
    }

    private static final void updateEnv(Properties source, Properties target) {
        for (String key : source.stringPropertyNames()) {
            try {
                String value = source.getProperty(key);
                if (value == null) continue;
                target.setProperty(key, value);
            }
            catch (RuntimeException thrown) {
                System.err.println("Error updating Env property (key=" + key + ", value=" + source.getProperty(key) + "): " + thrown.getLocalizedMessage());
                throw thrown;
            }
        }
    }

    public static synchronized void initialize(Properties env) {
        if (initializedEnv != null) {
            if (DUMP_ON_REINIT) {
                String thisInitializer = UtlThrowable.prepareStackTrace((Throwable)new Exception("Initializing Thread: " + Thread.currentThread().getName()));
                System.err.println("WARNING: Runtime Environment initialized after already being initialized: [\nLast inititializer:\n" + lastInitializer + "'\nThis initializer:\n" + thisInitializer + "\n]");
                lastInitializer = thisInitializer;
            } else if (WARN_ON_REINIT) {
                System.err.println("WARNING: Runtime Environment initialized after already being initialized: [Last inititializer = '" + lastInitializer + "', ', This initializer='" + Thread.currentThread().getName() + "']");
                lastInitializer = Thread.currentThread().getName();
            }
        } else if (DUMP_ON_REINIT) {
            lastInitializer = UtlThrowable.prepareStackTrace((Throwable)new Exception("Initializing Thread: " + Thread.currentThread().getName()));
        } else if (WARN_ON_REINIT) {
            lastInitializer = Thread.currentThread().getName();
        }
        initializedEnv = env;
        Env.setEnvironment(UtlEnv.toMap(initializedEnv));
    }

    public static synchronized void update(Properties val) {
        Properties env = UtlEnv.getEnvPropsNoWarn();
        for (String key : val.stringPropertyNames()) {
            try {
                String value = val.getProperty(key);
                if (value == null) continue;
                env.setProperty(key, value);
            }
            catch (RuntimeException thrown) {
                System.err.println("Error updating property (key=" + key + ", value=" + val.getProperty(key) + "): " + thrown.getLocalizedMessage());
                throw thrown;
            }
        }
        Env.updateEnvironment(UtlEnv.toMap(env));
    }

    public static Properties getEnvPropsNoWarn() {
        if (initializedEnv != null) {
            return initializedEnv;
        }
        return prebootstrapEnv;
    }

    public static Properties getEnvProps() {
        if (initializedEnv != null) {
            return initializedEnv;
        }
        if (DUMP_ON_EARLY_ACCESS) {
            return UtlEnv.getEnvPropsFor("*");
        }
        if (WARN_ON_EARLY_ACCESS) {
            return UtlEnv.getEnvPropsFor("*");
        }
        return prebootstrapEnv;
    }

    private static Properties getEnvPropsFor(String name) {
        if (initializedEnv != null) {
            return initializedEnv;
        }
        if (DUMP_ON_EARLY_ACCESS) {
            new Exception("WARNING: Runtime environment accessed prior to initialization: [for: '" + name + "', thread=" + Thread.currentThread().getName() + "]").printStackTrace(System.err);
        } else if (WARN_ON_EARLY_ACCESS) {
            System.err.println("WARNING: Runtime environment accessed prior to initialization: [for: '" + name + "', thread=" + Thread.currentThread().getName() + "]");
        }
        return prebootstrapEnv;
    }

    public static String getValue(String name) {
        String val = null;
        try {
            val = UtlEnv.getEnvPropsFor(name).getProperty(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static final boolean getValue(String name, boolean defValue) {
        return UtlProps.getValue((Properties)UtlEnv.getEnvPropsFor(name), (String)name, (boolean)defValue);
    }

    public static final double getValue(String name, double defValue) {
        return UtlProps.getValue((Properties)UtlEnv.getEnvPropsFor(name), (String)name, (double)defValue);
    }

    public static final int getValue(String name, int defValue) {
        return UtlProps.getValue((Properties)UtlEnv.getEnvPropsFor(name), (String)name, (int)defValue);
    }

    public static final short getValue(String name, short defValue) {
        return UtlProps.getValue((Properties)UtlEnv.getEnvPropsFor(name), (String)name, (short)defValue);
    }

    public static String getValue(String name, String defValue) {
        String value = defValue;
        String valueStr = null;
        try {
            valueStr = UtlEnv.getValue(name);
            if (valueStr != null) {
                value = valueStr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Deprecated
    public static final String getPid() {
        return UtlProc.getPid();
    }

    @Deprecated
    public static final InetAddress getLocalHostInetAddress() throws UnknownHostException {
        return UtlNet.getLocalHostInetAddress();
    }

    @Deprecated
    public static final String getLocalHostNameForDisplay(String defaultValue) {
        return UtlNet.getLocalHostNameForDisplay(defaultValue);
    }

    @Deprecated
    public static final String getLocalHostName() throws UnknownHostException {
        return UtlNet.getLocalHostName();
    }

    @Deprecated
    public static final String getLocalHostAddressForDisplay(String defaultValue) {
        return UtlNet.getLocalHostAddressForDisplay(defaultValue);
    }

    @Deprecated
    public static final String getLocalHostAddress() throws UnknownHostException {
        return UtlNet.getLocalHostAddress();
    }

    static {
        initialPrebootstrapEnv = new Properties();
        prebootstrapEnv = new Properties();
        String propfile = System.getProperty("nv.app.propfile", System.getenv("nv.app.propfile".replace(".", "_")));
        if (propfile == null) {
            String nvRootFromEnv = System.getenv("NVROOT");
            String nvRootDirectory = UtlProps.getValue((Properties)System.getProperties(), (String)"NVROOT", (String)(nvRootFromEnv != null ? nvRootFromEnv : "."));
            if (new File(nvRootDirectory + File.separator + "conf/application.conf").exists()) {
                propfile = nvRootDirectory + File.separator + "conf/application.conf";
            }
        }
        UtlEnv.updateEnv(System.getProperties(), prebootstrapEnv);
        if (propfile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                prebootstrapEnv.load(fis);
            }
            catch (Exception nvRootDirectory) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException nvRootDirectory) {}
            }
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            prebootstrapEnv.setProperty(entry.getKey(), entry.getValue());
            prebootstrapEnv.setProperty(entry.getKey().replace('_', '.'), entry.getValue());
        }
        WARN_ON_EARLY_ACCESS = UtlProps.getValue((Properties)prebootstrapEnv, (String)"nv.env.warnonearlyaccess", (boolean)false);
        DUMP_ON_EARLY_ACCESS = UtlProps.getValue((Properties)prebootstrapEnv, (String)"nv.env.dumponearlyaccess", (boolean)false);
        WARN_ON_REINIT = UtlProps.getValue((Properties)prebootstrapEnv, (String)"nv.env.warnonreinit", (boolean)false);
        DUMP_ON_REINIT = UtlProps.getValue((Properties)prebootstrapEnv, (String)"nv.env.dumponreinit", (boolean)false);
        initialPrebootstrapEnv.putAll((Map<?, ?>)prebootstrapEnv);
    }
}

