/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public final class UtlCharset {
    public static CharsetEncoder getEncoder(String charsetName) {
        try {
            Charset charset = Charset.forName(charsetName);
            return charset.newEncoder();
        }
        catch (IllegalCharsetNameException e) {
            throw new IllegalArgumentException("Invalid charset name [" + charsetName + "]");
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException("Charset [" + charsetName + "] is not supported");
        }
    }

    public static CharsetDecoder getDecoder(String charsetName) {
        try {
            Charset charset = Charset.forName(charsetName);
            return charset.newDecoder();
        }
        catch (IllegalCharsetNameException e) {
            throw new IllegalArgumentException("Invalid charset name [" + charsetName + "]");
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException("Charset [" + charsetName + "] is not supported");
        }
    }
}

