/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlPlatform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;

public final class UtlArchive {
    private static final String WINDOWS_COMPRESSED_ARCHIVE_EXTENSION = ".zip";
    private static final String UNIX_ARCHIVE_EXTENSION = ".tar";
    private static final String UNIX_COMPRESSED_EXTENSION = ".gz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void archiveAndCompress(File root, String source, ZipArchiveOutputStream out) throws Exception {
        File sourceFile = source == null ? root : new File(root + File.separator + source);
        File[] files = sourceFile.listFiles();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String relativeFilename;
                String string = relativeFilename = source == null ? files[i].getName() : source + File.separator + files[i].getName();
                if (files[i].isDirectory()) {
                    UtlArchive.archiveAndCompress(root, relativeFilename, out);
                    continue;
                }
                out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(files[i], relativeFilename));
                try {
                    FileInputStream in = new FileInputStream(files[i]);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        continue;
                    }
                    finally {
                        out.flush();
                        in.close();
                    }
                }
                finally {
                    out.closeArchiveEntry();
                }
            }
        } else if (source != null) {
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(sourceFile, source));
            out.closeArchiveEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void archive(File root, String source, TarArchiveOutputStream out) throws Exception {
        File sourceFile = source == null ? root : new File(root + File.separator + source);
        File[] files = sourceFile.listFiles();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String relativeFilename;
                String string = relativeFilename = source == null ? files[i].getName() : source + File.separator + files[i].getName();
                if (files[i].isDirectory()) {
                    UtlArchive.archive(root, relativeFilename, out);
                    continue;
                }
                TarArchiveEntry archiveEntry = new TarArchiveEntry(files[i], relativeFilename);
                archiveEntry.setSize(files[i].length());
                out.putArchiveEntry((ArchiveEntry)archiveEntry);
                try {
                    FileInputStream in = new FileInputStream(files[i]);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        continue;
                    }
                    finally {
                        out.flush();
                        in.close();
                    }
                }
                finally {
                    out.closeArchiveEntry();
                }
            }
        } else if (source != null) {
            out.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(sourceFile, source));
            out.closeArchiveEntry();
        }
    }

    public static final String getCompressedArchiveFileExtension(String platform) {
        if (platform == null) {
            throw new IllegalArgumentException("platform cannot be null");
        }
        if (UtlPlatform.isWindowsPlatform((String)platform)) {
            return WINDOWS_COMPRESSED_ARCHIVE_EXTENSION;
        }
        return ".tar.gz";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File archiveAndCompress(File source, File dest, String archiveFilename, String platform) throws Exception {
        if (source == null) {
            throw new IllegalArgumentException("source directory cannot be null");
        }
        if (archiveFilename == null) {
            throw new IllegalArgumentException("archive file name cannot be null");
        }
        if (source.exists()) {
            if (source.isDirectory()) {
                File archivedAndCompressedFile = null;
                if (UtlPlatform.isWindowsPlatform((String)platform)) {
                    archivedAndCompressedFile = new File(dest + File.separator + archiveFilename + WINDOWS_COMPRESSED_ARCHIVE_EXTENSION);
                    try (ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(archivedAndCompressedFile)));){
                        out.setMethod(8);
                        UtlArchive.archiveAndCompress(source, null, out);
                    }
                }
                File archiveFile = new File(dest + File.separator + archiveFilename + UNIX_ARCHIVE_EXTENSION);
                TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(archiveFile)));
                try {
                    try {
                        out.setLongFileMode(2);
                        UtlArchive.archive(source, null, out);
                    }
                    finally {
                        out.close();
                    }
                    archivedAndCompressedFile = new File(archiveFile + UNIX_COMPRESSED_EXTENSION);
                    CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)new FileOutputStream(archivedAndCompressedFile));
                    FileInputStream in = new FileInputStream(archiveFile);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)cos);
                    }
                    finally {
                        in.close();
                        cos.close();
                    }
                }
                finally {
                    archiveFile.delete();
                }
                return archivedAndCompressedFile;
            }
            throw new Exception("source must be a directory");
        }
        throw new FileNotFoundException(source.toString());
    }
}

