/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XCharCollection;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XCharLinkedHashMap;
import com.neeve.lang.XCharLinkedList;
import com.neeve.lang.XCharList;
import com.neeve.lang.XCharListIterator;
import com.neeve.lang.XCharMap;
import com.neeve.lang.XCharSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class CharCollectionAdapters {
    CharCollectionAdapters() {
    }

    static <V> Map<Character, V> toLinkedCharacterMap(XCharMap<V> map) {
        return new XPrimitiveToCharacterMapAdapter<V>(map);
    }

    static <V> List<Character> toCharacterList(XCharList list) {
        return new XPrimitiveToCharacterListAdapter(list);
    }

    private static char adaptCharacter(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return ((Character)value).charValue();
    }

    private static Object adaptCharacterMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return CharCollectionAdapters.adaptCharacterMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XCharMap.Entry<V> adaptCharacterMapEntry(Map.Entry<Character, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XCharToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveCharacterMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(CharCollectionAdapters.adaptCharacterMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XCharMap.Entry<V>> adaptToPrimitiveCharacterMapEntryCollection(Collection<? extends Map.Entry<Character, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XCharMap.Entry<V>> list = new ArrayList<XCharMap.Entry<V>>(c.size());
        for (Map.Entry<Character, V> e : c) {
            list.add(CharCollectionAdapters.adaptCharacterMapEntry(e));
        }
        return list;
    }

    public static class Characters
    extends SampleElements<Character> {
        public Characters() {
            super((Object)Character.valueOf('a'), (Object)Character.valueOf('b'), (Object)Character.valueOf('c'), (Object)Character.valueOf('d'), (Object)Character.valueOf('e'));
        }
    }

    public static abstract class TestCharListGenerator
    implements TestListGenerator<Character> {
        public SampleElements<Character> samples() {
            return new Characters();
        }

        public List<Character> create(Object ... elements) {
            Character[] array = new Character[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Character)e;
            }
            return this.create(array);
        }

        protected abstract List<Character> create(Character[] var1);

        public Character[] createArray(int length) {
            return new Character[length];
        }

        public List<Character> order(List<Character> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestCharMapGenerator
    implements TestMapGenerator<Character, String> {
        public SampleElements<Map.Entry<Character, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)Character.valueOf('j'), (Object)"January"), (Object)Helpers.mapEntry((Object)Character.valueOf('f'), (Object)"February"), (Object)Helpers.mapEntry((Object)Character.valueOf('m'), (Object)"March"), (Object)Helpers.mapEntry((Object)Character.valueOf('a'), (Object)"April"), (Object)Helpers.mapEntry((Object)Character.valueOf('y'), (Object)"May"));
        }

        public Map<Character, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Character, String> create(Map.Entry<Character, String>[] var1);

        public final Map.Entry<Character, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Character[] createKeyArray(int length) {
            return new Character[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Character, String>> order(List<Map.Entry<Character, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToCharacterEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Character, V>>
    implements Set<Map.Entry<Character, V>> {
        private final Set<XCharMap.Entry<V>> adaptee;

        public XPrimtiveToCharacterEntrySetAdapter(Set<XCharMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(CharCollectionAdapters.adaptCharacterMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Character, V>> iterator() {
            final Iterator<XCharMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Character, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Character, V> next() {
                    XCharMap.Entry next = (XCharMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(Character.valueOf(next.getKey()), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XCharMap.Entry xEntry = (XCharMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(Character.valueOf(xEntry.getKey()), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XCharMap.Entry[] toAdapt = this.adaptee.toArray(new XCharMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(Character.valueOf(toAdapt[i].getKey()), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Character, V> e) {
            return this.adaptee.add(CharCollectionAdapters.adaptCharacterMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(CharCollectionAdapters.adaptCharacterMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(CharCollectionAdapters.adaptToPrimitiveCharacterMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Character, V>> c) {
            return this.adaptee.addAll(CharCollectionAdapters.adaptToPrimitiveCharacterMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(CharCollectionAdapters.adaptToPrimitiveCharacterMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(CharCollectionAdapters.adaptToPrimitiveCharacterMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XCharToPrimitiveMapEntryAdapter<V>
    extends XCharLinkedHashMap.Entry<V> {
        XCharToPrimitiveMapEntryAdapter(Map.Entry<Character, V> entry) {
            this.setKey(entry.getKey().charValue());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToCharacterListIteratorAdapater
    extends XCharIteratorAdapater
    implements ListIterator<Character> {
        final XCharListIterator adaptee;

        XPrimitiveToCharacterListIteratorAdapater(XCharListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Character previous() {
            return Character.valueOf(this.adaptee.previous());
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Character e) {
            this.adaptee.set(CharCollectionAdapters.adaptCharacter(e));
        }

        @Override
        public void add(Character e) {
            this.adaptee.add(CharCollectionAdapters.adaptCharacter(e));
        }
    }

    private static class XCharIteratorAdapater
    implements Iterator<Character> {
        final XCharIterator iterator;

        XCharIteratorAdapater(XCharIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Character next() {
            return Character.valueOf(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToCharacterCollectionAdapter<S extends XCharCollection>
    extends AbstractCollection<Character>
    implements Collection<Character> {
        final S adaptee;

        XPrimitiveToCharacterCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(CharCollectionAdapters.adaptCharacter(o));
        }

        @Override
        public Iterator<Character> iterator() {
            return new XCharIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            char[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = Character.valueOf(val[i]);
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            char[] toAdapt = this.adaptee.toArray(new char[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = Character.valueOf(toAdapt[i]);
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Character e) {
            return this.adaptee.add(CharCollectionAdapters.adaptCharacter(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(CharCollectionAdapters.adaptCharacter(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XCharLinkedList adapter = new XCharLinkedList();
            for (Object o : c) {
                adapter.add(CharCollectionAdapters.adaptCharacter(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            XCharLinkedList adapter = new XCharLinkedList();
            for (Character c2 : c) {
                adapter.add(CharCollectionAdapters.adaptCharacter(c2));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XCharLinkedList adapter = new XCharLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(CharCollectionAdapters.adaptCharacter(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XCharLinkedList adapter = new XCharLinkedList();
            for (Object o : c) {
                adapter.add(CharCollectionAdapters.adaptCharacter(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToCharacterListAdapter
    extends XPrimitiveToCharacterCollectionAdapter<XCharList>
    implements List<Character> {
        XPrimitiveToCharacterListAdapter(XCharList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Character> c) {
            XCharLinkedList adapter = new XCharLinkedList();
            for (Character c2 : c) {
                adapter.add(CharCollectionAdapters.adaptCharacter(c2));
            }
            return ((XCharList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(((XCharList)this.adaptee).get(index));
        }

        @Override
        public Character set(int index, Character element) {
            return Character.valueOf(((XCharList)this.adaptee).set(index, CharCollectionAdapters.adaptCharacter(element)));
        }

        @Override
        public void add(int index, Character element) {
            ((XCharList)this.adaptee).add(index, CharCollectionAdapters.adaptCharacter(element));
        }

        @Override
        public Character remove(int index) {
            return Character.valueOf(((XCharList)this.adaptee).remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return ((XCharList)this.adaptee).indexOf(CharCollectionAdapters.adaptCharacter(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XCharList)this.adaptee).lastIndexOf(CharCollectionAdapters.adaptCharacter(o));
        }

        @Override
        public ListIterator<Character> listIterator() {
            return new XPrimitiveToCharacterListIteratorAdapater(((XCharList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Character> listIterator(int index) {
            return new XPrimitiveToCharacterListIteratorAdapater(((XCharList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToCharacterListAdapter(((XCharList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Character> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Character o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Character obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToCharacterSetAdapter
    extends XPrimitiveToCharacterCollectionAdapter<XCharSet>
    implements Set<Character> {
        XPrimitiveToCharacterSetAdapter(XCharSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Character obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Character> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToCharacterMapAdapter<V>
    extends AbstractMap<Character, V>
    implements Map<Character, V> {
        private final XCharMap<V> map;

        public XPrimitiveToCharacterMapAdapter(XCharMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(CharCollectionAdapters.adaptCharacter(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(CharCollectionAdapters.adaptCharacter(key));
        }

        @Override
        public V put(Character key, V value) {
            return this.map.put(CharCollectionAdapters.adaptCharacter(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(CharCollectionAdapters.adaptCharacter(key));
        }

        @Override
        public void putAll(Map<? extends Character, ? extends V> m) {
            XCharLinkedHashMap<V> adapter = new XCharLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Character, V> entry : m.entrySet()) {
                adapter.put(CharCollectionAdapters.adaptCharacter(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Character> keySet() {
            return new XPrimitiveToCharacterSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Character, V>> entrySet() {
            return new XPrimtiveToCharacterEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

