/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XFloatCollection;
import com.neeve.lang.XFloatCollectionBase;
import com.neeve.lang.XFloatIterator;
import com.neeve.lang.XFloatList;
import com.neeve.lang.XFloatListIterator;
import java.util.NoSuchElementException;

public class XFloatLinkedList
extends XFloatCollectionBase
implements XFloatList {
    private transient FloatNode _head = this.newNode();
    private transient FloatNode _tail = this.newNode();
    private transient int _size;

    public XFloatLinkedList() {
        this(4);
    }

    public XFloatLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        FloatNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            FloatNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XFloatLinkedList(XFloatCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XFloatLinkedList newInstance() {
        return new XFloatLinkedList();
    }

    @Override
    public final boolean add(float value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final float get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final float set(int index, float value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        FloatNode node = this.nodeAt(index);
        float previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, float value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XFloatCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        FloatNode indexNode = this.nodeAt(index);
        XFloatIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final float remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        FloatNode node = this.nodeAt(index);
        float previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(float value) {
        int index = 0;
        FloatNode n = this._head;
        FloatNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(float value) {
        int index = this.size() - 1;
        FloatNode n = this._tail;
        FloatNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XFloatIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XFloatListIterator listIterator() {
        return XFloatLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XFloatListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XFloatLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XFloatList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final float getFirst() {
        FloatNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final float getLast() {
        FloatNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(float value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(float value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final float removeFirst() {
        FloatNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        float previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final float removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        FloatNode last = this._tail._previous;
        float previousValue = last._value;
        this._tail = last;
        last._value = 0.0f;
        return previousValue;
    }

    public final void addBefore(FloatNode next, float value) {
        FloatNode newNode;
        FloatNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        FloatNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final FloatNode nodeAt(int index) {
        FloatNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final FloatNode head() {
        return this._head;
    }

    @Override
    public final FloatNode tail() {
        return this._tail;
    }

    @Override
    public final float valueOf(XCollection.Record record) {
        return ((FloatNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        FloatNode node = (FloatNode)record;
        --this._size;
        node._value = 0.0f;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        FloatNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(float value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XFloatList unmodifiable() {
        return (XFloatList)super.unmodifiable();
    }

    protected FloatNode newNode() {
        return new FloatNode();
    }

    private void increaseCapacity() {
        FloatNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        FloatNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        FloatNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        FloatNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XFloatLinkedListIterator
    implements XFloatListIterator {
        private XFloatLinkedList _list;
        private FloatNode _nextNode;
        private FloatNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XFloatLinkedListIterator() {
        }

        public static XFloatLinkedListIterator valueOf(XFloatLinkedList list, FloatNode nextNode, int nextIndex, int size) {
            XFloatLinkedListIterator itr = new XFloatLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public float next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public float previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(float o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(float o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XFloatLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XFloatCollectionBase
    implements XFloatList {
        private XFloatLinkedList _list;
        private FloatNode _head;
        private FloatNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XFloatLinkedList list, FloatNode head, FloatNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public float valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XFloatCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XFloatCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            FloatNode indexNode = this.nodeAt(index);
            XFloatIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public float get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public float set(int index, float value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            FloatNode node = this.nodeAt(index);
            float previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(float element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, float element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public float remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            FloatNode node = this.nodeAt(index);
            float previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(float value) {
            int index = 0;
            FloatNode n = this._head;
            FloatNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(float value) {
            int index = this.size() - 1;
            FloatNode n = this._tail;
            FloatNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XFloatListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XFloatListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XFloatLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XFloatList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final FloatNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                FloatNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            FloatNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class FloatNode
    implements XCollection.Record {
        private FloatNode _next;
        private FloatNode _previous;
        private float _value;

        protected FloatNode() {
        }

        public final float getValue() {
            return this._value;
        }

        @Override
        public final FloatNode getNext() {
            return this._next;
        }

        @Override
        public final FloatNode getPrevious() {
            return this._previous;
        }
    }
}

