/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XFloatIterator;
import java.util.NoSuchElementException;

public class XFloatArrayIterator
implements XFloatIterator {
    private final float[] array;
    private final int offset;
    private final int length;
    private int current = 0;

    public XFloatArrayIterator(float[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array == null ? 0 : array.length;
    }

    public XFloatArrayIterator(float[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        if (length < 0 || array == null && length > 0 || length > array.length) {
            throw new IllegalArgumentException("length cannot be less than 0");
        }
        if (offset < 0 || array == null && offset > 0 || offset >= array.length) {
            throw new IndexOutOfBoundsException("length cannot be less than 0");
        }
    }

    public final float[] array() {
        return this.array;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public final boolean hasNext() {
        return this.current < this.length;
    }

    @Override
    public final float next() {
        if (this.current < this.length) {
            return this.array[this.offset + this.current++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public final XFloatIterator toFirst() {
        this.current = 0;
        return this;
    }
}

