/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class XFactory {
    private static final Provider provider;

    public static final XString createXString(int expectedSize) {
        return provider.createXString(expectedSize, false, false);
    }

    public static final XString createXString(int expectedSize, boolean mutable) {
        return provider.createXString(expectedSize, mutable, false);
    }

    public static final XString createXString(int expectedSize, boolean mutable, boolean isNative) {
        return provider.createXString(expectedSize, mutable, isNative);
    }

    public static final XString createXString(String value) {
        return XFactory.createXString(value, false);
    }

    public static final XString createXString(String value, boolean isNative) {
        XString str = provider.createXString(value.length(), false, isNative);
        str.setValue(value);
        return str;
    }

    public static final <T extends XString> XString.Factory<T> createXPooledStringFactory(Class<T> pooledStringClass, String factoryName, Map<String, Object> props) throws RuntimeException {
        Method factoryMethod = null;
        try {
            factoryMethod = pooledStringClass.getMethod("newFactory", String.class, Map.class);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No newFactory(String, Map) method found for " + pooledStringClass, e);
        }
        try {
            return (XString.Factory)factoryMethod.invoke(null, factoryName, props);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error creating " + pooledStringClass.getCanonicalName() + " factory factory: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error creating " + pooledStringClass.getCanonicalName() + " factory factory: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error creating " + pooledStringClass.getCanonicalName() + " factory factory: " + e.getMessage(), e);
        }
    }

    static {
        try {
            provider = (Provider)Class.forName("com.neeve.raw.RawDataFactory").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Unable to load RawDataFactory: " + e.getMessage(), e);
        }
    }

    public static interface Provider {
        public XString createXString(int var1, boolean var2, boolean var3);
    }
}

