/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCharCollection;
import com.neeve.lang.XCharCollectionBase;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XCharList;
import com.neeve.lang.XCharListIterator;
import com.neeve.lang.XCollection;
import com.neeve.lang.XIndex;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class XCharIndexedList
extends XCharCollectionBase
implements XCharList,
RandomAccess {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int M1 = 1023;
    private transient char[] _low = new char[16];
    private transient char[][] _high = new char[1][];
    private transient int _capacity = 16;
    private transient int _size;
    private static final char[] NULL_BLOCK = new char[1024];

    public XCharIndexedList() {
        this._high[0] = this._low;
    }

    public XCharIndexedList(int capacity) {
        this();
        while (capacity > this._capacity) {
            this.increaseCapacity();
        }
    }

    public XCharIndexedList(XCharCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XCharIndexedList newInstance() {
        return new XCharIndexedList();
    }

    public void setSize(int size) {
        while (this._size < size) {
            this.addLast('\uffff');
        }
        while (this._size > size) {
            this.removeLast();
        }
    }

    @Override
    public final char get(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return index < 1024 ? this._low[index] : this._high[index >> 10][index & 0x3FF];
    }

    @Override
    public final char set(int index, char value) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        char[] low = this._high[index >> 10];
        char previous = low[index & 0x3FF];
        low[index & 0x3FF] = value;
        return previous;
    }

    @Override
    public final boolean add(char value) {
        if (this._size >= this._capacity) {
            this.increaseCapacity();
        }
        this._high[this._size >> 10][this._size & 0x3FF] = value;
        ++this._size;
        return true;
    }

    public final char getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._low[0];
    }

    public final char getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this._size - 1);
    }

    public final void addLast(char value) {
        this.add(value);
    }

    public final char removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        char[] low = this._high[this._size >> 10];
        char previous = low[this._size & 0x3FF];
        low[this._size & 0x3FF] = '\u0000';
        return previous;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._size; i += 1024) {
            int count = Math.min(this._size - i, 1024);
            char[] low = this._high[i >> 10];
            System.arraycopy(NULL_BLOCK, 0, low, 0, count);
        }
        this._size = 0;
    }

    public void reset() {
        this.clear();
    }

    @Override
    public final boolean addAll(int index, XCharCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int shift = values.size();
        this.shiftRight(index, shift);
        XCharIterator valuesIterator = values.iterator();
        int n = index + shift;
        for (int i = index; i < n; ++i) {
            this._high[i >> 10][i & 0x3FF] = valuesIterator.next();
        }
        this._size += shift;
        return shift != 0;
    }

    @Override
    public final void add(int index, char value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.shiftRight(index, 1);
        this._high[index >> 10][index & 0x3FF] = value;
        ++this._size;
    }

    @Override
    public final char remove(int index) {
        char previous = this.get(index);
        this.shiftLeft(index + 1, 1);
        --this._size;
        this._high[this._size >> 10][this._size & 0x3FF] = '\u0000';
        return previous;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex || toIndex > this._size) {
            throw new IndexOutOfBoundsException("XList removeRange(" + fromIndex + ", " + toIndex + ") index out of bounds, size: " + this._size);
        }
        int shift = toIndex - fromIndex;
        this.shiftLeft(toIndex, shift);
        this._size -= shift;
        int n = this._size + shift;
        for (int i = this._size; i < n; ++i) {
            this._high[i >> 10][i & 0x3FF] = '\u0000';
        }
    }

    @Override
    public final int indexOf(char value) {
        int count;
        for (int i = 0; i < this._size; i += count) {
            char[] low = this._high[i >> 10];
            count = Math.min(low.length, this._size - i);
            for (int j = 0; j < count; ++j) {
                if (value != low[j]) continue;
                return i + j;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char value) {
        int count;
        for (int i = this._size - 1; i >= 0; i -= count) {
            char[] low = this._high[i >> 10];
            int j = count = (i & 0x3FF) + 1;
            while (--j >= 0) {
                if (value != low[j]) continue;
                return i + j - count + 1;
            }
        }
        return -1;
    }

    @Override
    public XCharIterator iterator() {
        return XCharLinkedListIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public XCharListIterator listIterator() {
        return XCharLinkedListIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public XCharListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException();
        }
        return XCharLinkedListIterator.valueOf(this, index, 0, this._size);
    }

    @Override
    public final XCharList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubTable.valueOf(this, fromIndex, toIndex - fromIndex);
    }

    public final void trimToSize() {
        while (this._capacity - this._size > 1024) {
            this._capacity -= 1024;
            this._high[this._capacity >> 10] = null;
        }
    }

    public void sort(boolean ascending) {
        this.quicksort(0, this._size - 1, ascending);
    }

    private void quicksort(int first, int last, boolean ascending) {
        int pivIndex = 0;
        if (first < last) {
            pivIndex = this.partition(first, last, ascending);
            this.quicksort(first, pivIndex - 1, ascending);
            this.quicksort(pivIndex + 1, last, ascending);
        }
    }

    private int partition(int f, int l, boolean ascending) {
        char piv = this.get(f);
        int up = f;
        int down = l;
        while (true) {
            if (this.compare(this.get(up), piv, ascending) <= 0 && up < l) {
                ++up;
                continue;
            }
            while (this.compare(this.get(down), piv, ascending) > 0 && down > f) {
                --down;
            }
            if (up < down) {
                char temp = this.get(up);
                this.set(up, this.get(down));
                this.set(down, temp);
            }
            if (down <= up) break;
        }
        this.set(f, this.get(down));
        this.set(down, piv);
        return down;
    }

    private final int compare(char l1, char l2, boolean ascending) {
        if (ascending) {
            return l1 - l2;
        }
        return l2 - l1;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final XCollection.Record head() {
        return XIndex.valueOf(-1);
    }

    @Override
    public final XCollection.Record tail() {
        return XIndex.valueOf(this._size);
    }

    @Override
    public final char valueOf(XCollection.Record record) {
        return this.get(((XIndex)record).intValue());
    }

    @Override
    public final void delete(XCollection.Record record) {
        this.remove(((XIndex)record).intValue());
    }

    @Override
    public XCharList unmodifiable() {
        return (XCharList)super.unmodifiable();
    }

    @Override
    public final boolean contains(char value) {
        return this.indexOf(value) >= 0;
    }

    protected final int getCapacity() {
        return this._capacity;
    }

    private void increaseCapacity() {
        if (this._capacity < 1024) {
            this._capacity <<= 1;
            char[] tmp = new char[this._capacity];
            System.arraycopy(this._low, 0, tmp, 0, this._size);
            this._low = tmp;
            this._high[0] = tmp;
        } else {
            int j = this._capacity >> 10;
            if (j >= this._high.length) {
                char[][] tmp = new char[this._high.length * 2][];
                System.arraycopy(this._high, 0, tmp, 0, this._high.length);
                this._high = tmp;
            }
            this._high[j] = new char[1024];
            this._capacity += 1024;
        }
    }

    private void shiftRight(int index, int shift) {
        while (this._size + shift >= this._capacity) {
            this.increaseCapacity();
        }
        int i = this._size;
        while (--i >= index) {
            int dest = i + shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private void shiftLeft(int index, int shift) {
        for (int i = index; i < this._size; ++i) {
            int dest = i - shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private static final class XCharLinkedListIterator
    implements XCharListIterator {
        private XCharIndexedList _list;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;
        private char[] _low;
        private char[][] _high;

        private XCharLinkedListIterator() {
        }

        public static XCharLinkedListIterator valueOf(XCharIndexedList list, int nextIndex, int start, int end) {
            XCharLinkedListIterator iterator = new XCharLinkedListIterator();
            iterator._list = list;
            iterator._start = start;
            iterator._end = end;
            iterator._nextIndex = nextIndex;
            iterator._low = list._low;
            iterator._high = list._high;
            iterator._currentIndex = -1;
            return iterator;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public char next() {
            int i;
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            return (i = (this._currentIndex = this._nextIndex++)) < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        @Override
        public char previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            int i = this._nextIndex;
            return i < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(char o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        @Override
        public void set(char o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._list.set(this._currentIndex, o);
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentIndex >= 0) {
                this._list.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }

        @Override
        public XCharLinkedListIterator toFirst() {
            this._start = 0;
            this._end = this._list.size();
            this._nextIndex = 0;
            this._low = this._list._low;
            this._high = this._list._high;
            this._currentIndex = -1;
            return this;
        }
    }

    private static final class SubTable
    extends XCharCollectionBase
    implements XCharList,
    RandomAccess {
        private XCharIndexedList _list;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        public static SubTable valueOf(XCharIndexedList list, int offset, int size) {
            SubTable subTable = new SubTable();
            subTable._list = list;
            subTable._offset = offset;
            subTable._size = size;
            return subTable;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return XIndex.valueOf(-1);
        }

        @Override
        public XCollection.Record tail() {
            return XIndex.valueOf(this._size);
        }

        @Override
        public char valueOf(XCollection.Record record) {
            return this._list.get(((XIndex)record).intValue() + this._offset);
        }

        @Override
        public void delete(XCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public boolean addAll(int index, XCharCollection values) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public char get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._list.get(index + this._offset);
        }

        @Override
        public char set(int index, char value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._list.set(index + this._offset, value);
        }

        @Override
        public void add(int index, char element) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public char remove(int index) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public int indexOf(char value) {
            int i = -1;
            while (++i < this._size) {
                if (value != this._list.get(i + this._offset)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(char value) {
            int i = this._size;
            while (--i >= 0) {
                if (value != this._list.get(i + this._offset)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public XCharListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XCharListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XCharLinkedListIterator.valueOf(this._list, index + this._offset, this._offset, this._offset + this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XCharList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            return SubTable.valueOf(this._list, this._offset + fromIndex, toIndex - fromIndex);
        }
    }
}

