/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableCharField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableCharFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final Character randomCharacter() {
        return Character.valueOf((char)random.nextInt(Short.MAX_VALUE));
    }

    private final XbufVariableCharField testSetClearSyncDesync(XbufVariableCharField field1) {
        char value = '\u0000';
        field1.setValue('\u0000');
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field1.length());
        value = XbufVariableCharFieldTest.randomCharacter().charValue();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field1.length());
        value = XbufVariableCharFieldTest.randomCharacter().charValue();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)0)), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        value = '\u0000';
        field1.setValue('\u0000');
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field1.sync(buffer1, 23));
        XbufVariableCharField field2 = XbufVariableCharField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field2.length());
        value = XbufVariableCharFieldTest.randomCharacter().charValue();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableCharField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint32Size((int)value)), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableCharField field1 = XbufVariableCharField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARCHAR), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)0)), (long)field1.length());
        field1 = XbufVariableCharField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARCHAR), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)0)), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() {
        XbufVariableCharField field1 = XbufVariableCharField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() {
        XbufVariableCharField field1 = XbufVariableCharField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void setSyncThenModify() {
        XbufVariableCharField field1 = XbufVariableCharField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        field1.setValue('a');
        container.sync();
        int origLength = container.getSerializedLength();
        field1.setValue('\u00e2');
        int newLength = container.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }
}

