/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableByteField;
import com.neeve.xbuf.XbufVariableByteListField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableByteListFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final byte[] randomArray(int len) {
        byte[] array = new byte[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)random.nextInt(127);
        }
        return array;
    }

    public static final void assertEqual(byte[] array1, byte[] array2, boolean array1EmptyIsArray2Null) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((String)("Wrong byte at index " + i), (long)array1[i], (long)array2[i]);
            }
        }
    }

    public static final void assertEqual(byte[] array1, byte[] array2) {
        XbufVariableByteListFieldTest.assertEqual(array1, array2, false);
    }

    private final XbufVariableByteField field(XbufVariableByteListField listField, byte val) {
        XbufVariableByteField field = XbufVariableByteField.create(listField.id(), listField.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field).build());
        field.setValue(val);
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private final XbufVariableByteListField testSetClearSyncDesync(XbufVariableByteListField field1) {
        void var10_16;
        void var10_14;
        byte[] values = XbufVariableByteListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)0L, (long)field1.length());
        byte value1 = (byte)random.nextInt(127);
        field1.addValue(value1);
        values = new byte[]{value1};
        Assert.assertEquals((long)1L, (long)field1.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)field1.length());
        byte value2 = (byte)random.nextInt(127);
        field1.addValue(value2);
        values = new byte[]{value1, value2};
        Assert.assertEquals((long)2L, (long)field1.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2)), (long)field1.length());
        byte value3 = (byte)random.nextInt(127);
        field1.getValues().add(value3);
        values = new byte[]{value1, value2, value3};
        Assert.assertEquals((long)3L, (long)field1.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2) + CodedOutputStream.computeRawVarint32Size((int)value3)), (long)field1.length());
        values = XbufVariableByteListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertEquals((long)values.length, (long)field1.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field1.getValuesAsArray());
        int len = 0;
        for (byte by : values) {
            len += this.field(field1, by).headerLength() + CodedOutputStream.computeRawVarint32Size((int)by);
        }
        Assert.assertEquals((long)len, (long)field1.length());
        values = XbufVariableByteListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        field1.clearValue();
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        values = XbufVariableByteListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        value1 = (byte)random.nextInt(127);
        field1.addValue(value1);
        values = new byte[]{value1};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)field1.sync(buffer1, 23));
        XbufVariableByteListField field2 = XbufVariableByteListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)field2.desync(buffer1, 23));
        Assert.assertEquals((long)1L, (long)field2.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)field2.length());
        value2 = (byte)random.nextInt(127);
        field1.addValue(value2);
        values = new byte[]{value1, value2};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2)), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableByteListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2)), (long)len);
        Assert.assertEquals((long)2L, (long)field2.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2)), (long)field2.length());
        value3 = (byte)random.nextInt(127);
        field1.getValues().add(value3);
        values = new byte[]{value1, value2, value3};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2) + CodedOutputStream.computeRawVarint32Size((int)value3)), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableByteListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2) + CodedOutputStream.computeRawVarint32Size((int)value3)), (long)len);
        Assert.assertEquals((long)3L, (long)field2.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint32Size((int)value1) + CodedOutputStream.computeRawVarint32Size((int)value2) + CodedOutputStream.computeRawVarint32Size((int)value3)), (long)field2.length());
        values = XbufVariableByteListFieldTest.randomArray(1 + random.nextInt(20));
        byte[] byteValues = new byte[values.length];
        boolean bl = false;
        while (var10_14 < values.length) {
            byteValues[var10_14] = values[var10_14];
            ++var10_14;
        }
        field1.setValues(byteValues);
        boolean bl2 = false;
        for (byte i : values) {
            var10_16 += this.field(field1, i).headerLength() + CodedOutputStream.computeRawVarint32Size((int)i);
        }
        Assert.assertEquals((long)((long)var10_16), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableByteListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = 0;
        for (int i = 0; i < values.length; ++i) {
            len += field2.desync(buffer1, 23 + len);
        }
        Assert.assertEquals((long)((long)var10_16), (long)len);
        Assert.assertEquals((long)values.length, (long)field2.getValues().size());
        XbufVariableByteListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)((long)var10_16), (long)field2.length());
        return field2;
    }

    @Test(expected=IllegalStateException.class)
    public final void testHasValue() {
        XbufVariableByteListField field1 = XbufVariableByteListField.create((short)1, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.hasValue();
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableByteListField field1 = XbufVariableByteListField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARBYTE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        field1 = XbufVariableByteListField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARBYTE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() throws Exception {
        XbufVariableByteListField field1 = XbufVariableByteListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() throws Exception {
        XbufVariableByteListField field1 = XbufVariableByteListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufVariableByteListField field1 = XbufVariableByteListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(this.randomValue());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(this.randomValue());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }

    private final byte randomValue() {
        return (byte)random.nextInt(127);
    }
}

