/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufStringField;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufStringFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final String randomString(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.valueOf(random.nextInt(10)));
        }
        return sb.toString();
    }

    static final String randomString() {
        return String.format("%04d", random.nextInt(9999));
    }

    @Test
    public final void testGetFollowedByRawGetShouldFail_InitialSetByValue() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufStringField field1 = XbufStringField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.setValue(XbufStringFieldTest.randomString());
        field1.getValue();
        field1.getRawValue();
    }

    @Test
    public final void testGetFollowedByRawGetShouldFail_InitialSetByRawValue() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufStringField field1 = XbufStringField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.setValueFrom(XString.create((String)XbufStringFieldTest.randomString()));
        try {
            field1.getValue();
        }
        catch (Throwable e) {
            Assert.fail((String)"failed in getting string value when it should not have");
        }
        field1.getRawValue();
    }

    private final XbufStringField testSetClearSyncDesync(XbufStringField field1) {
        String value = null;
        value = "";
        field1.setValue("");
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field1.length());
        value = XbufStringFieldTest.randomString();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field1.length());
        value = null;
        field1.setValue((String)null);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        value = XbufStringFieldTest.randomString();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)field1.headerLength(), (long)field1.sync(buffer1, 10));
        XbufStringField field2 = XbufStringField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)field1.headerLength(), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertNull(field2.getRawValue());
        Assert.assertNull((Object)field2.getValue());
        Assert.assertEquals((long)field2.headerLength(), (long)field2.length());
        value = "";
        field1.setValue("");
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field1.sync(buffer1, 23));
        field2 = XbufStringField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getRawValue().getValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + value.length()), (long)field2.length());
        value = XbufStringFieldTest.randomString();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field1.sync(buffer1, 23));
        field2 = XbufStringField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + value.length()), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getRawValue().getValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + value.length()), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufStringField field1 = XbufStringField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.STRING), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        field1 = XbufStringField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.STRING), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() {
        XbufStringField field1 = XbufStringField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() {
        XbufStringField field1 = XbufStringField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void setSyncThenModify() {
        XbufStringField field1 = XbufStringField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        field1.setValue("");
        container.sync();
        int origLength = container.getSerializedLength();
        field1.setValue("A longer string");
        int newLength = container.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }
}

