/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufLongArrayField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufLongArrayFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final long[] randomArray(int len) {
        long[] array = new long[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = random.nextLong();
        }
        return array;
    }

    public static final void assertEqual(long[] array1, long[] array2, boolean same, boolean array1EmptyIsArray2Null) {
        if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((long)array1[i], (long)array2[i]);
            }
        }
    }

    public static final void assertEqual(long[] array1, long[] array2, boolean same) {
        XbufLongArrayFieldTest.assertEqual(array1, array2, same, false);
    }

    private final XbufLongArrayField testSetClearSyncDesync(XbufLongArrayField field1) {
        long[] value = null;
        value = XbufLongArrayFieldTest.randomArray(0);
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        XbufLongArrayFieldTest.assertEqual(value, (long[])field1.getValue(), true);
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field1.length());
        value = XbufLongArrayFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        XbufLongArrayFieldTest.assertEqual(value, (long[])field1.getValue(), true);
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field1.length());
        value = null;
        field1.setValue(null);
        Assert.assertTrue((boolean)field1.hasValue());
        XbufLongArrayFieldTest.assertEqual(value, (long[])field1.getValue(), true);
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        value = XbufLongArrayFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull(field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)field1.headerLength(), (long)field1.sync(buffer1, 10));
        XbufLongArrayField field2 = XbufLongArrayField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)field1.headerLength(), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertNull(field2.getValue());
        Assert.assertEquals((long)field2.headerLength(), (long)field2.length());
        value = XbufLongArrayFieldTest.randomArray(0);
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field1.sync(buffer1, 23));
        field2 = XbufLongArrayField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        XbufLongArrayFieldTest.assertEqual(value, (long[])field2.getValue(), false);
        Assert.assertEquals((long)(field2.headerLength() + 8 * value.length), (long)field2.length());
        value = XbufLongArrayFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field1.sync(buffer1, 23));
        field2 = XbufLongArrayField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 8 * value.length), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        XbufLongArrayFieldTest.assertEqual(value, (long[])field2.getValue(), false);
        Assert.assertEquals((long)(field2.headerLength() + 8 * value.length), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufLongArrayField field1 = XbufLongArrayField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.LONG_ARRAY), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull(field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        field1 = XbufLongArrayField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.LONG_ARRAY), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull(field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() {
        XbufLongArrayField field1 = XbufLongArrayField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() {
        XbufLongArrayField field1 = XbufLongArrayField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufLongArrayField field1 = XbufLongArrayField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(XbufLongArrayFieldTest.randomValue());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(XbufLongArrayFieldTest.randomValue());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }

    private static final long randomValue() {
        return random.nextLong();
    }
}

