/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufCharField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufCharFieldTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());

    private final XbufCharField testSetClearSyncDesync(XbufCharField field1) {
        char value = (char)this.random.nextInt(65535);
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.length());
        value = '\u0000';
        field1.setValue('\u0000');
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.length());
        field1.setValue((char)this.random.nextInt(65535));
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        value = '\u0000';
        Assert.assertEquals((long)'\u0000', (long)field1.getValue());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.sync(buffer1, 10));
        XbufCharField field2 = XbufCharField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 2), (long)field2.length());
        value = (char)this.random.nextInt(65535);
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.sync(buffer1, 23));
        field2 = XbufCharField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 2), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)this.random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufCharField field1 = XbufCharField.create(id, name, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CHAR), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.length());
        field1 = XbufCharField.create(id, null, true);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CHAR), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertTrue((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 2), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap() {
        XbufCharField field1 = XbufCharField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native() {
        XbufCharField field1 = XbufCharField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

