/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufByteField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufByteFieldTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());

    private final XbufByteField testSetClearSyncDesync(XbufByteField field1, boolean frameOnly) {
        byte value = (byte)this.random.nextInt(127);
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.length());
        value = 0;
        field1.setValue((byte)0);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.length());
        field1.setValue((byte)this.random.nextInt(127));
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        value = 0;
        Assert.assertEquals((long)0, (long)field1.getValue());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.sync(buffer1, 10));
        XbufByteField field2 = XbufByteField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field2.desync(buffer1, 10, frameOnly));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 1), (long)field2.length());
        value = (byte)this.random.nextInt(127);
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.sync(buffer1, 23));
        field2 = XbufByteField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field2.desync(buffer1, 23, frameOnly));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 1), (long)field2.length());
        value = (byte)this.random.nextInt(127);
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.sync(buffer1, 12));
        field2 = XbufByteField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field2.desync(buffer1, 12, false));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 1), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)this.random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufByteField field1 = XbufByteField.create(id, name, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.BYTE), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.length());
        field1 = XbufByteField.create(id, null, true);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.BYTE), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertTrue((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 1), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap_CopyDesync() {
        XbufByteField field1 = XbufByteField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), false);
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap_FrameDesync() {
        XbufByteField field1 = XbufByteField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), true);
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native_CopyDesync() {
        XbufByteField field1 = XbufByteField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), false);
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native_FrameDesync() {
        XbufByteField field1 = XbufByteField.create((short)this.random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), true);
    }
}

