/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.xbuf.EXbufFieldAlreadyPresentException;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableEnumField;
import com.neeve.xbuf.XbufVariableEnumListField;
import com.neeve.xbuf.XbufVariableIntAdaptingField;
import com.neeve.xbuf.XbufVariableIntAdaptingListField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class XbufSchema {
    private final XbufField[] fields;
    private final Map<String, Integer> fieldMapByName;
    private final OpenIntObjectHashMap fieldMapById;
    private long[] fieldInterestBitmask;

    private XbufSchema(XbufField[] fields, Map<String, Integer> fieldMapByName, OpenIntObjectHashMap fieldMapById) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setPosInSchema(i);
        }
        this.fields = fields;
        this.fieldMapByName = fieldMapByName;
        this.fieldMapById = fieldMapById;
    }

    public static final XbufSchema create(XbufField[] fields, Map<String, Integer> fieldMapByName, OpenIntObjectHashMap fieldMapById) {
        return new XbufSchema(fields, fieldMapByName, fieldMapById);
    }

    public static final Builder builder() {
        return new Builder();
    }

    public final XbufSchema setFieldInterest(long[] fieldInterestBitmask) {
        this.fieldInterestBitmask = fieldInterestBitmask;
        return this;
    }

    public final long[] getFieldInterest() {
        return this.fieldInterestBitmask;
    }

    public final XbufField[] fields() {
        return this.fields;
    }

    public final <T> XbufVariableIntAdaptingField<T> variableIntAdaptingField(short id, Class<T> adapatedType) {
        Integer fieldId = (Integer)this.fieldMapById.get((int)id);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableIntAdaptingField)this.fields[fieldId];
    }

    public final <T> XbufVariableIntAdaptingField<T> variableIntAdaptingField(String name, Class<T> adapatedType) {
        Integer fieldId = this.fieldMapByName.get(name);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableIntAdaptingField)this.fields[fieldId];
    }

    public final <T> XbufVariableIntAdaptingListField<T> variableIntAdaptingListField(short id, Class<T> adapatedType) {
        Integer fieldId = (Integer)this.fieldMapById.get((int)id);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableIntAdaptingListField)this.fields[fieldId];
    }

    public final <T> XbufVariableIntAdaptingListField<T> variableIntAdaptingListField(String name, Class<T> adapatedType) {
        Integer fieldId = this.fieldMapByName.get(name);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableIntAdaptingListField)this.fields[fieldId];
    }

    public final <T> XbufVariableEnumField<T> variableLengthEnumField(short id, Class<T> adapatedType) {
        Integer fieldId = (Integer)this.fieldMapById.get((int)id);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableEnumField)this.fields[fieldId];
    }

    public final <T> XbufVariableEnumField<T> variableLengthEnumField(String name, Class<T> adapatedType) {
        Integer fieldId = this.fieldMapByName.get(name);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableEnumField)this.fields[fieldId];
    }

    public final <T> XbufVariableEnumListField<T> variableLengthEnumListField(short id, Class<T> adapatedType) {
        Integer fieldId = (Integer)this.fieldMapById.get((int)id);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableEnumListField)this.fields[fieldId];
    }

    public final <T> XbufVariableEnumListField<T> variableLengthEnumListField(String name, Class<T> adapatedType) {
        Integer fieldId = this.fieldMapByName.get(name);
        if (fieldId == null) {
            return null;
        }
        return (XbufVariableEnumListField)this.fields[fieldId];
    }

    public final XbufField field(short id) {
        Integer fieldId = (Integer)this.fieldMapById.get((int)id);
        if (fieldId == null) {
            return null;
        }
        return this.fields[fieldId];
    }

    public final XbufField field(String name) {
        Integer fieldId = this.fieldMapByName.get(name);
        if (fieldId == null) {
            return null;
        }
        return this.fields[fieldId];
    }

    public final int count() {
        return this.fields.length;
    }

    public final Object clone() {
        return null;
    }

    public static final class Builder {
        private final ArrayList<XbufField> fieldList = new ArrayList();
        private final Map<String, Integer> fieldMapByName = new HashMap<String, Integer>();
        private final OpenIntObjectHashMap fieldMapById = new OpenIntObjectHashMap(256, 0.0, 0.5);

        private Builder() {
        }

        public final Builder add(XbufField field) {
            if (field == null) {
                throw new IllegalArgumentException("field cannot be null");
            }
            if (field.isLinked()) {
                throw new EXbufFieldAlreadyPresentException();
            }
            int fieldNumber = this.fieldList.size();
            this.fieldList.add(field);
            if (field.name() != null) {
                this.fieldMapByName.put(field.name(), fieldNumber);
            }
            if (field.id() > 0) {
                this.fieldMapById.put((int)field.id(), (Object)fieldNumber);
            }
            return this;
        }

        public final XbufSchema build() {
            return new XbufSchema(this.fieldList.toArray(new XbufField[this.fieldList.size()]), this.fieldMapByName, this.fieldMapById);
        }
    }
}

