/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIntAdapter;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableIntAdaptingListField;
import com.neeve.xbuf.XbufVariableIntField;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;

class XbufRepeatedIntAdaptingFieldBuffer<T>
implements XIterator<T> {
    static final int[] EMPTY_ARRAY = new int[0];
    final PktBuffer val;
    final XbufField.VarintDesyncLength desyncLength;
    private final XIntAdapter<T> valueAdapter;
    private final boolean allowsNullValues;
    private final XbufField.NullValueCheckPolicy nullValueCheckPolicy;
    final short id;
    int current;
    int length;
    int count;

    XbufRepeatedIntAdaptingFieldBuffer(short id, boolean mayHaveNullValues, XbufField.NullValueCheckPolicy nullValueCheckPolicy, int initialLength, boolean isNative, XIntAdapter<T> valueAdapter) {
        this.id = id;
        this.valueAdapter = valueAdapter;
        this.desyncLength = new XbufField.VarintDesyncLength();
        this.allowsNullValues = mayHaveNullValues;
        this.nullValueCheckPolicy = nullValueCheckPolicy;
        this.val = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialLength, (boolean)isNative);
        this.val.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    public final short getFieldId() {
        return this.id;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    final XbufRepeatedIntAdaptingFieldBuffer<T> reset() {
        if (this.count > 0) {
            this.val.setLength(0);
            this.count = 0;
            this.current = 0;
            this.length = 0;
        }
        return this;
    }

    final int desyncAndAddValue(PktBuffer buffer, int offset, int length) {
        int toAdapt = XbufVariableIntField.deserializeValue(buffer, offset, this.desyncLength);
        if (this.valueAdapter.canAdaptFrom(toAdapt)) {
            this.add(this.valueAdapter.adaptFrom(toAdapt));
        }
        return this.desyncLength.value;
    }

    final int copyInto(IOElasticBuffer buffer, int offset) {
        if (this.length == 0) {
            return 0;
        }
        buffer.putFrom(offset, (IOElasticBuffer)this.val, 0, this.length);
        return this.length;
    }

    final int serializedLength() {
        return this.length;
    }

    final int count() {
        return this.count;
    }

    public final void add(T v) {
        if (!this.assertEncodable(v)) {
            return;
        }
        this.length += XbufVariableIntField.serializeField(this.val, this.length, this.id, this.valueAdapter.adaptTo(v));
        ++this.count;
    }

    public final void setValuesFrom(XbufRepeatedIntAdaptingFieldBuffer<T> values) {
        this.reset();
        if (this.isBufferCopyPossibleFrom(values)) {
            this.val.putFrom(0, (IOElasticBuffer)values.val, 0, values.length);
            this.length = values.length;
            this.count = values.count;
        } else {
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final void setValuesFrom(XIterator<T> values) {
        if (values instanceof XbufVariableIntAdaptingListField.Values) {
            this.setValuesFrom((XbufRepeatedIntAdaptingFieldBuffer)values);
        } else {
            this.reset();
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final boolean hasNext() {
        return this.current < this.length;
    }

    public final T next() {
        if (this.hasNext()) {
            int v = XbufVariableIntField.deserializeField(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return (T)this.valueAdapter.adaptFrom(v);
        }
        throw new NoSuchElementException("no more elements");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
    }

    public final XbufRepeatedIntAdaptingFieldBuffer<T> toFirst() {
        this.current = 0;
        return this;
    }

    private final boolean assertEncodable(T val) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (val != null) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    final boolean allowsNullValues() {
        return this.allowsNullValues;
    }

    private final boolean isBufferCopyPossibleFrom(XbufRepeatedIntAdaptingFieldBuffer<T> source) {
        if (source.getFieldId() != this.getFieldId()) {
            return false;
        }
        if (this.allowsNullValues()) {
            return true;
        }
        if (!source.allowsNullValues()) {
            switch (source.nullValueCheckPolicy) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final T[] toArray() {
        if (this.count == 0) {
            return this.valueAdapter.newArray(0);
        }
        Object[] ret = this.valueAdapter.newArray(this.count);
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.next();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Appendable toString(Appendable to) {
        int c = this.current;
        try {
            this.toFirst();
            while (this.hasNext()) {
                try {
                    to.append(String.valueOf(this.next()));
                    if (!this.hasNext()) continue;
                    to.append(",");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                    return to;
                }
            }
        }
        finally {
            this.current = c;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

