/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XCharIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableCharField;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;

public class XbufRepeatedCharFieldBuffer
implements XCharIterator {
    static final char[] EMPTY_ARRAY = new char[0];
    final PktBuffer val;
    final XbufField.VarintDesyncLength desyncLength = new XbufField.VarintDesyncLength();
    final short id;
    int current;
    int length;
    int count;

    XbufRepeatedCharFieldBuffer(short id, int initialLength, boolean isNative) {
        this.id = id;
        this.val = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialLength, (boolean)isNative);
        this.val.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    public final short getFieldId() {
        return this.id;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    final XbufRepeatedCharFieldBuffer reset() {
        if (this.count > 0) {
            this.val.setLength(0);
            this.count = 0;
            this.current = 0;
            this.length = 0;
        }
        return this;
    }

    final int desyncAndAddValue(PktBuffer buffer, int offset, int length) {
        this.add(XbufVariableCharField.deserializeValue(buffer, offset, this.desyncLength));
        return this.desyncLength.value;
    }

    final int copyInto(IOElasticBuffer buffer, int offset) {
        if (this.length == 0) {
            return 0;
        }
        buffer.putFrom(offset, (IOElasticBuffer)this.val, 0, this.length);
        return this.length;
    }

    final int serializedLength() {
        return this.length;
    }

    final int count() {
        return this.count;
    }

    public final void add(char v) {
        this.length += XbufVariableCharField.serializeField(this.val, this.length, this.id, v);
        ++this.count;
    }

    public final void setValuesFrom(XbufRepeatedCharFieldBuffer values) {
        this.reset();
        if (this.isBufferCopyPossibleFrom(values)) {
            this.val.putFrom(0, (IOElasticBuffer)values.val, 0, values.length);
            this.length = values.length;
            this.count = values.count;
        } else {
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final void setValuesFrom(XCharIterator values) {
        if (values instanceof XbufRepeatedCharFieldBuffer) {
            this.setValuesFrom((XbufRepeatedCharFieldBuffer)values);
        } else {
            this.reset();
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final boolean hasNext() {
        return this.current < this.length;
    }

    public final char next() {
        if (this.hasNext()) {
            char v = XbufVariableCharField.deserializeField(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return v;
        }
        throw new NoSuchElementException("no more elements");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
    }

    public final XbufRepeatedCharFieldBuffer toFirst() {
        this.current = 0;
        return this;
    }

    private final boolean isBufferCopyPossibleFrom(XbufRepeatedCharFieldBuffer source) {
        return source.getFieldId() == this.getFieldId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final char[] toArray() {
        if (this.count == 0) {
            return EMPTY_ARRAY;
        }
        char[] ret = new char[this.count];
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.next();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Appendable toString(Appendable to) {
        int c = this.current;
        try {
            this.toFirst();
            while (this.hasNext()) {
                try {
                    to.append(String.valueOf(this.next()));
                    if (!this.hasNext()) continue;
                    to.append(",");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                    return to;
                }
            }
        }
        finally {
            this.current = c;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

