/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufDoubleField
extends XbufField {
    private final Value value = new Value();

    private XbufDoubleField(short id, String name, boolean pinned) {
        super(XbufField.Type.DOUBLE, id, name, pinned);
    }

    public static final XbufDoubleField create(short id, String name, boolean pinned) {
        return new XbufDoubleField(id, name, pinned);
    }

    final int serializedLength(double val) {
        return 8;
    }

    final int serialize(PktBuffer buffer, int offset, double val) {
        buffer.putDouble(offset, val);
        return 8;
    }

    final double deserialize(PktBuffer buffer, int offset) {
        return buffer.getDouble(offset);
    }

    final String toString(double val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 8) {
            throw new InternalError("request to deserialize double with length != 8 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 8;
    }

    @Override
    protected final int contentLength() {
        return 8;
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, 0.0);
            return true;
        }
        this.value.val = 0.0;
        return this.container.clearValue(this);
    }

    public final void setValue(double val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufDoubleField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final double getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : 0.0;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, double v) {
        int headerLength = XbufDoubleField.syncHeader(buffer, offset, id, XbufField.Type.DOUBLE, 8);
        buffer.putDouble(offset + headerLength, v);
        return headerLength + 8;
    }

    public static int serializedFieldLength(short id, double v) {
        return 8 + XbufDoubleField.headerLength(id, XbufField.Type.DOUBLE, 8);
    }

    static final double deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        varintDesyncLength.value = 8;
        return buffer.getDouble(offset);
    }

    static final double deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufDoubleField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufDoubleField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        double value = XbufDoubleField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        double val;

        private Value() {
        }
    }
}

