/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmObject;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.AdmXMLWriter;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgBuildParameters;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public final class AdmCodeGenerator
extends AdmObject {
    private static final ProductInfo PRODUCT_INFO = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");
    private static final Set<String> INPUT_PARAMS_PARSE_INFO_INCLUDE = new TreeSet<String>(Arrays.asList(GenerateParameter.MODEL_URL.toString(), GenerateParameter.MODELS_DIR.toString(), GenerateParameter.OUT_DIR.toString(), GenerateParameter.XPCOMPAT.toString(), GenerateParameter.EMPTY_IF_NULL_ARRAY.toString(), GenerateParameter.NAMESPACE.toString(), GenerateParameter.ABSOLUTE.toString(), GenerateParameter.PROTO_DIR.toString(), GenerateParameter.INCREMENTAL_BUILD.toString(), GenerateParameter.ADDITIONAL_COPY_DIRS.toString(), "apexStyle", "generateEmbeddedEntityInterfaces", "generateEmbeddedEntitiesNonFinal", "generateDefaultGetters", "generateThrowOnUnsetGetters", "generateRequiredFieldValidators", "generateFluentSetters", "generateBuilderInterfaceSetters", "generateDeprecatedAccessors", "generateAllStringsPoolable", "pooledStringFieldTypeNameSuffixPolicy", "pooledStringFieldTypeNameSuffix", "nullArrayElementPolicy", "generateProtobufClasses", "encodingType", "modelBundleOutputDir", "requireExplicitCollectionKeys", "generateMessageFinalizers", "generateStateFinalizers", "useIOBufferAsMessageBackingStorage", "useIOBufferAsStateBackingStorage", "serializeToDataPacket", "rewriteOutputModelImports", "enableTypeNameValidation"));
    private static final Set<String> INPUT_PARAMS_PARSE_INFO_EXCLUDE = new TreeSet<String>(Arrays.asList(GenerateParameter.BUILD_INFO.toString(), GenerateParameter.CODEGEN_EVENT_LISTENERS.toString(), GenerateParameter.CODEGEN_EVENT_LISTENER_PROPERTIES.toString()));
    private final CgBuildParameters parameters = CgBuildParameters.newInstance().adoptParameters(CODEGEN_PARAMS, null);
    public static final CgBuildParameters CODEGEN_PARAMS = CgBuildParameters.newInstance().adoptParameters(AdmModel.DIRECTIVE_DEFINITIONS, null).newParameter(GenerateParameter.MODEL_URL.toString(), "The input file url.", new Class[]{URL.class, String.class}, true, null).getParent().newParameter(GenerateParameter.MODELS_DIR.toString(), "Base directory for the referenced files.", new Class[]{File.class, String.class}, false, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.OUT_DIR.toString(), "Base out directory for the generated files.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.XPCOMPAT.toString(), "Wire compatibility between protobuf and xbuf generated classes.", new Class[]{AdmEncodingType.class, String.class}, false, (Object)AdmEncodingType.Protobuf).setArgumentValueConverter(new CgBuildParameters.ArgumentValueConverter(){

        public Object convertValue(Object value) throws Exception {
            Object retVal = value;
            if (value != null) {
                retVal = AdmEncodingType.valueOf(value.toString());
            }
            return retVal;
        }
    }).getParent().newParameter(GenerateParameter.EMPTY_IF_NULL_ARRAY.toString(), "Instructs the code generator to return empty arrays instead of null for unset array fields.", new Class[]{Boolean.class, String.class}, true, null).setStringToBooleanConverter().getParent().newParameter(GenerateParameter.NAMESPACE.toString(), "Namespace of model parsed from the input file (overrides namespace in model file if supplied).", new Class[]{String.class}, false, null).getParent().newParameter(GenerateParameter.ABSOLUTE.toString(), "Generate all files in output directory (instead of a namespace based directory structure relative to output directory).", new Class[]{Boolean.class, String.class}, true, null).setStringToBooleanConverter().getParent().newParameter(GenerateParameter.PROTO_DIR.toString(), "Additonal directory in which to search for imported .proto files.", new Class[]{String.class}, false, null).getParent().newParameter(GenerateParameter.BUILD_INFO.toString(), "Build time information such as project version, timestamp and machine being built on.", new Class[]{String.class}, false, null).getParent().newParameter(GenerateParameter.INCREMENTAL_BUILD.toString(), "Trigger incremental code generation - run only if something changed since last run.", new Class[]{Boolean.class, String.class}, true, (Object)true).getParent().newParameter(GenerateParameter.ADDITIONAL_COPY_DIRS.toString(), "Additional locations where to copy model, idl files.", new Class[]{File[].class, String[].class}, false, (Object)new File[0]).setStringArrayToFileArrayConverter().getParent().newParameter(GenerateParameter.CODEGEN_EVENT_LISTENERS.toString(), "Listeners to code generation events.", new Class[]{CodegenListener[].class}, false, (Object)new CodegenListener[0]).putAdditionalData("hidden", (Object)"This parameter is for internal use").getParent().newParameter(GenerateParameter.CODEGEN_EVENT_LISTENER_PROPERTIES.toString(), "Properties to pass in code generation events for use by listeners.", new Class[]{Map.class}, false, new HashMap()).putAdditionalData("hidden", (Object)"This parameter is for internal use").getParent();

    public AdmCodeGenerator() {
        TreeSet<String> includeExcludeUnion = new TreeSet<String>(INPUT_PARAMS_PARSE_INFO_INCLUDE);
        includeExcludeUnion.addAll(INPUT_PARAMS_PARSE_INFO_EXCLUDE);
        if (!includeExcludeUnion.equals(this.parameters.getParameters().keySet())) {
            throw new IllegalStateException("Incremental build include and exclude list of codegen input params does not add up " + Arrays.toString(this.parameters.getParameters().keySet().toArray()) + "/" + Arrays.toString(INPUT_PARAMS_PARSE_INFO_INCLUDE.toArray()) + "/" + Arrays.toString(INPUT_PARAMS_PARSE_INFO_EXCLUDE.toArray()));
        }
    }

    private static final void printUsageAndExit() {
        System.err.println("Usage AdmCodeGenerator [{-f, --file} the input file specified either as OS path or URL]");
        System.err.println("                       [{-m, --modelsdir} base directory for the referenced files]");
        System.err.println("                       [{-o, --outdir} base out directory for the generated files]");
        System.err.println("                       [{-c, --classesdir} classes output folder to which generated resoures should be copied]");
        System.err.println("                       [{-a, --absolute} generate all files in output directory (instead of a namespace based directory structure relative to output directory)]");
        System.err.println("                       [{-e, --encoding} encoding type of content underlying the generated classes (Xbuf | Protobuf | Json)]");
        System.err.println("                       [{-x, --xpcompat} wire compatibility between protobuf and xbuf generated classes (None | Xbuf | Protobuf)]");
        System.err.println("                       [{-y, --emptyifnullarray} instructs the code generator return empty arrays instead of null for unset array fields)");
        System.err.println("                       [{-n, --namespace} namespace of model parsed from the input file (overrides namespace in model file if supplied)");
        System.err.println("                       [{-p, --protodir} additonal directory in which to search for imported .proto files.");
        System.err.println("                       [{-d, --directive} a key=value pair specifying a code generation directive.");
        System.err.println("                       [{-b, --buildinfo} String with build time information such as project version, timestamp and machine being built on.");
        System.err.println("                       [{-i, --incremental} trigger incremental code generation - run only if something changed since last run.");
        System.err.println("                       [{-u, --bundledir} Directory to which to output model XML and IDL files if applicable.");
        System.err.println("                       [{-h, --help} print this help string]");
        System.exit(1);
    }

    private final void fireCodeGenerateEvent(CodeGenerateEventType e, AdmModel model, CgSourceCodeErrorAggregator errorAggregator, Map<String, String> codeGenListenerProperties) {
        CodegenListener[] codegenListeners = (CodegenListener[])this.parameters.getValue(GenerateParameter.CODEGEN_EVENT_LISTENERS.toString());
        if (codegenListeners != null) {
            for (CodegenListener listener : codegenListeners) {
                listener.codeGenerateEvent(new CodeGenerateEvent(e, model, errorAggregator, codeGenListenerProperties));
            }
        }
    }

    private final Map<String, String> inputOptionsToParseInfo() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        HashSet allParamsSet = new HashSet();
        for (Map.Entry entry : this.parameters.getParameters().entrySet()) {
            allParamsSet.add(entry.getKey());
            if (!INPUT_PARAMS_PARSE_INFO_INCLUDE.contains(entry.getKey())) continue;
            String strValue = ((CgBuildParameters.AdmParameter)entry.getValue()).getValueAsString("null");
            retVal.put((String)entry.getKey(), strValue);
        }
        return retVal;
    }

    private final Map<String, String> getDirectives() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        TreeMap passedArguments = this.parameters.getArguments();
        for (String paramName : AdmModel.DIRECTIVE_DEFINITIONS.getParameters().keySet()) {
            if (!passedArguments.containsKey(paramName)) continue;
            String value = this.parameters.getValueAsString(paramName, null);
            retVal.put(paramName, value);
        }
        return retVal;
    }

    private final void outputBundleRecursiveModelImports(AdmModel model, File outDir, Set<String> savedModels) throws EAdmException {
        for (AdmModelImport modelImport : model.getModelImports()) {
            this.outputBundleRecursiveModelImports(modelImport.getModel(), outDir, savedModels);
            if (savedModels.contains(modelImport.getModel().getFullName())) continue;
            AdmXMLWriter.writeModelToDir(modelImport.getModel(), outDir);
            savedModels.add(modelImport.getModel().getFullName());
        }
    }

    private final void saveModelToBundleOutputDir(AdmModel model) throws EAdmException {
        File modelBundleDir = (File)this.parameters.getValue("modelBundleOutputDir");
        if (modelBundleDir != null) {
            modelBundleDir.mkdirs();
            AdmXMLWriter.writeModelToDir(model, modelBundleDir);
            this.outputBundleRecursiveModelImports(model, modelBundleDir, new HashSet<String>());
        }
    }

    public final void setArguments(Map<String, Object> arguments) {
        this.parameters.newArguments(arguments);
    }

    public final AdmCodeGenerator setArgument(String name, Object value) {
        this.parameters.newArgument(name, value);
        return this;
    }

    public final void generate() throws Exception {
        File[] additionalCopyDirs;
        this.parameters.validate();
        Map<String, String> parseInfo = this.inputOptionsToParseInfo();
        boolean incrementalBuild = (Boolean)this.parameters.getValue(GenerateParameter.INCREMENTAL_BUILD.toString());
        URL modelUrl = (URL)this.parameters.getValue(GenerateParameter.MODEL_URL.toString());
        File outDir = (File)this.parameters.getValue(GenerateParameter.OUT_DIR.toString());
        File modelsDir = (File)this.parameters.getValue(GenerateParameter.MODELS_DIR.toString());
        AdmEncodingType encodingType = (AdmEncodingType)((Object)this.parameters.getValue("encodingType"));
        AdmEncodingType xpcompat = (AdmEncodingType)((Object)this.parameters.getValue(GenerateParameter.XPCOMPAT.toString()));
        String namespace = (String)this.parameters.getValue(GenerateParameter.NAMESPACE.toString());
        String buildInfo = (String)this.parameters.getValue(GenerateParameter.BUILD_INFO.toString());
        String protoDir = (String)this.parameters.getValue(GenerateParameter.PROTO_DIR.toString());
        Map codegenListenerProperties = (Map)this.parameters.getValue(GenerateParameter.CODEGEN_EVENT_LISTENER_PROPERTIES.toString());
        boolean absolute = (Boolean)this.parameters.getValue(GenerateParameter.ABSOLUTE.toString());
        boolean emptyIfNullArray = (Boolean)this.parameters.getValue(GenerateParameter.EMPTY_IF_NULL_ARRAY.toString());
        Map<String, String> directives = this.getDirectives();
        CgResourceChangeTracker changeTracker = null;
        if (incrementalBuild) {
            CgResourceChangeTracker previousGenerationContext = CgResourceChangeTracker.fromPreviousCodeGeneration((File)outDir, (URL)modelUrl, parseInfo, (ProductInfo)PRODUCT_INFO);
            if (!previousGenerationContext.isChanged()) {
                this.fireCodeGenerateEvent(CodeGenerateEventType.SKIP, null, null, codegenListenerProperties);
                return;
            }
            changeTracker = CgResourceChangeTracker.forNewCodeGeneration((File)outDir, (URL)modelUrl, parseInfo, (ProductInfo)PRODUCT_INFO);
        }
        this.fireCodeGenerateEvent(CodeGenerateEventType.START, null, null, codegenListenerProperties);
        AdmModel model = AdmXMLParser.parse(modelUrl, modelsDir, namespace, directives, changeTracker);
        model.setBuildInfo(buildInfo);
        if (protoDir != null && encodingType == AdmEncodingType.Protobuf) {
            model.setExternalProtoDirs(Arrays.asList(new File(protoDir)));
        }
        model.setProtoXbufGenerationCompatibility(xpcompat);
        model.setGenerateArrayGetterReturnEmptyIfNull(emptyIfNullArray);
        CgSourceCodeErrorAggregator externalAggregator = new CgSourceCodeErrorAggregator(modelUrl);
        this.fireCodeGenerateEvent(CodeGenerateEventType.MODEL_PARSED, model, externalAggregator, codegenListenerProperties);
        if (externalAggregator.getNumErrors() > 0) {
            throw new EAdmException("External listener errors", externalAggregator);
        }
        if (Tracer.getLevel((Properties)XRuntime.getProps(), (String)"nv.adm.trace", (Tracer.Level)Tracer.Level.OFF) == Tracer.Level.VERBOSE) {
            model.dump();
        }
        model.generateClasses(outDir, absolute);
        AdmXMLWriter.writeModelToDir(model, outDir);
        for (File additionalDir : additionalCopyDirs = (File[])this.parameters.getValue(GenerateParameter.ADDITIONAL_COPY_DIRS.toString())) {
            additionalDir.mkdirs();
            AdmXMLWriter.writeModelToDir(model, additionalDir);
        }
        String idlFilename = model.getNamespace().replace(".", File.separator) + File.separator + model.getProtobufOuterClassName() + ".proto";
        File generatedIDL = new File(outDir, idlFilename);
        if (generatedIDL.exists()) {
            for (File additionalDir : additionalCopyDirs) {
                UtlFile.copyFile((File)generatedIDL, (File)new File(additionalDir, idlFilename));
            }
        }
        this.saveModelToBundleOutputDir(model);
        if (incrementalBuild) {
            changeTracker.save();
        }
        this.fireCodeGenerateEvent(CodeGenerateEventType.END, model, externalAggregator, codegenListenerProperties);
        if (externalAggregator.getNumErrors() > 0) {
            throw new EAdmException("External listener errors", externalAggregator);
        }
    }

    public static final void main(String[] args) {
        block27: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option modelfileOption = parser.addStringOption('f', "file");
                CmdLineParser.Option modelsdirOption = parser.addStringOption('m', "modelsdir");
                CmdLineParser.Option outdirOption = parser.addStringOption('o', "outdir");
                CmdLineParser.Option classdirOption = parser.addStringOption('c', "classesdir");
                CmdLineParser.Option namespaceOption = parser.addStringOption('n', "namespace");
                CmdLineParser.Option encodingOption = parser.addStringOption('e', "encoding");
                CmdLineParser.Option xpcompatOption = parser.addStringOption('x', "xpcompat");
                CmdLineParser.Option emptyifnullarrayOption = parser.addBooleanOption('y', "emptyifnullarray");
                CmdLineParser.Option absoluteOption = parser.addBooleanOption('a', "absolute");
                CmdLineParser.Option protodirOption = parser.addStringOption('p', "protodir");
                CmdLineParser.Option directivesOption = parser.addStringOption('d', "directives");
                CmdLineParser.Option buildInfoOption = parser.addStringOption('b', "buildinfo");
                CmdLineParser.Option jsonizableOption = parser.addBooleanOption('j', "jsonizable");
                CmdLineParser.Option incrementalBuildOption = parser.addBooleanOption('i', "incremental");
                CmdLineParser.Option bundleDirOption = parser.addStringOption('u', "bundledir");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String modelfilename = (String)parser.getOptionValue(modelfileOption, null);
                        String modelsdirname = (String)parser.getOptionValue(modelsdirOption, null);
                        String outdirname = (String)parser.getOptionValue(outdirOption, null);
                        String encodingstr = (String)parser.getOptionValue(encodingOption, (Object)AdmEncodingType.Protobuf.toString());
                        String xpcompatstr = (String)parser.getOptionValue(xpcompatOption, (Object)"Protobuf");
                        boolean emptyifnullarray = (Boolean)parser.getOptionValue(emptyifnullarrayOption, (Object)false);
                        String namespace = (String)parser.getOptionValue(namespaceOption, null);
                        boolean absolute = (Boolean)parser.getOptionValue(absoluteOption, (Object)false);
                        String protodir = (String)parser.getOptionValue(protodirOption, null);
                        String buildInfo = (String)parser.getOptionValue(buildInfoOption, null);
                        boolean incrementalBuild = (Boolean)parser.getOptionValue(incrementalBuildOption, (Object)false);
                        String bundleDir = (String)parser.getOptionValue(bundleDirOption, null);
                        HashMap<String, String> directives = new HashMap<String, String>();
                        Vector directiveValues = parser.getOptionValues(directivesOption);
                        for (String directivePair : directiveValues) {
                            String[] keyValue = directivePair.split("=");
                            if (keyValue.length != 2) {
                                throw new IllegalArgumentException("Invalid directive: '" + directivePair + "' expected <directName>=<directiveValue>");
                            }
                            directives.put(keyValue[0].trim(), keyValue[1].trim());
                        }
                        if (modelfilename != null && outdirname != null) {
                            AdmEncodingType encodingType = null;
                            try {
                                encodingType = AdmEncodingType.valueOf(encodingstr);
                            }
                            catch (Exception e) {
                                System.err.println("Invalid encoding type '" + encodingstr + "'");
                                AdmCodeGenerator.printUsageAndExit();
                            }
                            AdmEncodingType xpcompat = null;
                            if (xpcompatstr != null) {
                                if (xpcompatstr.equalsIgnoreCase("none")) {
                                    xpcompat = null;
                                } else {
                                    try {
                                        xpcompat = AdmEncodingType.valueOf(xpcompatstr);
                                    }
                                    catch (Exception e) {
                                        System.err.println("Invalid compatibility encoding type '" + xpcompatstr + "'");
                                        AdmCodeGenerator.printUsageAndExit();
                                    }
                                }
                            }
                            try {
                                URL modelUrl;
                                try {
                                    modelUrl = new URL(modelfilename);
                                }
                                catch (MalformedURLException ex) {
                                    try {
                                        modelUrl = new File(modelfilename).toURI().toURL();
                                    }
                                    catch (Exception ex2) {
                                        throw new EAdmException("Error opening model: " + ex2.getMessage(), ex2);
                                    }
                                }
                                catch (Exception ex) {
                                    throw new EAdmException("Error opening model: " + ex.getMessage(), ex);
                                }
                                AdmCodeGenerator codeGenerator = new AdmCodeGenerator();
                                codeGenerator.setArgument(GenerateParameter.MODEL_URL.toString(), modelUrl).setArgument(GenerateParameter.MODELS_DIR.toString(), modelsdirname == null ? null : new File(modelsdirname)).setArgument(GenerateParameter.OUT_DIR.toString(), new File(outdirname)).setArgument("encodingType", (Object)encodingType).setArgument(GenerateParameter.XPCOMPAT.toString(), (Object)xpcompat).setArgument(GenerateParameter.EMPTY_IF_NULL_ARRAY.toString(), emptyifnullarray).setArgument(GenerateParameter.NAMESPACE.toString(), namespace).setArgument(GenerateParameter.ABSOLUTE.toString(), absolute).setArgument(GenerateParameter.PROTO_DIR.toString(), protodir).setArgument(GenerateParameter.BUILD_INFO.toString(), buildInfo).setArgument(GenerateParameter.INCREMENTAL_BUILD.toString(), incrementalBuild).setArgument("modelBundleOutputDir", bundleDir);
                                Vector classesDirValues = parser.getOptionValues(classdirOption);
                                ArrayList<File> classesDirs = new ArrayList<File>();
                                for (String string : classesDirValues) {
                                    classesDirs.add(new File(string));
                                }
                                if (!classesDirs.isEmpty()) {
                                    codeGenerator.setArgument(GenerateParameter.ADDITIONAL_COPY_DIRS.toString(), classesDirs.toArray(new File[0]));
                                }
                                if (directives != null) {
                                    for (Map.Entry entry : directives.entrySet()) {
                                        codeGenerator.setArgument((String)entry.getKey(), entry.getValue());
                                    }
                                }
                                codeGenerator.generate();
                            }
                            catch (EAdmException ex) {
                                CgCodeSource srcInfo = ex.getCodeSource();
                                if (srcInfo != null) {
                                    System.err.println(srcInfo);
                                }
                                System.err.println("Parse error: [" + ex.toString() + "]");
                            }
                            break block27;
                        }
                        System.err.println("Input file and output directory both needs to be specified");
                        AdmCodeGenerator.printUsageAndExit();
                        break block27;
                    }
                    AdmCodeGenerator.printUsageAndExit();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    AdmCodeGenerator.printUsageAndExit();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Parse error: [" + e.toString() + "]");
            }
        }
    }

    public final class CodeGenerateEvent {
        private CodeGenerateEventType eventType;
        private AdmModel model;
        private CgSourceCodeErrorAggregator errorAggregator;
        private Map<String, String> codeGenListenerProperties;

        private CodeGenerateEvent(CodeGenerateEventType eventType, AdmModel model, CgSourceCodeErrorAggregator errorAggregator, Map<String, String> codeGenListenerProperties) {
            this.eventType = eventType;
            this.codeGenListenerProperties = codeGenListenerProperties;
            if (eventType == CodeGenerateEventType.MODEL_PARSED || eventType == CodeGenerateEventType.END) {
                if (model == null) {
                    throw new IllegalArgumentException("'model' cannot be null for event MODEL_PARSED");
                }
                this.model = model;
                if (errorAggregator == null) {
                    throw new IllegalArgumentException("'errorAggregator' cannot be null for event MODEL_PARSED");
                }
                this.errorAggregator = errorAggregator;
            }
        }

        public final CodeGenerateEventType getEventType() {
            return this.eventType;
        }

        public final AdmModel getModel() {
            return this.model;
        }

        public final CgSourceCodeErrorAggregator getErrorAggregator() {
            return this.errorAggregator;
        }

        public final Map<String, String> getCodegenListenerProperties() {
            return this.codeGenListenerProperties;
        }

        public String toString() {
            return "CodeGenerateEvent [" + (Object)((Object)this.getEventType()) + "] - " + (this.model != null ? this.model.getFullName() : " no model specified");
        }
    }

    public static interface CodegenListener {
        public void codeGenerateEvent(CodeGenerateEvent var1);
    }

    public static enum GenerateParameter {
        MODEL_URL,
        MODELS_DIR,
        OUT_DIR,
        XPCOMPAT,
        EMPTY_IF_NULL_ARRAY,
        NAMESPACE,
        ABSOLUTE,
        PROTO_DIR,
        BUILD_INFO,
        INCREMENTAL_BUILD,
        ADDITIONAL_COPY_DIRS,
        CODEGEN_EVENT_LISTENERS,
        CODEGEN_EVENT_LISTENER_PROPERTIES;

    }

    public static enum CodeGenerateEventType {
        START,
        MODEL_PARSED,
        END,
        SKIP;

    }
}

