/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.test.UnitTest;
import com.neeve.util.UtlAddressDescriptor;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public final class UtlAddressDescriptorTest
extends UnitTest {
    private void testInvalidDescriptorStr(String descriptorStr) {
        try {
            UtlAddressDescriptor.parse(descriptorStr, null);
            UtlAddressDescriptorTest.testFailure("Successully parsed an invalid descriptor string [" + descriptorStr + "]");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            UtlAddressDescriptor.isValid(descriptorStr);
            UtlAddressDescriptorTest.testFailure("Successully validated an invalid descriptor string [" + descriptorStr + "]");
        }
        catch (IllegalArgumentException e) {
            UtlAddressDescriptorTest.testSuccess("Successfully received exception for descriptor validation '" + descriptorStr + "'");
        }
    }

    private void testValidDescriptorStr(String descriptorStr, String addr, HashMap<String, Object> inprops, HashMap<String, Object> outprops) {
        UtlAddressDescriptor.isValid(descriptorStr);
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, inprops);
        if (descriptor.address.compareTo(addr) != 0) {
            UtlAddressDescriptorTest.testFailure("Address portion of descriptor string '" + descriptorStr + "' is incorrect [exp=" + addr + " actual=" + descriptor.address + "]");
        }
        if (!descriptor.props.equals(outprops)) {
            UtlAddressDescriptorTest.testFailure("Extracted properties " + descriptor.props + " from descriptor string '" + descriptorStr + "' do not match expected properties " + outprops);
        }
        UtlAddressDescriptorTest.testSuccess("Descriptor string '" + descriptorStr + "' with props=" + inprops + " successfully parsed into <addr='" + descriptor.address + "' props=" + outprops + ">");
    }

    @Test
    public void testInvalidDescriptorStrs() {
        try {
            this.testInvalidDescriptorStr("type");
            this.testInvalidDescriptorStr("type://");
            this.testInvalidDescriptorStr("addr&a");
            this.testInvalidDescriptorStr("addr&a=");
            this.testInvalidDescriptorStr("addr&a=b&c");
        }
        catch (Exception e) {
            UtlAddressDescriptorTest.testFailure("Unhandled exception [" + e + "]");
        }
    }

    @Test
    public void testValidDescriptorStrs() {
        try {
            HashMap<String, Object> inprops = new HashMap<String, Object>();
            HashMap<String, Object> outprops = new HashMap<String, Object>();
            outprops.clear();
            this.testValidDescriptorStr("type://addr", "addr", null, outprops);
            inprops.clear();
            outprops.clear();
            this.testValidDescriptorStr("type://addr", "addr", inprops, outprops);
            inprops.clear();
            inprops.put("a", "b");
            this.testValidDescriptorStr("type://addr", "addr", inprops, inprops);
            outprops.clear();
            this.testValidDescriptorStr("type://addr&", "addr", null, outprops);
            inprops.clear();
            outprops.clear();
            this.testValidDescriptorStr("type://addr&", "addr", inprops, outprops);
            inprops.clear();
            inprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&", "addr", inprops, inprops);
            outprops.clear();
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b", "addr", null, outprops);
            inprops.clear();
            outprops.clear();
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("a", "b");
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("a", "c");
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("c", "d");
            outprops.put("a", "b");
            outprops.put("c", "d");
            this.testValidDescriptorStr("type://addr&a=b", "addr", inprops, outprops);
            outprops.clear();
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b&", "addr", null, outprops);
            inprops.clear();
            outprops.clear();
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b&", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("a", "b");
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b&", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("a", "c");
            outprops.put("a", "b");
            this.testValidDescriptorStr("type://addr&a=b&", "addr", inprops, outprops);
            inprops.clear();
            outprops.clear();
            inprops.put("c", "d");
            outprops.put("a", "b");
            outprops.put("c", "d");
            this.testValidDescriptorStr("type://addr&a=b&", "addr", inprops, outprops);
            outprops.clear();
            outprops.put("a", "b");
            outprops.put("c", "d");
            this.testValidDescriptorStr("type://addr&a=b&c=d", "addr", null, outprops);
        }
        catch (Exception e) {
            UtlAddressDescriptorTest.testFailure("Unhandled exception [" + e + "]");
        }
    }

    @Test
    public void testDescriptorStrSanitization() {
        Assert.assertEquals((Object)"type://addr&a=b&c=d", (Object)UtlAddressDescriptor.parse("type://addr&a=b&c=d", null).toFullString());
        Assert.assertEquals((Object)"type://addr&a=b&c=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&c=d", null).toFullString("c"));
        Assert.assertEquals((Object)"type://addr&a=b&val_c=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&val_c=d", null).toFullString("_c"));
        Assert.assertEquals((Object)"type://addr&a=b&c_password=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&c_password=d", null).toPasswordSanitizedFullString());
        Assert.assertEquals((Object)"type://addr&a=b&c_password_val=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&c_password_val=d", null).toPasswordSanitizedFullString());
        Assert.assertEquals((Object)"type://addr&a=b&password=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&password=d", null).toPasswordSanitizedFullString());
        Assert.assertEquals((Object)"type://addr&a=b&password_val=<sanitized>", (Object)UtlAddressDescriptor.parse("type://addr&a=b&password_val=d", null).toPasswordSanitizedFullString());
    }
}

