/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.trace;

import com.neeve.trace.TraceUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class TraceFormatter
extends Formatter {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss:SSS");

    public static TraceFormatter create() {
        return new TraceFormatter();
    }

    private final String getLevel(Level level) {
        if (level == Level.FINEST) {
            return "dbg";
        }
        if (level == Level.FINER) {
            return "fin";
        }
        if (level == Level.FINE) {
            return "fin";
        }
        if (level == Level.CONFIG) {
            return "cfg";
        }
        if (level == Level.INFO) {
            return "inf";
        }
        if (level == Level.WARNING) {
            return "wrn";
        }
        if (level == Level.SEVERE) {
            return "sev";
        }
        return "unk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(record.getThreadID());
        sb.append(",");
        sb.append(TraceUtil.getPidForTrace());
        sb.append(",");
        sb.append(TraceUtil.getLocalHostNameForTrace());
        sb.append("> ");
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            sb.append(this.dateFormat.format(new Date(record.getMillis())));
        }
        sb.append(" (");
        sb.append(this.getLevel(record.getLevel()));
        sb.append(")...");
        sb.append(record.getMessage());
        sb.append("\n");
        return sb.toString();
    }
}

