/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigObject;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ConfigProviderDescriptor
extends ConfigObject {
    private final String name;
    private final String className;
    private final Properties props;

    private ConfigProviderDescriptor(String name, String className) {
        this.name = name;
        this.className = className;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
    }

    public final void setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final void save(IConfigRepository repo) throws EConfigException {
        IConfigSimpleEntity entity;
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/config/providers");
        if (container == null) {
            container = repo.createSimpleEntityContainer("/config/providers");
        }
        if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
            entity = (IConfigSimpleEntity)container.createEntity(this.name);
        }
        entity.setProperties(null);
        entity.setProperties(this.props);
        entity.setProperty("Class", this.getClassName());
    }

    public final void delete(IConfigRepository repo) throws EConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/config/providers");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", '" + this.className + "', " + this.props + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        return repo.getSimpleEntity("/config/providers/" + name) != null;
    }

    public static boolean exists(String name) {
        return ConfigProviderDescriptor.exists(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static ConfigProviderDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("provider class name cannot be null");
        }
        return new ConfigProviderDescriptor(name, className);
    }

    public static ConfigProviderDescriptor load(IConfigRepository repo, String name) throws EConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration repository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/config/providers/" + name);
        if (entity != null) {
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new EConfigException("Invalid provider configuration [Missing 'Class' property]");
            }
            ConfigProviderDescriptor providerDescriptor = ConfigProviderDescriptor.create(name, className);
            providerDescriptor.setProperties(entity.getProperties());
            providerDescriptor.getProperties().remove("Class");
            return providerDescriptor;
        }
        throw new EConfigException("Provider '" + name + "' not found in repository");
    }

    public static ConfigProviderDescriptor load(String name) throws EConfigException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return ConfigProviderDescriptor.load(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static Set<ConfigProviderDescriptor> loadAll(IConfigRepository repo) throws EConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<ConfigProviderDescriptor> providers = new LinkedHashSet<ConfigProviderDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/emp/providers");
        if (container != null) {
            Iterator iterator = container.iterator();
            while (iterator.hasNext()) {
                IConfigSimpleEntity entity = (IConfigSimpleEntity)iterator.next();
                try {
                    providers.add(ConfigProviderDescriptor.load(repo, entity.getName()));
                }
                catch (EConfigException e) {
                    throw new EConfigException("Failure in loading descriptor for provider '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return providers;
    }

    public static Set<ConfigProviderDescriptor> loadAll() throws EConfigException {
        return ConfigProviderDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getLocalRepository());
    }
}

