/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.env.Env;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public final class Config {
    private static final boolean WARN_ON_EARLY_ACCESS;
    private static final boolean DUMP_ON_EARLY_ACCESS;
    private static final boolean WARN_ON_REINIT;
    private static final boolean DUMP_ON_REINIT;
    private static String lastInitializer;
    private static final Properties initialPrebootstrapProps;
    private static final Properties prebootstrapProps;
    private static volatile Properties initializedProps;

    private static final Properties toProps(Map<String, Object> map) {
        Properties props = new Properties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            props.setProperty(key, (String)value);
        }
        return props;
    }

    private static final Properties getPropsFor(String name) {
        if (initializedProps != null) {
            return initializedProps;
        }
        if (DUMP_ON_EARLY_ACCESS) {
            new Exception("WARNING: Runtime environment accessed prior to initialization: [for: '" + name + "', thread=" + Thread.currentThread().getName() + "]").printStackTrace(System.err);
        } else if (WARN_ON_EARLY_ACCESS) {
            System.err.println("WARNING: Runtime environment accessed prior to initialization: [for: '" + name + "', thread=" + Thread.currentThread().getName() + "]");
        }
        return prebootstrapProps;
    }

    public static final void reset() {
        initializedProps = null;
        prebootstrapProps.clear();
        prebootstrapProps.putAll((Map<?, ?>)initialPrebootstrapProps);
    }

    public static final synchronized void initialize(Properties props) {
        if (initializedProps != null) {
            if (DUMP_ON_REINIT) {
                String thisInitializer = UtlThrowable.prepareStackTrace(new Exception("Initializing Thread: " + Thread.currentThread().getName()));
                System.err.println("WARNING: Runtime Environment initialized after already being initialized: [\nLast inititializer:\n" + lastInitializer + "'\nThis initializer:\n" + thisInitializer + "\n]");
                lastInitializer = thisInitializer;
            } else if (WARN_ON_REINIT) {
                System.err.println("WARNING: Runtime Environment initialized after already being initialized: [Last inititializer = '" + lastInitializer + "', ', This initializer='" + Thread.currentThread().getName() + "']");
                lastInitializer = Thread.currentThread().getName();
            }
        } else if (DUMP_ON_REINIT) {
            lastInitializer = UtlThrowable.prepareStackTrace(new Exception("Initializing Thread: " + Thread.currentThread().getName()));
        } else if (WARN_ON_REINIT) {
            lastInitializer = Thread.currentThread().getName();
        }
        initializedProps = props;
    }

    public static final Properties getPropsNoWarn() {
        if (initializedProps != null) {
            return initializedProps;
        }
        return prebootstrapProps;
    }

    public static final Properties getProps() {
        if (initializedProps != null) {
            return initializedProps;
        }
        if (DUMP_ON_EARLY_ACCESS) {
            return Config.getPropsFor("*");
        }
        if (WARN_ON_EARLY_ACCESS) {
            return Config.getPropsFor("*");
        }
        return prebootstrapProps;
    }

    public static final String getRootDirectory() {
        return UtlProps.getValue(Config.getProps(), "NVROOT", ".");
    }

    public static final String getBinDirectory() {
        return Config.getRootDirectory() + "/bin";
    }

    public static final String getConfigDirectory() {
        return Config.getRootDirectory() + "/conf";
    }

    public static final String getJavaLibDirectory() {
        return Config.getRootDirectory() + "/bin/java/lib";
    }

    public static final String getUnmanagedJavaLibDirectory() {
        return Config.getJavaLibDirectory() + "/unmanaged";
    }

    public static final String getDataDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = UtlProps.getValue(Config.getProps(), "nv.data.directory", null);
        if (dirname == null) {
            dirname = Config.getRootDirectory() + "/rdat";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(Config.getRootDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured data directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getDataDirectory() {
        return Config.getDataDirectory(true);
    }

    public static final String getLogsDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = UtlProps.getValue(Config.getProps(), "nv.log.directory", null);
        if (dirname == null) {
            dirname = Config.getDataDirectory() + "/logs";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(Config.getDataDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured data directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getLogsDirectory() {
        return Config.getLogsDirectory(true);
    }

    static {
        prebootstrapProps = Config.toProps(Env.getExternalEnvironment());
        WARN_ON_EARLY_ACCESS = UtlProps.getValue(prebootstrapProps, "nv.config.warnonearlyaccess", false);
        DUMP_ON_EARLY_ACCESS = UtlProps.getValue(prebootstrapProps, "nv.config.dumponearlyaccess", false);
        WARN_ON_REINIT = UtlProps.getValue(prebootstrapProps, "nv.config.warnonreinit", false);
        DUMP_ON_REINIT = UtlProps.getValue(prebootstrapProps, "nv.config.dumponreinit", false);
        initialPrebootstrapProps = new Properties();
        initialPrebootstrapProps.putAll((Map<?, ?>)prebootstrapProps);
    }
}

