/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.test.UnitTest;
import com.neeve.test.util.ProcessWrapper;
import com.neeve.tools.TransactionLogTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TLTTest
extends UnitTest {
    @Test
    public void testVariableSubstitution() throws IOException {
        TLTTest.setVerbose((boolean)true);
        ProcessWrapper pw = this.createTLTProcess(new String[0]);
        pw.writeLn("message=\"Hello World\"");
        try {
            String osName = XRuntime.getValue((String)"os.name", (String)"UNKNOWN");
            this.invokeCommand(pw, "echo ${os.name} ${message}", osName + " Hello World", ">");
            this.invokeCommand(pw, "echo ${os.name} ${message2::nomessage}", osName + " nomessage", ">");
            this.invokeCommand(pw, "set message2 \"${message}\"", ">");
            this.invokeCommand(pw, "echo ${os.name} ${message2::nomessage}", osName + " Hello World", ">");
            this.invokeCommand(pw, "set message2", ">");
            this.invokeCommand(pw, "echo ${os.name} ${message2::nomessage}", osName + " nomessage", ">");
            this.invokeCommand(pw, "set message2", ">");
            this.invokeCommand(pw, "echo ${os.name} ${message2}", osName + " ${message2}", ">");
        }
        finally {
            this.closeTool(pw);
        }
    }

    public void invokeCommand(ProcessWrapper pw, long timeout, String command, String ... expectedOutputStrings) throws IOException {
        pw.markOutputPosistions();
        pw.writeLn(command);
        if (expectedOutputStrings != null && expectedOutputStrings.length > 0) {
            for (String expectedOutput : expectedOutputStrings) {
                Assert.assertTrue((String)("Didn't get expected output of '" + expectedOutput + "' running command '" + command + "'\n Process Output:\n" + pw.getOutput() + "\n Process Errors:\n" + pw.getErrorOutput()), (boolean)pw.waitForOutputAndQuiesence(1000L, timeout, expectedOutput));
            }
        }
    }

    public void invokeCommand(ProcessWrapper pw, String command, String ... expectedOutputStrings) throws IOException {
        pw.markOutputPosistions();
        int errorPos = pw.getErrorOutputLength();
        pw.writeLn(command);
        if (expectedOutputStrings != null && expectedOutputStrings.length > 0) {
            for (String expectedOutput : expectedOutputStrings) {
                Assert.assertTrue((String)("Didn't get expected output of '" + expectedOutput + "' running command '" + command + "'\n Process Output:\n" + pw.getOutput() + "\n Process Errors:\n" + pw.getErrorOutput()), (boolean)pw.waitForOutputAndQuiesence(1000L, 5000L, expectedOutput));
            }
        }
        if (errorPos != pw.getErrorOutputLength()) {
            Assert.fail((String)("Running command '" + command + "'\n Resulted in errors: " + pw.getErrorOutput().substring(errorPos)));
        }
    }

    private void closeTool(ProcessWrapper pw) throws IOException {
        this.invokeCommand(pw, "exit", new String[0]);
        pw.close();
    }

    private ProcessWrapper createTLTProcess(String ... args) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + TLTTest.getTestbedRoot());
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(TransactionLogTool.class.getName());
        for (String arg : args) {
            cmd.add(arg);
        }
        File dataDir = new File(TLTTest.getTestbedRoot(), "rdat");
        dataDir.mkdirs();
        ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)dataDir);
        pw.setOutputEchoEnabled(TLTTest.verbose());
        pw.waitForOutputAndQuiesence(1000L, 5000L, ">");
        return pw;
    }
}

