/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.eaio.uuid.UUID;
import com.google.common.collect.Lists;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.proto.Child1;
import com.neeve.adm.test.unit.proto.Child2;
import com.neeve.adm.test.unit.proto.ChildLongMap;
import com.neeve.adm.test.unit.proto.IChild1;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.query.Query;
import com.neeve.query.QueryEngine;
import com.neeve.query.QueryException;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryRepository;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryPlanImpl;
import com.neeve.query.impl.predicates.FieldPredicate;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.impl.util.UtlQueryResultFormatter;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.query.predicates.Predicate;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.log.RogLogEntryField;
import com.neeve.rog.impl.log.RogLogQueryEngineImpl;
import com.neeve.rog.impl.log.RogLogQueryFieldResolver;
import com.neeve.rog.impl.log.RogLogQueryImpl;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQuery;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.rog.log.test.unit.messages.proto.Address;
import com.neeve.rog.log.test.unit.messages.proto.Customer;
import com.neeve.rog.log.test.unit.messages.proto.Employee;
import com.neeve.rog.log.test.unit.messages.proto.Factory;
import com.neeve.rog.log.test.unit.messages.proto.InMessage;
import com.neeve.rog.log.test.unit.messages.proto.OutMessage;
import com.neeve.rog.log.test.unit.messages.proto.Supplier;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlObjectGraph;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class RogLogQueryTest
extends UnitTest {
    private static final String smallString = "this";
    private static final String cn = RogLogQueryTest.class.getCanonicalName();
    private static final String largeString = cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn + ":" + cn;
    private int valCount;
    private long txnId;
    private long sno;
    private RogLog defaultLog;
    private RogLogReader reader;
    private RogLogRepository repository;
    private Random random = new Random(System.currentTimeMillis());
    RogLogQueryFieldResolver resolver = RogLogQueryFieldResolver.get();
    private int admTestObjectCount = 2000;
    private static ArrayList<IChild1> admTestObjects = new ArrayList();
    @Rule
    public TestName name = new TestName();

    @Before
    public void testInitialize() throws Exception {
        ++this.txnId;
        this.sno = 0L;
        this.resolver.addFactory(Factory.class);
    }

    @After
    public void testCleanup() throws Exception {
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
        if (this.defaultLog != null) {
            this.defaultLog.close();
            this.defaultLog = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RogLog createLog(String logName) throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.0");
        RogLogReader.registerFactory(new Factory());
        RogLogReader.registerFactory(new com.neeve.adm.test.unit.proto.Factory());
        RogLog log = RogLog.create(logName, props);
        log.open();
        try (RogLogReader reader = log.createReader();){
            reader.skip(1000, null);
            System.out.println("Read " + reader.getStats().getNumEntries() + " entries");
        }
        return log;
    }

    private final void initializeDefaultLog() throws Exception {
        this.defaultLog = this.createLog(this.name.getMethodName());
        this.reader = this.defaultLog.createReader();
    }

    private final void logSends(int count, boolean hasOutMsgsInTransaction, long txnId) {
        for (int i = 0; i < count; ++i) {
            InMessage message = InMessage.create();
            message.setTransactionId(txnId);
            message.setOutMsgsInTransaction(hasOutMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setMessageTransportHeaders(MessageTransportHeaders.create());
            message.getMessageTransportHeaders().addHeader((CharSequence)"msgid", i);
            message.getMessageTransportHeaders().addHeader((CharSequence)"channelName", (CharSequence)"foo");
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            message.sync();
            this.defaultLog.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Send, new UUID(), message.getOfid(), message.getType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message, message.serializeToPacket(), message.getContentEncodingType(), false, i == count - 1), false, i == count - 1);
        }
    }

    private final void logSends(int count, boolean hasOutMsgsInTransaction) {
        this.logSends(count, hasOutMsgsInTransaction, this.txnId);
    }

    private final void logMessages(int count, boolean hasInMsgsInTransaction, long txnId) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = OutMessage.create();
            message.setTransactionId(txnId);
            message.setInMsgsInTransaction(hasInMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setAsOutboundMessage(true);
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            message.sync();
            this.defaultLog.log(message, i == count - 1);
        }
        this.defaultLog.flush(true);
    }

    private final void logMessages(int count, boolean hasInMsgsInTransaction) {
        this.logMessages(count, hasInMsgsInTransaction, this.txnId);
    }

    private final void logPut(IRogNode node) {
        this.logPut(node, true);
    }

    private final void logPut(IRogNode node, boolean commit) {
        this.logPut(this.defaultLog, node, commit);
    }

    private final void logPut(RogLog log, IRogNode node, boolean commit) {
        log.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Put, node.getId(), node.getOfid(), node.getType(), node.getTransactionId(), node.getStableTransactionId(), node.getCheckpointVersion(), node, node.serialize(), node.getContentEncodingType(), false, commit), true, commit);
    }

    private final void logUpdate(IRogNode node) {
        this.logUpdate(node, true);
    }

    private final void logUpdate(IRogNode node, boolean commit) {
        this.defaultLog.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Put, node.getId(), node.getOfid(), node.getType(), node.getTransactionId(), node.getStableTransactionId(), node.getCheckpointVersion(), node, node.serialize(), node.getContentEncodingType(), false, commit), true, commit);
    }

    private final void logRemove(IRogNode node) {
        this.logRemove(node, true);
    }

    private final void logRemove(IRogNode node, boolean commit) {
        this.defaultLog.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Remove, node.getId(), node.getOfid(), node.getType(), node.getTransactionId(), node.getStableTransactionId(), node.getCheckpointVersion(), node, node.serialize(), node.getContentEncodingType(), false, commit), false, commit);
    }

    private final ArrayList<IChild1> getTestObjects() throws Exception {
        if (admTestObjects.isEmpty()) {
            System.out.println("Creating test objects");
            long popStart = System.currentTimeMillis();
            for (int i = 0; i < this.admTestObjectCount; ++i) {
                Child1 child = com.neeve.adm.test.unit.proto.Factory.createChild1();
                UtlObjectGraph.populateObject((Object)child, (Class[])new Class[]{IChild1.class, IRogNode.class});
                child.setIntField(i);
                if (i == 0) {
                    child.setStringField("This is a \n string that is kind of long, has a newline, and is not too suitable for tabular display in one row.");
                }
                admTestObjects.add(child);
            }
            System.out.println("Created test objects in " + (System.currentTimeMillis() - popStart) + "ms");
        }
        return admTestObjects;
    }

    private void flushIndexing() throws QueryException, InterruptedException {
        this.defaultLog.flush(true);
        this.repository.flushIndexing();
    }

    @Test
    public void testIndexing() throws Exception {
        RogLog.Entry entry;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryFieldResolver resolver = RogLogQueryFieldResolver.get();
        resolver.addFactory(Factory.class);
        IdxField field = resolver.getField((Class)RogLog.Entry.class, "object.messageSequenceNumber", Long.class, new Class[0]);
        this.repository.createIndex(field, true);
        HashMap<Long, RogLog.Entry> toValidate = new HashMap<Long, RogLog.Entry>();
        for (int i = 0; i < 100; ++i) {
            int numMsgs = this.random.nextInt(10);
            int numSends = this.random.nextInt(10);
            this.logMessages(numMsgs, numSends > 0);
            this.logSends(numSends, numMsgs > 0);
            ++this.txnId;
        }
        this.reader.rewind();
        while ((entry = this.reader.next()) != null) {
            if (entry.getMetadata().getMessageSequenceNumber() < 50L) continue;
            toValidate.put(entry.getMetadata().getMessageSequenceNumber(), entry);
        }
        IdxUniqueIndex index = this.repository.getUniqueIndex(field);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)this.sno, (long)index.getStats().getCardinality());
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class, InMessage.class, OutMessage.class);
        for (Long seqNo : toValidate.keySet()) {
            RogLog.Entry logged = (RogLog.Entry)toValidate.get(seqNo);
            long key = (Long)index.getId(seqNo);
            Assert.assertNotNull((String)("Log key not found for sno=" + seqNo), (Object)key);
            RogLog.Entry indexed = (RogLog.Entry)this.repository.retrieve(key);
            StringBuffer buf = new StringBuffer();
            if (UtlObjectGraph.deepApiEquals((Object)logged.getObject(), (Object)indexed.getObject(), (StringBuffer)buf, comparisonApis)) continue;
            Assert.fail((String)("Logged entry entry doesn't match index retrieved entry for seqNo " + seqNo + ": " + buf));
        }
    }

    @Test
    public void testIndexExistingLog() throws Exception {
        int testSize = 2000;
        this.initializeDefaultLog();
        for (int i = 1; i <= testSize; ++i) {
            Customer cust = Customer.create();
            cust.setCustomerId(i);
            cust.setFirstName("Bob");
            cust.setLastName("Jones" + i);
            cust.ensureId();
            boolean commit = i % 1000 == 0;
            this.logPut(cust, commit);
        }
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        long start = System.currentTimeMillis();
        long cutoff = start + 100L + (long)testSize;
        int logSize = 0;
        RogLogQuery query = queryEngine.createQuery().from("repo");
        while (logSize < testSize && System.currentTimeMillis() < cutoff) {
            Thread.sleep(10L);
            RogLogResultSet results = queryEngine.execute(query);
            logSize = results.getCount();
            results.close();
            System.out.println("waiting on log: " + logSize);
        }
        Assert.assertEquals((String)"Didn't retrieve all rows", (long)testSize, (long)logSize);
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated for " + index), (long)testSize, (long)index.getStats().getCardinality());
    }

    @Test
    public void testIndexAfterReopen() throws Exception {
        int testSize = 2000;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        this.repository.close();
        this.defaultLog.close();
        this.initializeDefaultLog();
        for (int i = 1; i <= testSize; ++i) {
            Customer cust = Customer.create();
            cust.setCustomerId(i);
            cust.setFirstName("Bob");
            cust.setLastName("Jones" + i);
            cust.ensureId();
            boolean commit = i % 1000 == 0;
            this.logPut(cust, commit);
        }
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        index = this.repository.getNonUniqueIndex(firstNameField);
        queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated: " + index), (long)testSize, (long)index.getStats().getCardinality());
    }

    @Test
    public void testQuery() throws Exception {
        RogLog.Entry entry;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField field = this.resolver.getField((Class)IRogMetadata.class, "messageSequenceNumber", Long.class, new Class[0]);
        this.repository.createIndex(field, true);
        HashMap<Long, RogLog.Entry> toValidate = new HashMap<Long, RogLog.Entry>();
        for (int i = 0; i < 100; ++i) {
            int numMsgs = this.random.nextInt(10);
            int numSends = this.random.nextInt(10);
            this.logMessages(numMsgs, numSends > 0);
            this.logSends(numSends, numMsgs > 0);
            ++this.txnId;
        }
        this.reader.rewind();
        while ((entry = this.reader.next()) != null) {
            if (entry.getMetadata().getMessageSequenceNumber() < 50L) continue;
            toValidate.put(entry.getMetadata().getMessageSequenceNumber(), entry);
        }
        IdxUniqueIndex index = this.repository.getUniqueIndex(field);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)this.sno, (long)index.getStats().getCardinality());
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery();
        query.from("repo").where(field.greaterThanOrEqual(50L));
        RogLogResultSet results = queryEngine.execute(query);
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class, InMessage.class, OutMessage.class);
        for (QueryResultSet.Row row : results.getQueryResult()) {
            RogLog.Entry queried = (RogLog.Entry)row.getRecord();
            long seqNo = queried.getMetadata().getMessageSequenceNumber();
            RogLog.Entry logged = (RogLog.Entry)toValidate.remove(seqNo);
            Assert.assertNotNull((String)("Query returned unexpected result: " + queried), (Object)logged);
            StringBuffer buf = new StringBuffer();
            if (UtlObjectGraph.deepApiEquals((Object)logged.getObject(), (Object)queried.getObject(), (StringBuffer)buf, comparisonApis)) continue;
            Assert.fail((String)("Logged entry entry doesn't match index retrieved entry for seqNo " + seqNo + ": " + buf));
        }
        results.close();
        Assert.assertTrue((String)("Query results are missing: " + toValidate.values()), (boolean)toValidate.isEmpty());
    }

    @Test
    public void testStringQuery() throws Exception {
        RogLog.Entry entry;
        this.initializeDefaultLog();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        queryEngine.addRepository(this.repository, "repo");
        IdxField field = queryEngine.getField((Class)IRogMetadata.class, "messageSequenceNumber", Long.class, new Class[0]);
        this.repository.createIndex(field, true);
        HashMap<Long, RogLog.Entry> toValidate = new HashMap<Long, RogLog.Entry>();
        for (int i = 0; i < 100; ++i) {
            int numMsgs = this.random.nextInt(10);
            int numSends = this.random.nextInt(10);
            this.logMessages(numMsgs, numSends > 0);
            this.logSends(numSends, numMsgs > 0);
            ++this.txnId;
        }
        this.reader.rewind();
        while ((entry = this.reader.next()) != null) {
            if (entry.getMetadata().getMessageSequenceNumber() < 50L) continue;
            toValidate.put(entry.getMetadata().getMessageSequenceNumber(), entry);
        }
        IdxUniqueIndex index = this.repository.getUniqueIndex(field);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)this.sno, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute(queryEngine.createQuery("SELECT transactionId FROM repo WHERE Metadata.messageSequenceNumber >= 50"));
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class, InMessage.class, OutMessage.class);
        for (QueryResultSet.Row row : results.getQueryResult()) {
            RogLog.Entry queried = (RogLog.Entry)row.getRecord();
            long seqNo = queried.getMetadata().getMessageSequenceNumber();
            RogLog.Entry logged = (RogLog.Entry)toValidate.remove(seqNo);
            Assert.assertNotNull((String)("Query returned unexpected result: " + queried), (Object)logged);
            StringBuffer buf = new StringBuffer();
            if (UtlObjectGraph.deepApiEquals((Object)logged.getObject(), (Object)queried.getObject(), (StringBuffer)buf, comparisonApis)) continue;
            Assert.fail((String)("Logged entry entry doesn't match index retrieved entry for seqNo " + seqNo + ": " + buf));
        }
        results.close();
        Assert.assertTrue((String)("Query results are missing: " + toValidate.values()), (boolean)toValidate.isEmpty());
    }

    @Test
    public void testUniqueIndexQueryNaturalLogOrder() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField field = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        this.repository.createIndex(field, true);
        Customer customer3 = Customer.create();
        customer3.setCustomerId(3L);
        customer3.setFirstName("Bob");
        customer3.ensureId();
        customer3.setTransactionId(1L);
        this.logPut(customer3);
        Customer customer2 = Customer.create();
        customer2.setCustomerId(2L);
        customer2.setFirstName("Bob");
        customer2.ensureId();
        customer2.setTransactionId(1L);
        this.logPut(customer2);
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        IdxUniqueIndex index = this.repository.getUniqueIndex(field);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)3L, (long)index.getStats().getCardinality());
        Query query = queryEngine.createQuery().select(field).from("repo").where(field.greaterThanOrEqual(1L));
        RogLogResultSet results = queryEngine.execute((RogLogQuery)query);
        Assert.assertTrue((String)"Missing result 3", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)3L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 2", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)2L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 1", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)1L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertFalse((String)("Unexpected result: " + results.getLogEntry().toString()), (boolean)results.next());
        results.beforeFirst();
        this.checkTabularResults(results, 10, 3);
    }

    @Test
    public void testNonUniqueIndexQueryNaturalLogOrder() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField field = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        IdxField filePosition = queryEngine.getField("Entry", "filePosition");
        this.repository.createIndex(field, false);
        Customer customer3 = Customer.create();
        customer3.setCustomerId(3L);
        customer3.setFirstName("Jane");
        customer3.setLastName("Baker");
        customer3.ensureId();
        customer3.setTransactionId(1L);
        this.logPut(customer3);
        Customer customer2 = Customer.create();
        customer2.setCustomerId(2L);
        customer2.setFirstName("Bill");
        customer2.setLastName("Smith");
        customer2.ensureId();
        customer2.setTransactionId(1L);
        this.logPut(customer2);
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Jeff");
        customer1.setLastName("Jones");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        customer3.setLastName("Smith");
        this.logUpdate(customer3);
        customer1.setLastName("Smith");
        this.logUpdate(customer1);
        customer2.setLastName("Jones");
        this.logUpdate(customer2);
        IdxNonUniqueIndex index = this.repository.getNonUniqueIndex(field);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)6L, (long)index.getStats().getCardinality());
        queryEngine.setFetchRatioThreshold(1.0);
        RogLogResultSet results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(field).select(filePosition).select(queryEngine.getField((Class)Customer.class, "firstName")).select(queryEngine.getField((Class)Customer.class, "lastName")).from("repo").where(field.greaterThanOrEqual(1L)));
        Assert.assertTrue((String)"Missing result 3", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)3L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 2", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)2L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 1", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)1L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 3 update ", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)3L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 1 update ", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)1L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertTrue((String)"Missing result 2 update ", (boolean)results.next());
        Assert.assertEquals((String)"Unexpected seqno", (long)2L, (long)((Customer)results.getRogNode()).getCustomerId());
        Assert.assertFalse((String)"Unexpected extra result", (boolean)results.next());
        results.beforeFirst();
        this.checkTabularResults(results, 10, 6);
    }

    @Test
    public void testQueryEmptyLog() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery();
        IdxField objectField = this.resolver.getField((Class)RogLog.Entry.class, "object", Object.class, new Class[0]);
        query.select(objectField).from("repo").where(firstNameField.is("Bob"));
        RogLogResultSet results = queryEngine.execute(query);
        Assert.assertFalse((String)"Unexpected results returned", (boolean)results.next());
        results.beforeFirst();
        this.checkTabularResults(results, 10, 0);
    }

    @Test(expected=QueryException.class)
    public void testQueryEngineWithNoRepo() throws Exception {
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery();
        IdxField objectField = this.resolver.getField((Class)RogLog.Entry.class, "object", Object.class, new Class[0]);
        query.select(objectField).from("repo").where(firstNameField.is("Bob"));
        RogLogResultSet results = queryEngine.execute(query);
        Assert.assertFalse((String)"Unexpected results returned", (boolean)results.next());
        results.beforeFirst();
        this.checkTabularResults(results, 10, 0);
    }

    @Test
    public void testQueryWithNoFrom() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery();
        IdxField objectField = this.resolver.getField((Class)RogLog.Entry.class, "object", Object.class, new Class[0]);
        query.select(objectField).where(firstNameField.is("Bob"));
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
    }

    @Test(expected=QueryException.class)
    public void testStringQueryWithNoFrom() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogResultSet results = queryEngine.execute("SELECT Entry.object WHERE Entry.object.firstName = 'Bob'");
        this.checkTabularResults(results, 10, 0);
    }

    @Test
    public void testQueryWithWrongRepository() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)("Index was not fully populated" + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer.customerId FROM bogusRepo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"invalid repo", (Object)"Invalid repository: bogusrepo", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseUnknownColumnType() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Bogus.id FROM repo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Bogus cannot be resolved", (Object)"The path [Object.Bogus.id] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testInvalidUnqualifiedField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT bogusId FROM repo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Bogus cannot be resolved", (Object)"The path [Object.bogusId] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testLogFieldIsQualified() {
        IdxField field = this.resolver.getField((Class)RogLog.Entry.class, "object.monthlySalary", Float.class, new Class[0]);
        Assert.assertFalse((String)"monthlySalary is not qualified", (boolean)field.isQualified());
        field = this.resolver.getField((Class)Employee.class, "monthlySalary", Float.class, new Class[0]);
        Assert.assertTrue((String)"Employee.monthlySalary is qualified", (boolean)field.isQualified());
        field = this.resolver.getField((Class)RogLog.Entry.class, "id", UUID.class, new Class[0]);
        Assert.assertFalse((String)"[Entry.]id is not qualified", (boolean)field.isQualified());
    }

    @Test
    public void testIrrelevantUnqualifiedField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogResultSet rs = queryEngine.execute(queryEngine.createQuery("SELECT monthlySalary FROM repo WHERE firstName = 'Bob'"));
        Assert.assertEquals((String)"Customers should not be returned, no Customer field: monthlySalary", (long)0L, (long)rs.getCount());
        rs.close();
        rs = queryEngine.execute(queryEngine.createQuery("SELECT firstName FROM repo WHERE firstName = 'Bob'"));
        Assert.assertEquals((String)"Customers have a firstName", (long)1L, (long)rs.getCount());
        rs.close();
    }

    @Test
    public void testParseNonExistentColumnField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer.bogusField FROM repo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"The path [Customer.bogusField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseNonExistentPredicateType() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        IdxField firstNameField = this.resolver.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer.customerId FROM repo WHERE BogusType.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"unresolvable entity", (Object)"The path [Object.BogusType.firstName] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseNonExistentMetadataColumnField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Metadata.bogusField FROM repo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"The path [IRogMetadata.bogusField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseNonExistentMetadataPredicateField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer.customerId FROM repo WHERE Metadata.bogusField = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"The path [IRogMetadata.bogusField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseNonExistentEntryColumnField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Entry.bogusField FROM repo WHERE Customer.firstName = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"The path [Entry.bogusField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseNonExistentEntryPredicateField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer.customerId FROM repo WHERE Entry.bogusField = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"The path [Entry.bogusField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseFailOfNonExistantPredicateField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer FROM repo WHERE Customer.nonExistentField = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertEquals((Object)"The path [Customer.nonExistentField] could not be resolved", (Object)qe.getMessage());
        }
    }

    @Test
    public void testParseFailOfWrongPredicateType() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        try {
            queryEngine.execute(queryEngine.createQuery("SELECT Customer FROM repo WHERE Customer.customerId = 'Bob'"));
            Assert.fail((String)"Query shouldn't have been executable");
        }
        catch (QueryException qe) {
            Assert.assertTrue((String)("Wrong error message " + qe.getMessage()), (boolean)qe.getMessage().startsWith("Cannot convert String [Bob] to Long"));
        }
    }

    @Test
    public void testQueryWithNoWhere() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(2L);
        this.logPut(employee);
        this.flushIndexing();
        Assert.assertEquals((String)("Index size is wrong for " + index), (long)2L, (long)index.getStats().getCardinality());
        RogLogQuery query = queryEngine.createQuery();
        IdxField objectField = queryEngine.getField((Class)RogLog.Entry.class, "object", Object.class, new Class[0]);
        query.select(objectField).from("repo");
        RogLogResultSet results = queryEngine.execute(query);
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        Assert.assertTrue((String)"Didn't get expected Employee result", (boolean)results.next());
        queried = results.getObject(1);
        buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)employee, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Employee.class))) {
            Assert.fail((String)("Returned Employee doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 2);
    }

    @Test
    public void testClassIndex() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)RogLog.Entry.class, "object.firstName", String.class, new Class[0]);
        IdxField classField = queryEngine.getField((Class)RogLog.Entry.class, "object.class", Class.class, new Class[0]);
        this.repository.createIndex(firstNameField, false);
        IdxNonUniqueIndex index = (IdxNonUniqueIndex)this.repository.createIndex(classField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer = Customer.create();
        customer.setCustomerId(1L);
        customer.setAddress(address);
        customer.setFirstName("Bob");
        customer.ensureId();
        customer.setTransactionId(1L);
        this.logPut(customer);
        Employee employee = Employee.create();
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(2L);
        this.logPut(employee);
        this.flushIndexing();
        Assert.assertEquals((String)("Index size is wrong for " + index), (long)2L, (long)index.getStats().getCardinality());
        Iterator iterator = index.get(Customer.class).iterator();
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)iterator.hasNext());
        Long recordId = (Long)iterator.next();
        RogLog.Entry entry = (RogLog.Entry)this.repository.retrieve(recordId);
        IStoreObject queried = entry.getObject();
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer, (Object)queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        Assert.assertFalse((String)"Got an unexpected Customer id result", (boolean)iterator.hasNext());
        iterator = index.get(Employee.class).iterator();
        Assert.assertTrue((String)"Didn't get expected Employee result", (boolean)iterator.hasNext());
        recordId = (Long)iterator.next();
        entry = (RogLog.Entry)this.repository.retrieve(recordId);
        queried = entry.getObject();
        buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)employee, (Object)queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Employee.class))) {
            Assert.fail((String)("Returned Employee doesn't match: " + buf.toString()));
        }
        Assert.assertFalse((String)"Got an unexpected Employee result", (boolean)iterator.hasNext());
        RogLogQuery query = queryEngine.createQuery();
        query.select(classField.count()).from((QueryRepository)this.repository).where(classField.equal(Customer.class));
        RogLogResultSet rs = queryEngine.execute(query);
        Assert.assertTrue((String)"one row exists", (boolean)rs.next());
        Assert.assertEquals((String)"found one customer", (long)1L, (long)rs.getInteger(1));
        Assert.assertFalse((String)"no more than one row exists", (boolean)rs.next());
        try {
            query = queryEngine.createQuery();
            query.select(classField.count()).from((QueryRepository)this.repository).where(classField.greaterThan(Customer.class));
            rs = queryEngine.execute(query);
            Assert.fail((String)"ranged query on Class was not caught");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"wrong error", (Object)"Cannot create a ranged query on Class", (Object)qe.getMessage());
        }
    }

    @Test
    public void testStringQueryWithNoWhereAndNoIndex() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(2L);
        this.logPut(employee);
        this.defaultLog.flush(true);
        RogLogResultSet results = queryEngine.execute("SELECT * FROM repo");
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        Assert.assertTrue((String)"Didn't get expected Employee result", (boolean)results.next());
        queried = results.getObject(1);
        buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)employee, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Employee.class))) {
            Assert.fail((String)("Returned Employee doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 2);
    }

    @Test
    public void testStringQueryNumericTypeConverion() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Entry.object FROM repo WHERE Customer.customerId >= '1'");
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testStringQueryNaryNumericTypeConverion() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName", String.class, new Class[0]);
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Entry.object FROM repo WHERE Customer.customerId IN ('1', '2')");
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testStringQueryTernaryNumericTypeConverion() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName", String.class, new Class[0]);
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        queryEngine.addRepository(this.repository, "repo");
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Entry.object FROM repo WHERE Customer.customerId BETWEEN '0' AND '2'");
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testStringQueryClassSelection() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setEmployeeId(1L);
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(1L);
        this.logPut(employee);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Customer FROM repo WHERE Customer.firstName = 'Bob'");
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        results.close();
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
    }

    @Test
    public void testCountStar() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setEmployeeId(1L);
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(1L);
        this.logPut(employee);
        this.checkTabularResults(queryEngine.execute("SELECT count(*) FROM LOGS"), 10, 1);
    }

    @Test
    public void testQueryClassSelection() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setEmployeeId(1L);
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(1L);
        this.logPut(employee);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        int retries = 6000;
        while (index.getStats().getCardinality() < 1 && retries-- > 0) {
            Thread.sleep(10L);
        }
        RogLogQuery query = queryEngine.createQuery();
        query.select(queryEngine.getField((Class)Customer.class, (String)null)).from((QueryRepository)this.repository).where(queryEngine.getField((Class)Customer.class, "firstName").is("Bob"));
        RogLogResultSet results = queryEngine.execute(query);
        Assert.assertTrue((String)"Didn't get expected Customer result", (boolean)results.next());
        Object queried = results.getObject(1);
        StringBuffer buf = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)customer1, queried, (StringBuffer)buf, Arrays.asList(IRogNode.class, Customer.class))) {
            Assert.fail((String)("Returned Customer doesn't match: " + buf.toString()));
        }
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testQueryFieldInMultipleClasses() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setEmployeeId(1L);
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(1L);
        this.logPut(employee);
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery();
        query.select(queryEngine.getField((Class)Object.class, "firstName", String.class, new Class[0]));
        query.from((QueryRepository)this.repository);
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 2);
    }

    @Test
    public void testStringQueryFieldInMultipleClasses() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        Employee employee = Employee.create();
        employee.setEmployeeId(1L);
        employee.setAddress(address);
        employee.setFirstName("Bob");
        employee.ensureId();
        employee.setTransactionId(1L);
        this.logPut(employee);
        this.checkTabularResults(queryEngine.execute("SELECT Object.firstName FROM logs"), 10, 2);
        this.checkTabularResults(queryEngine.execute("SELECT firstName FROM logs"), 10, 2);
        this.checkTabularResults(queryEngine.execute("SELECT Customer.firstName FROM logs"), 10, 1);
        this.checkTabularResults(queryEngine.execute("SELECT Supplier.firstName FROM logs"), 10, 0);
    }

    @Test
    public void testStringQueryClassSelectionNoResults() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField employeeFirstNameField = queryEngine.getField((Class)Employee.class, "firstName");
        IdxIndex employeeFirstNameIndex = this.repository.createIndex(employeeFirstNameField, false);
        IdxField customerFirstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex customerFirstNameIndex = this.repository.createIndex(customerFirstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + customerFirstNameIndex), (long)1L, (long)customerFirstNameIndex.getStats().getCardinality());
        Assert.assertEquals((String)"Employee index shouldn't have any entries", (long)0L, (long)employeeFirstNameIndex.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Employee FROM repo WHERE firstName = 'Bob'");
        this.checkTabularResults(results, 10, 0);
        results = queryEngine.execute("SELECT Customer.firstName FROM repo WHERE Customer.firstName = 'Bob'");
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testStringQueryClassSelectionNonMatchingPredicate() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        IdxField customerIdField = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        IdxIndex index = this.repository.createIndex(customerIdField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        queryEngine.addRepository(this.repository, "repo");
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Employee FROM repo WHERE Customer.customerId > 1");
        this.checkTabularResults(results, 10, 0);
    }

    @Test
    public void testStringQueryPartialNonMatchingClassPredicate() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)("Wrong stats cardinality for index " + index), (long)1L, (long)index.getStats().getCardinality());
        RogLogResultSet results = queryEngine.execute("SELECT Customer.firstName FROM repo WHERE Customer.customerId >= 1 AND Employee.firstName = 'Not Bob'");
        Assert.assertFalse((String)"Timed out waiting for entries to be indexed", ((long)index.getStats().getCardinality() < this.sno ? 1 : 0) != 0);
        this.checkTabularResults(results, 10, 0);
    }

    @Test
    public void testArraysNotSupported() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)IChild1.class, "longArrayField");
        try {
            this.repository.createIndex(firstNameField, false);
            Assert.fail((String)"Shouldn't be able to create an array index");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"Wrong error message", (Object)"Can't create index on IChild1.object.longArrayField because array indexes are not currently supported", (Object)qe.getMessage());
        }
    }

    private final Collection<String> getIndexableFields(Class<?> type) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String fieldName : UtlReflection.getDecamelcasedProperties(type)) {
            Class fieldType = UtlReflection.getUnwrappedReturnType(type, (String)fieldName);
            if (fieldType.isArray() || !fieldType.isPrimitive() && (!Serializable.class.isAssignableFrom(fieldType) || !Comparable.class.isAssignableFrom(fieldType)) || type.isAnnotationPresent(AdmGenerated.class) && fieldName.endsWith("FieldId")) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    @Test
    public void testAdmDataTypes() throws Exception {
        RogLogQueryTest.setVerbose((boolean)true);
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        HashMap<String, IdxField> childFields = new HashMap<String, IdxField>();
        for (String beanName : this.getIndexableFields(Child1.class)) {
            IdxField field = queryEngine.getField((Class)Child1.class, beanName);
            this.repository.createIndex(field, false);
            childFields.put(beanName, field);
        }
        long start = System.currentTimeMillis();
        ArrayList<IChild1> children = this.getTestObjects();
        int recordCount = children.size();
        for (int i = 0; i < children.size(); ++i) {
            IChild1 child = children.get(i);
            if (i % 5 == 0) {
                child.setIntField(5);
            }
            boolean commit = i % 100 == 0 || i == children.size() - 1;
            this.logPut(child, commit);
        }
        System.out.println("Logged " + recordCount + " records in " + (System.currentTimeMillis() - start) + "ms");
        IdxNonUniqueIndex intIndex = this.repository.getNonUniqueIndex(queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]));
        this.flushIndexing();
        Assert.assertEquals((String)"Wrong stats cardinality", (long)recordCount, (long)intIndex.getStats().getCardinality());
        System.out.println("Indexed " + recordCount + " records in " + (System.currentTimeMillis() - start) + "ms");
        String selectString = "SELECT";
        boolean first = false;
        RogLogQuery query = queryEngine.createQuery();
        for (RogLogQueryEngine.RogLogField field : childFields.values()) {
            query.select((IdxField)field);
            if (first) {
                selectString = selectString + " " + field.getName();
                first = false;
                continue;
            }
            selectString = selectString + ", " + field.getName();
        }
        System.out.println(selectString);
        query.from((QueryRepository)this.repository);
        query.where(queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]).equal(5));
        start = System.currentTimeMillis();
        RogLogResultSet results = queryEngine.execute(query);
        System.out.println("Executed query in " + (System.currentTimeMillis() - start) + "ms");
        this.checkTabularResults(results, 10, recordCount / 5);
        if (results.isFullScan()) {
            System.err.println("Index wasn't used to fulfill query, plan was:");
            results.describePlan(System.err);
            Assert.fail((String)"Index wasn't used to fulfill query");
        }
        IdxField entryTypeField = queryEngine.getField((Class)RogLog.Entry.class, "entryType");
        IdxField transactionIdField = queryEngine.getField((Class)RogLog.Entry.class, "transactionId");
        IdxField child1IntField = queryEngine.getField((Class)Child1.class, "intField");
        query = queryEngine.createQuery("SELECT x_repository_name, Entry.entryType, Entry.filePosition, Entry.object FROM logs WHERE Entry.entryType IS NOT NULL");
        RogLogResultSet rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT x_repository_name, Entry.entryType, Entry.filePosition, Entry.object FROM logs WHERE Entry.entryType IN ('Put')");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT * FROM logs WHERE transactionId < 100");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT * FROM logs WHERE Child1.intField < 1000");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        queryEngine.createIndex(entryTypeField, false);
        queryEngine.createIndex(transactionIdField, false);
        queryEngine.createIndex(child1IntField, false);
        this.flushIndexing();
        query = queryEngine.createQuery("SELECT x_repository_name, Entry.entryType, Entry.filePosition, Entry.object FROM logs WHERE Entry.entryType IS NOT NULL");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT x_repository_name, Entry.entryType, Entry.filePosition, Entry.object FROM logs WHERE Entry.entryType IN ('Put')");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT x_repository_name, Entry.entryType, Entry.filePosition, Entry.object FROM logs WHERE Entry.entryType IN ('Update')");
        rs = queryEngine.execute(query);
        Assert.assertFalse((String)"expected index read", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"wrong est. size for rs", (long)0L, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT * FROM logs WHERE transactionId < 100");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT * FROM logs WHERE Child1.intField < 1999");
        rs = queryEngine.execute(query);
        Assert.assertTrue((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"expected all 2000 rows", (long)recordCount, (long)rs.getEstimatedCount());
        rs.close();
        query = queryEngine.createQuery("SELECT * FROM logs WHERE Child1.intField > 1900");
        rs = queryEngine.execute(query);
        Assert.assertFalse((String)"expected full scan", (boolean)rs.isFullScan());
        Assert.assertEquals((String)"wrong est. size for rs", (long)80L, (long)rs.getEstimatedCount());
        rs.close();
        queryEngine.dropIndex(entryTypeField);
        queryEngine.dropIndex(transactionIdField);
        queryEngine.dropIndex(child1IntField);
    }

    @Test
    public void testAdmDataTypesQueryEngineFlushing() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        HashMap<String, IdxField> childFields = new HashMap<String, IdxField>();
        for (String beanName : this.getIndexableFields(Child1.class)) {
            IdxField field = queryEngine.getField((Class)Child1.class, beanName);
            this.repository.createIndex(field, false);
            childFields.put(beanName, field);
        }
        long start = System.currentTimeMillis();
        ArrayList<IChild1> children = this.getTestObjects();
        int recordCount = children.size();
        for (int i = 0; i < children.size(); ++i) {
            IChild1 child = children.get(i);
            if (i % 5 == 0) {
                child.setIntField(5);
            }
            boolean commit = i % 100 == 0 || i == recordCount - 1;
            this.logPut(child, commit);
        }
        this.defaultLog.flush(true);
        System.out.println("Indexed " + recordCount + " records in " + (System.currentTimeMillis() - start) + "ms");
        IdxField intField = queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]);
        String selectString = "SELECT";
        boolean first = false;
        RogLogQuery query = queryEngine.createQuery();
        for (RogLogQueryEngine.RogLogField field : childFields.values()) {
            query.select((IdxField)field);
            if (first) {
                selectString = selectString + " " + field.getName();
                first = false;
                continue;
            }
            selectString = selectString + ", " + field.getName();
        }
        System.out.println(selectString);
        query.from((QueryRepository)this.repository);
        query.where(intField.equal(5));
        this.flushIndexing();
        start = System.currentTimeMillis();
        RogLogResultSet results = queryEngine.execute(query);
        System.out.println("Executed query in " + (System.currentTimeMillis() - start) + "ms");
        this.checkTabularResults(results, 10, recordCount / 5);
        Assert.assertFalse((String)"Index wasn't used to fulfill query", (boolean)results.isFullScan());
    }

    @Test
    public void testAdmDataTypesStringQuery() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        HashMap<String, IdxField> childFields = new HashMap<String, IdxField>();
        for (String beanName : this.getIndexableFields(Child1.class)) {
            IdxField field = queryEngine.getField((Class)Child1.class, beanName);
            this.repository.createIndex(field, false);
            childFields.put(beanName, field);
        }
        ArrayList<IChild1> children = this.getTestObjects();
        int recordCount = children.size();
        for (int i = 0; i < children.size(); ++i) {
            IChild1 child = children.get(i);
            if (i % 5 == 0) {
                child.setIntField(5);
            }
            this.logPut(child, i % 100 == 0 || i == recordCount - 1);
        }
        IdxNonUniqueIndex intIndex = this.repository.getNonUniqueIndex(queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]));
        this.flushIndexing();
        Assert.assertEquals((String)"Wrong stats cardinality", (long)recordCount, (long)intIndex.getStats().getCardinality());
        String selectString = "SELECT";
        boolean first = true;
        for (RogLogQueryEngine.RogLogField field : childFields.values()) {
            if (first) {
                selectString = selectString + " " + field.getName();
                first = false;
                continue;
            }
            selectString = selectString + ", " + field.getName();
        }
        RogLogQuery query = queryEngine.createQuery(selectString + " FROM repo WHERE Child1.intField = " + 5);
        long start = System.currentTimeMillis();
        RogLogResultSet results = queryEngine.execute(query);
        System.out.println("Executed query in " + (System.currentTimeMillis() - start) + "ms");
        Assert.assertEquals((String)"Wrong result count", (long)(recordCount / 5), (long)results.getCount());
        this.checkTabularResults(results, 10, recordCount / 5);
        Assert.assertFalse((String)"Index wasn't used to fulfill query", (boolean)results.isFullScan());
    }

    @Test
    public void testAdmDataTypesIndexRecovery() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_CREATE);
        queryEngine.addRepository(this.repository, "repo");
        HashMap<String, IdxField> childFields = new HashMap<String, IdxField>();
        for (String beanName : this.getIndexableFields(Child1.class)) {
            IdxField field = queryEngine.getField((Class)Child1.class, beanName);
            this.repository.createIndex(field, false);
            childFields.put(beanName, field);
        }
        long start = System.currentTimeMillis();
        ArrayList<IChild1> children = this.getTestObjects();
        int recordCount = children.size();
        for (int i = 0; i < children.size(); ++i) {
            IChild1 child = children.get(i);
            if (i % 5 == 0) {
                child.setIntField(5);
            }
            this.logPut(child, i % 100 == 0 || i == recordCount - 1);
        }
        IdxNonUniqueIndex intIndex = this.repository.getNonUniqueIndex(queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]));
        this.flushIndexing();
        System.out.println("Indexing completed in " + (System.currentTimeMillis() - start) + "ms.");
        Assert.assertEquals((String)"Wrong stats cardinality", (long)recordCount, (long)intIndex.getStats().getCardinality());
        RogLogQuery query = queryEngine.createQuery("Select Child1.intField FROM repo WHERE Child1.intField = 5");
        start = System.currentTimeMillis();
        RogLogResultSet results = queryEngine.execute(query);
        System.out.println("Executed query in " + (System.currentTimeMillis() - start) + "ms");
        Assert.assertEquals((String)"Wrong result count", (long)(recordCount / 5), (long)results.getCount());
        this.checkTabularResults(results, 10, recordCount / 5);
        Assert.assertFalse((String)"Index wasn't used to fulfill query", (boolean)results.isFullScan());
        queryEngine.close();
        this.defaultLog.close();
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        Set recoveredIndexes = queryEngine.getIndexedFields();
        HashSet<RogLogQueryEngine.RogLogField> missingIndexes = new HashSet<RogLogQueryEngine.RogLogField>();
        for (RogLogQueryEngine.RogLogField childField : childFields.values()) {
            if (recoveredIndexes.contains(childField)) continue;
            missingIndexes.add(childField);
        }
        if (!missingIndexes.isEmpty()) {
            Assert.fail((String)("Not all indexes were recovered, missing: " + missingIndexes));
        }
        intIndex = this.repository.getNonUniqueIndex(queryEngine.getField((Class)Child1.class, "intField", Integer.class, new Class[0]));
        Assert.assertEquals((String)"Index size is wrong", (long)2000L, (long)intIndex.getStats().getCardinality());
        query = queryEngine.createQuery("Select Child1.intField FROM repo WHERE Child1.intField = 5");
        start = System.currentTimeMillis();
        results = queryEngine.execute(query);
        System.out.println("Executed query in " + (System.currentTimeMillis() - start) + "ms");
        Assert.assertEquals((String)"Wrong result count", (long)(recordCount / 5), (long)results.getCount());
        this.checkTabularResults(results, 10, recordCount / 5);
        Assert.assertFalse((String)"Index wasn't used to fulfill query", (boolean)results.isFullScan());
    }

    @Test
    public void testIndexAndLogMismatch() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName");
        IdxIndex index = this.repository.createIndex(firstNameField, false);
        Address address = Address.create();
        address.setCity("");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setAddress(address);
        customer1.setFirstName("Bob");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        this.flushIndexing();
        Assert.assertEquals((String)"Wrong stats cardinality", (long)1L, (long)index.getStats().getCardinality());
        this.repository.close();
        this.defaultLog.close();
        this.reader.close();
        this.reader = null;
        File logFile = new File(XRuntime.getDataDirectory((boolean)false), this.defaultLog.getName() + ".log");
        Assert.assertTrue((String)"Log File not found", (boolean)logFile.exists());
        logFile.delete();
        Assert.assertTrue((String)"Failed to delete log", (!logFile.exists() ? 1 : 0) != 0);
        File metadataFile = new File(XRuntime.getDataDirectory((boolean)false), this.defaultLog.getName() + ".metadata");
        Assert.assertTrue((String)"Metadata File not found", (boolean)metadataFile.exists());
        metadataFile.delete();
        Assert.assertTrue((String)"Failed to delete metadata", (!metadataFile.exists() ? 1 : 0) != 0);
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        index = this.repository.getNonUniqueIndex(firstNameField);
        Assert.assertNotNull((String)"Index was dropped after reopen", index);
        Assert.assertEquals((String)"Index wasn't cleared", (long)0L, (long)index.getStats().getCardinality());
    }

    @Test
    public void testAddNewIndexAfterIndexing() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        IdxField customerIdField = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        IdxIndex customerIdIndex = this.repository.createIndex(customerIdField, true);
        int numEntries = 1000;
        for (int i = 1; i <= numEntries; ++i) {
            Customer customer = Customer.create();
            customer.setCustomerId(numEntries - i + 1);
            customer.setFirstName("Bob");
            customer.setLastName("Smith");
            customer.ensureId();
            customer.setTransactionId(i);
            this.logPut(customer);
        }
        this.defaultLog.flush(true);
        RogLogResultSet results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(customerIdField.greaterThanOrEqual(1L)));
        this.checkTabularResults(results, 10, numEntries);
        IdxField txnIdField = queryEngine.getField((Class)Customer.class, "transactionId", Long.class, new Class[0]);
        IdxIndex transactionIdIndex = this.repository.createIndex(txnIdField, true);
        IdxField customerLastNameField = queryEngine.getField((Class)Customer.class, "lastName", String.class, new Class[0]);
        IdxIndex customerLastNameIndex = this.repository.createIndex(customerLastNameField, false);
        results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(txnIdField.is(Long.valueOf(numEntries))));
        this.checkTabularResults(results, 10, 1);
        results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(customerLastNameField.is("Smith")));
        this.checkTabularResults(results, 10, numEntries);
        Assert.assertEquals((String)"Wrong transactionIdIndex cardinality", (long)1000L, (long)transactionIdIndex.getStats().getCardinality());
        Assert.assertEquals((String)"Wrong customerLastNameIndex cardinality", (long)1000L, (long)customerLastNameIndex.getStats().getCardinality());
        Assert.assertEquals((String)"Wrong customerIdIndex index cardinality", (long)1000L, (long)customerIdIndex.getStats().getCardinality());
    }

    @Test
    public void testAddNewIndexWhileIndexing() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        IdxField customerIdField = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        IdxIndex customerIdIndex = this.repository.createIndex(customerIdField, true);
        int numEntries = 1000;
        for (int i = 1; i <= numEntries; ++i) {
            Customer customer = Customer.create();
            customer.setCustomerId(numEntries - i + 1);
            customer.setFirstName("Bob");
            customer.setLastName("Smith");
            customer.ensureId();
            customer.setTransactionId(i);
            this.logPut(customer);
        }
        IdxField txnIdField = queryEngine.getField((Class)Customer.class, "transactionId", Long.class, new Class[0]);
        IdxIndex transactionIdIndex = this.repository.createIndex(txnIdField, true);
        IdxField customerLastNameField = queryEngine.getField((Class)Customer.class, "lastName", String.class, new Class[0]);
        IdxIndex customerLastNameIndex = this.repository.createIndex(customerLastNameField, false);
        RogLogResultSet results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(customerIdField.greaterThanOrEqual(1L)));
        this.checkTabularResults(results, 10, numEntries);
        results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(txnIdField.is(Long.valueOf(numEntries))));
        this.checkTabularResults(results, 10, 1);
        results = queryEngine.execute((RogLogQuery)queryEngine.createQuery().select(customerIdField).from("repo").where(customerLastNameField.is("Smith")));
        this.checkTabularResults(results, 10, numEntries);
        this.defaultLog.flush(true);
        Assert.assertEquals((String)"Wrong transactionIdIndex cardinality", (long)1000L, (long)transactionIdIndex.getStats().getCardinality());
        Assert.assertEquals((String)"Wrong customerLastNameIndex cardinality", (long)1000L, (long)customerLastNameIndex.getStats().getCardinality());
        Assert.assertEquals((String)"Wrong customerIdIndex index cardinality", (long)1000L, (long)customerIdIndex.getStats().getCardinality());
    }

    @Test
    public void testIsNull() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField customerIdField = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        int numEntries = 10;
        for (int i = 1; i <= numEntries; ++i) {
            Customer customer = Customer.create();
            customer.setCustomerId(numEntries - i + 1);
            customer.setFirstName("Bob");
            customer.ensureId();
            customer.setTransactionId(i);
            this.logPut(customer);
        }
        this.defaultLog.flush(true);
        IdxField customerLastNameField = queryEngine.getField((Class)Customer.class, "lastName", String.class, new Class[0]);
        this.repository.createIndex(customerLastNameField, false);
        Query query = queryEngine.createQuery().select(customerIdField).from("repo").where(customerLastNameField.isNull());
        RogLogResultSet results = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(results, 10, numEntries);
    }

    @Test
    public void testUntypedField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        int numEntries = 10;
        for (int i = 1; i <= numEntries; ++i) {
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(i);
            customer.setFirstName(firstName);
            customer.setLastName("Smith");
            customer.ensureId();
            customer.setTransactionId(i);
            this.logPut(customer);
            Employee employee = Employee.create();
            employee.setEmployeeId(i);
            employee.setFirstName(firstName);
            employee.setLastName("Jones");
            employee.ensureId();
            employee.setTransactionId(i);
            this.logPut(employee);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("SELECT Object.firstName FROM repo WHERE Object.firstName BETWEEN 'Alex' AND 'Ellen'");
        RogLogResultSet results = queryEngine.execute(query);
        int numRows = 0;
        while (results.next()) {
            ++numRows;
            String firstName = results.getString(1);
            Assert.assertEquals((String)"name should have been Bob", (Object)"Bob", (Object)firstName);
        }
        results.close();
        Assert.assertEquals((String)"should have found 5 customers and 5 employees", (long)10L, (long)numRows);
    }

    @Test
    public void testUnqualifiedField() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        int numEntries = 10;
        for (int i = 1; i <= numEntries; ++i) {
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(i);
            customer.setFirstName(firstName);
            customer.setLastName("Smith");
            customer.ensureId();
            customer.setTransactionId(i);
            this.logPut(customer);
            Employee employee = Employee.create();
            employee.setEmployeeId(i);
            employee.setFirstName(firstName);
            employee.setLastName("Jones");
            employee.ensureId();
            employee.setTransactionId(i);
            this.logPut(employee);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("SELECT firstName, id, object, transactionId, graphId FROM repo WHERE firstName BETWEEN 'Alex' AND 'Ellen'");
        RogLogResultSet results = queryEngine.execute(query);
        int numRows = 0;
        while (results.next()) {
            ++numRows;
            String firstName = results.getString(1);
            Assert.assertEquals((String)"name should have been Bob", (Object)"Bob", (Object)firstName);
            Object id = results.getObject(2);
            Assert.assertNotNull((String)"id should not be null", id);
            Object payload = results.getObject(3);
            Assert.assertNotNull((String)"payload should not be null", payload);
            long payloadId = -1L;
            if (payload instanceof Customer) {
                Customer cust = (Customer)payload;
                payloadId = cust.getCustomerId();
            } else if (payload instanceof Employee) {
                Employee emp = (Employee)payload;
                payloadId = emp.getEmployeeId();
            } else {
                Assert.fail((String)("unexpected payload type: " + payload.getClass().getSimpleName()));
            }
            Assert.assertTrue((String)"payload id should be even", (payloadId % 2L == 0L ? 1 : 0) != 0);
            long trxId = results.getLong(4);
            Assert.assertEquals((String)"transactionId should be the payload id", (long)payloadId, (long)trxId);
            int graphId = results.getInteger(5);
            Assert.assertEquals((String)"graphId should be zero", (long)0L, (long)graphId);
        }
        results.close();
        Assert.assertEquals((String)"should have found 5 customers and 5 employees", (long)10L, (long)numRows);
    }

    @Test
    public void testTransportHeaderQueries() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        this.logSends(100, false);
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("select messageTransportHeaders.msgid as awsn FROM logs WHERE messageTransportHeaders.msgid = 2");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select transactionId, messageTransportHeaders.msgid AS msgid, messageTransportHeaders.channelName AS channelname FROM logs WHERE messageTransportHeaders.channelName = 'foo'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 100);
        query = queryEngine.createQuery("select messageTransportHeaders.msgid as \"Message Id\" FROM logs WHERE messageTransportHeaders.msgid IN(1, 2, 3)");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 3);
        query = queryEngine.createQuery("select messageTransportHeaders.msgid as \"Message Id\" FROM logs WHERE messageTransportHeaders.msgid BETWEEN 1 and 3");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 3);
        query = queryEngine.createQuery("select messageTransportHeaders.msgid as \"Message Id\" FROM logs WHERE messageTransportHeaders.msgid >= 95");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 5);
        query = queryEngine.createQuery("select messageTransportHeaders.msgid as \"Message Id\" FROM logs WHERE messageTransportHeaders.msgid < 5");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 5);
        IdxField field = this.resolver.getField((Class)IRogMetadata.class, "messageTransportHeaders.msgid", Long.class, new Class[0]);
        this.repository.createIndex(field, false);
        query = queryEngine.createQuery("select SUM(messageTransportHeaders.msgid) as \"Sum\" FROM logs WHERE messageTransportHeaders.msgid < 5");
        results = queryEngine.execute(query);
        results.first();
        Assert.assertEquals((String)"Wrong aggregate result", (long)10L, (long)results.getLong("Sum"));
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select AVG(messageTransportHeaders.msgid) as \"Average\" FROM logs WHERE messageTransportHeaders.msgid < 5");
        results = queryEngine.execute(query);
        results.first();
        Assert.assertEquals((String)"Wrong aggregate result", (double)2.0, (double)results.getDouble("Average"), (double)0.0);
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select MIN(messageTransportHeaders.msgid) as \"Minimum\" FROM logs");
        results = queryEngine.execute(query);
        results.first();
        Assert.assertEquals((String)"Wrong aggregate result", (long)0L, (long)results.getLong("Minimum"));
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select MAX(messageTransportHeaders.msgid) as \"Maximum\" FROM logs");
        results = queryEngine.execute(query);
        results.first();
        Assert.assertEquals((String)"Wrong aggregate result", (long)99L, (long)results.getLong("Maximum"));
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select Count(messageTransportHeaders.msgid) as \"Count\" FROM logs WHERE messageTransportHeaders.msgid < 5");
        results = queryEngine.execute(query);
        results.first();
        Assert.assertEquals((String)"Wrong aggregate result", (long)5L, (long)results.getLong("Count"));
        results.beforeFirst();
        this.checkTabularResults(results, 10, 1);
        query = queryEngine.createQuery("select messageTransportHeaders.msgid as \"Message Id\" FROM logs WHERE messageTransportHeaders.msgid > 98");
        results = queryEngine.execute(query);
        results.next();
        RogLog.Entry entry = results.getLogEntry();
        RogLogUtil.dumpLogEntryJson(entry, true, true, true, RogLogUtil.JsonPrettyPrintStyle.PrettyPrint, new PrintWriter(System.out));
    }

    @Test
    public void testNestedFieldSelect() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        int numTransactions = 10;
        for (int i = 1; i <= numTransactions; ++i) {
            Child1 child1 = Child1.create();
            UtlObjectGraph.populateObject((Object)child1);
            Child2 child2 = Child2.create();
            child2.setBooleanField(true);
            child1.setChildField(child2);
            this.logPut(child1);
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(1L);
            customer.setAddress(address);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("select object.childField.booleanField FROM logs WHERE object.childField.booleanField = 'true'");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 10);
    }

    @Test
    public void testNestedFieldSelectAS() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        int numTransactions = 10;
        for (int i = 1; i <= numTransactions; ++i) {
            Child1 child1 = Child1.create();
            UtlObjectGraph.populateObject((Object)child1);
            Child2 child2 = Child2.create();
            child2.setBooleanField(true);
            child1.setChildField(child2);
            this.logPut(child1);
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(1L);
            customer.setAddress(address);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("select object.childField.booleanField AS \"booleanAlias\" FROM logs WHERE object.childField.booleanField = 'true'");
        RogLogResultSet results = queryEngine.execute(query);
        results.next();
        Assert.assertTrue((String)"Expected field", (boolean)results.getBoolean("booleanAlias"));
        results.beforeFirst();
        this.checkTabularResults(results, 10, 10);
    }

    @Test
    public void testUnqualifiedNestedFieldSelect() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Address address = Address.create();
        address.setCity("");
        int numTransactions = 10;
        for (int i = 1; i <= numTransactions; ++i) {
            Child1 child1 = Child1.create();
            UtlObjectGraph.populateObject((Object)child1);
            Child2 child2 = Child2.create();
            child2.setBooleanField(true);
            child1.setChildField(child2);
            this.logPut(child1);
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(1L);
            customer.setAddress(address);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("select childField.booleanField FROM logs WHERE childField.booleanField = 'true'");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 10);
    }

    @Test
    public void testSelectMapObjectClassNameStringQuery() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        ChildLongMap childMap = ChildLongMap.create();
        this.logPut(childMap);
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("select object.class.simpleName FROM logs WHERE object.class.simpleName = 'ChildLongMap'");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 1);
    }

    @Test
    public void testStringDateParse() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        int numTransactions = 10;
        for (int i = 1; i <= numTransactions; ++i) {
            Child1 child1 = Child1.create();
            UtlObjectGraph.populateObject((Object)child1);
            Child2 child2 = Child2.create();
            child2.setBooleanField(true);
            child1.setChildField(child2);
            this.logPut(child1);
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(1L);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN TIMESTAMP'2014-01-29 19:54:00.000 -8:00' and TIMESTAMP'2014-01-29 19:55:00.000 -8:00'");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN TIMESTAMP'2014-01-29 19:54:00.000' and TIMESTAMP'2014-01-29 19:55:00.000'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN '2014-01-29 19:54:00.000 -8:00' and '2014-01-29 19:55:00.000 -8:00'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN '2014-01-29 19:54:00.000 -8:00' and '2014-01-29 19:55:00.000 -8:00'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN '2014-01-29 19:54:00 -8.00' and '2014-01-29 19:55:00 -8:00'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN '2014-01-29 19:54' and '2014-01-29 19:55'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN DATE'2014-01-29' and DATE'2014-01-30'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entry.timestamp BETWEEN '2014-01-29' and '2014-01-30'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 10, 0);
    }

    @Test
    public void testSelectStarWithAutoIndexing() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        queryEngine.setAutoIndexing(true);
        int numTransactions = 10;
        for (int i = 1; i <= numTransactions; ++i) {
            Child1 child1 = Child1.create();
            UtlObjectGraph.populateObject((Object)child1);
            Child2 child2 = Child2.create();
            child2.setBooleanField(true);
            child1.setChildField(child2);
            this.logPut(child1);
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(1L);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.defaultLog.flush(true);
        RogLogQuery query = queryEngine.createQuery("SELECT * FROM logs WHERE entryType = 'Put'");
        RogLogResultSet results = queryEngine.execute(query);
        this.checkTabularResults(results, 20, 20);
        Assert.assertTrue((String)"Should be a full read plan", (boolean)results.isFullScan());
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 20, 20);
        Assert.assertTrue((String)"Should be a full read plan", (boolean)results.isFullScan());
        query = queryEngine.createQuery("SELECT * FROM logs WHERE entryType = 'Remove'");
        results = queryEngine.execute(query);
        this.checkTabularResults(results, 0, 0);
        Assert.assertFalse((String)"Should be an indexed read plan", (boolean)results.isFullScan());
    }

    @Test
    public void testIndexDDL() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        queryEngine.executeStatement("create unique index customer_id on repo(Customer.id)");
        IdxField custIdField = queryEngine.getField("Customer", "id");
        IdxUniqueIndex custIdIndex = this.repository.getUniqueIndex(custIdField);
        Assert.assertNotNull((String)"customer_id was not created", custIdIndex);
        queryEngine.executeStatement("drop index customer_id");
        custIdIndex = this.repository.getUniqueIndex(custIdField);
        Assert.assertNull((String)"customer_id was not dropped", custIdIndex);
        queryEngine.executeStatement("create  index entity_id on repo(Object.id)");
        IdxField untypedIdField = queryEngine.getField("Object", "id");
        IdxIndex untypedIdIndex = this.repository.getNonUniqueIndex(untypedIdField);
        Assert.assertNotNull((String)"entity_id was not created", untypedIdIndex);
        queryEngine.executeStatement("drop index entity_id");
        untypedIdIndex = this.repository.getUniqueIndex(untypedIdField);
        Assert.assertNull((String)"entity_id was not dropped", untypedIdIndex);
        queryEngine.executeStatement("create  index unqualified_id on logs(id)");
        IdxField unqualifiedField = queryEngine.getField("Object", "id");
        IdxIndex unqualifiedIdIndex = this.repository.getNonUniqueIndex(unqualifiedField);
        Assert.assertNotNull((String)"unqualified_id was not created", unqualifiedIdIndex);
        queryEngine.executeStatement("drop index unqualified_id");
        unqualifiedIdIndex = this.repository.getUniqueIndex(unqualifiedField);
        Assert.assertNull((String)"unqualified_id was not dropped", unqualifiedIdIndex);
        queryEngine.executeStatement("create  index entry_type on repo(Entry.entryType)");
        IdxField entryTypeField = queryEngine.getField("", "entryType");
        IdxIndex entryTypeIndex = this.repository.getNonUniqueIndex(entryTypeField);
        Assert.assertNotNull((String)"entry_type was not created", entryTypeIndex);
        queryEngine.executeStatement("drop index entry_type");
        entryTypeIndex = this.repository.getUniqueIndex(entryTypeField);
        Assert.assertNull((String)"entry_type was not dropped", entryTypeIndex);
        queryEngine.executeStatement("create  index transaction_id on repo(Metadata.transactionId)");
        IdxField transactionIdField = queryEngine.getField("Metadata", "transactionId");
        IdxIndex transactionIdIndex = this.repository.getNonUniqueIndex(transactionIdField);
        Assert.assertNotNull((String)"transaction_id was not created", transactionIdIndex);
        queryEngine.executeStatement("drop index transaction_id");
        transactionIdIndex = this.repository.getUniqueIndex(transactionIdField);
        Assert.assertNull((String)"transaction_id was not dropped", transactionIdIndex);
    }

    @Test
    public final void testMetaDataFieldResolution() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField baseline = queryEngine.getField("metadata", "graphId");
        Assert.assertEquals((String)"Wrong name for transactionId field", (Object)"graphId", (Object)baseline.getName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("Entry", "metadata.graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("", "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((String)null, "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)IRogMetadata.class, "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)Object.class, "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField(IRogMetadata.class.getName(), "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField(Object.class.getName(), "graphId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("Entry", "metadata.graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("", "graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((String)null, "graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)IRogMetadata.class, "graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)Object.class, "graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField(IRogMetadata.class.getName(), "graphId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField(Object.class.getName(), "graphId").getCanonicalName());
        Assert.assertNotEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)Customer.class, "graphId"));
    }

    @Test
    public final void testEntryFieldResolution() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField baseline = queryEngine.getField("entry", "filePosition");
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("", "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((String)null, "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)RogLog.Entry.class, "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField(RogLog.Entry.class.getName(), "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)Object.class, "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField(Object.class.getName(), "filePosition"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("", "filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((String)null, "filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)RogLog.Entry.class, "filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField(RogLog.Entry.class.getName(), "filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)Object.class, "filePosition").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField(Object.class.getName(), "filePosition").getCanonicalName());
    }

    @Test
    public final void testQualifiedCanonicalFieldName() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField baseline = queryEngine.getField((Class)Customer.class, "customerId");
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("Customer", "customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("Customer.customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)RogLog.Entry.class, "object.customerId", Long.class, new Class[]{Customer.class}));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("Customer", "customerId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("Customer.customerId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)RogLog.Entry.class, "object.customerId", Long.class, new Class[]{Customer.class}).getCanonicalName());
    }

    @Test
    public final void testUnQualifiedCanonicalFieldName() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField baseline = queryEngine.getField((Class)RogLog.Entry.class, "object.customerId", Long.class, new Class[0]);
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("Object", "customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField((Class)Object.class, "customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline, (Object)queryEngine.getField("object.customerId"));
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("customerId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("object", "customerId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField((Class)Object.class, "customerId").getCanonicalName());
        Assert.assertEquals((String)"Fields should be equal", (Object)baseline.getCanonicalName(), (Object)queryEngine.getField("object.customerId").getCanonicalName());
    }

    @Test
    public void testCanonicalIndexCreation() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField baselineField = queryEngine.getField((Class)RogLog.Entry.class, "object.customerId", Long.class, new Class[0]);
        queryEngine.createIndex(baselineField, true);
        IdxIndex baselineIndex = this.repository.getIndex(baselineField);
        IdxField custId1 = queryEngine.getField("customerId");
        queryEngine.createIndex(custId1, true);
        Assert.assertEquals((String)"indexes should be equal", baselineIndex, this.repository.getIndex(custId1));
        IdxField custId2 = queryEngine.getField("object", "customerId");
        queryEngine.createIndex(custId2, true);
        Assert.assertEquals((String)"indexes should be equal", baselineIndex, this.repository.getIndex(custId2));
        IdxField custId3 = queryEngine.getField((Class)Object.class, "customerId");
        queryEngine.createIndex(custId3, true);
        Assert.assertEquals((String)"indexes should be equal", baselineIndex, this.repository.getIndex(custId3));
        IdxField custId5 = queryEngine.getField("object", "customerId");
        try {
            queryEngine.createIndex(custId5, false);
            Assert.fail((String)"Should not have been able to create NON-UNIQUE index on the same field.");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"incorrect exception", (Object)"A UNIQUE index already exists on this field.", (Object)qe.getMessage());
        }
    }

    @Test
    public final void testAmbiguousFieldResolution() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField customerField = queryEngine.getField("Customer", "ambiguousField");
        Assert.assertNotNull((String)"customerField", (Object)customerField);
        customerField = queryEngine.getField((Class)Customer.class, "ambiguousField");
        Assert.assertNotNull((String)"customerField", (Object)customerField);
        customerField = queryEngine.getField(Customer.class.getCanonicalName().replace(".", "/") + ".ambiguousField");
        Assert.assertNotNull((String)"customerField", (Object)customerField);
        IdxField employeeField = queryEngine.getField("Employee", "ambiguousField");
        Assert.assertNotNull((String)"employeeField", (Object)employeeField);
        try {
            queryEngine.getField("", "ambiguousField");
            Assert.fail((String)"Shouln't have been able to resolve ambiguous field");
        }
        catch (QueryException expected) {
            Assert.assertTrue((String)("Wrong error message: " + expected.getMessage()), (expected.getMessage().indexOf("ambiguous") > 0 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField("object", "ambiguousField");
            Assert.fail((String)"Shouln't have been able to resolve ambiguous field");
        }
        catch (QueryException expected) {
            Assert.assertTrue((String)("Wrong error message: " + expected.getMessage()), (expected.getMessage().indexOf("ambiguous") > 0 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField("entry", "object.ambiguousField");
            Assert.fail((String)"Shouln't have been able to resolve ambiguous field");
        }
        catch (QueryException expected) {
            Assert.assertTrue((String)("Wrong error message: " + expected.getMessage()), (expected.getMessage().indexOf("ambiguous") > 0 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField((Class)Object.class, "ambiguousField");
            Assert.fail((String)"Shouln't have been able to resolve ambiguous field");
        }
        catch (QueryException expected) {
            Assert.assertTrue((String)("Wrong error message: " + expected.getMessage()), (expected.getMessage().indexOf("ambiguous") > 0 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField((Class)RogLog.Entry.class, "object.ambiguousField");
            Assert.fail((String)"Shouln't have been able to resolve ambiguous field");
        }
        catch (QueryException expected) {
            Assert.assertTrue((String)("Wrong error message: " + expected.getMessage()), (expected.getMessage().indexOf("ambiguous") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGroupByAggregation() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName", String.class, new Class[0]);
        RogLogQuery query = queryEngine.createQuery();
        query.select(firstNameField).from("repo").groupBy(firstNameField);
        RogLogResultSet rs = queryEngine.execute(query);
        ArrayList firstNames = Lists.newArrayList();
        while (rs.next()) {
            String firstName = rs.getString(1);
            firstNames.add(firstName);
        }
        Collections.sort(firstNames);
        Assert.assertEquals((String)"two first names", (Object)Lists.newArrayList((Object[])new String[]{"Bob", "Mary"}), (Object)firstNames);
        Assert.assertEquals((String)"counted two rows", (long)2L, (long)rs.getCount());
        Assert.assertEquals((String)"estimated two rows", (long)2L, (long)rs.getEstimatedCount());
        rs.close();
    }

    @Test
    public void testGroupByInvalidColumn() throws Exception {
        RogLogQuery query;
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField customerIdField = queryEngine.getField((Class)Customer.class, "customerId", Long.class, new Class[0]);
        IdxField firstNameField = queryEngine.getField((Class)Customer.class, "firstName", String.class, new Class[0]);
        try {
            query = queryEngine.createQuery();
            query.select(customerIdField).from("repo").groupBy(firstNameField);
            queryEngine.execute(query);
            Assert.fail((String)"Should have thrown group-by error");
        }
        catch (QueryException e) {
            Assert.assertTrue((String)"Expected GROUP-BY error", (boolean)e.getMessage().contains("GROUP BY"));
        }
        try {
            query = queryEngine.createQuery("select Customer.firstName, Customer.id, count(Customer.address.city) from repo group by Customer.firstName");
            queryEngine.execute(query);
            Assert.fail((String)"expected group-by exception");
        }
        catch (QueryException e) {
            Assert.assertTrue((String)"Expected GROUP-BY error", (boolean)e.getMessage().contains("GROUP BY"));
        }
    }

    @Test
    public void testGroupByCountVariations() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.firstName, count(*), count(Customer.id), count(Customer.address.city) from repo group by Customer.firstName");
        RogLogResultSet rs = queryEngine.execute(query);
        while (rs.next()) {
            String firstName = rs.getString(1);
            int countAll = rs.getInteger(2);
            int countId = rs.getInteger(3);
            int countCity = rs.getInteger(4);
            Assert.assertEquals((String)"25 rows", (long)25L, (long)countAll);
            Assert.assertEquals((String)"25 ids", (long)25L, (long)countId);
            if (firstName.equals("Bob")) {
                Assert.assertEquals((String)"8 even row cities", (long)8L, (long)countCity);
                continue;
            }
            Assert.assertEquals((String)"9 odd row cities", (long)9L, (long)countCity);
        }
        rs.close();
        query = queryEngine.createQuery("select Customer.firstName, count(*), count(Customer.id), count(Customer.address.city) from repo group by Customer.firstName");
        rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 2, 2);
        query = queryEngine.createQuery("select Customer.firstName, count(Customer), count(Customer.address) from repo group by Customer.firstName");
        rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 2, 2);
    }

    @Test
    public void testGroupByMinMax() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.firstName, min(Customer.address.city) , max(Customer.address.city) from repo group by Customer.firstName");
        RogLogResultSet rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 2, 2);
        try {
            query = queryEngine.createQuery("select Customer.firstName, min(Customer.address) from repo group by Customer.firstName");
            rs = queryEngine.execute(query);
            Assert.fail((String)"expected comparable exception");
        }
        catch (QueryException e) {
            Assert.assertTrue((String)"Expected GROUP-BY error", (boolean)e.getMessage().contains("Comparable"));
        }
    }

    @Test
    public void testGroupBySumAvg() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.firstName, sum(Customer.customerId) , avg(Customer.customerId) from repo group by Customer.firstName");
        RogLogResultSet rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 2, 2);
        try {
            query = queryEngine.createQuery("select Customer.firstName, avg(Customer.id) from repo group by Customer.firstName");
            rs = queryEngine.execute(query);
            Assert.fail((String)"expected numeric exception");
        }
        catch (QueryException e) {
            Assert.assertTrue((String)"Expected GROUP-BY error", (boolean)e.getMessage().contains("numeric"));
        }
    }

    @Test
    public void testAggregationWithoutGroupBy() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select count(*) from repo");
        RogLogResultSet rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 1, 1);
        query = queryEngine.createQuery("select min(Customer.firstName), max(Customer.lastName), avg(Customer.customerId) from repo");
        rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 1, 1);
    }

    @Test
    public void testOrderBy() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.customerId, Customer.firstName, Customer.lastName from repo order by Customer.firstName, Customer.customerId desc");
        RogLogResultSet rs = queryEngine.execute(query);
        long expectedId = 50L;
        String expectedName = "Bob";
        int numRows = 0;
        while (rs.next()) {
            long custId = rs.getLong(1);
            String custName = rs.getString(2);
            Assert.assertEquals((String)"expected customerId", (long)expectedId, (long)custId);
            Assert.assertEquals((String)"expected firstName", (Object)expectedName, (Object)custName);
            if (expectedId == 2L) {
                expectedId = 49L;
                expectedName = "Mary";
            } else {
                expectedId -= 2L;
            }
            ++numRows;
        }
        rs.close();
        Assert.assertEquals((String)"Expected 50 rows", (long)50L, (long)numRows);
        query = queryEngine.createQuery("select Customer from repo order by Customer.firstName desc, Customer.customerId");
        rs = queryEngine.execute(query);
        expectedId = 1L;
        expectedName = "Mary";
        numRows = 0;
        while (rs.next()) {
            Customer customer = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"expected customerId", (long)expectedId, (long)customer.getCustomerId());
            Assert.assertEquals((String)"expected firstName", (Object)expectedName, (Object)customer.getFirstName());
            if (expectedId == 49L) {
                expectedId = 2L;
                expectedName = "Bob";
            } else {
                expectedId += 2L;
            }
            ++numRows;
        }
        rs.close();
        Assert.assertEquals((String)"Expected 50 rows", (long)50L, (long)numRows);
    }

    @Test
    public void testOrderByFlushNever() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(2000);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setAutoIndexing(true);
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_NEVER);
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.customerId, Customer.firstName, Customer.lastName from repo order by Customer.customerId desc");
        RogLogResultSet rs = queryEngine.execute(query);
        rs.next();
        Assert.assertEquals((String)"Didn't get the last customer id", (long)2000L, (long)rs.getLong(1));
        rs.close();
        rs.describePlan(System.out);
    }

    @Test
    public void testFlushOnUseIndex() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(2000);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setAutoIndexing(true);
        queryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_USE);
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.customerId, Customer.firstName, Customer.lastName from repo WHERE customerId >= 2000");
        RogLogResultSet rs = queryEngine.execute(query);
        rs.next();
        Assert.assertEquals((String)"Didn't get the last customer id", (long)2000L, (long)rs.getLong(1));
        rs.close();
        rs.describePlan(System.out);
    }

    @Test
    public void testLimit() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer from repo order by Customer.firstName, Customer.customerId desc limit 10");
        RogLogResultSet rs = queryEngine.execute(query);
        long expectedId = 50L;
        String expectedName = "Bob";
        int numRows = 0;
        while (rs.next()) {
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"expected customerId", (long)expectedId, (long)cust.getCustomerId());
            Assert.assertEquals((String)"expected firstName", (Object)expectedName, (Object)cust.getFirstName());
            if (expectedId == 2L) {
                expectedId = 49L;
                expectedName = "Mary";
            } else {
                expectedId -= 2L;
            }
            ++numRows;
        }
        rs.close();
        Assert.assertEquals((String)"Expected 10 rows", (long)10L, (long)numRows);
    }

    @Test
    public void testLike() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer from repo where Customer.firstName like 'b_b'");
        RogLogResultSet rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 4, 25);
        query = queryEngine.createQuery("select Customer from repo where Customer.firstName like 'm%y'");
        rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 4, 25);
    }

    @Test
    public void testRegexLike() throws Exception {
        this.initializeDefaultLog();
        this.populateSampleCustomers(50);
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQuery query = queryEngine.createQuery("select Customer.firstName from repo where Customer.firstName regex_like 'B.b'");
        RogLogResultSet rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 5, 25);
        query = queryEngine.createQuery("select Customer.firstName from repo where Customer.firstName regex_like 'M.*y'");
        rs = queryEngine.execute(query);
        this.checkTabularResults(rs, 5, 25);
    }

    private void populateSampleCustomers(int size) {
        for (int i = 1; i <= size; ++i) {
            String firstName = i % 2 == 0 ? "Bob" : "Mary";
            Customer customer = Customer.create();
            customer.setCustomerId(i);
            Address address = Address.create();
            address.setZipcode((short)12345);
            if (i % 3 == 1) {
                address.setCity("Boston");
            }
            customer.setAddress(address);
            customer.setFirstName(firstName);
            customer.ensureId();
            customer.setTransactionId(1L);
            this.logPut(customer, true);
        }
        this.defaultLog.flush(true);
    }

    @Test
    public final void testListTypes() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQueryFieldResolver resolver = (RogLogQueryFieldResolver)((RogLogQueryEngineImpl)queryEngine).getQueryFieldResolver(RogLog.Entry.class);
        Collection<Class<?>> types = resolver.getTypes();
        Assert.assertTrue((String)"Missing Customer type", (boolean)types.contains(Customer.class));
        Assert.assertTrue((String)"Missing Employee type", (boolean)types.contains(Employee.class));
    }

    @Test
    public final void testDescribeTypes() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        RogLogQueryFieldResolver resolver = (RogLogQueryFieldResolver)((RogLogQueryEngineImpl)queryEngine).getQueryFieldResolver(RogLog.Entry.class);
        StringBuffer sb = new StringBuffer();
        resolver.describeFields(queryEngine.getField("Customer"), sb);
        String desc = sb.toString();
        Assert.assertTrue((String)"Missing address in Customer description", (desc.indexOf("address") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing checkpointVersion in Customer description", (desc.indexOf("checkpointVersion") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing filePosition in Customer description", (desc.indexOf("filePosition") > 0 ? 1 : 0) != 0);
        sb = new StringBuffer();
        resolver.describeFields(queryEngine.getField("Customer.address"), sb);
        desc = sb.toString();
        Assert.assertTrue((String)"Missing zipcode in Customer.address description", (desc.indexOf("address") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Shouldn't have metadata fields in Customer.address description", (desc.indexOf("checkpointVersion") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Shouldn't have entry fields in Customer.address description", (desc.indexOf("filePosition") > 0 ? 1 : 0) != 0);
        sb = new StringBuffer();
        resolver.describeFields(queryEngine.getField("metadata"), sb);
        desc = sb.toString();
        Assert.assertTrue((String)"Missing checkpointVersion in metadata description", (desc.indexOf("outTs") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Shouldn't have entry fields in metadata description", (desc.indexOf("filePosition") > 0 ? 1 : 0) != 0);
        sb = new StringBuffer();
        resolver.describeFields(queryEngine.getField("entry"), sb);
        desc = sb.toString();
        Assert.assertFalse((String)"Shouldn't have metadata fields in metadata description", (desc.indexOf("outTs") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing entry fields in entry description", (desc.indexOf("filePosition") > 0 ? 1 : 0) != 0);
    }

    private final void checkTabularResults(QueryResultSet<?> results, int rowsToCheck, int expectedTotalResults) throws IOException {
        StringBuilder sb = new StringBuilder();
        UtlQueryResultFormatter.dumpNext(results, rowsToCheck, UtlTableFormatter.Format.TABULAR, sb);
        System.out.println("Checking results:\n" + sb.toString());
        BufferedReader reader = new BufferedReader(new StringReader(sb.toString()));
        Assert.assertEquals((String)"Wrong result count", (long)expectedTotalResults, (long)results.getCount());
        String header = reader.readLine();
        List<Integer> headerDelims = this.findLocations(header, '|');
        String resultRow = reader.readLine();
        for (int i = 0; i < rowsToCheck && i < expectedTotalResults; ++i) {
            resultRow = reader.readLine();
            if (resultRow == null) {
                Assert.fail((String)("Got " + i + " rows but expected at least " + expectedTotalResults));
            }
            List<Integer> rowDelims = this.findLocations(resultRow, '|');
            Assert.assertTrue((String)("Row delimiters are skewed for row " + (i + 1)), (boolean)rowDelims.containsAll(headerDelims));
        }
        results.close();
    }

    private List<Integer> findLocations(String string, char search) {
        ArrayList<Integer> locations = new ArrayList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != search) continue;
            locations.add(i);
        }
        return locations;
    }

    public static final void main(String[] args) throws Exception {
        RogLog defaultLog = RogLogFactory.createLog("C:/dev/neeve/x-platform/nvx-core/main/nvx-talon/target/testbed/rdat/blackbird.log");
        defaultLog.open();
        RogLogQueryEngine engine = RogLogFactory.createQueryEngine();
        engine.addRepository(defaultLog.asRepository(), "mylog");
        RogLogQuery query1 = engine.createQuery("SELECT transactionId, timestamp, messageKey FROM logs WHERE transactionId > 0");
        RogLogResultSet results = engine.execute(query1);
        UtlQueryResultFormatter.dumpNext(results, 10, UtlTableFormatter.Format.TABULAR, System.out);
        while (results.next()) {
            RogLog.Entry entry = results.getLogEntry();
            IStoreObject iStoreObject = entry.getObject();
        }
        results.close();
    }

    @Test
    public void testUnindexedEntries() throws Exception {
        int i;
        int i2;
        boolean repoReadTest = false;
        boolean fullTest = false;
        boolean secondTest = false;
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        int sampleSsn = 500112222;
        RogLog outboundLog = this.createLog("unindexed-outbound");
        RogLogRepository outboundRepo = outboundLog.asRepository();
        outboundRepo.open();
        queryEngine.addRepository(outboundRepo, "outbound");
        int size = fullTest ? 24000 : 240;
        for (i2 = 1; i2 <= size; ++i2) {
            Customer customer = this.createDummyCustomer(i2);
            boolean commit = i2 % 1000 == 0;
            this.logPut(outboundLog, customer, commit);
        }
        for (i2 = 1; i2 <= 20; ++i2) {
            Employee emp = Employee.create();
            if (i2 <= 16) {
                emp.setSsn(sampleSsn);
            }
            this.logPut(outboundLog, emp, i2 == 20);
        }
        outboundLog.flush(true);
        RogLog recoveryLog = this.createLog("unindexed-recovery");
        RogLogRepository recoveryRepo = recoveryLog.asRepository();
        recoveryRepo.open();
        queryEngine.addRepository(recoveryRepo, "recovery");
        size = fullTest ? 788000 : 788;
        for (i = 1; i <= size; ++i) {
            Customer customer = this.createDummyCustomer(i);
            boolean commit = i % 1000 == 0;
            this.logPut(recoveryLog, customer, commit);
        }
        for (i = 1; i <= 5; ++i) {
            Employee emp = Employee.create();
            if (i <= 3) {
                emp.setSsn(sampleSsn);
            }
            this.logPut(recoveryLog, emp, i == 5);
        }
        recoveryLog.flush(true);
        long start = System.currentTimeMillis();
        if (repoReadTest) {
            ArrayList employees = Lists.newArrayList();
            int outboundCount = 0;
            for (Object entry : outboundRepo.retrieveAll()) {
                Employee emp;
                ++outboundCount;
                IStoreObject payload = ((RogLog.Entry)entry).getObject();
                if (!(payload instanceof Employee) || sampleSsn != (emp = (Employee)payload).getSsn()) continue;
                employees.add(emp);
            }
            int recoveryCount = 0;
            for (RogLog.Entry entry : recoveryRepo.retrieveAll()) {
                Employee emp;
                ++recoveryCount;
                IStoreObject payload = entry.getObject();
                if (!(payload instanceof Employee) || sampleSsn != (emp = (Employee)payload).getSsn()) continue;
                employees.add(emp);
            }
            if (fullTest) {
                System.out.println("Direct read of logs: " + (System.currentTimeMillis() - start));
                Assert.assertEquals((String)"expected 24020 outbound records", (long)24020L, (long)outboundCount);
                Assert.assertEquals((String)"expected 788005 recovery records", (long)788005L, (long)recoveryCount);
            }
            Assert.assertEquals((String)"logs should have 19 matching employees", (long)19L, (long)employees.size());
        }
        IdxField ssn = queryEngine.getField((Class)Employee.class, "ssn", Integer.class, new Class[0]);
        IdxField timestamp = queryEngine.getField((Class)RogLog.Entry.class, "timestamp", Long.class, new Class[0]);
        RogLogQuery query = queryEngine.createQuery();
        query.select(ssn).select(timestamp).from("logs").where(ssn.equal(sampleSsn));
        RogLogResultSet rs = queryEngine.execute(query);
        start = System.currentTimeMillis();
        int count = 0;
        while (rs.next()) {
            int rowSsn = rs.getInteger(1);
            Assert.assertEquals((String)"unexpected ssn value", (long)sampleSsn, (long)rowSsn);
            ++count;
        }
        Assert.assertEquals((String)"expect 19 rows", (long)19L, (long)count);
        long fullScanMillis = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        queryEngine.createIndex(ssn, false);
        outboundRepo.flushIndexing();
        recoveryRepo.flushIndexing();
        if (fullTest) {
            System.out.println("SSN index creation: " + (System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        queryEngine.createIndex(timestamp, false);
        outboundRepo.flushIndexing();
        recoveryRepo.flushIndexing();
        if (fullTest) {
            System.out.println("Timestamp index creation: " + (System.currentTimeMillis() - start));
        }
        rs = queryEngine.execute(query);
        start = System.currentTimeMillis();
        count = 0;
        while (rs.next()) {
            int rowSsn = rs.getInteger(1);
            Assert.assertEquals((String)"unexpected ssn value", (long)sampleSsn, (long)rowSsn);
            ++count;
        }
        Assert.assertEquals((String)"expect 19 rows", (long)19L, (long)count);
        long indexedReadMillis = System.currentTimeMillis() - start;
        if (fullTest) {
            System.out.println("full scan: " + fullScanMillis + ", indexed read: " + indexedReadMillis);
        }
        int indexedReadFactor = fullTest ? 500 : 2;
        Assert.assertTrue((String)("indexed read should be " + indexedReadFactor + "X faster: " + fullScanMillis + " vs " + indexedReadMillis), (fullScanMillis > indexedReadMillis * (long)indexedReadFactor ? 1 : 0) != 0);
        queryEngine.close();
        if (secondTest) {
            queryEngine = RogLogFactory.createQueryEngine();
            outboundRepo = outboundLog.asRepository();
            outboundRepo.open();
            queryEngine.addRepository(outboundRepo, "outbound");
            recoveryRepo = recoveryLog.asRepository();
            recoveryRepo.open();
            queryEngine.addRepository(recoveryRepo, "recovery");
            outboundRepo.flushIndexing();
            recoveryRepo.flushIndexing();
            query = queryEngine.createQuery();
            query.select(ssn).from("logs").where(ssn.equal(sampleSsn));
            rs = queryEngine.execute(query);
            start = System.currentTimeMillis();
            count = 0;
            while (rs.next()) {
                int rowSsn = rs.getInteger(1);
                Assert.assertEquals((String)"unexpected ssn value", (long)sampleSsn, (long)rowSsn);
                ++count;
            }
            Assert.assertEquals((String)"expect 19 rows", (long)19L, (long)count);
            indexedReadMillis = System.currentTimeMillis() - start;
            if (fullTest) {
                System.out.println("full scan: " + fullScanMillis + ", indexed read: " + indexedReadMillis);
            }
            Assert.assertTrue((String)("indexed read should be " + indexedReadFactor + "X faster: " + fullScanMillis + " vs " + indexedReadMillis), (fullScanMillis > indexedReadMillis * (long)indexedReadFactor ? 1 : 0) != 0);
            queryEngine.close();
        }
        outboundLog.close();
        recoveryLog.close();
    }

    @Test
    public void testDefaultIndexing() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.setDefaultIndexing(true);
        queryEngine.addRepository(this.repository, "repo");
        this.repository.flushIndexing();
        List indexes = this.repository.getIndexes();
        Assert.assertEquals((String)"There should only be one default index field", (long)1L, (long)indexes.size());
        IdxIndex tsIndex = indexes.get(0);
        IdxField tsField = tsIndex.getField();
        Assert.assertEquals((String)"Timestamp field type is Long", Long.class, tsField.getFieldType());
        Assert.assertEquals((String)"Incorrect canonical name", (Object)"entry.timestamp", (Object)tsField.getCanonicalName());
    }

    private Customer createDummyCustomer(int i, boolean largePayload) {
        Customer customer = Customer.create();
        customer.setCustomerId(i);
        customer.setFirstName(i % 2 == 0 ? "Bob" : "Mary");
        customer.setAmbiguousField(largePayload ? largeString : smallString);
        customer.setAmbiguousFieldFrom(-1234567890L);
        customer.setCreateDate(new Date());
        customer.setCreateDateAsTimestamp(System.currentTimeMillis());
        customer.setInteger1(789789789);
        customer.setInteger1(234234234);
        customer.setIsVIP(false);
        customer.setLastName("Smith");
        customer.setTransactionId(1 + i % 500);
        customer.setMessageBus("testBus");
        customer.setMessageChannel("testChannel");
        customer.setMessageKey("testKey");
        customer.setMessageSender(20);
        customer.setOutTsMicros(UtlTime.nowSinceEpoch());
        return customer;
    }

    private Customer createDummyCustomer(int i) {
        return this.createDummyCustomer(i, false);
    }

    @Test
    public void testEntrySizeFields() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        queryEngine.createIndex("payloadSize", false);
        queryEngine.createIndex("entrySize", false);
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Jeff");
        customer1.setLastName("Jones");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        customer1.setFirstName("January");
        this.logUpdate(customer1);
        customer1.setFirstName("January");
        this.logRemove(customer1);
        RogLogResultSet rs = queryEngine.execute("select id, firstName, lastName, entrySize, payloadSize from repo");
        this.checkTabularResults(rs, 3, 3);
        rs.close();
        rs = queryEngine.execute("select entrySize, payloadSize from repo");
        this.checkTabularResults(rs, 3, 3);
        rs.close();
    }

    @Test
    public void testTypeInference() throws Exception {
        Predicate<RogLog.Entry> payloadTypePredicate;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Jeff");
        customer1.setLastName("Jones");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        RogLogQueryImpl query = (RogLogQueryImpl)queryEngine.createQuery("select firstName from repo");
        Predicate<RogLog.Entry> where = query.getWhere();
        if (where instanceof PredicatesImpl.And) {
            PredicatesImpl.And and = (PredicatesImpl.And)where;
            List childPredicates = and.getChildPredicates();
            payloadTypePredicate = childPredicates.get(0);
        } else {
            payloadTypePredicate = where;
        }
        FieldPredicate.NaryFieldPredicate inPredicate = (FieldPredicate.NaryFieldPredicate)payloadTypePredicate;
        Assert.assertEquals((String)"expect IN operator", (Object)PredicateOperator.IN, inPredicate.getOperator());
        List types = inPredicate.getValues();
        Assert.assertEquals((String)"expect 3 types with a firstName field", (long)3L, (long)types.size());
        Assert.assertTrue((String)"Must contain Customer.class", (boolean)types.contains(Customer.class));
        Assert.assertTrue((String)"Must contain Employee.class", (boolean)types.contains(Employee.class));
        Assert.assertTrue((String)"Must contain Supplier.class", (boolean)types.contains(Supplier.class));
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where firstName = 'Alex' and monthlySalary > 5000");
        where = query.getWhere();
        Set<Class> whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employees only", (long)1L, (long)whereTypes.size());
        Assert.assertTrue((String)"Must contain Employee.class", (boolean)whereTypes.contains(Employee.class));
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where firstName = 'Alex' and monthlySalary is null");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employee, Customer, Supplier: 3 types", (long)3L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where firstName = 'Alex' or monthlySalary > 5000");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employee, Customer, Supplier: 3 types", (long)3L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where (firstName = 'Alex' and monthlySalary > 5000) or (firstName = 'Amy' and customerId = 234)");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employee, Customer: 2 types", (long)2L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where monthlySalary > 5555 and customerId = 345");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"No types have both fields", (long)0L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where monthlySalary > 5555 or customerId = 345");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employee, Customer: 2 types", (long)2L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where not (monthlySalary > 5555 and customerId = 345)");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"Employee, Customer: 2 types", (long)2L, (long)whereTypes.size());
        query = (RogLogQueryImpl)queryEngine.createQuery("select * from repo where not (monthlySalary > 5555 or customerId = 345)");
        where = query.getWhere();
        whereTypes = query.extractPayloadTypes(where, true);
        Assert.assertEquals((String)"No types have both fields", (long)0L, (long)whereTypes.size());
    }

    @Test
    public void testPayloadIsNotDeserialized() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Jeff");
        customer1.setLastName("Jones");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        RogLogResultSet rs = queryEngine.execute("select Entry.object.class, className, simpleClassName from repo");
        while (rs.next()) {
            RogLog.Entry entry = (RogLog.Entry)rs.getRawResult();
            Class type = (Class)rs.getObject(1);
            String className = rs.getString(2);
            String simpleClassName = rs.getString(3);
            Assert.assertFalse((String)"payload should not be deserialized", (boolean)entry.isPayloadDeserialized());
            Class<?> payloadType = entry.getObject().getClass();
            Assert.assertTrue((String)"payload should now have been deserialized", (boolean)entry.isPayloadDeserialized());
            Assert.assertEquals((String)"The type of the payload should match", payloadType, (Object)type);
            Assert.assertEquals((String)"className matches", (Object)className, (Object)entry.getClassName());
            Assert.assertEquals((String)"simpleClassName matches", (Object)simpleClassName, (Object)entry.getSimpleClassName());
        }
        rs.close();
    }

    @Test
    public void testClassLiterals() throws Exception {
        Customer cust;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        Customer customer1 = Customer.create();
        customer1.setCustomerId(1L);
        customer1.setFirstName("Jeff");
        customer1.setLastName("Jones");
        customer1.ensureId();
        customer1.setTransactionId(1L);
        this.logPut(customer1);
        RogLogResultSet rs = queryEngine.execute("select * from repo where Entry.object.class='Customer'");
        int cnt = 0;
        while (rs.next()) {
            cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"wrong entry payload", (Object)"Jeff", (Object)cust.getFirstName());
            ++cnt;
        }
        Assert.assertEquals((String)"expected 1 row", (long)1L, (long)cnt++);
        rs.close();
        rs = queryEngine.execute("select * from repo where firstName.class='java.lang.String'");
        cnt = 0;
        while (rs.next()) {
            cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"wrong entry payload", (Object)"Jeff", (Object)cust.getFirstName());
            ++cnt;
        }
        Assert.assertEquals((String)"expected 1 row", (long)1L, (long)cnt++);
        rs.close();
        queryEngine.close();
    }

    @Test
    public void testMonotonicScans() throws Exception {
        String name;
        Customer cust;
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        IdxField custId = queryEngine.getField("Customer.customerId");
        ((QueryIndexableRepository)((Object)this.repository)).registerMonotonicField(custId, true);
        for (int i = 1; i <= 50; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogResultSet rs = queryEngine.execute("select * from repo where Customer.customerId in (10,15,20)");
        QueryPlan plan = rs.getPlan("repo");
        QueryPlan.Step firstStep = plan.getSteps().get(0);
        Assert.assertTrue((String)"expected MonotonicValueScan", (boolean)(firstStep instanceof QueryPlanImpl.MonotonicValueScan));
        int cnt = 0;
        while (rs.next()) {
            cust = (Customer)rs.getObject(1);
            name = cnt % 2 == 0 ? "Bob" : "Mary";
            Assert.assertEquals((String)"wrong entry payload", (Object)name, (Object)cust.getFirstName());
            ++cnt;
        }
        Assert.assertEquals((String)"expected 3 rows", (long)3L, (long)cnt++);
        rs.close();
        rs = queryEngine.execute("select * from repo where Customer.customerId between 4 and 8");
        plan = rs.getPlan("repo");
        firstStep = plan.getSteps().get(0);
        Assert.assertTrue((String)"expected MonotonicRangeScan", (boolean)(firstStep instanceof QueryPlanImpl.MonotonicRangeScan));
        cnt = 0;
        while (rs.next()) {
            cust = (Customer)rs.getObject(1);
            name = cnt % 2 == 0 ? "Bob" : "Mary";
            Assert.assertEquals((String)"wrong entry payload", (Object)name, (Object)cust.getFirstName());
            ++cnt;
        }
        Assert.assertEquals((String)"expected 5 row", (long)5L, (long)cnt++);
        rs.close();
        queryEngine.close();
    }

    @Test
    public void testPredicateCostPrioritization() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        for (int i = 1; i <= 50; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("select * from repo where lastName = 'Smith' and timestamp > 0");
        Predicate<RogLog.Entry> where = ((RogLogQueryImpl)query).getWhere();
        PredicateBase whereImpl = (PredicateBase)where;
        whereImpl.regularize();
        whereImpl.prioritizeByCost();
        Assert.assertTrue((String)"whereImpl is an AND", (boolean)(whereImpl instanceof PredicatesImpl.And));
        double previousCost = 0.0;
        Predicate lastChild = null;
        for (Predicate child : ((PredicatesImpl.And)whereImpl).getChildPredicates()) {
            double cost = child.getCost();
            lastChild = child;
            Assert.assertTrue((String)"child cost is increasing", (cost >= previousCost ? 1 : 0) != 0);
            previousCost = cost;
        }
        Assert.assertTrue((String)"Should be a FieldPredicate", (boolean)(lastChild instanceof FieldPredicate));
        FieldPredicate lastNameSmith = (FieldPredicate)lastChild;
        Assert.assertEquals((String)"lastName should be last", (Object)"object.lastName", (Object)lastNameSmith.getField().getName());
    }

    @Test
    public void testImplicitTypes() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        for (int i = 1; i <= 50; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("select Customer.address.zipcode from repo");
        queryEngine.execute(query);
        Predicate<RogLog.Entry> where = ((RogLogQueryImpl)query).getWhere();
        PredicateBase whereImpl = (PredicateBase)where;
        whereImpl.regularize();
        whereImpl.prioritizeByCost();
        System.out.println("WHERE " + where);
        Assert.assertTrue((String)"Should be a FieldPredicate", (boolean)(where instanceof FieldPredicate));
        FieldPredicate fieldPredicate = (FieldPredicate)where;
        Assert.assertEquals((String)"against payload type", RogLogEntryField.PAYLOAD_TYPE, fieldPredicate.getField());
        Assert.assertEquals((String)"one value", (long)1L, (long)fieldPredicate.getValues().size());
        Assert.assertEquals((String)"value: Customer", Customer.class, fieldPredicate.getValues().get(0));
    }

    @Test
    public void testIndexDataRead() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        for (int i = 1; i <= 5; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("select lastName from repo");
        RogLogResultSet rs = queryEngine.execute(query);
        while (rs.next()) {
            String lastName = rs.getString(1);
            System.out.println("last name: " + lastName);
        }
        rs.close();
        queryEngine.close();
    }

    @Test
    public void testIndexCompatibility() throws Exception {
        this.assertCompatible("1_6", false, false);
        this.assertCompatible("1_8", true, true);
        this.assertCompatible("1_9", true, true);
        this.assertCompatible("3_3", true, true);
        this.assertCompatible("3_4", true, true);
        this.assertCompatible("3_5", true, true);
    }

    private void assertCompatible(String version, boolean compatibleLog, boolean compatibleIndex) throws Exception {
        block8: {
            this.retrieveCompatibilityLog(version);
            try {
                RogLog log = this.createLog("compatibility" + version);
                if (!compatibleLog) {
                    Assert.fail((String)("A " + version + " log is not compatible, but was successfully opened."));
                }
                try {
                    RogLogRepository repo = log.asRepository();
                    repo.open();
                    RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
                    queryEngine.addRepository(repo, "repo");
                    RogLogResultSet rs = queryEngine.execute("select * from repo");
                    Assert.assertEquals((String)"should return all 50 customers", (long)50L, (long)rs.getCount());
                    rs = queryEngine.execute("select * from repo where customerId = 33");
                    Assert.assertEquals((String)"should be 1 customer", (long)1L, (long)rs.getCount());
                    StringWriter writer = new StringWriter();
                    rs.beforeFirst();
                    rs.next();
                    RogLogUtil.dumpLogEntryJson(rs.getLogEntry(), true, true, true, RogLogUtil.JsonPrettyPrintStyle.PrettyPrint, writer);
                    if (RogLogQueryTest.verbose()) {
                        System.out.println("entry with customer id 33 from log version: " + version + ":\n" + writer);
                    }
                    if (!compatibleIndex) {
                        Assert.fail((String)("A " + version + " log is not compatible but was successfully queried"));
                    }
                }
                catch (Exception e) {
                    if (compatibleIndex) {
                        Assert.fail((String)("A " + version + " log could not be queried: " + UtlThrowable.prepareStackTrace((Throwable)e)));
                    }
                }
            }
            catch (Exception e) {
                if (!compatibleLog) break block8;
                Assert.fail((String)("A " + version + " log could not be opened: " + UtlThrowable.prepareStackTrace((Throwable)e)));
            }
        }
    }

    private void retrieveCompatibilityLog(String version) throws Exception {
        String dataDirectoryName = XRuntime.getDataDirectory((boolean)true);
        File dataDir = new File(dataDirectoryName);
        for (File file : dataDir.listFiles()) {
            file.delete();
        }
        File sourceDir = new File(RogLogQueryTest.getProjectBaseDirectory() + "/test/java/com/neeve/rog/log/test/unit/compatibility/" + version);
        if (!sourceDir.exists()) {
            System.out.println("Creating compatibility log for " + version + " (none was found in " + sourceDir.toString() + ")");
            this.createCompatibilityLog(version);
            sourceDir.mkdirs();
            for (File newFile : dataDir.listFiles()) {
                File backupFile = new File(sourceDir, newFile.getName());
                UtlFile.copyFile((File)newFile, (File)backupFile);
            }
        } else {
            for (File sourceFile : sourceDir.listFiles()) {
                File targetFile = new File(dataDir, sourceFile.getName());
                UtlFile.copyFile((File)sourceFile, (File)targetFile);
            }
        }
    }

    private void createCompatibilityLog(String version) throws Exception {
        RogLog compatLog = this.createLog("compatibility" + version);
        this.repository = compatLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        queryEngine.createIndex("customerId", true);
        queryEngine.createIndex("lastName", false);
        for (int i = 1; i <= 50; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(compatLog, customer, true);
        }
        compatLog.flush(true);
        this.repository.flushIndexing();
        queryEngine.close();
    }

    @Test
    public void testQualifiedSelectStar() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        for (int i = 1; i <= 5; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("select Customer.*, com/neeve/rog/log/test/unit/messages/proto/Customer.* from repo");
        RogLogResultSet rs = queryEngine.execute(query);
        while (rs.next()) {
            Customer cust = (Customer)rs.getObject(1);
            Customer cust2 = (Customer)rs.getObject(2);
            Assert.assertEquals((String)"should be same Customers", (long)cust.getCustomerId(), (long)cust2.getCustomerId());
        }
        rs.close();
        queryEngine.close();
    }

    @Test
    public void testSelectClass() throws Exception {
        this.initializeDefaultLog();
        this.repository = this.defaultLog.asRepository();
        this.repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(this.repository, "repo");
        for (int i = 1; i <= 5; ++i) {
            Customer customer = this.createDummyCustomer(i);
            this.logPut(customer);
        }
        this.flushIndexing();
        RogLogQuery query = queryEngine.createQuery("select Entry.object.class, object.class, class from repo");
        RogLogResultSet rs = queryEngine.execute(query);
        while (rs.next()) {
            Class type1 = (Class)rs.getObject(1);
            Class type2 = (Class)rs.getObject(2);
            Class type3 = (Class)rs.getObject(3);
            Assert.assertEquals((String)"Entry.object.class yields Customer", Customer.class, (Object)type1);
            Assert.assertEquals((String)"object.class yields Customer", Customer.class, (Object)type2);
            Assert.assertEquals((String)"class yields Customer", Customer.class, (Object)type3);
        }
        rs.close();
        queryEngine.close();
    }

    @Test
    public void testDocumentedExamples() throws Exception {
        this.defaultLog = this.createLog("orderProcessingApp");
        Customer customer1 = Customer.create();
        customer1.setFirstName("John");
        customer1.setLastName("Smith");
        customer1.setCustomerId(1L);
        Address address1 = new Address();
        address1.setStreet("1 Market Street");
        address1.setCity("San Francisco");
        address1.setZipcode((short)28569);
        address1.setState("CA");
        address1.setCountry("USA");
        customer1.setAddress(address1);
        this.logPut(customer1);
        Customer customer2 = Customer.create();
        customer2.setFirstName("Jane");
        customer2.setLastName("Doe");
        customer2.setCustomerId(2L);
        Address address2 = new Address();
        address2.setStreet("625 42nd Street");
        address2.setCity("New York");
        address2.setZipcode((short)10102);
        address2.setState("NY");
        address2.setCountry("NY");
        customer2.setAddress(address2);
        this.logPut(customer2);
        this.defaultLog.flush(true);
        this.defaultLog.close();
        RogLog log = RogLogFactory.createLog("orderProcessingApp");
        log.open();
        RogLogRepository repository = log.asRepository();
        repository.open();
        RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();
        queryEngine.addRepository(repository, "orderProcessingApp");
        Assert.assertEquals((String)"Wrong result count in query", (long)2L, (long)queryEngine.execute("SELECT * FROM LOGS").getCount());
        Query<RogLog.Entry> query = queryEngine.createQuery("SELECT * FROM logs WHERE Customer.customerId = 2");
        RogLogResultSet rs = queryEngine.execute((RogLogQuery)query);
        while (rs.next()) {
            Customer customer = (Customer)rs.getLogEntry().getObject();
            System.out.println(customer.toJsonString());
        }
        rs.close();
        IdxField customerFirstName = queryEngine.getField((Class)Customer.class, "firstName");
        IdxField customerLastName = queryEngine.getField((Class)Customer.class, "lastName");
        IdxField customerId = queryEngine.getField((Class)Customer.class, "customerId");
        IdxField customerZipcode = queryEngine.getField((Class)Customer.class, "address.zipcode");
        IdxField zipCodeCount = customerZipcode.count();
        IdxField zipCodeMin = customerZipcode.min();
        IdxField zipCodeMax = customerZipcode.max();
        query = queryEngine.createQuery();
        query.select(customerFirstName).select(customerLastName).select(customerZipcode).from("orderProcessingApp").where(customerId.is(2L));
        rs = queryEngine.execute((RogLogQuery)query);
        while (rs.next()) {
            System.out.println("First Name: " + rs.getObject(customerFirstName.getName()));
            System.out.println("Result Object:");
            Customer customer = (Customer)rs.getLogEntry().getObject();
            System.out.println(customer.toJsonString());
        }
        rs.close();
        query = queryEngine.createQuery("SELECT Customer.firstName, Customer.address.zipcode FROM orderProcessingApp WHERE Customer.customerId = 2");
        rs = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(rs, 10, 1);
        IdxField entryType = queryEngine.getField("entryType");
        query = queryEngine.createQuery().select((IdxField)RogLogQueryFieldResolver.SELECT_ALL_FIELD).from("orderProcessingApp").where(customerLastName.is("Doe").and(customerFirstName.is("Jane")).and(entryType.is(RogLog.Entry.Type.Put)));
        rs = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(rs, 10, 1);
        rs.close();
        IdxField timestamp = queryEngine.getField("timestamp");
        query = queryEngine.createQuery().select(customerZipcode).select(customerId.count()).select(customerId.min()).select(customerId.max()).from("logs").where(timestamp.greaterThan(UtlDataTypes.parseAsDate((Object)"one day ago").getTime())).groupBy(customerZipcode);
        rs = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(rs, 10, 2);
        Assert.assertEquals((String)"Wrong result count in query", (long)2L, (long)queryEngine.execute((RogLogQuery)query).getCount());
        rs.close();
        query = queryEngine.createQuery().select(customerLastName).select(customerFirstName).from("logs").orderBy(customerLastName, Query.SortOrder.ASCENDING);
        rs = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(rs, 10, 2);
        Assert.assertEquals((String)"Wrong result count in query", (long)2L, (long)queryEngine.execute((RogLogQuery)query).getCount());
        rs.close();
        query = queryEngine.createQuery().select(customerLastName).select(customerFirstName).from("logs").orderBy(customerLastName, Query.SortOrder.ASCENDING).limit(1);
        rs = queryEngine.execute((RogLogQuery)query);
        this.checkTabularResults(rs, 10, 1);
        rs.close();
        query = queryEngine.createQuery();
        query.select(queryEngine.getField("entry.object")).from("orderProcessingApp");
        rs = queryEngine.execute((RogLogQuery)query);
        while (rs.next()) {
            Customer customer = (Customer)rs.getObject(1);
            System.out.println(customer);
        }
        rs.beforeFirst();
        this.checkTabularResults(rs, 10, 2);
        query = queryEngine.createQuery();
        query.select(customerFirstName).select(customerLastName).select(customerZipcode).from("orderProcessingApp").where(customerId.is(2L));
        rs = queryEngine.execute((RogLogQuery)query);
        rs.beforeFirst();
        while (rs.next()) {
            String firstName = rs.getString(1);
            String lastName = rs.getString(2);
            short zipcode = rs.getShort(3);
            Assert.assertEquals((String)"Wrong first name", (Object)customer2.getFirstName(), (Object)firstName);
            Assert.assertEquals((String)"Wrong last name", (Object)customer2.getLastName(), (Object)lastName);
            Assert.assertEquals((String)"Wrong first name", (long)customer2.getAddress().getZipcode(), (long)zipcode);
        }
        rs.beforeFirst();
        while (rs.next()) {
            RogLog.Entry entry = rs.getLogEntry();
            entry.getMetadata();
            entry.getObject();
        }
        rs.beforeFirst();
        this.checkTabularResults(rs, 10, 1);
    }
}

