/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.query.index.IdxField;
import com.neeve.rog.impl.log.RogLogEntryField;
import com.neeve.rog.impl.log.RogLogQueryFieldResolver;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.test.unit.messages.proto.Factory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RogLogQueryFieldResolverTest {
    private static RogLogQueryFieldResolver resolver;

    @BeforeClass
    public static void before() {
        resolver = RogLogQueryFieldResolver.get();
        resolver.addFactory(Factory.class);
    }

    @Test
    public void testEntry() {
        IdxField entryField = resolver.getField("Entry", "");
        Assert.assertEquals((String)"Entry should be the record", RogLogEntryField.ENTRY, (Object)entryField);
        IdxField checkpointVersionField = resolver.getField("Entry", "checkpointVersion");
        Assert.assertEquals((Object)"Entry.checkpointVersion", (Object)checkpointVersionField.getCanonicalName());
        Assert.assertEquals((Object)"checkpointVersion", (Object)checkpointVersionField.getFieldPath());
        Assert.assertEquals(Long.class, checkpointVersionField.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, checkpointVersionField.getRecordType());
        checkpointVersionField = resolver.getField("", "checkpointVersion");
        Assert.assertEquals((Object)"Entry.checkpointVersion", (Object)checkpointVersionField.getCanonicalName());
        Assert.assertEquals((Object)"checkpointVersion", (Object)checkpointVersionField.getFieldPath());
        Assert.assertEquals(Long.class, checkpointVersionField.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, checkpointVersionField.getRecordType());
    }

    @Test
    public void testMetadata() {
        IdxField field = resolver.getField("Entry", "metadata.messageSequenceNumber");
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("", "metadata.messageSequenceNumber");
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("Metadata", "messageSequenceNumber");
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("IRogMetadata", "messageSequenceNumber");
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("", "messageSequenceNumber");
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"metadata.messageSequenceNumber", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
    }

    @Test
    public void testSimplePayload() {
        IdxField field = resolver.getField("Entry", "object.customerId");
        Assert.assertEquals((Object)"object.customerId", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"object.customerId", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("", "object.customerId");
        Assert.assertEquals((Object)"object.customerId", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"object.customerId", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("Customer", "customerId");
        Assert.assertEquals((Object)"com/neeve/rog/log/test/unit/messages/proto/Customer.customerId", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"object.customerId", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
        field = resolver.getField("", "customerId");
        Assert.assertEquals((Object)"object.customerId", (Object)field.getCanonicalName());
        Assert.assertEquals((Object)"object.customerId", (Object)field.getFieldPath());
        Assert.assertEquals(Long.class, field.getFieldType());
        Assert.assertEquals(RogLog.Entry.class, field.getRecordType());
    }

    @Test
    public void testPayloadClass() {
        IdxField field = resolver.getField("Entry", "object.class");
        Assert.assertEquals((String)"Entry.object.class should be payload type", RogLogEntryField.PAYLOAD_TYPE, (Object)field);
        field = resolver.getField("", "object.class");
        Assert.assertEquals((String)"object.class should be payload type", RogLogEntryField.PAYLOAD_TYPE, (Object)field);
        field = resolver.getField("", "class");
        Assert.assertEquals((String)"'class' should be payload type", RogLogEntryField.PAYLOAD_TYPE, (Object)field);
    }
}

