/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl.log;

import com.neeve.ods.IStoreObjectFactory;
import com.neeve.query.QueryException;
import com.neeve.query.QueryParseException;
import com.neeve.query.QueryRepository;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.QueryFieldResolver;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryRepositoryBase;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.index.IdxField;
import com.neeve.rog.impl.log.RogLogEntryField;
import com.neeve.rog.impl.log.RogLogQueryFieldResolver;
import com.neeve.rog.impl.log.RogLogQueryImpl;
import com.neeve.rog.impl.log.RogLogResultSetImpl;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQuery;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.trace.Tracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;

public class RogLogQueryEngineImpl
extends QueryEngineImpl<Long, RogLog.Entry>
implements RogLogQueryEngine {
    private RogLogQueryFieldResolver fieldResolver;
    private static final Comparator<Long> LOG_POSITION_COMPARATOR = new LogPositionComparator();
    private static final Comparator<QueryResultSet.Row<RogLog.Entry>> TIMESTAMP_COMPARATOR = new Comparator<QueryResultSet.Row<RogLog.Entry>>(){

        @Override
        public int compare(QueryResultSet.Row<RogLog.Entry> row1, QueryResultSet.Row<RogLog.Entry> row2) {
            long t2;
            long t1 = row1.getRecord().getTimestamp();
            if (t1 > (t2 = row2.getRecord().getTimestamp())) {
                return 1;
            }
            if (t1 < t2) {
                return -1;
            }
            return 0;
        }
    };

    public RogLogQueryEngineImpl() {
        super(RogLog.Entry.class);
        IdxField timestampField = this.fieldResolver.getField((Class)RogLog.Entry.class, "timestamp", Long.class, new Class[0]);
        this.registerDefaultIndexField(timestampField, false);
    }

    @Override
    public final QueryFieldResolver<RogLog.Entry> getQueryFieldResolver(Class<RogLog.Entry> concreteBaseType) {
        if (this.fieldResolver == null) {
            this.fieldResolver = RogLogQueryFieldResolver.get();
        }
        return this.fieldResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(QueryRepository<Long, RogLog.Entry> log, String alias) {
        if (log == null) {
            throw new QueryException("Cannot add a null repository: " + alias);
        }
        try (BufferedReader br = new BufferedReader(new FileReader(new File(((QueryRepositoryBase)log).getDataDirectory(), log.getName() + ".factories")));){
            String factoryClassName;
            while ((factoryClassName = br.readLine()) != null) {
                try {
                    Class<?> clazz = Class.forName(factoryClassName);
                    this.fieldResolver.addFactory(clazz);
                }
                catch (Exception e) {
                    this.tracer.log("Error reading factory file for " + log.getName() + ": " + e.getMessage(), Tracer.Level.SEVERE);
                }
            }
        }
        catch (IOException ioe) {
            throw new QueryException("Error parsinhg log repository's factory file", ioe);
        }
        ((QueryIndexableRepository)log).registerMonotonicField(RogLogEntryField.TIMESTAMP, true);
        super.addRepository(log, alias);
    }

    @Override
    public Collection<RogLogRepository> getRepositories() {
        return super.getRepositories();
    }

    @Override
    public RogLogQuery createQuery() {
        return new RogLogQueryImpl();
    }

    @Override
    public RogLogQuery createQuery(String xsql) {
        return (RogLogQuery)super.createQuery(xsql);
    }

    @Override
    public RogLogResultSet execute(String xsql) {
        return this.execute(this.createQuery(xsql));
    }

    @Override
    public RogLogResultSet execute(RogLogQuery query) {
        return (RogLogResultSet)super.execute(query);
    }

    @Override
    public QueryResultSetImpl<Long, RogLog.Entry> createResultSet() {
        return new RogLogResultSetImpl(this);
    }

    @Override
    protected Comparator<Long> getNaturalKeyOrder() {
        return LOG_POSITION_COMPARATOR;
    }

    @Override
    protected Comparator<QueryResultSet.Row<RogLog.Entry>> getCollationComparator() {
        return TIMESTAMP_COMPARATOR;
    }

    @Override
    public final <T> RogLogQueryEngine.RogLogField<T> getField(String objectTypeName, String fieldPath) {
        return this.fieldResolver.getField(objectTypeName, fieldPath);
    }

    @Override
    public <T> RogLogQueryEngine.RogLogField<T> getField(String columnDefinition) throws QueryException, QueryParseException {
        return (RogLogQueryEngine.RogLogField)super.getField(columnDefinition);
    }

    @Override
    public final <T> RogLogQueryEngine.RogLogField<T> getField(Class<?> objectType, String fieldPath) {
        return this.fieldResolver.getField((Class)objectType, fieldPath);
    }

    @Override
    public final <T> RogLogQueryEngine.RogLogField<T> getField(Class<?> objectType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        return this.fieldResolver.getField((Class)objectType, fieldPath, (Class)fieldType, (Class[])pathTypes);
    }

    @Override
    protected boolean isAllRepositoriesToken(String token) {
        if (token.equalsIgnoreCase("logs")) {
            return true;
        }
        return super.isAllRepositoriesToken(token);
    }

    public Collection<Class<?>> getTypes() {
        return this.fieldResolver.getTypes();
    }

    @Override
    public final void registerFactory(Class<?> factoryClass) {
        this.fieldResolver.addFactory(factoryClass);
    }

    @Override
    public void enableTypeInference(boolean enable) {
        this.fieldResolver.enableTypeReference(enable);
    }

    @Override
    public void enableStaticFields(boolean enable) {
        RogLogEntryField.enableStaticFields(enable);
    }

    @Override
    public final RogLogRepository addTransactionLogForQuery(File transactionLogFile, String alias) throws Exception {
        String name = transactionLogFile.getName().substring(0, transactionLogFile.getName().length() - 4);
        Properties props = new Properties();
        props.setProperty("detactedPersist", "false");
        props.setProperty("storeRoot", transactionLogFile.getParent());
        props.setProperty("autoRepair", String.valueOf(false));
        props.setProperty("logMode", "r");
        RogLog transactionLog = RogLogFactory.createLog(name, props);
        File factoriesFile = new File(transactionLogFile.getParent(), name + ".factories");
        if (factoriesFile.exists()) {
            this.readFactories(factoriesFile);
        }
        transactionLog.open();
        RogLogRepository repo = transactionLog.asRepository();
        repo.setCloseLogOnClose(true);
        repo.open();
        this.addRepository(repo, name);
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readFactories(File factoriesFile) throws Exception {
        if (factoriesFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(factoriesFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.registerFactory(line.trim());
                }
            }
        } else {
            throw new Exception("File not found: " + factoriesFile);
        }
    }

    private final void registerFactory(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        Method createMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
            createMethod = clazz.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException cne) {
            throw new Exception("Failed to load java.util.Properties during instantiation of factory class");
        }
        catch (SecurityException se) {
            throw new Exception("Invalid factory class '" + className + "' access to create method is denied");
        }
        catch (NoSuchMethodException nsme) {
            throw new Exception("Invalid factory class '" + className + "' create() not found");
        }
        IStoreObjectFactory factory = null;
        try {
            try {
                Object[] parameters = new Object[]{null};
                factory = (IStoreObjectFactory)createMethod.invoke(null, parameters);
                if (null == factory) {
                    throw new Exception("Invalid factory class '" + className + "' create() method returned a null object");
                }
                RogLogReader.registerFactory(factory);
            }
            catch (ClassCastException ce) {
                throw new Exception("Invalid factory class '" + className + "' create() did not return a valid factory");
            }
        }
        catch (IllegalAccessException ile) {
            throw new Exception("Invalid factory class '" + className + "'");
        }
    }

    private static class LogPositionComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LogPositionComparator() {
        }

        @Override
        public int compare(Long pos1, Long pos2) {
            return pos1.compareTo(pos2);
        }
    }
}

