/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.protobuf.Message;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.rog.IRogRawMessage;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.impl.RogRawMessageFactory;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlBuffer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class RogRawMessageImpl
extends RogNode
implements IRogRawMessage,
MessageReflector {
    private ByteBuffer rawMessage;

    protected RogRawMessageImpl(UUID id, ByteBuffer message) {
        super((short)4, (short)7, (short)1, id, false);
        this.setMessageReflector(this);
        this.setRawMessage(message);
    }

    public void sync() {
        this.setMessage(1, this.rawMessage);
    }

    @Override
    public IStoreObject.EncodingType getContentEncodingType() {
        return IStoreObject.EncodingType.Custom;
    }

    @JsonGetter(value="rawMessage")
    public byte[] serializeToByteArray() {
        byte[] serialized;
        if (this.rawMessage == null) {
            serialized = new byte[]{};
        } else {
            serialized = new byte[this.rawMessage.remaining()];
            int pos = this.rawMessage.position();
            try {
                this.rawMessage.get(serialized);
            }
            finally {
                this.rawMessage.position(pos);
            }
        }
        return serialized;
    }

    public ByteBuffer serializeToByteBuffer() {
        return ByteBuffer.wrap(this.serializeToByteArray());
    }

    public IOBuffer serializeToIOBuffer(boolean useNative) {
        ByteBuffer serialized = this.serializeToByteBuffer();
        IOBuffer target = IOBuffer.create((int)serialized.remaining(), (boolean)useNative);
        UtlBuffer.copy((ByteBuffer)serialized, (int)serialized.position(), (ByteBuffer)target.getBufferUnsafe(), (int)0, (int)serialized.remaining());
        return target;
    }

    public PktPacket serializeToPacket() {
        this.sync();
        ByteBuffer serializedMessage = this.serializeToByteBuffer();
        PktSerializable.DeserializeContext deserializeContext = PktSerializable.DeserializeContext.create().setBuffer(serializedMessage);
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(257);
            packet.getBody().deserialize(deserializeContext, serializedMessage.remaining(), null);
            return packet;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Message serializeToProtobuf() {
        throw new UnsupportedOperationException("RogRawMessage doesn't support protobuf encoding");
    }

    public String serializeToJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            RogRawMessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return baos.toString();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public PktPacket serialize() {
        return this.serializeToPacket();
    }

    @Override
    public void setRawMessage(PktPacket packet) {
        byte[] bytes = new byte[packet.getSerializedLength()];
        packet.serialize(bytes, 0);
        this.setRawMessage(bytes);
    }

    @Override
    public void setRawMessage(ByteBuffer message) {
        this.rawMessage = message != null ? message.slice() : null;
        this.setMessage(1, this.rawMessage);
    }

    @Override
    @JsonSetter(value="rawMessage")
    public void setRawMessage(byte[] message) {
        if (message == null) {
            this.setRawMessage((ByteBuffer)null);
        } else {
            this.setRawMessage(ByteBuffer.wrap(message));
        }
    }

    @Override
    public ByteBuffer getRawMessage() {
        return this.rawMessage;
    }

    public final RogRawMessageImpl deserializeFromByteArray(byte[] array) {
        this.rawMessage = ByteBuffer.wrap(array);
        this.setMessage(1, null);
        return this;
    }

    public final RogRawMessageImpl deserializeFromByteBuffer(ByteBuffer buffer) {
        this.rawMessage = ByteBuffer.allocate(buffer.remaining());
        int originalPos = buffer.position();
        this.rawMessage.put(buffer);
        buffer.position(originalPos);
        this.rawMessage.position(0);
        this.setMessage(1, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogRawMessageImpl deserializeFromPacket(PktPacket packet) {
        ByteBuffer deserialized = null;
        PktBuffer packetBuffer = packet.getBody().getBuffer();
        IOBuffer ioBuffer = packetBuffer.getIOBuffer();
        ByteBuffer byteBuffer = ioBuffer.takeBuffer();
        try {
            byteBuffer.position(packetBuffer.getOffset());
            byteBuffer.limit(packetBuffer.getLength());
            deserialized = UtlBuffer.clone((ByteBuffer)byteBuffer);
        }
        finally {
            ioBuffer.releaseBuffer();
        }
        this.setRawMessage(deserialized);
        return this;
    }

    @Override
    public final RogRawMessageImpl deserializeFromProtobuf(Message message) {
        throw new IllegalArgumentException("unsupported serialized form '" + message.getClass().getName() + "'");
    }

    public final RogRawMessageImpl deserializeFromJson(String json) {
        try {
            RogRawMessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public final IStoreObject deserialize(PktPacket packet) {
        return this.deserializeFromPacket(packet);
    }

    public static IRogRawMessage createFrom(byte[] from) {
        return new RogRawMessageImpl(null, ByteBuffer.wrap(from));
    }

    public static IRogRawMessage createFrom(ByteBuffer from) {
        return new RogRawMessageImpl(null, from);
    }

    static IRogRawMessage createFrom(UUID id, PktPacket from) {
        RogRawMessageImpl message = new RogRawMessageImpl(id, null);
        message.deserialize(from);
        return message;
    }

    public final RogRawMessageImpl copy() {
        RogRawMessageImpl copy = new RogRawMessageImpl(null, this.serializeToByteBuffer());
        this.copyCopyableFieldsToCopy(copy);
        return copy;
    }

    public final boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return false;
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return false;
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return null;
    }

    public String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("pathComponents cannot be null");
        }
        return null;
    }

    public XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return null;
    }

    public XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("pathComponents cannot be null");
        }
        return null;
    }
}

