/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import cern.colt.function.LongObjectProcedure;
import cern.colt.function.LongProcedure;
import cern.colt.map.OpenLongObjectHashMap;
import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.IRogContainerNode;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;

public abstract class RogContainerNode
extends RogNode
implements IRogContainerNode {
    private OpenLongObjectHashMap children;
    private LongObjectProcedure childrenReadder;
    private LongProcedure childrenClearer;
    private LongObjectProcedure childrenDisposer;
    private long fidOffset;
    private long nextAvailableFid;
    private boolean clearing;

    protected RogContainerNode(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.reset();
    }

    private final void reset() {
        if (this.children != null) {
            this.children.clear();
        }
        this.fidOffset = -1L;
        this.nextAvailableFid = -1L;
    }

    private final void addToChildrenTable(long fid, RogNode val) {
        val.acquire();
        this.children.put(fid, (Object)val);
    }

    private final void removeFromChildrenTable(long fid, RogNode existing) {
        this.children.removeKey(fid);
        existing.dispose();
    }

    private final void onAddedAsChild() {
        if (this.children != null && this.children.size() > 0) {
            if (this.childrenReadder == null) {
                this.childrenReadder = new ChildrenReadder();
            }
            this.children.forEachPair(this.childrenReadder);
        }
    }

    private final void onRemovedAsChild() {
        if (this.children != null && this.children.size() > 0) {
            if (this.childrenClearer == null) {
                this.childrenClearer = new ChildrenClearer();
            }
            this.clearing = true;
            try {
                this.children.forEachKey(this.childrenClearer);
            }
            finally {
                this.clearing = false;
                this.children.clear();
            }
        }
    }

    protected final long allocFid() {
        if (this.fidOffset == -1L) {
            this.nextAvailableFid = this.fidOffset = (long)(this.getLastFid() + 1);
        }
        return this.nextAvailableFid++;
    }

    protected final void releaseFid(long fid) {
        if (this.fidOffset == -1L) {
            throw new IllegalArgumentException("fid has not been allocated");
        }
    }

    protected final boolean isDynamicFid(long fid) {
        return this.fidOffset > 0L && fid >= this.fidOffset;
    }

    protected final void rollbackChildAdd(long fid, RogNode node) {
        node.setParent(null);
        this.removeFromChildrenTable(fid, node);
        this.onChildAddRollback(node);
    }

    protected final void rollbackChildRemove(long fid, RogNode node) {
        node.setParent(this);
        this.addToChildrenTable(fid, node);
        this.onChildRemoveRollback(node);
    }

    protected final void assertSingleParent(IRogNode node) throws IllegalStateException {
        if (node != null && node.getParent() != null && node.getParent() != this) {
            throw new ERogIllegalParentReferenceException("Cannot set '" + node.getClass().getSimpleName() + "' as a child of '" + this.getClass().getSimpleName() + "', it is already a child of '" + node.getParent().getClass().getSimpleName() + "'. An entity can only be used as a single field in the object graph.");
        }
    }

    protected final boolean setChild(long fid, RogNode node) {
        RogNode existing;
        boolean repeatAdd;
        this.assertSingleParent(node);
        IStoreBinding store = this.getBinding();
        boolean bl = repeatAdd = node != null && node.getParent() == this;
        if (this.children == null) {
            this.children = new OpenLongObjectHashMap(2 * this.getExpectedChildrenCount(), 0.1, 0.5);
        }
        RogNode rogNode = existing = repeatAdd ? node : (RogNode)this.children.get(fid);
        if (existing != null && existing != node) {
            if (existing instanceof RogContainerNode) {
                ((RogContainerNode)existing).onRemovedAsChild();
            }
            existing.setGraphId(0);
            if (!this.clearing) {
                this.removeFromChildrenTable(fid, existing);
            } else {
                existing.dispose();
            }
            existing.setParent(null);
            if (store != null && store.getState() == IStoreBinding.State.Open && store.getRole() == IStoreBinding.Role.Primary) {
                if (this.transactional) {
                    this.recordFieldUpdate(fid, existing);
                }
                store.remove(existing);
            }
        }
        if (node != null) {
            if (existing != node) {
                this.addToChildrenTable(fid, node);
            }
            node.setParent(this);
            node.setGraphId(this.getGraphId());
            if (store != null && store.getState() == IStoreBinding.State.Open && store.getRole() == IStoreBinding.Role.Primary) {
                if (this.transactional) {
                    this.recordFieldUpdate(fid, null);
                }
                store.put(node);
            }
            if (node instanceof RogContainerNode) {
                ((RogContainerNode)node).onAddedAsChild();
            }
        }
        return existing != node;
    }

    protected final RogNode getChild(long fid) {
        return this.children == null ? null : (RogNode)this.children.get(fid);
    }

    protected int getExpectedChildrenCount() {
        return this.getLastFid();
    }

    protected void onChildAddRollback(RogNode node) {
    }

    protected void onChildRemoveRollback(RogNode node) {
    }

    @Override
    public void addChild(IRogNode node) {
    }

    @Override
    public void removeChild(IRogNode node) {
    }

    @Override
    public final int getNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public IStoreObject setFieldValue(long fid, Object val) {
        if (this.children != null && this.children.containsKey(fid)) {
            if (val == null) {
                this.rollbackChildAdd(fid, (RogNode)this.children.get(fid));
            } else {
                RogNode node = (RogNode)val;
                this.rollbackChildRemove(fid, node);
            }
        } else {
            super.setFieldValue(fid, val);
        }
        return this;
    }

    @Override
    public void dump(final StringBuilder sb, final String leader, final String leaderConcat) {
        super.dump(sb, leader, leaderConcat);
        if (this.children != null) {
            this.children.forEachPair(new LongObjectProcedure(){

                public final boolean apply(long fid, Object value) {
                    if (value != null) {
                        ((RogNode)value).dump(sb, leader + leaderConcat, leaderConcat);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            if (this.children != null && this.children.size() > 0) {
                if (this.childrenDisposer == null) {
                    this.childrenDisposer = new ChildrenDisposer();
                }
                this.children.forEachPair(this.childrenDisposer);
            }
            this.reset();
        }
        return count;
    }

    @Override
    protected void visitFields(final RogGraphVisitor visitor) {
        this.children.forEachPair(new LongObjectProcedure(){

            public boolean apply(long fid, Object field) {
                RogContainerNode.this.visitField(visitor, "fid=" + fid, (RogNode)field);
                return true;
            }
        });
    }

    @Override
    public String toString() {
        return super.toString() + ", children=" + (this.children != null ? this.children.size() : 0);
    }

    private final class ChildrenDisposer
    implements LongObjectProcedure {
        private ChildrenDisposer() {
        }

        public final boolean apply(long fid, Object value) {
            ((RogNode)value).dispose();
            return true;
        }
    }

    private final class ChildrenClearer
    implements LongProcedure {
        private ChildrenClearer() {
        }

        public final boolean apply(long fid) {
            RogContainerNode.this.setChild(fid, null);
            return true;
        }
    }

    private final class ChildrenReadder
    implements LongObjectProcedure {
        private ChildrenReadder() {
        }

        public final boolean apply(long fid, Object value) {
            RogContainerNode.this.setChild(fid, (RogNode)value);
            return true;
        }
    }
}

