/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.collect.test.unit;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.neeve.query.impl.util.collect.UtlSorted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SortedTest {
    @Test
    public void testInterleave() {
        ArrayList empty = Lists.newArrayList();
        ArrayList n1 = Lists.newArrayList((Object[])new Integer[]{5, 10, 15});
        ArrayList n2 = Lists.newArrayList((Object[])new Integer[]{4, 8, 12, 16});
        ArrayList n3 = null;
        ArrayList n4 = null;
        Iterable result = UtlSorted.mergeEach(n1, n2);
        ArrayList resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)Lists.newArrayList((Object[])new Integer[]{4, 5, 8, 10, 12, 15, 16}), (Object)resultList);
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        n2 = Lists.newArrayList((Object[])new Integer[]{4, 5});
        result = UtlSorted.mergeEach(n1, n2);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5}), (Object)resultList);
        result = UtlSorted.mergeEach(n1, empty);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), (Object)resultList);
        result = UtlSorted.mergeEach(empty, n2);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)Lists.newArrayList((Object[])new Integer[]{4, 5}), (Object)resultList);
        result = UtlSorted.mergeEach(n1);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), (Object)resultList);
        result = UtlSorted.mergeEach(empty);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"4,5,etc", (Object)empty, (Object)resultList);
        result = UtlSorted.mergeEach(new Iterable[0]);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"empty", (Object)empty, (Object)resultList);
        n1 = Lists.newArrayList((Object[])new Integer[]{5, 10, 15});
        n2 = Lists.newArrayList((Object[])new Integer[]{4, 8, 12});
        n3 = Lists.newArrayList((Object[])new Integer[]{7, 14});
        n4 = Lists.newArrayList((Object[])new Integer[]{11});
        result = UtlSorted.mergeEach(n1, n2, n3, n4);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"all values", (Object)Lists.newArrayList((Object[])new Integer[]{4, 5, 7, 8, 10, 11, 12, 14, 15}), (Object)resultList);
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        n2 = Lists.newArrayList((Object[])new Integer[]{2, 4});
        result = UtlSorted.mergeEach(n1, n2);
        resultList = Lists.newArrayList(result);
        Assert.assertEquals((String)"dup values", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 2, 3, 4, 4}), (Object)resultList);
    }

    @Test
    public void testIntersect() {
        List<Object> n1 = Lists.newArrayList((Object[])new Integer[]{3, 6, 9, 12, 15, 18});
        List<Object> n2 = Lists.newArrayList((Object[])new Integer[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20});
        Iterable intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"multiples of 6", (Object)Lists.newArrayList((Object[])new Integer[]{6, 12, 18}), (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{2, 4, 6, 8});
        n2 = Lists.newArrayList((Object[])new Integer[]{3, 5, 7, 9});
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"empty intersection", (Object)Lists.newArrayList(), (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 2, 3, 4, 4});
        n2 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"dupes removed", (Object)n2, (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 2, 3, 4, 4});
        n2 = Lists.newArrayList((Object[])new Integer[]{2, 2, 4, 4});
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"dupes retained", (Object)n2, (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        n2 = Lists.newArrayList((Object[])new Integer[]{9});
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"dupes retained", Collections.emptyList(), (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        n2 = Collections.emptyList();
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"dupes retained", Collections.emptyList(), (Object)Lists.newArrayList(intersection));
        n1 = Collections.emptyList();
        n2 = Collections.emptyList();
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2}));
        Assert.assertEquals((String)"dupes retained", (Object)n2, (Object)Lists.newArrayList(intersection));
        n1 = Lists.newArrayList((Object[])new Integer[]{3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33});
        n2 = Lists.newArrayList((Object[])new Integer[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30});
        ArrayList n3 = Lists.newArrayList((Object[])new Integer[]{5, 10, 15, 20, 25, 30, 35, 40});
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2, n3}));
        Assert.assertEquals((String)"dupes retained", (Object)Lists.newArrayList((Object[])new Integer[]{30}), (Object)Lists.newArrayList(intersection));
        n2.clear();
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2, n3}));
        Assert.assertEquals((String)"empty intersection", Collections.emptyList(), (Object)Lists.newArrayList(intersection));
        n1.clear();
        n3.clear();
        intersection = UtlSorted.intersect(Lists.newArrayList((Object[])new List[]{n1, n2, n3}));
        Assert.assertEquals((String)"empty intersection", Collections.emptyList(), (Object)Lists.newArrayList(intersection));
    }

    @Test
    public void testUnique() {
        List<Object> n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        ArrayList unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)n1, (Object)unique);
        n1 = Collections.emptyList();
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)n1, (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{null, "a", "b", "c"});
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)n1, (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c", null});
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)n1, (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "a", "b", "b", "c", "c", null, null});
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", null}), (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "a", "a"});
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)Lists.newArrayList((Object[])new String[]{"a"}), (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "b", "b", "b", "b", "b", "b", "b", "b"});
        unique = Lists.newArrayList(UtlSorted.unique(n1));
        Assert.assertEquals((String)"list unchanged", (Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)unique);
    }

    @Test
    public void testMergeUnique() {
        List<Object> n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        List<Object> n2 = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterable uniqueIterable = UtlSorted.mergeUnique(Lists.newArrayList((Object[])new List[]{n1, n2}), Ordering.natural());
        ArrayList unique = Lists.newArrayList(uniqueIterable);
        Assert.assertEquals((String)"identical lists merged", (Object)n1, (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        n2 = Lists.newArrayList((Object[])new String[]{"b", "c", "d"});
        uniqueIterable = UtlSorted.mergeUnique(Lists.newArrayList((Object[])new List[]{n1, n2}), Ordering.natural());
        unique = Lists.newArrayList(uniqueIterable);
        Assert.assertEquals((String)"identical lists merged", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"});
        n2 = Lists.newArrayList((Object[])new String[]{"b", "c"});
        uniqueIterable = UtlSorted.mergeUnique(Lists.newArrayList((Object[])new List[]{n1, n2}), Ordering.natural());
        unique = Lists.newArrayList(uniqueIterable);
        Assert.assertEquals((String)"identical lists merged", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), (Object)unique);
        n1 = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"});
        n2 = Collections.emptyList();
        uniqueIterable = UtlSorted.mergeUnique(Lists.newArrayList((Object[])new List[]{n1, n2}), Ordering.natural());
        unique = Lists.newArrayList(uniqueIterable);
        Assert.assertEquals((String)"identical lists merged", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), (Object)unique);
        n1 = Collections.emptyList();
        n2 = Collections.emptyList();
        uniqueIterable = UtlSorted.mergeUnique(Lists.newArrayList((Object[])new List[]{n1, n2}), Ordering.natural());
        unique = Lists.newArrayList(uniqueIterable);
        Assert.assertEquals((String)"identical lists merged", Collections.emptyList(), (Object)unique);
    }
}

