/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryReflectionField;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.index.IdxField;
import com.neeve.test.UnitTest;
import java.util.Date;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReflectionFieldTest
extends UnitTest {
    @Test
    public void testSimpleField() {
        Date d = new Date();
        Integer year = d.getYear();
        QueryReflectionField<Date, Integer> dateYear = new QueryReflectionField<Date, Integer>(Date.class, Integer.class, "year", new Class[0]);
        Assert.assertEquals((String)"date.year", (Object)year, (Object)dateYear.apply(d));
    }

    @Test
    public void testCompoundPath() {
        String s = "asdf";
        String name = s.getClass().getSimpleName();
        QueryReflectionField<String, String> className = new QueryReflectionField<String, String>(String.class, String.class, "class.simpleName", new Class[0]);
        Assert.assertEquals((String)"string.class.simpleName", (Object)name, (Object)className.apply(s));
    }

    @Test
    public void testInvalidPath() {
        try {
            new QueryReflectionField<String, Integer>(String.class, Integer.class, "a.b.c", new Class[0]);
            Assert.fail((String)"Shouldn't be able to create a reflection field with an invalid path");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Wrong error message", (Object)"Invalid fieldPath for String.a.b.c at a, java.lang.String has no accessor for a", (Object)e.getMessage());
        }
    }

    @Test
    public void testPathComponents() {
        String zipcode = (String)MockRecord.customerZipcode.apply(null);
        Assert.assertNull((String)"null record yields null zipcode", (Object)zipcode);
        MockRecord rec = new MockRecord(1, null);
        zipcode = (String)MockRecord.customerZipcode.apply(rec);
        Assert.assertNull((String)"null customer yields null zipcode", (Object)zipcode);
        Customer cust = new Customer(100L, "Bob");
        rec = new MockRecord(1, cust);
        zipcode = (String)MockRecord.customerZipcode.apply(rec);
        Assert.assertNull((String)"null address yields null zipcode", (Object)zipcode);
        Address addr = new Address(null);
        cust.setAddress(addr);
        zipcode = (String)MockRecord.customerZipcode.apply(rec);
        Assert.assertNull((String)"null zipcode yields null zipcode", (Object)zipcode);
        addr.setZipcode("12345");
        zipcode = (String)MockRecord.customerZipcode.apply(rec);
        Assert.assertEquals((String)"expect 12345", (Object)"12345", (Object)zipcode);
    }

    @Ignore
    @Test
    public void testAbstractFieldPerf() {
        IdxField concreteName = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.name", String.class, Customer.class);
        IdxField abstractName = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.name", String.class, Object.class);
        IdxField nonExistent = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.noSuchMethod", String.class, Object.class);
        Customer cust = new Customer(100L, "Bob");
        MockRecord rec = new MockRecord(1, cust);
        Assert.assertEquals((String)"expect concrete", (Object)"Bob", (Object)concreteName.apply(rec));
        Assert.assertEquals((String)"expect abstract", (Object)"Bob", (Object)abstractName.apply(rec));
        Assert.assertEquals((String)"expect non-existent", (Object)null, (Object)nonExistent.apply(rec));
        for (int i = 0; i < 20000; ++i) {
            concreteName.apply(rec);
        }
        int testSize = 5000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < testSize; ++i) {
            concreteName.apply(rec);
        }
        long concreteMs = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < testSize; ++i) {
            abstractName.apply(rec);
        }
        long abstractMs = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < testSize; ++i) {
            nonExistent.apply(rec);
        }
        long nonExistentMs = System.currentTimeMillis() - start;
        long threshold = 3L * concreteMs;
        Assert.assertTrue((String)("abstract too slow: " + abstractMs + "ms vs " + concreteMs + "ms"), (abstractMs <= threshold ? 1 : 0) != 0);
        Assert.assertTrue((String)("nonExistent too slow: " + nonExistentMs + "ms vs " + concreteMs + "ms"), (nonExistentMs <= threshold ? 1 : 0) != 0);
    }
}

