/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.predicates;

import com.google.common.collect.Maps;
import com.neeve.query.impl.predicates.PredicateOperators;
import com.neeve.query.impl.util.UtlQueryRegex;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class PredicateOperator {
    public static final UnaryOperator IS_NULL = new IsNull();
    public static final UnaryOperator IS_NOT_NULL = new IsNotNull();
    public static final BinaryOperator EQUALS = new Equals();
    public static final BinaryOperator NOT_EQUALS = new NotEquals();
    public static final BinaryOperator LIKE = new Like();
    public static final BinaryOperator REGEX_LIKE = new RegexLike();
    public static final BinaryOperator LESS_THAN = new LessThan();
    public static final BinaryOperator LESS_THAN_OR_EQUAL = new LessThanOrEqual();
    public static final BinaryOperator GREATER_THAN = new GreaterThan();
    public static final BinaryOperator GREATER_THAN_OR_EQUAL = new GreaterThanOrEqual();
    public static final TernaryOperator BETWEEN = new Between();
    public static final NaryOperator IN = new In();
    private static final Map<String, PredicateOperator> operatorsBySymbol = Maps.newHashMap();

    public boolean isRanged() {
        return false;
    }

    public abstract PredicateOperators getPublicOperator();

    public abstract Arity getArity();

    public static PredicateOperator lookup(String operatorSymbol) {
        String key = operatorSymbol.toUpperCase();
        return operatorsBySymbol.get(key);
    }

    public static PredicateOperator lookup(PredicateOperators oper) {
        switch (oper) {
            case IS_NULL: {
                return IS_NULL;
            }
            case IS_NOT_NULL: {
                return IS_NOT_NULL;
            }
            case EQUALS: {
                return EQUALS;
            }
            case NOT_EQUALS: {
                return NOT_EQUALS;
            }
            case LIKE: {
                return LIKE;
            }
            case REGEX_LIKE: {
                return REGEX_LIKE;
            }
            case IN: {
                return IN;
            }
            case LESS_THAN: {
                return LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
            case BETWEEN: {
                return BETWEEN;
            }
        }
        return null;
    }

    static {
        operatorsBySymbol.put("IS NULL", IS_NULL);
        operatorsBySymbol.put("IS NOT NULL", IS_NOT_NULL);
        operatorsBySymbol.put("=", EQUALS);
        operatorsBySymbol.put("!=", NOT_EQUALS);
        operatorsBySymbol.put("<>", NOT_EQUALS);
        operatorsBySymbol.put("LIKE", LIKE);
        operatorsBySymbol.put("REGEX_LIKE", REGEX_LIKE);
        operatorsBySymbol.put("<", LESS_THAN);
        operatorsBySymbol.put("<=", LESS_THAN_OR_EQUAL);
        operatorsBySymbol.put(">", GREATER_THAN);
        operatorsBySymbol.put(">=", GREATER_THAN_OR_EQUAL);
        operatorsBySymbol.put("BETWEEN", BETWEEN);
        operatorsBySymbol.put("IN", IN);
    }

    private static class Between
    extends TernaryOperator {
        private Between() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.BETWEEN;
        }

        @Override
        public boolean isRanged() {
            return true;
        }

        @Override
        public <T> boolean apply(T subject, T value1, T value2) {
            if (subject == null || value1 == null || value2 == null) {
                return false;
            }
            if (!(subject instanceof Comparable)) {
                return false;
            }
            if (subject == value1 || subject == value2) {
                return true;
            }
            Comparable c1 = (Comparable)subject;
            return c1.compareTo(value1) >= 0 && c1.compareTo(value2) <= 0;
        }

        public String toString() {
            return "BETWEEN";
        }
    }

    private static class RegexLike
    extends BinaryOperator {
        private RegexLike() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.REGEX_LIKE;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (!(subject instanceof String)) {
                return false;
            }
            if (!(value instanceof String)) {
                return false;
            }
            Pattern p = Pattern.compile((String)value);
            return p.matcher((String)subject).matches();
        }

        public String toString() {
            return "REGEX_LIKE";
        }
    }

    private static class Like
    extends BinaryOperator {
        private Like() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.LIKE;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (!(subject instanceof String)) {
                return false;
            }
            if (!(value instanceof String)) {
                return false;
            }
            return UtlQueryRegex.like((String)subject, (String)value);
        }

        public String toString() {
            return "LIKE";
        }
    }

    private static class GreaterThanOrEqual
    extends BinaryOperator {
        private GreaterThanOrEqual() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.GREATER_THAN_OR_EQUAL;
        }

        @Override
        public boolean isRanged() {
            return true;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (subject == null || value == null) {
                return false;
            }
            if (!(subject instanceof Comparable)) {
                return false;
            }
            if (subject == value) {
                return true;
            }
            Comparable c1 = (Comparable)subject;
            return c1.compareTo(value) >= 0;
        }

        public String toString() {
            return ">=";
        }
    }

    private static class GreaterThan
    extends BinaryOperator {
        private GreaterThan() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.GREATER_THAN;
        }

        @Override
        public boolean isRanged() {
            return true;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (subject == value || value == null) {
                return false;
            }
            if (subject == null) {
                return false;
            }
            if (!(subject instanceof Comparable)) {
                return false;
            }
            Comparable c1 = (Comparable)subject;
            return c1.compareTo(value) > 0;
        }

        public String toString() {
            return ">";
        }
    }

    private static class LessThanOrEqual
    extends BinaryOperator {
        private LessThanOrEqual() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.LESS_THAN_OR_EQUAL;
        }

        @Override
        public boolean isRanged() {
            return true;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (subject == null || value == null) {
                return false;
            }
            if (!(subject instanceof Comparable)) {
                return false;
            }
            if (subject == value) {
                return true;
            }
            Comparable c1 = (Comparable)subject;
            return c1.compareTo(value) <= 0;
        }

        public String toString() {
            return "<=";
        }
    }

    private static class LessThan
    extends BinaryOperator {
        private LessThan() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.LESS_THAN;
        }

        @Override
        public boolean isRanged() {
            return true;
        }

        @Override
        public <T> boolean apply(T subject, T value) {
            if (subject == value) {
                return false;
            }
            if (subject == null || value == null) {
                return false;
            }
            if (!(subject instanceof Comparable)) {
                return false;
            }
            Comparable c1 = (Comparable)subject;
            return c1.compareTo(value) < 0;
        }

        public String toString() {
            return "<";
        }
    }

    private static class In
    extends NaryOperator {
        private In() {
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.IN;
        }

        @Override
        public <T> boolean apply(T subject, T ... values) {
            for (T value : values) {
                if (subject == value) {
                    return true;
                }
                if (subject == null || !subject.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> boolean apply(T subject, Collection<T> values) {
            for (T value : values) {
                if (subject == value) {
                    return true;
                }
                if (subject == null || !subject.equals(value)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            return obj instanceof In;
        }

        public int hashCode() {
            return In.class.hashCode();
        }

        public String toString() {
            return "IN";
        }
    }

    private static class NotEquals
    extends BinaryOperator {
        private NotEquals() {
        }

        @Override
        public <T> boolean apply(T a, T b) {
            if (a == b || a == null) {
                return false;
            }
            return !a.equals(b);
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.NOT_EQUALS;
        }

        public boolean equals(Object obj) {
            return obj instanceof NotEquals;
        }

        public int hashCode() {
            return NotEquals.class.hashCode();
        }

        public String toString() {
            return "!=";
        }
    }

    private static class Equals
    extends BinaryOperator {
        private Equals() {
        }

        @Override
        public <T> boolean apply(T a, T b) {
            if (a == b) {
                return true;
            }
            return a != null && a.equals(b);
        }

        public boolean equals(Object obj) {
            return obj instanceof Equals;
        }

        public int hashCode() {
            return Equals.class.hashCode();
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.EQUALS;
        }

        public String toString() {
            return "=";
        }
    }

    private static class IsNotNull
    extends UnaryOperator {
        private IsNotNull() {
        }

        @Override
        public <T> boolean apply(T subject) {
            return subject != null;
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.IS_NOT_NULL;
        }

        public boolean equals(Object obj) {
            return obj instanceof IsNotNull;
        }

        public int hashCode() {
            return IsNotNull.class.hashCode();
        }

        public String toString() {
            return "IS NOT NULL";
        }
    }

    private static class IsNull
    extends UnaryOperator {
        private IsNull() {
        }

        @Override
        public <T> boolean apply(T subject) {
            return subject == null;
        }

        @Override
        public PredicateOperators getPublicOperator() {
            return PredicateOperators.IS_NULL;
        }

        public boolean equals(Object obj) {
            return obj instanceof IsNull;
        }

        public int hashCode() {
            return IsNull.class.hashCode();
        }

        public String toString() {
            return "IS NULL";
        }
    }

    public static abstract class NaryOperator
    extends PredicateOperator {
        public abstract <T> boolean apply(T var1, T ... var2);

        public abstract <T> boolean apply(T var1, Collection<T> var2);

        @Override
        public final Arity getArity() {
            return Arity.NARY;
        }
    }

    public static abstract class TernaryOperator
    extends PredicateOperator {
        public abstract <T> boolean apply(T var1, T var2, T var3);

        @Override
        public final Arity getArity() {
            return Arity.TERNARY;
        }
    }

    public static abstract class BinaryOperator
    extends PredicateOperator {
        public abstract <T> boolean apply(T var1, T var2);

        @Override
        public final Arity getArity() {
            return Arity.BINARY;
        }
    }

    public static abstract class UnaryOperator
    extends PredicateOperator {
        public abstract <T> boolean apply(T var1);

        @Override
        public final Arity getArity() {
            return Arity.UNARY;
        }
    }

    public static enum Arity {
        UNARY,
        BINARY,
        TERNARY,
        NARY;

    }
}

