/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index.test.unit;

import com.google.common.collect.Lists;
import com.neeve.query.QueryIndexer;
import com.neeve.query.impl.index.IdxIndexerImpl;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.impl.mock.domain.SalesOrder;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexerImplTest
extends UnitTest {
    public static final IdxIndexerImpl.IdMapper<Integer, MockRecord> idMapper = new IdxIndexerImpl.IdMapper<Integer, MockRecord>(){

        @Override
        public Integer getRecordId(MockRecord record) {
            return record.getId();
        }

        @Override
        public long getCommitSequence(MockRecord record) {
            return record.getId();
        }
    };
    private QueryIndexer<Integer, MockRecord> indexer;
    private String fileName = "IndexerImplTest.idx";
    private File indexDataDir;

    @Before
    public void setup() throws Exception {
        this.indexDataDir = IndexerImplTest.getTestbedRoot();
        this.indexer = IdxIndexerImpl.createFileBased(this.indexDataDir, this.fileName, idMapper);
        this.indexer.open();
        this.indexer.createIndex(MockRecord.customerId, true, null);
    }

    @After
    public void teardown() throws Exception {
        if (this.indexer != null) {
            this.indexer.close();
            this.indexer.delete();
        }
    }

    @Test
    public void testGetIndexes() {
        List<IdxIndex<?, Integer>> indexes = this.indexer.getIndexes();
        Assert.assertEquals((String)"one index", (long)1L, (long)indexes.size());
        IdxIndex<?, Integer> index = indexes.get(0);
        Assert.assertEquals((String)"field is customerId", MockRecord.customerId, index.getField());
        Assert.assertTrue((String)"index is unique", (boolean)index.getStats().isUnique());
    }

    @Test
    public void testIndexWithoutCommit() {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testIndexWithCommit() {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.commit(1L);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)2L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testAddExistingIndex() {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.createIndex(MockRecord.customerId, true, null);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testIndexDrop() {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
        this.indexer.dropIndex(MockRecord.customerId);
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertNull((String)"Index remains after clear", index);
        Assert.assertEquals((String)"Index commit seqno not reset:", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testIndexerDelete() throws Exception {
        try {
            this.indexer.delete();
            Assert.fail((String)"Shouldn't be able to delete open index");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.indexer.close();
        final ArrayList indexerFiles = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(IndexerImplTest.this.fileName)) {
                    indexerFiles.add(pathname);
                    return true;
                }
                return false;
            }
        };
        this.indexDataDir.listFiles(filter);
        Assert.assertFalse((String)"No index files found after close", (boolean)indexerFiles.isEmpty());
        this.indexer.delete();
        this.indexer = null;
        indexerFiles.clear();
        this.indexDataDir.listFiles(filter);
        Assert.assertTrue((String)("Index files not deleted: " + indexerFiles), (boolean)indexerFiles.isEmpty());
    }

    @Test
    public void testIndexerRename() throws Exception {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)2L, (long)this.indexer.getLiveCommitSequenceNumber());
        this.indexer.rename("RenamedIndex.idx");
        final ArrayList indexerFiles = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(IndexerImplTest.this.fileName)) {
                    indexerFiles.add(pathname);
                    return true;
                }
                return false;
            }
        };
        this.indexDataDir.listFiles(filter);
        Assert.assertTrue((String)("Indexer files not renamed: " + indexerFiles), (boolean)indexerFiles.isEmpty());
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertNotNull((String)"Index no longer exists after rename", index);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno is wrong", (long)2L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testIndexerClear() throws Exception {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(1L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        this.indexer.clear(true);
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertNull((String)"Index remains after clear", index);
        Assert.assertEquals((String)"Index commit seqno not reset:", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
    }

    @Test
    public void testIndexerClearContentsOnly() throws Exception {
        Customer cust1 = new Customer(1L, "John Doe");
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        MockRecord rec2 = new MockRecord(101, cust2);
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        this.indexer.clear(false);
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertNotNull((String)"Index remains after clear", index);
        Assert.assertNull((String)"Index content remains after clear", (Object)index.getId(cust1.getId()));
        Assert.assertNull((String)"Index content remains after clear", (Object)index.getId(cust2.getId()));
        Assert.assertEquals((String)"Index commit seqno not reset:", (long)0L, (long)this.indexer.getLiveCommitSequenceNumber());
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        Assert.assertEquals((String)"cust1 was on rec1", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"cust2 was on rec2", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
    }

    @Test
    public void testFieldEquality() {
        Assert.assertEquals((String)"Fields should be the same", MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Customer.class, new Class[0]), MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Customer.class, new Class[0]));
        IdxField null1 = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, null, MockRecord.class, new Class[0]);
        IdxField null2 = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, null, MockRecord.class, new Class[0]);
        Assert.assertEquals((String)"Fields should be the same", null1, null2);
        Assert.assertEquals((String)"Fields should be the same", MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment", Address.class, Customer.class), MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment", Address.class, Customer.class));
        Assert.assertNotEquals((String)"Fields with same path but different field type shouldn't match", MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Customer.class, new Class[0]), MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Address.class, new Class[0]));
        Assert.assertNotEquals((String)"Fields with same path but different recordType shouldn't match", MockQueryEngine.FIELD_RESOLVER.getField(Address.class, "id", Long.class, new Class[0]), MockQueryEngine.FIELD_RESOLVER.getField(Customer.class, "id", Long.class, new Class[0]));
        Assert.assertNotEquals((String)"Fields with same path but different fieldType shouldn't match", MockQueryEngine.FIELD_RESOLVER.getField(Address.class, "attachment.id", Long.class, new Class[0]), MockQueryEngine.FIELD_RESOLVER.getField(Address.class, "attachment.id", Integer.class, new Class[0]));
        Assert.assertNotEquals((String)"Fields with same path but different pathSelector shouldn't match", MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment", Address.class, Customer.class), MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment", Address.class, Address.class));
    }

    @Test
    public void testUniqueIndexRecovery() throws Exception {
        Customer cust1 = new Customer(1L, "John Doe");
        Address address1 = new Address("94107");
        address1.setId(1L);
        cust1.setAddress(address1);
        cust1.setAttachment(address1);
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        Address address2 = new Address("94103");
        address2.setId(2L);
        cust2.setAddress(address2);
        cust2.setAttachment(address2);
        MockRecord rec2 = new MockRecord(101, cust2);
        IdxField customerZipCodeField = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.address.zipcode", String.class, Customer.class);
        IdxUniqueIndex<String, Integer> customerZipCodeIndex = (IdxUniqueIndex<String, Integer>)this.indexer.createIndex(customerZipCodeField, true, "customer_zipcode");
        IdxField customerAddressAttachmentIdField = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment.id", Long.class, Customer.class, Address.class);
        IdxUniqueIndex<Long, Integer> customerAddressAttachmentIdIndex = (IdxUniqueIndex<Long, Integer>)this.indexer.createIndex(customerAddressAttachmentIdField, true, "customer_address_attachment_id");
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"wrong record for cust1 zipcode", (Object)rec1.getId(), customerZipCodeIndex.getId(address1.getZipcode()));
        Assert.assertEquals((String)"wrong record for cust1 attchment id", (Object)rec1.getId(), customerAddressAttachmentIdIndex.getId(address1.getId()));
        Assert.assertEquals((String)"wrong record for cust1 id", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"wrong record for cust2 zipcode", (Object)rec2.getId(), customerZipCodeIndex.getId(address2.getZipcode()));
        Assert.assertEquals((String)"wrong record for cust2 attchment id", (Object)rec2.getId(), customerAddressAttachmentIdIndex.getId(address2.getId()));
        Assert.assertEquals((String)"wrong record for cust2 id", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        this.indexer.close();
        this.indexer.open();
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        customerZipCodeIndex = this.indexer.getUniqueIndex(customerZipCodeField);
        customerAddressAttachmentIdIndex = this.indexer.getUniqueIndex(customerAddressAttachmentIdField);
        Assert.assertEquals((String)"wrong record for cust1 zipcode", (Object)rec1.getId(), (Object)customerZipCodeIndex.getId(address1.getZipcode()));
        Assert.assertEquals((String)"wrong record for cust1 attchment id", (Object)rec1.getId(), (Object)customerAddressAttachmentIdIndex.getId(address1.getId()));
        Assert.assertEquals((String)"wrong record for cust1 id", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"wrong record for cust2 zipcode", (Object)rec2.getId(), (Object)customerZipCodeIndex.getId(address2.getZipcode()));
        Assert.assertEquals((String)"wrong record for cust2 attchment id", (Object)rec2.getId(), (Object)customerAddressAttachmentIdIndex.getId(address2.getId()));
        Assert.assertEquals((String)"wrong record for cust2 id", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
    }

    @Test
    public void testNonUniqueIndexRecovery() throws Exception {
        Customer cust1 = new Customer(1L, "John Doe");
        Address address1 = new Address("94107");
        address1.setId(1L);
        cust1.setAddress(address1);
        cust1.setAttachment(address1);
        MockRecord rec1 = new MockRecord(100, cust1);
        Customer cust2 = new Customer(2L, "Jane Doe");
        Address address2 = new Address("94103");
        address2.setId(2L);
        cust2.setAddress(address2);
        cust2.setAttachment(address2);
        MockRecord rec2 = new MockRecord(101, cust2);
        IdxField customerZipCodeField = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.address.zipcode", String.class, Customer.class);
        IdxNonUniqueIndex<String, Integer> customerZipCodeIndex = (IdxNonUniqueIndex<String, Integer>)this.indexer.createIndex(customerZipCodeField, false, "customer_zipcode");
        IdxField customerAddressAttachmentIdField = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment.id", Long.class, Customer.class, Address.class);
        IdxNonUniqueIndex<Long, Integer> customerAddressAttachmentIdIndex = (IdxNonUniqueIndex<Long, Integer>)this.indexer.createIndex(customerAddressAttachmentIdField, false, "customer_address_attachment_id");
        this.indexer.put(rec1);
        this.indexer.put(rec2);
        this.indexer.commit(2L);
        IdxUniqueIndex<Long, Integer> index = this.indexer.getUniqueIndex(MockRecord.customerId);
        Assert.assertEquals((String)"wrong record for cust1 zipcode", (Object)rec1.getId(), customerZipCodeIndex.get(address1.getZipcode()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust1 attchment id", (Object)rec1.getId(), customerAddressAttachmentIdIndex.get(address1.getId()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust1 id", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"wrong record for cust2 zipcode", (Object)rec2.getId(), customerZipCodeIndex.get(address2.getZipcode()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust2 attchment id", (Object)rec2.getId(), customerAddressAttachmentIdIndex.get(address2.getId()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust2 id", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
        this.indexer.close();
        this.indexer.open();
        index = this.indexer.getUniqueIndex(MockRecord.customerId);
        customerZipCodeIndex = this.indexer.getNonUniqueIndex(customerZipCodeField);
        customerAddressAttachmentIdIndex = this.indexer.getNonUniqueIndex(customerAddressAttachmentIdField);
        Assert.assertEquals((String)"wrong record for cust1 zipcode", (Object)rec1.getId(), (Object)customerZipCodeIndex.get(address1.getZipcode()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust1 attchment id", (Object)rec1.getId(), (Object)customerAddressAttachmentIdIndex.get(address1.getId()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust1 id", (Object)rec1.getId(), (Object)index.getId(cust1.getId()));
        Assert.assertEquals((String)"wrong record for cust2 zipcode", (Object)rec2.getId(), (Object)customerZipCodeIndex.get(address2.getZipcode()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust2 attchment id", (Object)rec2.getId(), (Object)customerAddressAttachmentIdIndex.get(address2.getId()).iterator().next());
        Assert.assertEquals((String)"wrong record for cust2 id", (Object)rec2.getId(), (Object)index.getId(cust2.getId()));
    }

    @Test
    public void testCurrencyIndex() {
        IdxNonUniqueIndex currencyIndex = (IdxNonUniqueIndex)this.indexer.createIndex(MockRecord.orderCurrency, false, "orderCurrency_n1");
        Currency usd = Currency.getInstance(Locale.US);
        Currency cad = Currency.getInstance(Locale.CANADA);
        SalesOrder order1 = new SalesOrder(1L, null, "order 1");
        order1.setCurrency(usd);
        this.indexer.put(new MockRecord(501, order1));
        SalesOrder order2 = new SalesOrder(2L, null, "order 2");
        order2.setCurrency(usd);
        this.indexer.put(new MockRecord(502, order2));
        SalesOrder order3 = new SalesOrder(3L, null, "order 3");
        order3.setCurrency(cad);
        this.indexer.put(new MockRecord(503, order3));
        this.indexer.commit(1000L);
        ArrayList ids = Lists.newArrayList(currencyIndex.get(usd));
        Assert.assertEquals((String)"two ids", (long)2L, (long)ids.size());
        Assert.assertEquals((String)"first is 501", (long)501L, (long)((Integer)ids.get(0)).intValue());
        Assert.assertEquals((String)"second is 502", (long)502L, (long)((Integer)ids.get(1)).intValue());
        ids = Lists.newArrayList(currencyIndex.get(cad));
        Assert.assertEquals((String)"one ids", (long)1L, (long)ids.size());
        Assert.assertEquals((String)"first is 503", (long)503L, (long)((Integer)ids.get(0)).intValue());
    }

    @Test
    public void testIndexerCardinality() {
        IdxNonUniqueIndex custNameIndex = (IdxNonUniqueIndex)this.indexer.createIndex(MockRecord.customerName, false, "cusotmerName_n1");
        int size = 10000;
        int keySize = 500;
        for (int id = 1; id <= size; ++id) {
            Customer cust = new Customer(id, "John Doe [" + id % keySize + "]");
            this.indexer.put(new MockRecord(id, cust));
        }
        this.indexer.commit(size);
        Assert.assertEquals((String)"wrong indexer size", (long)size, (long)this.indexer.getSize());
        Assert.assertEquals((String)"wrong index size", (long)size, (long)custNameIndex.getStats().getCardinality());
        Assert.assertEquals((String)"wrong index key size", (long)keySize, (long)custNameIndex.getStats().getKeyCardinality());
    }

    @Test
    public void testIndexerParallelCardinality() throws Exception {
        final IdxIndexerImpl<Integer, MockRecord> inMemoryIndexer = IdxIndexerImpl.createMemoryBased(idMapper);
        inMemoryIndexer.open();
        IdxNonUniqueIndex custNameIndex = (IdxNonUniqueIndex)inMemoryIndexer.createIndex(MockRecord.customerName, false, "cusotmerName_n1");
        int size = 800;
        int keySize = 100;
        int numThreads = 4;
        final CountDownLatch start = new CountDownLatch(4);
        final CountDownLatch finish = new CountDownLatch(4);
        final AtomicInteger count = new AtomicInteger(0);
        int n = 1;
        while (n <= 4) {
            final int threadNum = n++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await();
                        int batchSize = 200;
                        int batchOffset = batchSize * (threadNum - 1);
                        int batchStart = batchOffset + 1;
                        int batchEnd = batchOffset + batchSize;
                        System.out.println("batching [" + batchStart + "," + batchEnd + "]");
                        for (int id = batchStart; id <= batchEnd; ++id) {
                            int recordId = count.incrementAndGet();
                            Customer cust = new Customer(id, "John Doe [" + id % 100 + "]");
                            inMemoryIndexer.put(new MockRecord(recordId, cust));
                            if (recordId % 100 != 0) continue;
                            inMemoryIndexer.commit(recordId);
                        }
                        System.out.println("finished [" + batchStart + "," + batchEnd + "]");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    finally {
                        finish.countDown();
                    }
                }
            });
            t.start();
            start.countDown();
        }
        finish.await();
        inMemoryIndexer.commit(800L);
        for (int k = 0; k < 100; ++k) {
            String name = "John Doe [" + k + "]";
            Iterable ids = custNameIndex.get(name);
            int idCount = 0;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                ++idCount;
            }
            Assert.assertEquals((String)("wrong number of values for [" + name + "]"), (long)8L, (long)idCount);
        }
        IdxIndex.Stats stats = custNameIndex.getStats();
        Assert.assertEquals((String)"wrong insert count", (long)800L, (long)count.get());
        Assert.assertEquals((String)"wrong index size", (long)800L, (long)stats.getCardinality());
        Assert.assertEquals((String)"wrong index key size", (long)100L, (long)stats.getKeyCardinality());
        Assert.assertEquals((String)"wrong indexer size", (long)800L, (long)inMemoryIndexer.getSize());
        inMemoryIndexer.close();
    }

    @Test
    public void testSize() {
        for (int id = 1; id <= 50; ++id) {
            this.indexer.put(new MockRecord(id, new Object()));
        }
        Assert.assertEquals((String)"size wrong", (long)50L, (long)this.indexer.getSize());
    }
}

