/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index.test.unit;

import com.neeve.query.impl.index.IdxBaseIndex;
import com.neeve.query.impl.index.IdxComparatorRegistry;
import com.neeve.query.impl.index.IdxIndexManager;
import com.neeve.query.impl.index.IdxIndexerImpl;
import com.neeve.query.impl.index.IdxNonUniqueTreeIndex;
import com.neeve.query.impl.index.IdxUniqueBaseIndex;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.test.UnitTest;
import java.util.Currency;
import java.util.Iterator;
import java.util.Locale;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class IndexManagerTest
extends UnitTest {
    private static IdxIndexManager<Integer, MockRecord> indexManager;
    private static IdxField<MockRecord, String> dummyUnique;
    private static IdxField<MockRecord, String> dummyNonUnique;
    private static IdxField<MockRecord, Currency> dummyCurrency;
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws Exception {
        indexManager = IdxIndexManager.createFileBased(IndexManagerTest.getTestbedRoot(), this.name.getMethodName());
        indexManager.open();
    }

    @After
    public void after() throws Exception {
        indexManager.clear(true);
        indexManager.close();
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        indexManager.awaitShutdown();
    }

    @Test
    public void testManagerStats() {
        IdxUniqueBaseIndex<String, Integer> index = indexManager.createUniqueIndex(dummyUnique, null);
        index.put("a", 1);
        index.put("b", 5);
        indexManager.commit(0L);
        IdxIndex.Stats stats = ((IdxBaseIndex)index).getStats();
        Assert.assertNotNull((String)"stats", (Object)stats);
        Assert.assertEquals((String)"two entries", (long)2L, (long)((IdxBaseIndex.StatsImpl)stats).getCardinality());
        Assert.assertEquals((String)"two keys", (long)2L, (long)((IdxBaseIndex.StatsImpl)stats).getKeyCardinality());
        Assert.assertEquals((String)"a is the low key", (Object)"a", ((IdxBaseIndex.StatsImpl)stats).getLowKey());
        Assert.assertEquals((String)"b is the low key", (Object)"b", ((IdxBaseIndex.StatsImpl)stats).getHighKey());
        IdxField field = index.getField();
        Assert.assertNotNull((String)"field", field);
        String fieldName = field.getName();
        String canonicalName = field.getCanonicalName();
        indexManager.close();
        indexManager = null;
        indexManager = IdxIndexManager.createFileBased(IndexManagerTest.getTestbedRoot(), this.name.getMethodName());
        indexManager.open();
        index = indexManager.getUniqueIndex(dummyUnique);
        stats = ((IdxBaseIndex)index).getStats();
        Assert.assertNotNull((String)"stats", (Object)stats);
        Assert.assertEquals((String)"two entries", (long)2L, (long)((IdxBaseIndex.StatsImpl)stats).getCardinality());
        Assert.assertEquals((String)"two keys", (long)2L, (long)((IdxBaseIndex.StatsImpl)stats).getKeyCardinality());
        Assert.assertEquals((String)"a is the low key", (Object)"a", ((IdxBaseIndex.StatsImpl)stats).getLowKey());
        Assert.assertEquals((String)"b is the low key", (Object)"b", ((IdxBaseIndex.StatsImpl)stats).getHighKey());
        field = index.getField();
        Assert.assertNotNull((String)"field", field);
        Assert.assertEquals((String)"same fieldName", (Object)fieldName, (Object)field.getName());
        Assert.assertEquals((String)"same canonicalName", (Object)canonicalName, (Object)field.getCanonicalName());
    }

    @Test
    public void testManagerUniqueIndex() {
        indexManager.createUniqueIndex(dummyUnique, null);
        IdxUniqueBaseIndex<String, Integer> index = indexManager.getUniqueIndex(dummyUnique);
        index.put("abc", 1);
        index.put("abc", 2);
        index.put("xyz", 3);
        indexManager.commit(3L);
        Assert.assertEquals((String)"unique value", (Object)2, index.getId("abc"));
    }

    @Test
    public void testManagerNonUniqueIndex() {
        indexManager.createNonUniqueIndex(dummyNonUnique, null);
        IdxNonUniqueTreeIndex<String, Integer> index = indexManager.getNonUniqueIndex(dummyNonUnique);
        index.put("aaa", 1);
        index.put("aaa", 2);
        index.put("aaa", 3);
        index.put("bbb", 4);
        indexManager.commit(4L);
        Iterable values = index.get("aaa");
        Iterator iter = values.iterator();
        Assert.assertEquals((String)"sorted value", (Object)1, iter.next());
        Assert.assertEquals((String)"sorted value", (Object)2, iter.next());
        Assert.assertEquals((String)"sorted value", (Object)3, iter.next());
        Assert.assertFalse((String)"only 3 values", (boolean)iter.hasNext());
    }

    @Test
    public void testManagerRollback() {
        indexManager.createUniqueIndex(dummyUnique, null);
        IdxUniqueBaseIndex<String, Integer> index = indexManager.getUniqueIndex(dummyUnique);
        indexManager.commit(1L);
        index.put("abc", 2);
        indexManager.rollback();
        Assert.assertEquals((String)"no value", null, index.getId("abc"));
    }

    @Test
    public void testManagerNonComparableKeyField() {
        IdxComparatorRegistry.registerKeyComparator(Currency.class, IdxIndexerImpl.CURRENCY_COMPARATOR);
        IdxUniqueBaseIndex<Currency, Integer> index = indexManager.createUniqueIndex(dummyCurrency, null);
        Currency gbp = Currency.getInstance(Locale.UK);
        index.put(gbp, 1);
        indexManager.commit(1L);
        Assert.assertEquals((String)"wrong currency value", (long)1L, (long)((Integer)index.getId(gbp)).intValue());
    }

    @Test
    public void testManagerCardinality() {
        IdxNonUniqueTreeIndex<String, Integer> customerNameIndex = indexManager.createNonUniqueIndex(MockRecord.customerName, "customerName");
        int size = 10000;
        int keySize = 500;
        for (int id = 1; id <= size; ++id) {
            customerNameIndex.put("John Smith[" + id % keySize + "]", id);
        }
        indexManager.commit(size);
        Assert.assertEquals((String)"wrong index size", (long)size, (long)((IdxBaseIndex.StatsImpl)customerNameIndex.getStats()).getCardinality());
        Assert.assertEquals((String)"wrong key size", (long)keySize, (long)((IdxBaseIndex.StatsImpl)customerNameIndex.getStats()).getKeyCardinality());
    }

    static {
        dummyUnique = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.notUsedUnique", String.class, new Class[0]);
        dummyNonUnique = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.notUsedNonUnique", String.class, new Class[0]);
        dummyCurrency = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.notUsedCurrency", Currency.class, new Class[0]);
    }
}

